# CHANGELOG

## 2.4.6 (2015-08-03)

- Take fallback value into account

## 2.4.5 (2015-07-28)

- [7: Ensure Required, AllowEmpty validation combo works](https://github.com/zendframework/zend-inputfilter/pull/7)

## 2.4.4 (2015-07-21)

- Fix count increment on insert in PriorityList

## 2.4.2 (2015-05-11)

- [7503: Mail header - boundary issue (related to ZF2015-04)](https://github.com/zendframework/zf2/issues/7503)
- [7506: &#91;mail&#92; Fix set UTF-8 values to headers. Fix #7501](https://github.com/zendframework/zf2/pull/7506)
- [7507: &#91;http&#92; Allow serialize any character on cookies](https://github.com/zendframework/zf2/pull/7507)
- [7510: &#91;mail/mime&#92; Fix content-type has invalid characters in field value. Fix #7503](https://github.com/zendframework/zf2/pull/7510)
- [7512: \Zend\Ldap\Attribute::valueFromLdap catching wrong exception](https://github.com/zendframework/zf2/issues/7512)
- [7513: &#91;ldap&#92; Fix exceptions while parsing are not captured.](https://github.com/zendframework/zf2/pull/7513)
- [7514: &#91;#7503&#92; Pass the `\r\n` sequence to Part::getHeadersAsArray()](https://github.com/zendframework/zf2/pull/7514)

## 2.4.1 (2015-05-07)

- [7361: Missing parameter annotation in PHPDoc in Zend\Http\PhpEnvironment\Request](https://github.com/zendframework/zf2/pull/7361)
- [7376: Fixes DocBlock for BasePath helper in PhpRenderer](https://github.com/zendframework/zf2/pull/7376)
- [7378: Change year on comment](https://github.com/zendframework/zf2/pull/7378)
- [7380: Remove unused code](https://github.com/zendframework/zf2/pull/7380)
- [7383: Fixes typos](https://github.com/zendframework/zf2/pull/7383)
- [7391: update composer's branch-alias](https://github.com/zendframework/zf2/pull/7391)
- [7392: improvments for Zend\InputFilter](https://github.com/zendframework/zf2/pull/7392)
- [7393: implements @todo write more tests for Zend\Ldap\Converter::toLdap()](https://github.com/zendframework/zf2/pull/7393)
- [7394: fixed return type on disconnect method in pgsql connection](https://github.com/zendframework/zf2/pull/7394)
- [7396: added connection type to allow force new connection](https://github.com/zendframework/zf2/pull/7396)
- [7397: &#91;travis&#92; Remove some old hacks](https://github.com/zendframework/zf2/pull/7397)
- [7398: &#91;travis&#92; Enable memcache and redis services](https://github.com/zendframework/zf2/pull/7398)
- [7406: Update AutoDiscover.php](https://github.com/zendframework/zf2/pull/7406)
- [7407: Sql-query breaks on 2.4.0 compare to 2.3.7](https://github.com/zendframework/zf2/issues/7407)
- [7408: Zend\Code\Generator\ClassGenerator can not generate final classes](https://github.com/zendframework/zf2/pull/7408)
- [7412: Use === and !== in null checks instead of == and !=](https://github.com/zendframework/zf2/pull/7412)
- [7413: increase loop performance by assign count() to variable](https://github.com/zendframework/zf2/pull/7413)
- [7415: XMLRPC Incompatibility with HHVM](https://github.com/zendframework/zf2/pull/7415)
- [7417: replace self::EOL with PHP&#95;EOL as AbstractHtmlElement::EOL is deprecated](https://github.com/zendframework/zf2/pull/7417)
- [7419: Updated the CA language pack](https://github.com/zendframework/zf2/pull/7419)
- [7420: implements tests's @todo of ZendTest\Http\Header\AuthorizationTest](https://github.com/zendframework/zf2/pull/7420)
- [7422: Get correct expression string when Zend\Db\Sql\Expression is used](https://github.com/zendframework/zf2/pull/7422)
- [7423: Test for percentage sign in Zend\Db\Sql\Expression](https://github.com/zendframework/zf2/pull/7423)
- [7425: update variable name : $myParams to $pageParams](https://github.com/zendframework/zf2/pull/7425)
- [7426: Fixed form collections with nested fieldsets that implements InputfilterProviderInterface](https://github.com/zendframework/zf2/pull/7426)
- [7431: zf7428 fixed issue with inconsistent getTrait() behaviour #7428](https://github.com/zendframework/zf2/pull/7431)
- [7432: update Zend&#95;Validate.php resource file for 2.4](https://github.com/zendframework/zf2/pull/7432)
- [7433: Update Zend&#95;Validate.php for &quot;id&quot; for 2.4](https://github.com/zendframework/zf2/pull/7433)
- [7436: remove version&#95;compare check for PHP &gt;=5.3.7](https://github.com/zendframework/zf2/pull/7436)
- [7446: bugfix removing multiple fieldsets does't work](https://github.com/zendframework/zf2/pull/7446)
- [7451: partialLoop notice #7450](https://github.com/zendframework/zf2/pull/7451)
- [7453: update url to 'current' at INSTALL.md](https://github.com/zendframework/zf2/pull/7453)
- [7460: Update PHP CS Fixer to v1.7](https://github.com/zendframework/zf2/pull/7460)
- [7461: CS: The PHP constants true, false, and null MUST be in lower case.](https://github.com/zendframework/zf2/pull/7461)
- [7462: CS: single&#95;line&#95;after&#95;imports](https://github.com/zendframework/zf2/pull/7462)
- [7468: Replace whitespace in the parameter prefix option passed to AbstractSql::processExpression](https://github.com/zendframework/zf2/pull/7468)
- [7474: Implement expected Input::isValid workflow](https://github.com/zendframework/zf2/pull/7474)
- [7476: &#91;test&#92; Replace assert(True|False) with more appropriate assertions where possible](https://github.com/zendframework/zf2/pull/7476)
- [7477: &#91;travis&#92; Colorize PHPUnit output (requires PHPUnit ~4.6)](https://github.com/zendframework/zf2/pull/7477)
- [7478: &#91;memory&#92; isLocked sometimes return integer instead bool](https://github.com/zendframework/zf2/pull/7478)
- [7480: &#91;travis-ci&#92;&nbsp;HHVM nightly is not supported](https://github.com/zendframework/zf2/pull/7480)
- [7481: CS remove unused uses](https://github.com/zendframework/zf2/pull/7481)
- [7482: Fix undefined PGSQL&#95;CONNECT&#95;ASYNC only present in PHP 5.6](https://github.com/zendframework/zf2/pull/7482)
- [7483: &#91;#7396&#92; Functionality only works in PHP &gt;= 5.6](https://github.com/zendframework/zf2/pull/7483)
- [7485: &#91;config&#92;&#91;test&#92; Fix assertContains should be assertArrayHasKey](https://github.com/zendframework/zf2/pull/7485)
- [7489: Updated phpDoc and removed duplicates](https://github.com/zendframework/zf2/pull/7489)
- [7490: mongo: mentions of redis removed](https://github.com/zendframework/zf2/pull/7490)
- [7492: &#91;stdlib&#92;&#91;test&#92; Fix Deprecated notice for Non-static method called static](https://github.com/zendframework/zf2/pull/7492)
- [7493: &#91;travis-ci&#92; Print list of PEAR packages installed and their versions](https://github.com/zendframework/zf2/pull/7493)
- [7494: &#91;db&#92;&#91;pgsql&#92;&#91;test&#92; Fix testDisconnect](https://github.com/zendframework/zf2/pull/7494)
- [7495: &#91;console&#92; Assert only int error levels are set](https://github.com/zendframework/zf2/pull/7495)

### SECURITY UPDATES

- **ZF2015-04**: `Zend\Mail` and `Zend\Http` were both susceptible to CRLF
  Injection Attack vectors (for HTTP, this is often referred to as HTTP Response
  Splitting). Both components were updated to perform header value validations
  to ensure no values contain characters not detailed in their corresponding
  specifications, and will raise exceptions on detection. Each also provides new
  facilities for both validating and filtering header values prior to injecting
  them into header classes.

  If you use either `Zend\Mail` or `Zend\Http` (which includes users of
  `Zend\Mvc`), we recommend upgrading immediately.

## 2.4.0 (2015-03-31)

- [4122: Update EM-&gt;trigerUntil to be an alias of trigger](https://github.com/zendframework/zf2/pull/4122)
- [4221: set shared false for view&#95;helpers doesn't work](https://github.com/zendframework/zf2/issues/4221)
- [4726: Add maxLength to ParameterContainer](https://github.com/zendframework/zf2/pull/4726)
- [5001: Zend\Db transaction api unification](https://github.com/zendframework/zf2/pull/5001)
- [5142: Zend/Db/Sql/Select - implements multiple combine statements](https://github.com/zendframework/zf2/pull/5142)
- [5320: Zend\Db\Predicates - allow use different types of arguments in any position](https://github.com/zendframework/zf2/pull/5320)
- [5505: Zend db nested transactions](https://github.com/zendframework/zf2/pull/5505)
- [5518: Paginator\Adapter\DbSelect custom query for count](https://github.com/zendframework/zf2/pull/5518)
- [5600: FlashMessanger escaping](https://github.com/zendframework/zf2/issues/5600)
- [5656: undefines indexes on hostname route](https://github.com/zendframework/zf2/issues/5656)
- [5683: fix Zend\Db\Adapter\Platform\PlatformInterface::quoteIdentifierInFragment](https://github.com/zendframework/zf2/pull/5683)
- [5699: Form\View\Helper\FormRow label position gets overwritten by &#95;&#95;invoke()](https://github.com/zendframework/zf2/issues/5699)
- [5701: Db\Sql - cleaning code duplicates](https://github.com/zendframework/zf2/pull/5701)
- [5742: Fix for issue #5699 - Disable label position caching for Zend\View\Helper\FormRow::&#95;&#95;invoke()](https://github.com/zendframework/zf2/pull/5742)
- [5743: Add auto escape method to Zend\View\Helper\FlashMessenger](https://github.com/zendframework/zf2/pull/5743)
- [6058: Timestamp log filter](https://github.com/zendframework/zf2/pull/6058)
- [6067: &#91;BC&#95;BREAK&#92; Fixes #6063](https://github.com/zendframework/zf2/pull/6067)
- [6073: Reduced code duplication in FlashMessenger plugin](https://github.com/zendframework/zf2/pull/6073)
- [6078: Add MongoDB adapter for Zend\Cache](https://github.com/zendframework/zf2/pull/6078)
- [6080: Use AuthenticationServiceInterface as type](https://github.com/zendframework/zf2/pull/6080)
- [6084: Zend\Loader\ClassMapAutoloader - Performance improvement #5716](https://github.com/zendframework/zf2/pull/6084)
- [6091: Added map naming strategy for hydrator](https://github.com/zendframework/zf2/pull/6091)
- [6095: Wrong @return value in PhpDoc for Sql Update class.](https://github.com/zendframework/zf2/issues/6095)
- [6097: Fixed return value for method. #6095](https://github.com/zendframework/zf2/pull/6097)
- [6108: Zend\Test Enable trace error by default](https://github.com/zendframework/zf2/pull/6108)
- [6112: Mail transfer encoding binary](https://github.com/zendframework/zf2/pull/6112)
- [6113: Mail ContentType handles trailing semicolon properly](https://github.com/zendframework/zf2/pull/6113)
- [6137: Zend\Log\Formatter\Xml improvement to handle extra data array](https://github.com/zendframework/zf2/pull/6137)
- [6142: Optimize ClassMethods hydrate() for loops and large objects](https://github.com/zendframework/zf2/pull/6142)
- [6145: add support number of string in &#95;&#95;construct of Priority](https://github.com/zendframework/zf2/pull/6145)
- [6151: Zend\Filter\Word\SeparatorToCamelCase break on numbers](https://github.com/zendframework/zf2/issues/6151)
- [6154: Properly pass context to input filter](https://github.com/zendframework/zf2/pull/6154)
- [6156: Fix for #6151 - Filter breaks on non-alpha characters](https://github.com/zendframework/zf2/pull/6156)
- [6161: Fix pattern for mobile phone number](https://github.com/zendframework/zf2/pull/6161)
- [6175: Mutable creation options aware trait](https://github.com/zendframework/zf2/pull/6175)
- [6178: Enhancement: Do not overwrite requestId if extra already has one](https://github.com/zendframework/zf2/pull/6178)
- [6183: Enhancement: Introduce ReferenceId processor](https://github.com/zendframework/zf2/pull/6183)
- [6194: Created hydrator strategy chain](https://github.com/zendframework/zf2/pull/6194)
- [6196: Added possibility to render view with short reference (added RelativeFallbackResolver).](https://github.com/zendframework/zf2/pull/6196)
- [6197: Added array map naming strategy](https://github.com/zendframework/zf2/pull/6197)
- [6203: Clean up repeat code by using already implemented AbstractListenerAggreg...](https://github.com/zendframework/zf2/pull/6203)
- [6208: #6207 should be cleaned up for ZF 2.4.0](https://github.com/zendframework/zf2/issues/6208)
- [6216: &#91;travis&#92; Adds hhvm-nightly](https://github.com/zendframework/zf2/pull/6216)
- [6227: Created Explode Strategy for hydrator](https://github.com/zendframework/zf2/pull/6227)
- [6232: Fix return type](https://github.com/zendframework/zf2/pull/6232)
- [6240: Form\Fieldset use priority list](https://github.com/zendframework/zf2/pull/6240)
- [6242: Stdlib\PriorityList fix current and iterator](https://github.com/zendframework/zf2/pull/6242)
- [6246:  I18n - Allow custom translation loaders to be injected via module config #6244](https://github.com/zendframework/zf2/pull/6246)
- [6247: Added new base path option specifically for console](https://github.com/zendframework/zf2/pull/6247)
- [6252: Add clearByPrefix to Redis Cache Storage](https://github.com/zendframework/zf2/pull/6252)
- [6257: Zend\Db\Sql\Ddl Improvements](https://github.com/zendframework/zf2/pull/6257)
- [6259: Cache-Storage: make sure a '.post' event will be triggered](https://github.com/zendframework/zf2/pull/6259)
- [6267: Support commas in names](https://github.com/zendframework/zf2/pull/6267)
- [6268: Make AddressList logic more accessible](https://github.com/zendframework/zf2/pull/6268)
- [6271: HTML5 compliant form attributes](https://github.com/zendframework/zf2/pull/6271)
- [6274: ZendCode - allow const and property of same name](https://github.com/zendframework/zf2/issues/6274)
- [6288: Fixes #6274 added proper support for constants](https://github.com/zendframework/zf2/pull/6288)
- [6289: Created DateTime Formater strategy for hydrator](https://github.com/zendframework/zf2/pull/6289)
- [6296: Show actual contents on assert*QueryContentContains](https://github.com/zendframework/zf2/pull/6296)
- [6301: Replacing self:: with static:: in Http\Client::setAuth](https://github.com/zendframework/zf2/pull/6301)
- [6322: Change &quot;Unknown Error&quot; with current internal list of messages](https://github.com/zendframework/zf2/pull/6322)
- [6338: Adding a new static ::fromTime($time) method to AbstractDate](https://github.com/zendframework/zf2/pull/6338)
- [6339: Closes issue #4876 - added support for trait generation and trait scanning](https://github.com/zendframework/zf2/pull/6339)
- [6359: Date validator problem vant validate big unix timestamps](https://github.com/zendframework/zf2/pull/6359)
- [6367: Added composite hydrator naming strategy](https://github.com/zendframework/zf2/pull/6367)
- [6370: FirePhp log writer works incorrectly with extra parameters.](https://github.com/zendframework/zf2/issues/6370)
- [6374: add $label parameters to error, warn, info, log methods. issue #6370](https://github.com/zendframework/zf2/pull/6374)
- [6385: \Zend\Http\Request - Uncaught InvalidArgumentException when the request method is not considered valid.](https://github.com/zendframework/zf2/issues/6385)
- [6386: Priority system for validators](https://github.com/zendframework/zf2/issues/6386)
- [6396: Use data provider in PhoneNumberTest.](https://github.com/zendframework/zf2/pull/6396)
- [6399: Fix controller tests to support HTTP PATCH method](https://github.com/zendframework/zf2/pull/6399)
- [6403: Removing $class-&gt;newInstanceArgs($this-&gt;creationOptions) from Zend\Paginator\Adapter\Service\DbSelectFactory ](https://github.com/zendframework/zf2/issues/6403)
- [6409: Fix #6385 Request exception](https://github.com/zendframework/zf2/pull/6409)
- [6419: missing dependency for zendframework/zend-feed stand-alone](https://github.com/zendframework/zf2/issues/6419)
- [6420: Zend\Code\Generator\MethodGenerator does not accept parameters as array](https://github.com/zendframework/zf2/issues/6420)
- [6422: Zend\Code\Generator\MethodGenerator now accepts parameter as array](https://github.com/zendframework/zf2/pull/6422)
- [6424: Add missing codes that can be caught by register&#95;shutdown&#95;function](https://github.com/zendframework/zf2/pull/6424)
- [6431: added method to merge input filters](https://github.com/zendframework/zf2/pull/6431)
- [6437: New Template resolver just like PSR-4 autoloader](https://github.com/zendframework/zf2/issues/6437)
- [6438: Added the file encryption/decryption to Zend\Crypt](https://github.com/zendframework/zf2/pull/6438)
- [6464: Repeal `autocomplete` form attribute being boolean](https://github.com/zendframework/zf2/pull/6464)
- [6481: Refactor german (de) Zend&#95;Validate.php](https://github.com/zendframework/zf2/pull/6481)
- [6496: #6386 Add Priority system for validators](https://github.com/zendframework/zf2/pull/6496)
- [6523: Hydrator Strategy to extract and hydrate Boolean values](https://github.com/zendframework/zf2/pull/6523)
- [6534: PHPCS fixes for Zend\Db](https://github.com/zendframework/zf2/pull/6534)
- [6538: PHPCS fixes for Zend\Escaper](https://github.com/zendframework/zf2/pull/6538)
- [6540: PHPCS fixes for Zend\Valiator](https://github.com/zendframework/zf2/pull/6540)
- [6545: Add UpperCaseWords filter](https://github.com/zendframework/zf2/pull/6545)
- [6552: Remove double dots from cache path without keys](https://github.com/zendframework/zf2/pull/6552)
- [6553: Method for adding extra identifiers to Abstract Controller Event Manager](https://github.com/zendframework/zf2/pull/6553)
- [6556: DDL component fixes](https://github.com/zendframework/zf2/pull/6556)
- [6560:  AbstractAdapter::getItem() should return null, if the item cannot be retrieved](https://github.com/zendframework/zf2/pull/6560)
- [6568: Add failing test for encoded routes with a query](https://github.com/zendframework/zf2/pull/6568)
- [6570: Add ability to set SMTP envelope addresses](https://github.com/zendframework/zf2/pull/6570)
- [6571: Allow HTTP client configuration to be supplied when using ClientStatic](https://github.com/zendframework/zf2/pull/6571)
- [6572: Rem unneeded factories ( ViewFeedRendererFactory and ViewJsonRendererFactory )](https://github.com/zendframework/zf2/pull/6572)
- [6574: Fixes #6403](https://github.com/zendframework/zf2/pull/6574)
- [6580: remove double suggest block at Zend\Version\composer.json](https://github.com/zendframework/zf2/pull/6580)
- [6581: activate commented Exception in Validator/Between::&#95;&#95;construct](https://github.com/zendframework/zf2/pull/6581)
- [6592: Remove Identical validator type hint](https://github.com/zendframework/zf2/pull/6592)
- [6604: PATCH request test (Zend\Test\PHPUnit\Controller)](https://github.com/zendframework/zf2/issues/6604)
- [6613: Deprecate &#91;Global&#92;EventManager::triggerUntil()](https://github.com/zendframework/zf2/pull/6613)
- [6615: Add controller's implemented interfaces to its shared event manager default identifiers](https://github.com/zendframework/zf2/pull/6615)
- [6621: Use hash&#95;equals for constant-time string comparison](https://github.com/zendframework/zf2/pull/6621)
- [6646: Added password prompt to Console](https://github.com/zendframework/zf2/pull/6646)
- [6656: A getElements method has been added to DateSelect and MonthSelect which ...](https://github.com/zendframework/zf2/pull/6656)
- [6657: bugfix unfolding email multi-line header ](https://github.com/zendframework/zf2/pull/6657)
- [6667: Added &quot;zendframework/zend-filter&quot; into suggest at Zend\Stdlib](https://github.com/zendframework/zf2/pull/6667)
- [6669: Support subscribing to folders in IMAP](https://github.com/zendframework/zf2/pull/6669)
- [6675: Fixed the unit tests on Windows. The /tmp folder doesn't exist so we sho...](https://github.com/zendframework/zf2/pull/6675)
- [6678: Timezone validator](https://github.com/zendframework/zf2/pull/6678)
- [6679: TemplateWrapper getter](https://github.com/zendframework/zf2/pull/6679)
- [6682: PHPCS fixes for Zend\XmlRpc](https://github.com/zendframework/zf2/pull/6682)
- [6683: PHPCS fixes for Zend\Uri](https://github.com/zendframework/zf2/pull/6683)
- [6691: fixed removing handled header parts from response header](https://github.com/zendframework/zf2/pull/6691)
- [6709: HtmlTag helper](https://github.com/zendframework/zf2/pull/6709)
- [6712: Added form annotation builder factory](https://github.com/zendframework/zf2/pull/6712)
- [6731: fix for FilesSize validator usage with Input](https://github.com/zendframework/zf2/pull/6731)
- [6734: Remove PHPCov dependency via VCS composer repository](https://github.com/zendframework/zf2/issues/6734)
- [6740: Fix for Zend\Db\TableGateway: Alias for table #6726](https://github.com/zendframework/zf2/pull/6740)
- [6746: Di runtime definition optimisation - Cache result of processing and inline the check](https://github.com/zendframework/zf2/pull/6746)
- [6747: DI definition list optimisation - Cache classes upfront where possible to reduce iterations](https://github.com/zendframework/zf2/pull/6747)
- [6752: Added ability to specify label position as an element label option](https://github.com/zendframework/zf2/pull/6752)
- [6753: Input filter annotation fix](https://github.com/zendframework/zf2/pull/6753)
- [6754: Added preserve&#95;defined&#95;order flag to annotation builder](https://github.com/zendframework/zf2/pull/6754)
- [6756: implements @todo for setters/getters at Zend\Mime\Part](https://github.com/zendframework/zf2/pull/6756)
- [6757: implements @todo for getFileName() from path at Zend\Code\Reflection\FileReflection](https://github.com/zendframework/zf2/pull/6757)
- [6758: add getAdapterInstance() that return adapter instance at Zend\Filter\Encrypt](https://github.com/zendframework/zf2/pull/6758)
- [6775: Add options to mail file](https://github.com/zendframework/zf2/pull/6775)
- [6783: Added continueIfEmpty annotation to Zend Form](https://github.com/zendframework/zf2/pull/6783)
- [6786: Fixes #4221 : set shared false for view&#95;helpers should create new instance](https://github.com/zendframework/zf2/pull/6786)
- [6790: Test/Db/Adapter/Platform/SqlServerTest restore&#95;error&#95;handler();](https://github.com/zendframework/zf2/pull/6790)
- [6799: Zend\Db: Allow adding native predicates to sql queries, respecting nextPredicateCombineOrder](https://github.com/zendframework/zf2/pull/6799)
- [6800: Zend\Db\Sql\Predicate\Predicate: $nextPredicateCombineOperator + addPredicate() not working](https://github.com/zendframework/zf2/issues/6800)
- [6801: fix unit tests for Windows](https://github.com/zendframework/zf2/pull/6801)
- [6808: Paginator item counts for empty result sets are inaccurate](https://github.com/zendframework/zf2/issues/6808)
- [6809: Corrects firstItemCount for empty result sets](https://github.com/zendframework/zf2/pull/6809)
- [6812: Zend\Paginator\Paginator's  getItem() trigger an &quot;Fatal error: ...&quot; ](https://github.com/zendframework/zf2/issues/6812)
- [6817: Fixes #6812 : Zend\Paginator\Adapter\DbSelect::getItems should return array](https://github.com/zendframework/zf2/pull/6817)
- [6827: Fix inability to translate to languages which don't have plural forms](https://github.com/zendframework/zf2/pull/6827)
- [6829: coveralls coverage doesnot work on latest travis build](https://github.com/zendframework/zf2/issues/6829)
- [6833: &#91;Zend\ServiceManager&#92; Improve error handling in the abstract plugin manager](https://github.com/zendframework/zf2/pull/6833)
- [6838: QuoteValueList for MySql platform fails with multiple empty values.](https://github.com/zendframework/zf2/issues/6838)
- [6839: Fixes bug #6838, quoteValueList fails with multiple empty values.](https://github.com/zendframework/zf2/pull/6839)
- [6850: Removed impossible condition](https://github.com/zendframework/zf2/pull/6850)
- [6856: Soap Connection Timeout](https://github.com/zendframework/zf2/pull/6856)
- [6863: Fixes CS in develop in latest travis build : unused use](https://github.com/zendframework/zf2/pull/6863)
- [6864: Broken develop branch](https://github.com/zendframework/zf2/issues/6864)
- [6866: &#91;Console&#92; ViewManager hides exceptions in console](https://github.com/zendframework/zf2/issues/6866)
- [6870: Hostname route should throw an exception if route definition contains disallowed character](https://github.com/zendframework/zf2/pull/6870)
- [6874: Fixes CS on latest develop as php-cs-fixer updated to 1.*](https://github.com/zendframework/zf2/pull/6874)
- [6884: Stdlib\Options: Misc enhancements ](https://github.com/zendframework/zf2/pull/6884)
- [6885: Fixes CS in latest develop](https://github.com/zendframework/zf2/pull/6885)
- [6886: Set user and password in Http class](https://github.com/zendframework/zf2/pull/6886)
- [6890: allow use differents Adapter for build SqlObjects via Db\Sql (v2)](https://github.com/zendframework/zf2/pull/6890)
- [6894: standard hydrator idea](https://github.com/zendframework/zf2/pull/6894)
- [6899: Abilty to remove key during merge](https://github.com/zendframework/zf2/pull/6899)
- [6903: Ability to replace key in ArrayUtils::merge](https://github.com/zendframework/zf2/pull/6903)
- [6909: phpunit 4.x, phpcov 2.x (see #6029)](https://github.com/zendframework/zf2/pull/6909)
- [6912: Hotfix: #6386 #6496 validator chain merge type mismatch](https://github.com/zendframework/zf2/pull/6912)
- [6924: fix BC for #6890](https://github.com/zendframework/zf2/pull/6924)
- [6930: allow to filter the templates by extension in the templatemap generator](https://github.com/zendframework/zf2/pull/6930)
- [6931: Added consts for left and right outer joins](https://github.com/zendframework/zf2/pull/6931)
- [6934: create a new file if mode is append and the file does not exist](https://github.com/zendframework/zf2/pull/6934)
- [6940: Fixes CS on latest build on develop : braces](https://github.com/zendframework/zf2/pull/6940)
- [6942: Update phpunit to 4.0.0 in CONTRIBUTING.md, tests/Bootstrap.php, and Zend\Test\composer.json](https://github.com/zendframework/zf2/pull/6942)
- [6951: PR for #6866 - Allow console specific view manager configuration](https://github.com/zendframework/zf2/pull/6951)
- [6956: Move error view model generation methods to abstract controller](https://github.com/zendframework/zf2/pull/6956)
- [6962: New Whitelist / Blacklist Filter](https://github.com/zendframework/zf2/pull/6962)
- [6963: Feature/#6441 prefix path resolver](https://github.com/zendframework/zf2/pull/6963)
- [6969: Remove unused code ](https://github.com/zendframework/zf2/pull/6969)
- [6970: &#91;ZendTest\View\Helper&#92; - Fix setUp configuration](https://github.com/zendframework/zf2/pull/6970)
- [6983: test digest response is validated](https://github.com/zendframework/zf2/pull/6983)
- [7003: Fixing prepended `NotEmpty` validator](https://github.com/zendframework/zf2/pull/7003)
- [7004: add and apply function&#95;call&#95;space fixer for PHP CS Fixer](https://github.com/zendframework/zf2/pull/7004)
- [7010: Add support for providers in InputFilter factory](https://github.com/zendframework/zf2/pull/7010)
- [7014: CS: `return` instead of `return null`](https://github.com/zendframework/zf2/pull/7014)
- [7015: Found bugs in  `Zend\Db\Sql\Ddl` classes and tests](https://github.com/zendframework/zf2/pull/7015)
- [7016: Adapt Json\Json for better prettyPrint support](https://github.com/zendframework/zf2/pull/7016)
- [7020: Documenation fixes in eventmanager](https://github.com/zendframework/zf2/pull/7020)
- [7021: CS: join to implode](https://github.com/zendframework/zf2/pull/7021)
- [7024: CS: There MUST be one use keyword per declaration.](https://github.com/zendframework/zf2/pull/7024)
- [7025: CS: Removes line breaks between use statements.](https://github.com/zendframework/zf2/pull/7025)
- [7026: CS: There MUST be one blank line after the namespace declaration.](https://github.com/zendframework/zf2/pull/7026)
- [7027: CS: There MUST NOT be a space after the opening parenthesis. There MUST NOT be a space before the closing parenthesis.](https://github.com/zendframework/zf2/pull/7027)
- [7028: CS: .php&#95;cs - add standardize&#95;not&#95;equal fixer](https://github.com/zendframework/zf2/pull/7028)
- [7029: CS: In method arguments and method call, there MUST NOT be a space before each comma and there MUST be one space after each comma.](https://github.com/zendframework/zf2/pull/7029)
- [7031: use of undefined variable in Zend\Cache\Storage\Adapter\Apc::internalGetMetadatas()](https://github.com/zendframework/zf2/issues/7031)
- [7032: fixed #7031: use of undefined variable in ZendCacheStorageAdapterApc](https://github.com/zendframework/zf2/pull/7032)
- [7034: MongoDB to MongoDb](https://github.com/zendframework/zf2/pull/7034)
- [7037: &#91;ZendTest\Mvc&#92; Fix setUp configuration](https://github.com/zendframework/zf2/pull/7037)
- [7038: &#91;Db\Sql\Platform\Mysql\Ddl&#92; override getSqlString() is wrong](https://github.com/zendframework/zf2/pull/7038)
- [7039: Cache: better fix for #5860 introduced in #5863](https://github.com/zendframework/zf2/pull/7039)
- [7043: Cache: better compatibility with APCu](https://github.com/zendframework/zf2/pull/7043)
- [7046: Retrieve the InjectTemplateListener from the service manager.](https://github.com/zendframework/zf2/pull/7046)
- [7049: CS: Remove trailing whitespace the end of blank lines.](https://github.com/zendframework/zf2/pull/7049)
- [7050: PHP CS Fixer - correct link](https://github.com/zendframework/zf2/pull/7050)
- [7052: .php&#95;cs - add encoding fixer](https://github.com/zendframework/zf2/pull/7052)
- [7053: CS: PHP keywords MUST be in lower case](https://github.com/zendframework/zf2/pull/7053)
- [7056: Refactoring and bugfixes for InputFilter component](https://github.com/zendframework/zf2/pull/7056)
- [7057: Travis - show PHP CS Fixer diff](https://github.com/zendframework/zf2/pull/7057)
- [7067: Travis: running more tests for cache component](https://github.com/zendframework/zf2/pull/7067)
- [7071: Documentation improvements Zend/DB](https://github.com/zendframework/zf2/pull/7071)
- [7073: UnderscoreToCamelCase fails with digits](https://github.com/zendframework/zf2/issues/7073)
- [7075: Improving readability, removing redundancies on RBAC](https://github.com/zendframework/zf2/pull/7075)
- [7079:  Fixes CS latest build on travis : develop](https://github.com/zendframework/zf2/pull/7079)
- [7081: try fix travis cs develop again](https://github.com/zendframework/zf2/pull/7081)
- [7091: Added Checkbox Console Prompt and its tests](https://github.com/zendframework/zf2/pull/7091)
- [7092: #7055 - stricter validation of `TableIdentifier` parameters](https://github.com/zendframework/zf2/pull/7092)
- [7097: removed unused import](https://github.com/zendframework/zf2/pull/7097)
- [7102: Add Kosovo phone number specifications](https://github.com/zendframework/zf2/pull/7102)
- [7104: DataUnitFormatter filter](https://github.com/zendframework/zf2/pull/7104)
- [7105: WindowsAnsicon - fix docs](https://github.com/zendframework/zf2/pull/7105)
- [7106: UriTest - fix phpdoc](https://github.com/zendframework/zf2/pull/7106)
- [7120: Added trailing comma for multiline arrays](https://github.com/zendframework/zf2/pull/7120)
- [7121: Feature: Added sslverifypeer to curl adapter](https://github.com/zendframework/zf2/pull/7121)
- [7122: Paginator Iterator](https://github.com/zendframework/zf2/pull/7122)
- [7124: Interface for the Zend\Feed\Reader\Reader](https://github.com/zendframework/zf2/issues/7124)
- [7125: Adding ImportInterface for Zend\Feed\Reader\Reader](https://github.com/zendframework/zf2/pull/7125)
- [7128: SessionManagerFactory + session validators via config makes validation always fail](https://github.com/zendframework/zf2/pull/7128)
- [7141: Implement BcryptSha Hashing &amp; Harden Verification Checks](https://github.com/zendframework/zf2/pull/7141)
- [7152: Fixes #4936](https://github.com/zendframework/zf2/pull/7152)
- [7153: Disabling XDebug when not computing coverage](https://github.com/zendframework/zf2/pull/7153)
- [7159: Use getEncoding() instead of accessing options array directly](https://github.com/zendframework/zf2/pull/7159)
- [7163: Fix typos in inArray validators phpdoc](https://github.com/zendframework/zf2/pull/7163)
- [7164: .php&#95;cs - add few rules](https://github.com/zendframework/zf2/pull/7164)
- [7171: Reset password value on $form-&gt;prepare()](https://github.com/zendframework/zf2/pull/7171)
- [7176: Update PostCode.php](https://github.com/zendframework/zf2/pull/7176)
- [7177: Oracle quoting fix for values with single quotes](https://github.com/zendframework/zf2/pull/7177)
- [7178: Fixes #7136 : add ext-ldap as required extension in Ldap\composer.json](https://github.com/zendframework/zf2/pull/7178)
- [7181: Remove hidden TaggableInterface dependencies from paginator](https://github.com/zendframework/zf2/pull/7181)
- [7182: update copyright year to 2015 that still uses 2013 in &quot;develop&quot;](https://github.com/zendframework/zf2/pull/7182)
- [7183: update copyright year to 2015 that still uses 2013 in &quot;master&quot;](https://github.com/zendframework/zf2/pull/7183)
- [7184: FormButton $buttonContent parameter is now translated](https://github.com/zendframework/zf2/pull/7184)
- [7188: fix test pattern in FormDateTimeSelectTest::testCanRenderTextDelimiters](https://github.com/zendframework/zf2/pull/7188)
- [7189: add test for nested glob patterns](https://github.com/zendframework/zf2/pull/7189)
- [7190: Test for array of PDO connection params](https://github.com/zendframework/zf2/pull/7190)
- [7194: fix some of the documentation errors](https://github.com/zendframework/zf2/pull/7194)
- [7201: Additional tests for zf-code](https://github.com/zendframework/zf2/pull/7201)
- [7203: Cache: fix mongo options](https://github.com/zendframework/zf2/pull/7203)
- [7210: Added fix to prevent method lines to be intended again and again](https://github.com/zendframework/zf2/pull/7210)
- [7213: Error in FirePhp log writer](https://github.com/zendframework/zf2/pull/7213)
- [7215: replace is&#95;a() with instanceof](https://github.com/zendframework/zf2/pull/7215)
- [7222: Db\Sql\Select.php processJoins quote identifier error](https://github.com/zendframework/zf2/issues/7222)
- [7225: Fix for #7219 - Validation failure fr-CH in testValidationFailures](https://github.com/zendframework/zf2/pull/7225)
- [7231: Skip tests in ZendTest\View if ext-intl is not installed](https://github.com/zendframework/zf2/pull/7231)
- [7232: Remove unnecessary ternary operators](https://github.com/zendframework/zf2/pull/7232)
- [7233: Detect https on reversed proxy](https://github.com/zendframework/zf2/pull/7233)
- [7235: Fixing Docblock return type for &#95;&#95;invoke](https://github.com/zendframework/zf2/pull/7235)
- [7239: Fixes #7238 : Logger::log() exception message](https://github.com/zendframework/zf2/pull/7239)
- [7240: Feature: Zend\Mvc\HttpMethodListener](https://github.com/zendframework/zf2/pull/7240)
- [7241: Removed non existing curl options](https://github.com/zendframework/zf2/pull/7241)
- [7242: Add flexibility to FlashMessenger by determining hops as parameter.](https://github.com/zendframework/zf2/pull/7242)
- [7245: &#91;Navigation&#92; Introducing NavigationAbstractServiceFactory](https://github.com/zendframework/zf2/pull/7245)
- [7247: Add input&#95;filter&#95;specs feature from zfcampus/zf-content-validation and associated tests](https://github.com/zendframework/zf2/pull/7247)
- [7248: Remove CURLOPT&#95;POSTFIELDS from set of invalid curl options](https://github.com/zendframework/zf2/pull/7248)
- [7251: Fixed tests for quoteValue() methods in all Platform classes](https://github.com/zendframework/zf2/pull/7251)
- [7254: Ship a StandaloneExtensionManager for Zend\Feed\Reader](https://github.com/zendframework/zf2/pull/7254)
- [7255: Added $data param to deleteList](https://github.com/zendframework/zf2/pull/7255)
- [7256: fixed count error in config class](https://github.com/zendframework/zf2/pull/7256)
- [7258: Db Platform refactoring](https://github.com/zendframework/zf2/pull/7258)
- [7259: Override reason phrase by changing status code](https://github.com/zendframework/zf2/pull/7259)
- [7262: DateStep time for moscow fixes #7261](https://github.com/zendframework/zf2/pull/7262)
- [7264: Updated GB postcode regex to assert start and end positions for middle a...](https://github.com/zendframework/zf2/pull/7264)
- [7267: DBA inifile is not supported for caching](https://github.com/zendframework/zf2/pull/7267)
- [7275: #7222 processJoins quote identifier error fix](https://github.com/zendframework/zf2/pull/7275)
- [7276: Adds preserve defined order as a factory option](https://github.com/zendframework/zf2/pull/7276)
- [7277: Date select filter](https://github.com/zendframework/zf2/pull/7277)
- [7281: Fix: Email Validator vs IDN](https://github.com/zendframework/zf2/pull/7281)
- [7282: Fix: Array to string conversion in Zend\Log\Writer\Db](https://github.com/zendframework/zf2/pull/7282)
- [7285: Fixed documentation on $path property](https://github.com/zendframework/zf2/pull/7285)
- [7287: AbstractOptions isset issue, #7286](https://github.com/zendframework/zf2/pull/7287)
- [7290: Allow literal zero string as sql expression](https://github.com/zendframework/zf2/pull/7290)
- [7292: Fix call to method not in ExpressionInterface](https://github.com/zendframework/zf2/pull/7292)
- [7294: Feature/log writer mail factory](https://github.com/zendframework/zf2/pull/7294)
- [7295: Zend\Http\Header\GenericHeader introduces BC break](https://github.com/zendframework/zf2/pull/7295)
- [7296: Fix infinite loop when chaining peering service managers](https://github.com/zendframework/zf2/pull/7296)
- [7299: Fix reflection for one line docblocks](https://github.com/zendframework/zf2/pull/7299)
- [7303: update TLD list](https://github.com/zendframework/zf2/pull/7303)
- [7307: Automatic TLDs update for Zend\Validator\Hostname](https://github.com/zendframework/zf2/pull/7307)
- [7309: Hotfix/additional form options error case](https://github.com/zendframework/zf2/pull/7309)
- [7310: Callback Authentication Adapter](https://github.com/zendframework/zf2/pull/7310)
- [7311: Using TableGateway::insert() fails when table has an alias](https://github.com/zendframework/zf2/pull/7311)
- [7314: add getter method for object prototype to Zend\Db\ResultSet\HydratingResultSet](https://github.com/zendframework/zf2/pull/7314)
- [7315: array&#95;filter compatibility](https://github.com/zendframework/zf2/pull/7315)
- [7325: Changed fileprg annotation to type hint on FormInterface](https://github.com/zendframework/zf2/pull/7325)
- [7326: added doc-block @ Zend\InputFilter\InputInterface](https://github.com/zendframework/zf2/pull/7326)
- [7327: Rbac callback assertion](https://github.com/zendframework/zf2/pull/7327)
- [7328: Acl callback assertion](https://github.com/zendframework/zf2/pull/7328)
- [7329: added basic support for digest authentication on curl adapters](https://github.com/zendframework/zf2/pull/7329)
- [7332: Zend\Http\Client sends content-type: application/x-www-form-urlencoded with GET request](https://github.com/zendframework/zf2/pull/7332)
- [7334: feature: add bcrypt support to apache http basic auth](https://github.com/zendframework/zf2/pull/7334)
- [7336: Allowing the route match controller to override the controller class](https://github.com/zendframework/zf2/pull/7336)
- [7340: Fix testing issues under 5.3](https://github.com/zendframework/zf2/pull/7340)
- [7341: Set disabled attribute also on checkbox hidden element](https://github.com/zendframework/zf2/pull/7341)
- [7342: Do not throw exception when isset is used on AbstractOptions existing object variable](https://github.com/zendframework/zf2/pull/7342)
- [7343: Pdo fetch mode support](https://github.com/zendframework/zf2/pull/7343)
- [7345: use the target host and not the proxy host in the client hello request](https://github.com/zendframework/zf2/pull/7345)
- [7346: Add missing return statement.](https://github.com/zendframework/zf2/pull/7346)
- [7353: Added flag UNSEEN in Zend\Mail\Storage.](https://github.com/zendframework/zf2/pull/7353)
- [7354: Added test for Validator\IsInstanceOf passed $options without &quot;className&quot; key](https://github.com/zendframework/zf2/pull/7354)
- [7355: update &quot;ircmaxell/random-lib&quot; version to fix travis's composer install error](https://github.com/zendframework/zf2/pull/7355)
- [7358: Explode validator provides context to composed validator](https://github.com/zendframework/zf2/pull/7358)
- [7359: Missing return statement in PHPDoc in AbstractNavigationFactory](https://github.com/zendframework/zf2/pull/7359)
- [7362: Fixed the unit tests for Filter OpenSSL](https://github.com/zendframework/zf2/pull/7362)
- [7364: Switch to PSR-4](https://github.com/zendframework/zf2/pull/7364)
- [7366: PHP 7 on Travis-CI (re-redux)](https://github.com/zendframework/zf2/pull/7366)
- [7369: Composer update to 2.4-RC3](https://github.com/zendframework/zf2/pull/7369)
- [7374: Adjust ContentType regex to allow quoted strings and equals](https://github.com/zendframework/zf2/pull/7374)
- [7375: Correcting](https://github.com/zendframework/zf2/pull/7375)

## 2.3.9 (2015-05-11)

- [#7506](https://github.com/zendframework/zf2/pull/7506) resolves issues when UTF-8 values are used in Mail headers, particularly addresses.
- [#7507](https://github.com/zendframework/zf2/pull/7507) ensures that array values can be used with cookies.
- [#7514](https://github.com/zendframework/zf2/pull/7514) ensures that multipart MIME messages can be added to `Zend\Mail\Message` instances in such a way that they do not conflict with ZF2015-04.

## 2.3.8 (2015-05-07)

### SECURITY UPDATES

- **ZF2015-04**: `Zend\Mail` and `Zend\Http` were both susceptible to CRLF
  Injection Attack vectors (for HTTP, this is often referred to as HTTP Response
  Splitting). Both components were updated to perform header value validations
  to ensure no values contain characters not detailed in their corresponding
  specifications, and will raise exceptions on detection. Each also provides new
  facilities for both validating and filtering header values prior to injecting
  them into header classes.

  If you use either `Zend\Mail` or `Zend\Http` (which includes users of
  `Zend\Mvc`), we recommend upgrading immediately.

## 2.3.7 (2015-03-12)

- [7255: Revert BC break against AbstractRestfulController](https://github.com/zendframework/zf2/pull/7255)

## 2.3.6 (2015-03-12)

### SECURITY UPDATES

- **ZF2015-03** `Zend\Validator\Csrf` was incorrectly testing null or
  improperly formatted token identifiers, allowing them to pass validation. This
  release provides patches to correct the behavior. If you use the validator, or
  the corresponding `Zend\Form\Element\Csrf`, we recommend upgrading
  immediately.

## 2.3.5 (2015-02-18)

- [6666: bugfix : options can't be passed to SeparatorToSeparator via PluginManager](https://github.com/zendframework/zf2/pull/6666)
- [6676: Respecting line endings in AnnotationScanner](https://github.com/zendframework/zf2/pull/6676)
- [7005: Zend\Http\PhpEnvironment\Request omits query string](https://github.com/zendframework/zf2/issues/7005)
- [7127: SessionManagerFactory with ArrayStorage triggers undefined variable](https://github.com/zendframework/zf2/pull/7127)
- [7134: classmap&#95;generator Deprecated: preg&#95;replace():](https://github.com/zendframework/zf2/issues/7134)
- [7135: Fixing deprecated preg&#95;replace usage in classmap&#95;generator.php](https://github.com/zendframework/zf2/pull/7135)
- [7137: Request from string](https://github.com/zendframework/zf2/pull/7137)
- [7139: Fixing comment about email validator, when should be uri](https://github.com/zendframework/zf2/pull/7139)
- [7142: AbstractConfigFactory returns complete configuration array at first config call](https://github.com/zendframework/zf2/issues/7142)
- [7144: hotfix/#7142: AbstractConfigFactory now returns requested config array ](https://github.com/zendframework/zf2/pull/7144)
- [7148: ModuleLoader not capable of loading modules contained within an application.phar](https://github.com/zendframework/zf2/issues/7148)
- [7150: Estonian IDN definition &amp; fixed binary code for HOST&#95;DNS&#95;OR&#95;IPV4&#95;OR&#95;IPV6&#95;OR&#95;REGNAME](https://github.com/zendframework/zf2/pull/7150)
- [7151: Applications packaged as not capable of loading modules contained within the archive](https://github.com/zendframework/zf2/pull/7151)
- [7157: Exception message in Zend\Stdlib\AbstractOptions should use the actual used setter](https://github.com/zendframework/zf2/pull/7157)
- [7162: Incorrect response for HTTP status code 414](https://github.com/zendframework/zf2/pull/7162)
- [7167: Fixation form collection helper lost second argument](https://github.com/zendframework/zf2/pull/7167)
- [7168: Typo in #6598 pull request.](https://github.com/zendframework/zf2/pull/7168)
- [7169: bugfix : options can't be passed to SeparatorToSeparator ](https://github.com/zendframework/zf2/pull/7169)
- [7170: Fixed wrong phpdoc type hint.](https://github.com/zendframework/zf2/pull/7170)
- [7180: Fix: Inline variable](https://github.com/zendframework/zf2/pull/7180)
- [7200: Add support for DateTimeImmutable](https://github.com/zendframework/zf2/pull/7200)

### SECURITY UPDATES

- **ZF2015-02:** `Zend\Db\Adapter\Platform\Postgresql` was incorrectly using
  `\\` to escape double quotes in identifiers and values, which could lead to
  SQL injection vectors. We have provided patches that use proper escaping. If
  you use Postgresql with Zend Framework 2, we recommend upgrading immediately.

## 2.3.4 (2015-01-14)

- [3758: partialLoop/partial View Helper can not be nested when using setObjectKey](https://github.com/zendframework/zf2/issues/3758)
- [4517: Incompatible with RecursiveIterator::hasChildren()  Zend\Navigation\AbstractContainer](https://github.com/zendframework/zf2/issues/4517)
- [4960: DateTime form element weird DateInterval step!?](https://github.com/zendframework/zf2/issues/4960)
- [5992: Bug fix: Removes length limit (of TLD) when validating a hostname](https://github.com/zendframework/zf2/pull/5992)
- [6231: fixing http query parameters](https://github.com/zendframework/zf2/pull/6231)
- [6263: Collection attempts to access `object` property on `$this-&gt;targetElement`](https://github.com/zendframework/zf2/issues/6263)
- [6279: Return the text value in &#95; array key](https://github.com/zendframework/zf2/pull/6279)
- [6298: Handle regular form elements as target elements of `Zend\Form\Element\Collection`.](https://github.com/zendframework/zf2/pull/6298)
- [6312: &#91;Zend\I18n&#92; php.ini setting &quot;intl.use&#95;exceptions&quot; on true](https://github.com/zendframework/zf2/issues/6312)
- [6324: Redis::setItems - the last item is overwritten](https://github.com/zendframework/zf2/issues/6324)
- [6358: Wrong datetime format in Atom 1.0 date constructs](https://github.com/zendframework/zf2/issues/6358)
- [6398: Preserve the fluent interface](https://github.com/zendframework/zf2/pull/6398)
- [6435: Race Condition in Zend\Cache\Storage\Adapter\Filesystem::prepareDirectoryStructure](https://github.com/zendframework/zf2/issues/6435)
- [6492: &#91;Http&#92; Add body support for DELETE/OPTIONS request](https://github.com/zendframework/zf2/pull/6492)
- [6518: Suggested workaround for #6263](https://github.com/zendframework/zf2/pull/6518)
- [6526: &#91;Http&#92; Rationalize timeout behavior between adapters](https://github.com/zendframework/zf2/pull/6526)
- [6537: Mime Part class rewind fix](https://github.com/zendframework/zf2/pull/6537)
- [6539: PHPCS fixes for Zend\Captcha](https://github.com/zendframework/zf2/pull/6539)
- [6548: ServiceManager peering does not respect shared flag ](https://github.com/zendframework/zf2/pull/6548)
- [6561: Remove old component fork origins](https://github.com/zendframework/zf2/issues/6561)
- [6562: replacing array&#95;key&#95;exists with faster isset calls](https://github.com/zendframework/zf2/pull/6562)
- [6569: Should we use constant for events in Zend\Db\TableGateway\Feature\EventFeature?](https://github.com/zendframework/zf2/issues/6569)
- [6573: fixes #6435: Race Condition in filesystem cache on prepare dir structure](https://github.com/zendframework/zf2/pull/6573)
- [6575: fixed #6324: Redis::setItems: the last item is overwritten](https://github.com/zendframework/zf2/pull/6575)
- [6577: added missing register services at Zend\Paginator\AdapterPluginManager](https://github.com/zendframework/zf2/pull/6577)
- [6585: Form Collection `No element by the name of &#91;2&#92; found in form`](https://github.com/zendframework/zf2/issues/6585)
- [6586: Fixes typo](https://github.com/zendframework/zf2/pull/6586)
- [6594: Update classmap&#95;generator.php](https://github.com/zendframework/zf2/pull/6594)
- [6598: add try/catch around statements that execute intl&#95;is&#95;failure()](https://github.com/zendframework/zf2/pull/6598)
- [6614: fixes #6585](https://github.com/zendframework/zf2/pull/6614)
- [6625: Create Zend&#95;Captcha.php translation for spanish.](https://github.com/zendframework/zf2/pull/6625)
- [6628: added missing &quot;JavaProperties&quot; into Zend\Config\ReaderPluginManager and register the extension into Factory](https://github.com/zendframework/zf2/pull/6628)
- [6629: Fixes CS : unused use](https://github.com/zendframework/zf2/pull/6629)
- [6630: Use 2.* in require-dev zendframework/zend-escaper in Zend\Debug\composer.json](https://github.com/zendframework/zf2/pull/6630)
- [6631: Added zendframework/zend-servicemanager into suggest at Zend\Permissions\Acl's composer.json](https://github.com/zendframework/zf2/pull/6631)
- [6634: Allow `crossorigin` attribute in headScript](https://github.com/zendframework/zf2/pull/6634)
- [6635: Allow `sizes` attribute in headLink (used with rel=&quot;icon&quot;)](https://github.com/zendframework/zf2/pull/6635)
- [6636: AbstractControllerTestCase fails with multidimensional params array](https://github.com/zendframework/zf2/issues/6636)
- [6637: Allow multidimensional params in AbstractControllerTestCase](https://github.com/zendframework/zf2/pull/6637)
- [6643: change !is&#95;null to $value !== null for consistency](https://github.com/zendframework/zf2/pull/6643)
- [6644: The /e modifier of preg&#95;replace() deprecated as of PHP 5.5.0](https://github.com/zendframework/zf2/pull/6644)
- [6645: isValid sets up old values?](https://github.com/zendframework/zf2/issues/6645)
- [6647: Zend\I18n\Validator\Float does not set error message on NOT&#95;FLOAT.](https://github.com/zendframework/zf2/issues/6647)
- [6648: Fixes #6647 : Zend\I18n\Validator\Float set error message for NOT&#95;FLOAT](https://github.com/zendframework/zf2/pull/6648)
- [6649: Exception thrown when value&#95;options is empty in Form\View\ViewHelper\FormMultiCheckbox](https://github.com/zendframework/zf2/issues/6649)
- [6655: 6649](https://github.com/zendframework/zf2/pull/6655)
- [6660: prefer single quote](https://github.com/zendframework/zf2/pull/6660)
- [6673: SetCookie: let it accept DateTime object](https://github.com/zendframework/zf2/issues/6673)
- [6674: PHPCS fixes for Zend\View](https://github.com/zendframework/zf2/pull/6674)
- [6684: PHPCS fixes for Zend\Text](https://github.com/zendframework/zf2/pull/6684)
- [6685: PHPCS fixes for Zend\Tag](https://github.com/zendframework/zf2/pull/6685)
- [6686: @return self correction](https://github.com/zendframework/zf2/pull/6686)
- [6692: fix typo in form select view helper](https://github.com/zendframework/zf2/pull/6692)
- [6698: PHPCS fixes for Zend\Di](https://github.com/zendframework/zf2/pull/6698)
- [6699: PHPCS fixes for Zend\Dom](https://github.com/zendframework/zf2/pull/6699)
- [6700: PHPCS fixes for Zend\Feed](https://github.com/zendframework/zf2/pull/6700)
- [6701: PHPCS fixes for Zend\File](https://github.com/zendframework/zf2/pull/6701)
- [6711: Fix for BC break #6645 where isValid() sets up old values](https://github.com/zendframework/zf2/pull/6711)
- [6718: Zend\Db relies on Zend\Stdlib due to items in the Zend\Db\Sql package](https://github.com/zendframework/zf2/pull/6718)
- [6719: Zend\Db\Sql\Select::order(): accept ExpressionInterface instead of Expression](https://github.com/zendframework/zf2/issues/6719)
- [6722: Db order expressioninterface](https://github.com/zendframework/zf2/pull/6722)
- [6726: Zend\Db\TableGateway: Alias for table](https://github.com/zendframework/zf2/issues/6726)
- [6730: Zend\Config\Reader\Xml bug with close file after open](https://github.com/zendframework/zf2/issues/6730)
- [6743: Fixes cs : space after if and elseif in deep conditional](https://github.com/zendframework/zf2/pull/6743)
- [6750: yoda conditions in prg controller plugin](https://github.com/zendframework/zf2/pull/6750)
- [6751: added ocramius/proxy-manager into suggest at Zend\ServiceManager's composer.json](https://github.com/zendframework/zf2/pull/6751)
- [6760: pg&#95;connect params encodings](https://github.com/zendframework/zf2/issues/6760)
- [6761: Fixes #6730 : close() xml reader on fromFile() and fromString()](https://github.com/zendframework/zf2/pull/6761)
- [6762: Issue in gettext file load, when plural part from one phrase exists as singular part in another](https://github.com/zendframework/zf2/issues/6762)
- [6765: hotfix for issue with wrong gettext plural](https://github.com/zendframework/zf2/pull/6765)
- [6768: Zend\Stdlib\PriorityList cannot contain false values](https://github.com/zendframework/zf2/issues/6768)
- [6773: Fixes #6768 : boolean false values at priority list should be valid](https://github.com/zendframework/zf2/pull/6773)
- [6778: added zendframework/zendxml into suggest at Zend\Json's composer.json](https://github.com/zendframework/zf2/pull/6778)
- [6779: added zendframework/zend-validator and zendframework/zend-filter into suggest at Zend\Console's composer.json](https://github.com/zendframework/zf2/pull/6779)
- [6781: Added some missing hash constants in Zend/Crypt/Key/Derivation/SaltedS2k](https://github.com/zendframework/zf2/pull/6781)
- [6785: remove PHP&#95;VERSION&#95;ID check before 50323](https://github.com/zendframework/zf2/pull/6785)
- [6787: Fixes #6760 : decode http&#95;build&#95;query on connection string at Pgsql Connection](https://github.com/zendframework/zf2/pull/6787)
- [6789: detach() is now inherited from AbstractListenerAgregate.](https://github.com/zendframework/zf2/pull/6789)
- [6797: Fixed the call to addBranch() to include $branchName](https://github.com/zendframework/zf2/pull/6797)
- [6798: Fix annotations on zend db](https://github.com/zendframework/zf2/pull/6798)
- [6814: Invalid behaviour of classmap&#95;generator&#95;php for PHP &gt;=5.5 ::class constant ](https://github.com/zendframework/zf2/issues/6814)
- [6815: Update AbstractAdapter.php](https://github.com/zendframework/zf2/pull/6815)
- [6818: Add event manager to session for it is needed.](https://github.com/zendframework/zf2/pull/6818)
- [6820: Broken behavior for SET in SQL update](https://github.com/zendframework/zf2/issues/6820)
- [6825: Incompatible with RecursiveIterator](https://github.com/zendframework/zf2/pull/6825)
- [6826: removed navigation helper menu unused use statement](https://github.com/zendframework/zf2/pull/6826)
- [6834: Zend\Db\Sql\Update building update statement](https://github.com/zendframework/zf2/issues/6834)
- [6837: &#91;Zend\Test&#92; Provide fix  when 2 mandatory strings are used in route console](https://github.com/zendframework/zf2/pull/6837)
- [6845: Problem iterating buffered ResultSet](https://github.com/zendframework/zf2/issues/6845)
- [6847: Fix iterating over buffered ResultSet](https://github.com/zendframework/zf2/pull/6847)
- [6849: Db/Sql/Predicate/Expression: Fix method argument handling](https://github.com/zendframework/zf2/pull/6849)
- [6854: Added &quot;autocomplete&quot; to the list of valid attributes for textarea and select view helpers.](https://github.com/zendframework/zf2/pull/6854)
- [6858: Allow Session\Container names to start with numbers](https://github.com/zendframework/zf2/pull/6858)
- [6861: Fixes #6828 move zend\serializer deps how required](https://github.com/zendframework/zf2/pull/6861)
- [6867: Update EventManagerInterface.php](https://github.com/zendframework/zf2/pull/6867)
- [6869: ObjectProperty Hydrator should only hydrate public properties (fix + new test)](https://github.com/zendframework/zf2/pull/6869)
- [6871: Memcached returns FALSE on failure](https://github.com/zendframework/zf2/pull/6871)
- [6872: Update PHP-CS-Fixer and restrict .php&#95;cs](https://github.com/zendframework/zf2/pull/6872)
- [6873: CS Fix: string access and guard clauses](https://github.com/zendframework/zf2/pull/6873)
- [6877: Fixed #6818](https://github.com/zendframework/zf2/pull/6877)
- [6878: Cache: fixed 'Undefined index' error in memory adapter on access tags of...](https://github.com/zendframework/zf2/pull/6878)
- [6879: Rebased and cleaned up #6279](https://github.com/zendframework/zf2/pull/6879)
- [6880: Fix for #6263 (replaces PR #6518)](https://github.com/zendframework/zf2/pull/6880)
- [6881: Bug in Zend\Stdlib\PriorityList-&gt;valid() ](https://github.com/zendframework/zf2/issues/6881)
- [6891: Fixes Zend\Json\Json's composer.json containing single backslash](https://github.com/zendframework/zf2/pull/6891)
- [6893: Zend\Code\ClassScanner cannot scan abstract method when class has properties and other methods.](https://github.com/zendframework/zf2/issues/6893)
- [6895: Fix documentation](https://github.com/zendframework/zf2/pull/6895)
- [6896: Fix for https cases for Apache on IBM i](https://github.com/zendframework/zf2/pull/6896)
- [6897: Fix minor documentation typo](https://github.com/zendframework/zf2/pull/6897)
- [6900: ArrayUtils performance tweak](https://github.com/zendframework/zf2/pull/6900)
- [6901: Added a failing test for #6893](https://github.com/zendframework/zf2/pull/6901)
- [6902: Throw an ServiceNotFoundException in AbstractPluginManager when the invokable does not exist.](https://github.com/zendframework/zf2/pull/6902)
- [6904: Patch test case on Stdlib/PriorityListTest](https://github.com/zendframework/zf2/pull/6904)
- [6907: allow header field value of &quot;0&quot;](https://github.com/zendframework/zf2/pull/6907)
- [6914: Fix: Remove unused parameter and class property](https://github.com/zendframework/zf2/pull/6914)
- [6915: Fix: More unused local variables](https://github.com/zendframework/zf2/pull/6915)
- [6916: Fix: Yet another unused local variable](https://github.com/zendframework/zf2/pull/6916)
- [6917: Fix: Unnecessary FCQN](https://github.com/zendframework/zf2/pull/6917)
- [6918: Fix: Add missing return tag](https://github.com/zendframework/zf2/pull/6918)
- [6919: Code improvement - removed unused variable](https://github.com/zendframework/zf2/pull/6919)
- [6921: Improvement - removed some unnecessary variable assignment](https://github.com/zendframework/zf2/pull/6921)
- [6923: PR for #6673. Allow to set DateTimeObject for SetCookie Expires ](https://github.com/zendframework/zf2/pull/6923)
- [6927: Hotfix/6278](https://github.com/zendframework/zf2/pull/6927)
- [6928: Hydrator naming strategy zend filter dependency](https://github.com/zendframework/zf2/pull/6928)
- [6932: added zendframework/zend-cache into suggest at Zend\XmlRpc's composer.json](https://github.com/zendframework/zf2/pull/6932)
- [6933: Remove dependency of Zend\ModuleManager on Zend\Mvc](https://github.com/zendframework/zf2/issues/6933)
- [6935: bugfix wrong atom datetime format in updated](https://github.com/zendframework/zf2/pull/6935)
- [6937: Update Hostname.php](https://github.com/zendframework/zf2/pull/6937)
- [6939: Fixes CS on latest build on master : trailing&#95;spaces](https://github.com/zendframework/zf2/pull/6939)
- [6941: Zend\Validator tests refactoring](https://github.com/zendframework/zf2/issues/6941)
- [6943: Fixed #6941](https://github.com/zendframework/zf2/pull/6943)
- [6946: fix #6814: ignore php 5.5 scalar class name resolution](https://github.com/zendframework/zf2/pull/6946)
- [6948: Improve type hints](https://github.com/zendframework/zf2/pull/6948)
- [6949: Use hydrator variable only when hydrator variable is assigned](https://github.com/zendframework/zf2/pull/6949)
- [6953: Little code improvements](https://github.com/zendframework/zf2/pull/6953)
- [6958: Encoding Type is not set when sending Request object set as POST](https://github.com/zendframework/zf2/issues/6958)
- [6959: Bug #6958 Make sure encoding type is set when sending Request](https://github.com/zendframework/zf2/pull/6959)
- [6964: fixes #6952 / phpdoc Zend/Http/Request](https://github.com/zendframework/zf2/pull/6964)
- [6967: PHPCS: Zend\View](https://github.com/zendframework/zf2/pull/6967)
- [6968: Removed query method from mocks after issue 6798](https://github.com/zendframework/zf2/pull/6968)
- [6971: PHPCS fixes for Zend\Http](https://github.com/zendframework/zf2/pull/6971)
- [6972: PHPCS fixes for Zend\Json](https://github.com/zendframework/zf2/pull/6972)
- [6973: PHPCS fixes for Zend\InputFilter](https://github.com/zendframework/zf2/pull/6973)
- [6974: PHPCS fixes for Zend\Form](https://github.com/zendframework/zf2/pull/6974)
- [6975: PHPCS fixes for Zend\I18n](https://github.com/zendframework/zf2/pull/6975)
- [6976: PHPCS fixes for Zend\Filter](https://github.com/zendframework/zf2/pull/6976)
- [6978: fix PHPCS errors for Zend\Test](https://github.com/zendframework/zf2/pull/6978)
- [6979: fix PHPCS errors for Zend\Text](https://github.com/zendframework/zf2/pull/6979)
- [6980: fix PHPCS errors for Zend\Uri](https://github.com/zendframework/zf2/pull/6980)
- [6981: fix PHPCS errors for Zend\XmlRpc](https://github.com/zendframework/zf2/pull/6981)
- [6982: fix PHPCS errors for Zend\Validator](https://github.com/zendframework/zf2/pull/6982)
- [6984: PHPCS fixes for Zend\Log](https://github.com/zendframework/zf2/pull/6984)
- [6985: PHPCS fixes for Zend\Mvc](https://github.com/zendframework/zf2/pull/6985)
- [6986: PHPCS fixes for Zend\Ldap](https://github.com/zendframework/zf2/pull/6986)
- [6987: PHPCS fixes for Zend\Mail](https://github.com/zendframework/zf2/pull/6987)
- [6988: PHPCS fixes for Zend\Server](https://github.com/zendframework/zf2/pull/6988)
- [6989: PHPCS fixes for Zend\Stdlib](https://github.com/zendframework/zf2/pull/6989)
- [6990: PHPCS fixes for Zend\Serializer](https://github.com/zendframework/zf2/pull/6990)
- [6991: PHPCS fixes for Zend\Session](https://github.com/zendframework/zf2/pull/6991)
- [6992: PHPCS fixes for Zend\Memory](https://github.com/zendframework/zf2/pull/6992)
- [6993: PHPCS fixes for Zend\Paginator](https://github.com/zendframework/zf2/pull/6993)
- [6994: PHPCS fixes for Zend\ProgressBar](https://github.com/zendframework/zf2/pull/6994)
- [6995: PHPCS fixes for Zend\ServiceManager](https://github.com/zendframework/zf2/pull/6995)
- [6996: PHPCS fixes for Zend\Permissions](https://github.com/zendframework/zf2/pull/6996)
- [6997: PHPCS fixes for Zend\Soap](https://github.com/zendframework/zf2/pull/6997)
- [6998: PHPCS fixes for Zend\Mime](https://github.com/zendframework/zf2/pull/6998)
- [6999: PHPCS fixes for Zend\Loader](https://github.com/zendframework/zf2/pull/6999)
- [7000: PHPCS fixes for Zend\ModuleManager](https://github.com/zendframework/zf2/pull/7000)
- [7001: PHPCS fixes for Zend\Test](https://github.com/zendframework/zf2/pull/7001)
- [7002: Changing encode from View Helper is not passed to EscapeHtmlAttrHelper](https://github.com/zendframework/zf2/pull/7002)
- [7006: optimized performance of Zend\Stdlib\AbstractOptions](https://github.com/zendframework/zf2/pull/7006)
- [7008: Bug in PriorityList](https://github.com/zendframework/zf2/pull/7008)
- [7011: .php&#95;cs - sort fixers](https://github.com/zendframework/zf2/pull/7011)
- [7012: PHP &gt;=5.4 Syntax in AbstractHelperTest](https://github.com/zendframework/zf2/issues/7012)
- [7013: Hotfix/#7012 zend view php 5.4 syntax removal](https://github.com/zendframework/zf2/pull/7013)
- [7018: &#91;Validator&#92; Hostname: disallowed Unicode code point](https://github.com/zendframework/zf2/issues/7018)
- [7019: fixed #7018 : Hostname validator used disallowed unicode code points](https://github.com/zendframework/zf2/pull/7019)
- [7022: &#91;Zend\Http&#92; check if costant TESTS&#95;ZEND&#95;HTTP&#95;CLIENT&#95;ONLINE is defined](https://github.com/zendframework/zf2/issues/7022)
- [7023: Fixes #7022 TESTS&#95;ZEND&#95;HTTP&#95;CLIENT&#95;ONLINE check](https://github.com/zendframework/zf2/pull/7023)
- [7030: #6414-Add a condition for captcha element](https://github.com/zendframework/zf2/pull/7030)
- [7033: Cache: fixed some minor documentation issues](https://github.com/zendframework/zf2/pull/7033)
- [7036: PhpDoc fixes for Zend\Mvc](https://github.com/zendframework/zf2/pull/7036)
- [7047: cs fixes for Zend\Cache](https://github.com/zendframework/zf2/pull/7047)
- [7048: cs fixes for Zend\Code](https://github.com/zendframework/zf2/pull/7048)
- [7060: Removed hard coded dependency to Zend\Mvc from Zend\ModuleManager](https://github.com/zendframework/zf2/pull/7060)
- [7061: remove unused imports](https://github.com/zendframework/zf2/pull/7061)
- [7062: remove unused variables](https://github.com/zendframework/zf2/pull/7062)
- [7063: PhpDoc: fix return types and other incompatibilities](https://github.com/zendframework/zf2/pull/7063)
- [7064: Need update dependencies in zendframework/zend-db](https://github.com/zendframework/zf2/issues/7064)
- [7065: Cache: fixed CAS-Feature broken for APC adapter since 2.3.0](https://github.com/zendframework/zf2/pull/7065)
- [7066: Use constant for events in Zend\Db\TableGateway\Feature\EventFeature](https://github.com/zendframework/zf2/pull/7066)
- [7068: Cache: better compatibility with APCu](https://github.com/zendframework/zf2/pull/7068)
- [7070: Travis optimizations](https://github.com/zendframework/zf2/pull/7070)
- [7074: PSR2/PHPDoc fix for Zend\Http\Client](https://github.com/zendframework/zf2/pull/7074)
- [7078: Fixes CS latest build on travis : master](https://github.com/zendframework/zf2/pull/7078)
- [7080: Filter\Encrypt can't filter numbers](https://github.com/zendframework/zf2/pull/7080)
- [7083: Hotfix/encrypt numbers](https://github.com/zendframework/zf2/pull/7083)
- [7086: Honor returned status code for HEAD requests](https://github.com/zendframework/zf2/pull/7086)
- [7087: Happy new year 2015 : master](https://github.com/zendframework/zf2/pull/7087)
- [7089: Correct docblock](https://github.com/zendframework/zf2/pull/7089)
- [7093: Scope objectKey in nested partialLoop call](https://github.com/zendframework/zf2/pull/7093)
- [7101: Fixes DocBlocks in Zend\Barcode\Object\AbstractObject](https://github.com/zendframework/zf2/pull/7101)
- [7108: Fix form annotation options](https://github.com/zendframework/zf2/pull/7108)
- [7109: Improved disabled inputs testing when binding values into fieldset object](https://github.com/zendframework/zf2/pull/7109)
- [7110: Fix for validation timeouts, issue #4960](https://github.com/zendframework/zf2/pull/7110)
- [7112: Updated the readme with the logo](https://github.com/zendframework/zf2/pull/7112)
- [7114: added missing return $this to setValue method.](https://github.com/zendframework/zf2/pull/7114)
- [7117: Updated german translation file](https://github.com/zendframework/zf2/pull/7117)

### SECURITY UPDATES

- **ZF2015-01:** Session validators were not run if set before session start.
  Essentially, the validators were writing to the `$_SESSION` superglobal before
  session start, which meant the data was overwritten once the session began.
  This meant on subsequent calls, the validators had no data to compare against,
  making the sessions automatically valid. We have provided patches to ensure
  that validators are run only after the session has begun, which will ensure
  they validate sessions correctly going forward. If you use `Zend\Session`
  validators, we recommend upgrading immediately.

## 2.3.3 (2014-09-17)

- [6576: Custom barcode adapter wasn't being set in options](https://github.com/zendframework/zf2/pull/6576)
- [6664: Use is_file to check for an uploaded file](https://github.com/zendframework/zf2/pull/6664)

### SECURITY UPDATES

- **ZF2014-05:** Due to an issue that existed in PHP's LDAP extension, it is
  possible to perform an unauthenticated simple bind against a LDAP server by
  using a null byte for the password, regardless of whether or not the user
  normally requires a password. We have provided a patch in order to protect
  users of unpatched PHP versions (PHP 5.5 <= 5.5.11, PHP 5.4 <= 5.4.27, all
  versions of PHP 5.3 and below). If you use `Zend\Ldap` and are on an affected
  version of PHP, we recommend upgrading immediately.
- **ZF2014-06:** A potential SQL injection vector existed when using a SQL
  Server adapter to manually quote values due to the fact that it was not
  escaping null bytes. Code was added to ensure null bytes are escaped, and
  thus mitigate the SQLi vector. We do not recommend manually quoting values,
  but if you do, and use the SQL Server adapter without PDO, we recommend
  upgrading immediately.

## 2.3.2 (2014-08-11)

- [4747: Zend\Code\Generator\FileGenerator problem](https://github.com/zendframework/zf2/issues/4747)
- [5144: Unit tests get failed occasionaly](https://github.com/zendframework/zf2/issues/5144)
- [5794: Oracle incorrect SELECT FROM decoration with table alias when using nested selects](https://github.com/zendframework/zf2/pull/5794)
- [5851: Sqlsrv fixes - cursor type fix, utf8 support, transaction support, varbinary update support](https://github.com/zendframework/zf2/pull/5851)
- [5962: Fatal Error on /Mime/Message.php on line 111](https://github.com/zendframework/zf2/issues/5962)
- [6033: Fixed charset support for Pdo&#95;Pgsql.](https://github.com/zendframework/zf2/pull/6033)
- [6038: fix HeadLink docblock method declaration hints](https://github.com/zendframework/zf2/pull/6038)
- [6119: Allow OCI8 Statment to Handle LOB data type](https://github.com/zendframework/zf2/pull/6119)
- [6141: Fix: Indentation of method arguments](https://github.com/zendframework/zf2/pull/6141)
- [6143: Form - Ignore user values for disabled elements on bind](https://github.com/zendframework/zf2/issues/6143)
- [6144: Support shorthand Priority filter in Log\AbstractWriter](https://github.com/zendframework/zf2/pull/6144)
- [6146: Collection validation with element as target element](https://github.com/zendframework/zf2/pull/6146)
- [6147: Session validation listeners may return `null`, erroneously causing validation to fail](https://github.com/zendframework/zf2/pull/6147)
- [6149: Update Collection.php](https://github.com/zendframework/zf2/pull/6149)
- [6157: Fixes #5962](https://github.com/zendframework/zf2/pull/6157)
- [6158: fix misspelling of 'preferred'](https://github.com/zendframework/zf2/pull/6158)
- [6159: add support number of string in &#95;&#95;construct of Priority](https://github.com/zendframework/zf2/pull/6159)
- [6160: CollectionInputFilter-&gt;getCount() gives wrong count on consecutive setData() calls](https://github.com/zendframework/zf2/pull/6160)
- [6163: remove duplicate registered &quot;zendframework/zend-session&quot; in composer.json](https://github.com/zendframework/zf2/pull/6163)
- [6164: Fix: Add missing throws tags](https://github.com/zendframework/zf2/pull/6164)
- [6165: ZF2 Paginator Does Not Work with DB2](https://github.com/zendframework/zf2/issues/6165)
- [6168: Math\Rand::getInteger returns no values for the given range](https://github.com/zendframework/zf2/pull/6168)
- [6170: &#91;BUGFIX&#92; missing Zend XML-RPC support library](https://github.com/zendframework/zf2/pull/6170)
- [6176: Fix: C/P error when creating ProcessorPluginManager](https://github.com/zendframework/zf2/pull/6176)
- [6177: Fix: Indentation of array initialization, missing trailing comma](https://github.com/zendframework/zf2/pull/6177)
- [6179: Fix: Indentation, missing trailing commas, extra empty lines in Log\Logger](https://github.com/zendframework/zf2/pull/6179)
- [6180: Fix: Fix PHP-CS-Fixer to a working version](https://github.com/zendframework/zf2/pull/6180)
- [6184: Fix mongo handler](https://github.com/zendframework/zf2/pull/6184)
- [6186: Fix: Update fabpot/php-cs-fixer, remove optional path argument from command](https://github.com/zendframework/zf2/pull/6186)
- [6187: Add links to main repo in each composer.json](https://github.com/zendframework/zf2/issues/6187)
- [6188: Add CONTRIBUTE.md files in each component](https://github.com/zendframework/zf2/issues/6188)
- [6191: Fixes Typo](https://github.com/zendframework/zf2/pull/6191)
- [6192: Fixes #6187](https://github.com/zendframework/zf2/pull/6192)
- [6200: Fix: Exceptions raised in Soap/Server can leave XML entity loader disabled.](https://github.com/zendframework/zf2/pull/6200)
- [6205: Use composer's autoload-dev feature](https://github.com/zendframework/zf2/pull/6205)
- [6207: Hotfix for UnderscoreNamingStrategy](https://github.com/zendframework/zf2/pull/6207)
- [6213: Fixes typo algorihtm -&gt; algorithm](https://github.com/zendframework/zf2/pull/6213)
- [6214: Added hostname for OCI8 integration tests (required on linux)](https://github.com/zendframework/zf2/pull/6214)
- [6215: Console Adapter typo](https://github.com/zendframework/zf2/pull/6215)
- [6217: Fixes typo : contructor -&gt; constructor](https://github.com/zendframework/zf2/pull/6217)
- [6218: `iconv.internal&#95;encoding` is deprecated](https://github.com/zendframework/zf2/issues/6218)
- [6219: #6218 - applying hotfix for `iconv.internal&#95;encoding` deprecation](https://github.com/zendframework/zf2/pull/6219)
- [6222: Fix a sequence name with double quotes for PostgreSQL to preserve name registry](https://github.com/zendframework/zf2/pull/6222)
- [6223: Fix double registration of a complex type](https://github.com/zendframework/zf2/pull/6223)
- [6228: Fix parameter format causing duplicate mails](https://github.com/zendframework/zf2/pull/6228)
- [6237: Fixes typos](https://github.com/zendframework/zf2/pull/6237)
- [6238: Fix: CS of closure](https://github.com/zendframework/zf2/pull/6238)
- [6245: Fix invalid step error caused by DST](https://github.com/zendframework/zf2/pull/6245)
- [6250: Db\Sql\Update use sortable set](https://github.com/zendframework/zf2/pull/6250)
- [6253: Zend code doesn't generate heredoc correctly ](https://github.com/zendframework/zf2/issues/6253)
- [6254: Fixes #6188](https://github.com/zendframework/zf2/pull/6254)
- [6255: Zend code generator eats last brace](https://github.com/zendframework/zf2/issues/6255)
- [6261: Update StringTrim to allow '0' as charlist](https://github.com/zendframework/zf2/pull/6261)
- [6266: Fix delegators config with Mvc\Application](https://github.com/zendframework/zf2/pull/6266)
- [6277: Digit filter should ignore boolean input](https://github.com/zendframework/zf2/pull/6277)
- [6281: SessionHandler - MongoDbOptions default saveOptions not valid for pre-1.3 mongo driver](https://github.com/zendframework/zf2/issues/6281)
- [6283: Fixes #6253 updated regex to properly respect heredoc](https://github.com/zendframework/zf2/pull/6283)
- [6286: Fixes #6255 - removed regex for token parsing](https://github.com/zendframework/zf2/pull/6286)
- [6292: Created russian translation for Zend&#95;Captcha.](https://github.com/zendframework/zf2/pull/6292)
- [6293: zend-barcode without zend-servicemanager and zend-validator](https://github.com/zendframework/zf2/issues/6293)
- [6295: Fieldset ignore disabled elements](https://github.com/zendframework/zf2/pull/6295)
- [6297: DateTime (I18n) uses a wrong function in &quot;isValid&quot; function](https://github.com/zendframework/zf2/issues/6297)
- [6300: Float (I18n) parsing trouble](https://github.com/zendframework/zf2/issues/6300)
- [6302: Fixes issue #4747 - FileGenerator now properly generates files.](https://github.com/zendframework/zf2/pull/6302)
- [6303: fixes #5144: Cache: wait for full second before start TTL tests](https://github.com/zendframework/zf2/pull/6303)
- [6306: Console\RouteNotFoundStrategy throws invalid index exception](https://github.com/zendframework/zf2/issues/6306)
- [6307: Closes #6306 - Console\RouteNotFoundStrategy invalid index](https://github.com/zendframework/zf2/pull/6307)
- [6310: Fix Zend/Barcode composer.json to require zendframework/zend-validator.](https://github.com/zendframework/zf2/pull/6310)
- [6311: Fixes #6297: Fixes logic that checks if IntlDateFormatter parsed the string properly.](https://github.com/zendframework/zf2/pull/6311)
- [6315: Zend\Http\Client\Adapter\Curl does not send a proper DELETE request when request body is provided, hangs](https://github.com/zendframework/zf2/issues/6315)
- [6318: Add body to curl DELETE request if one is specified.](https://github.com/zendframework/zf2/pull/6318)
- [6321: I18n/Validator/DateTime should use mb&#95;strlen() instead of strlen()](https://github.com/zendframework/zf2/issues/6321)
- [6325: Fixes typo](https://github.com/zendframework/zf2/pull/6325)
- [6326: Bugfix/thousand separator in number validator](https://github.com/zendframework/zf2/pull/6326)
- [6330: Bugfix/merging inputs with allow empty](https://github.com/zendframework/zf2/pull/6330)
- [6333: Fix for performance issue in Http\Response](https://github.com/zendframework/zf2/pull/6333)
- [6335: Fix and test case for: RowGateway primary key not null constraint do not fail with empty string](https://github.com/zendframework/zf2/pull/6335)
- [6336: Fixes link media type list for iana and wikipedia](https://github.com/zendframework/zf2/pull/6336)
- [6351: update DE translation header](https://github.com/zendframework/zf2/pull/6351)
- [6361: Fixes #6281 - mongodb saveOptions not checked correctly](https://github.com/zendframework/zf2/pull/6361)
- [6373: Fix for #6300 -  I18n float validator rewrite](https://github.com/zendframework/zf2/pull/6373)
- [6382: Fix for #6377 - Zend\Session\Service\SessionConfigFactory: Wrong placeholder in Exception string](https://github.com/zendframework/zf2/pull/6382)
- [6391: UrlTest : missing private properties $url and $router](https://github.com/zendframework/zf2/pull/6391)
- [6393: unused parameters $sm for plugins factory](https://github.com/zendframework/zf2/pull/6393)
- [6400: Fix / tests for #6363](https://github.com/zendframework/zf2/pull/6400)
- [6401: Fixes @return docblock for Zend\Paginator\Adapter\Service\DbSelectFactory::createService()](https://github.com/zendframework/zf2/pull/6401)
- [6402: Fixes grammar](https://github.com/zendframework/zf2/pull/6402)
- [6412: Fix nested CollectionInputFilter not valid if count not specified](https://github.com/zendframework/zf2/pull/6412)
- [6423: Validate uploaded filename only if no upload error occured.](https://github.com/zendframework/zf2/pull/6423)
- [6427: Zend Session fatal error in get array copy](https://github.com/zendframework/zf2/pull/6427)
- [6429: Update Zend&#95;Validate.php](https://github.com/zendframework/zf2/pull/6429)
- [6430: Method setObject on Zend/Form/Element/Collection overrides count of target element](https://github.com/zendframework/zf2/issues/6430)
- [6440: Fixed typo](https://github.com/zendframework/zf2/pull/6440)
- [6443: Change method to set count fixes #6430](https://github.com/zendframework/zf2/pull/6443)
- [6446: Fix for #6445, adding pagination and transaction to IBM DB2 for Zend\Db](https://github.com/zendframework/zf2/pull/6446)
- [6452: Fix + tests for #5969](https://github.com/zendframework/zf2/pull/6452)
- [6462: Fix for odd php-cs-fixer finds](https://github.com/zendframework/zf2/pull/6462)
- [6472: Clear values on CollectionInputFilter before adding new data](https://github.com/zendframework/zf2/pull/6472)
- [6480: Fix: Undefined field in Zend\Http\Header\Origin](https://github.com/zendframework/zf2/pull/6480)
- [6484: fix #6480](https://github.com/zendframework/zf2/pull/6484)
- [6487: Remove trailing whitespaces](https://github.com/zendframework/zf2/pull/6487)
- [6490: PHPCS Fixes for Zend\Authentication](https://github.com/zendframework/zf2/pull/6490)
- [6491: Header\ContentType: remove empty values from parsed header](https://github.com/zendframework/zf2/pull/6491)
- [6494: CollectionInputFilter throws warning if invalid collection provided](https://github.com/zendframework/zf2/pull/6494)
- [6495: Redis Server URI correct parsing](https://github.com/zendframework/zf2/pull/6495)
- [6500: PHPCS fixes for Zend\Barcode](https://github.com/zendframework/zf2/pull/6500)
- [6505: swap order of initalization](https://github.com/zendframework/zf2/pull/6505)
- [6506: Missing dependency to zend-form in zend-mvc](https://github.com/zendframework/zf2/issues/6506)
- [6510: Fix 6428 - authenticate() always fails on IBMi when using DB table-based authentication](https://github.com/zendframework/zf2/pull/6510)
- [6511: conflicting PHPDoc @return values in SharedEventManager](https://github.com/zendframework/zf2/issues/6511)
- [6512: fixed conflicted phpdoc return values (see #6511)](https://github.com/zendframework/zf2/pull/6512)
- [6521: PHPCS fixes for Zend\\Cache](https://github.com/zendframework/zf2/pull/6521)
- [6522: PHPCS fixes for Zend\Code](https://github.com/zendframework/zf2/pull/6522)
- [6529: Update polish translation](https://github.com/zendframework/zf2/pull/6529)
- [6531: PHPCS fixes for Zend\Config](https://github.com/zendframework/zf2/pull/6531)
- [6532: PHPCS fixes for Zend\Console](https://github.com/zendframework/zf2/pull/6532)
- [6533: PHPCS fixes for Zend\Crypt](https://github.com/zendframework/zf2/pull/6533)
- [6535: PHPCS fixes for Zend\EventManager](https://github.com/zendframework/zf2/pull/6535)
- [6536: PHPCS fixes for Zend\Navigation](https://github.com/zendframework/zf2/pull/6536)
- [6541: Zend Db Query Builder Optimisation](https://github.com/zendframework/zf2/pull/6541)
- [6549: Link to new version of the QuickStart user guide](https://github.com/zendframework/zf2/pull/6549)
- [6551: Fixes CS : trailing spaces and unused use](https://github.com/zendframework/zf2/pull/6551)

## 2.3.1 (2014-04-15)

- [5392: Zend Db: Multiple nested selects - Zend Paginator with nested select bind parameters error](https://github.com/zendframework/zf2/pull/5392)
- [5857: Fixes #4521](https://github.com/zendframework/zf2/pull/5857)
- [5863: patch #5860 ](https://github.com/zendframework/zf2/pull/5863)
- [5948: Circular dependency test for #5651](https://github.com/zendframework/zf2/pull/5948)
- [5956: Prevent fatal error in JsonRpc-Client](https://github.com/zendframework/zf2/pull/5956)
- [5957: php 5.6 compatibility](https://github.com/zendframework/zf2/pull/5957)
- [5958: fix typo](https://github.com/zendframework/zf2/pull/5958)
- [5959: Issue - AbstractDiServiceFactory ,MvcTranslatorFactory throws Exception](https://github.com/zendframework/zf2/pull/5959)
- [5964: Upgrading branch aliases for components: 2.2-dev -&gt; 2.3-dev, 2.3-dev -&gt; 2.4-dev](https://github.com/zendframework/zf2/pull/5964)
- [5968: Collection Input Filter fix messages](https://github.com/zendframework/zf2/pull/5968)
- [5970: Adds disableInArrayValidator check to Radio](https://github.com/zendframework/zf2/pull/5970)
- [5972: permissions : docBlock](https://github.com/zendframework/zf2/pull/5972)
- [5973: Rbac::getRole() : check object-&gt;getName()](https://github.com/zendframework/zf2/pull/5973)
- [5975: Update wrong DocBlock comment](https://github.com/zendframework/zf2/pull/5975)
- [5978: ZF 2.3.0 BC break in MvcTranslator](https://github.com/zendframework/zf2/issues/5978)
- [5979: Fix BC break in TranslatorServiceFactory](https://github.com/zendframework/zf2/pull/5979)
- [5983: &#91;cs-fixer&#92; Centralize configuration in a single file](https://github.com/zendframework/zf2/pull/5983)
- [5985: Corrected placeholder token '%' for some translations](https://github.com/zendframework/zf2/pull/5985)
- [5986: InputFilter\Factory can't handle config with null input](https://github.com/zendframework/zf2/pull/5986)
- [5988: Fix patterns for mobile (allows 7 as fisrt number)](https://github.com/zendframework/zf2/pull/5988)
- [5989: Allow aria-labelledby and aria-describedby attributes in form elements](https://github.com/zendframework/zf2/pull/5989)
- [5991: ---removed---](https://github.com/zendframework/zf2/issues/5991)
- [5997: Update segment route to TranslatorInterface](https://github.com/zendframework/zf2/pull/5997)
- [5998: Add missing bitwise validator in pluginmanager](https://github.com/zendframework/zf2/pull/5998)
- [6000: Blackhole cache adapter : docblock corrections](https://github.com/zendframework/zf2/pull/6000)
- [6003: typo on comment fixed](https://github.com/zendframework/zf2/pull/6003)
- [6004: InputFilterPluginManager needs to allow InputInterface retrieval](https://github.com/zendframework/zf2/issues/6004)
- [6007: ZendMvc depends on ZendLog by default in 2.3.0, add it to composer](https://github.com/zendframework/zf2/pull/6007)
- [6009: Form\Element\Select multiple is always required](https://github.com/zendframework/zf2/pull/6009)
- [6012: Zend\ProgressBar\Adapter\Console::notify should use mb&#95;substr](https://github.com/zendframework/zf2/issues/6012)
- [6019: Fix for #6012 - Use wrapper for substr() in ProgressBar](https://github.com/zendframework/zf2/pull/6019)
- [6021: Missed variable, renamed to one which exists.](https://github.com/zendframework/zf2/pull/6021)
- [6022: Invalid instantiator of type &quot;NULL&quot; for &quot;Zend\I18n\Translator\TranslatorInterface&quot;](https://github.com/zendframework/zf2/issues/6022)
- [6023: Parameter generator backslash escaping](https://github.com/zendframework/zf2/pull/6023)
- [6024: Dispatch error should be preventable](https://github.com/zendframework/zf2/pull/6024)
- [6026: decompress() Zend/Filter/Compress/Zip fix](https://github.com/zendframework/zf2/pull/6026)
- [6027: Allow empty response strings in \Zend\Http\Response::fromStream](https://github.com/zendframework/zf2/pull/6027)
- [6028: Method getValue should check the type of input inside InputFilter](https://github.com/zendframework/zf2/pull/6028)
- [6030: Remove duplicate comment](https://github.com/zendframework/zf2/pull/6030)
- [6031: remove double semicolon](https://github.com/zendframework/zf2/pull/6031)
- [6032: fix comment on PhpMemoryArray loader](https://github.com/zendframework/zf2/pull/6032)
- [6035: fix exception message. Must be Stdlib\Hydrator](https://github.com/zendframework/zf2/pull/6035)
- [6037: Require PHP extension mcrypt in composer.json](https://github.com/zendframework/zf2/issues/6037)
- [6041: Hotfix : Zend\Test trace error flag](https://github.com/zendframework/zf2/pull/6041)
- [6042: Fix documentation](https://github.com/zendframework/zf2/pull/6042)
- [6045: File Form Element don't works](https://github.com/zendframework/zf2/issues/6045)
- [6046: Allow InputInterface retrieval from InputFilterPluginManager](https://github.com/zendframework/zf2/pull/6046)
- [6047: Fix Zend\Test test](https://github.com/zendframework/zf2/pull/6047)
- [6049: Fix for issue 6048](https://github.com/zendframework/zf2/pull/6049)
- [6050: update copyright year that still using 2013 to 2014](https://github.com/zendframework/zf2/pull/6050)
- [6051: 2.2.6 -&gt; 2.3.0 causes DI to try to instantiate `Zend\I18n\Translator\TranslatorInterface` instead of `Zend\I18n\Translator\Translator`](https://github.com/zendframework/zf2/issues/6051)
- [6056: Fixes a typo](https://github.com/zendframework/zf2/pull/6056)
- [6061: added missing License header](https://github.com/zendframework/zf2/pull/6061)
- [6062: fixed typo](https://github.com/zendframework/zf2/pull/6062)
- [6070: code-to-explain-code test in MultiCheckboxTest to check multi selected ](https://github.com/zendframework/zf2/pull/6070)
- [6071: Re enable zip compression tests on Travis](https://github.com/zendframework/zf2/pull/6071)
- [6077: fix for issue 6076. avoid GlobIterator globbing to directories which it ...](https://github.com/zendframework/zf2/pull/6077)
- [6082: Using \Zend\Db\Sql\Expression as part of join name.  Object of class Zend\Db\Sql\Expression could not be converted to string](https://github.com/zendframework/zf2/issues/6082)
- [6083: NumberOfParameterFilter correctly handles argument count greater than 0.](https://github.com/zendframework/zf2/pull/6083)
- [6085: Fixes #5929 - Remove a page recursively](https://github.com/zendframework/zf2/pull/6085)
- [6089: Problems with serializing Zend\Stdlib\ArrayObject](https://github.com/zendframework/zf2/issues/6089)
- [6092: Hotfix for #6089 - ArrayObject serialization doesn't restore `protectedProperties`](https://github.com/zendframework/zf2/pull/6092)
- [6093: Fix unused imports and local variables](https://github.com/zendframework/zf2/pull/6093)
- [6094: Fix undefined classes, constants and methods](https://github.com/zendframework/zf2/pull/6094)
- [6096: Prevent ArrayObject recursion in 5.6](https://github.com/zendframework/zf2/pull/6096)
- [6100: More tests for nested form fieldsets](https://github.com/zendframework/zf2/pull/6100)
- [6102: Zend\Filter\Compress\Tar::setMode() would not work](https://github.com/zendframework/zf2/issues/6102)
- [6103: Zend\Filter\Compress\Tar::setMode() should work with case-insensitive](https://github.com/zendframework/zf2/pull/6103)
- [6104: Validator\Ip should not allow newlines in any case.](https://github.com/zendframework/zf2/pull/6104)
- [6105: add missing resource messages at en - Bitwize &amp; Datestep](https://github.com/zendframework/zf2/pull/6105)
- [6106: suggest ext-mcrypt](https://github.com/zendframework/zf2/pull/6106)
- [6110: Allow session garbage collection to use an index](https://github.com/zendframework/zf2/pull/6110)
- [6116: fixed typos](https://github.com/zendframework/zf2/pull/6116)
- [6118: Extra fieldsets are created when calling form bind multiple times](https://github.com/zendframework/zf2/pull/6118)
- [6123: Mail: Require Zend\Validator](https://github.com/zendframework/zf2/pull/6123)
- [6125: added missing { and } after if](https://github.com/zendframework/zf2/pull/6125)
- [6126: Tiny typo fix in docblock](https://github.com/zendframework/zf2/pull/6126)
- [6128: Fix class description](https://github.com/zendframework/zf2/pull/6128)
- [6129: change is&#95;null($var) to (null === $var) for consistency](https://github.com/zendframework/zf2/pull/6129)
- [6130: change docblocks and comments that still using &quot;Zend&#95;&quot; to &quot;Zend\&quot;](https://github.com/zendframework/zf2/pull/6130)
- [6132: FormElementManager: Only initialize a shared element once](https://github.com/zendframework/zf2/pull/6132)
- [6136: Fix: No need to prefix imports](https://github.com/zendframework/zf2/pull/6136)
- [6139: Fix: Test name](https://github.com/zendframework/zf2/pull/6139)
- [6140: Fix: Indentation in array initialization, trailing commas](https://github.com/zendframework/zf2/pull/6140)

### SECURITY UPDATES

- **ZF2014-03:** Potential XSS vector in multiple view helpers due to
  inappropriate HTML attribute escaping. Many view helpers were using the
  `escapeHtml()` view helper in order to escape HTML attributes. This release
  patches them to use the `escapeHtmlAttr()` view helper in these situations.
  If you use form or navigation view helpers, or "HTML element" view helpers
  (such as `gravatar()`, `htmlFlash()`, `htmlPage()`, or `htmlQuicktime()`), we
  recommend upgrading immediately.

## 2.3.0 (2014-03-12)

- [3015: $escapeHtmlHelper is not optional, in case you want real HTML as a label](https://github.com/zendframework/zf2/issues/3015)
- [3198: Limit/offset doesn't work properly when using parameters and SQL Server drivers](https://github.com/zendframework/zf2/pull/3198)
- [4021: Mysqli driver raise a lot of warning about Undefined property after connection closed](https://github.com/zendframework/zf2/pull/4021)
- [4280: begin,commit and rollback methods for PostgreSQL have been implemented](https://github.com/zendframework/zf2/pull/4280)
- [4290: Zend\Db\Sql setTable method ommit array](https://github.com/zendframework/zf2/pull/4290)
- [4304: Add support for dblib PDO driver in quoteValue()](https://github.com/zendframework/zf2/pull/4304)
- [4348: Add isActive method Navigation Page Uri.](https://github.com/zendframework/zf2/pull/4348)
- [4397: Add coveralls support and fix a few testing bugs related to coverage](https://github.com/zendframework/zf2/pull/4397)
- [4400: Ability to get an element with creation options from the FormElementManager](https://github.com/zendframework/zf2/pull/4400)
- [4401: add flag for fallback value](https://github.com/zendframework/zf2/pull/4401)
- [4427: add group and having ability to Paginator\Adapter\DbTableGateway](https://github.com/zendframework/zf2/pull/4427)
- [4443: Translator\Loader\PhpArray can't load from the include path](https://github.com/zendframework/zf2/issues/4443)
- [4449: Console route improvements](https://github.com/zendframework/zf2/pull/4449)
- [4455: Need way to specify in the logger configuration the factory for the own writer](https://github.com/zendframework/zf2/pull/4455)
- [4489: Replacing the magic number for a list of constants in Validator\NotEmpty](https://github.com/zendframework/zf2/pull/4489)
- [4505: Give modules the ability to modify application config after their own co...](https://github.com/zendframework/zf2/pull/4505)
- [4510: Introduce Zend\I18n\Filter\NumberParse based on Zend\I18n\Filter\NumberFormat](https://github.com/zendframework/zf2/pull/4510)
- [4512: blackhole cache storage adapter](https://github.com/zendframework/zf2/pull/4512)
- [4515: Issue #4443 - Zend\I18n\Translator\Loader\PhpArray can now load files from include path](https://github.com/zendframework/zf2/pull/4515)
- [4534: Introduce JsonSerializable polyfill and support in Zend\Json\Encoder](https://github.com/zendframework/zf2/pull/4534)
- [4574: Config\Factory can read from include&#95;path](https://github.com/zendframework/zf2/pull/4574)
- [4584: Composer dependencies fixed](https://github.com/zendframework/zf2/pull/4584)
- [4606: Supports the encoding of the console and encodes the text to display if needed](https://github.com/zendframework/zf2/pull/4606)
- [4610: Version warning http:// wrapper is disabled in the server configuration by allow&#95;url&#95;fopen=0](https://github.com/zendframework/zf2/issues/4610)
- [4625: Use Zend\Http\Client in Zend\Version](https://github.com/zendframework/zf2/pull/4625)
- [4653: Zend\Authentication\Adapter\Http::&#95;challengeClient() should be public](https://github.com/zendframework/zf2/pull/4653)
- [4662: Zend\Db PDO adapter ignoring charset](https://github.com/zendframework/zf2/issues/4662)
- [4677: Add Form\Element labelOptions property w/ implemented use case](https://github.com/zendframework/zf2/pull/4677)
- [4679: !IE support for conditional comments powered viewhelper](https://github.com/zendframework/zf2/pull/4679)
- [4742: LoggerAwareInterface and its Trait](https://github.com/zendframework/zf2/pull/4742)
- [4751: Hydrator aware trait](https://github.com/zendframework/zf2/pull/4751)
- [4752: Hydrator refactoring](https://github.com/zendframework/zf2/pull/4752)
- [4756: getValue() for MonthSelect, DateSelect and DateTimeSelect Form Elements ](https://github.com/zendframework/zf2/pull/4756)
- [4764: Add interface `FilterEnabledInterface`](https://github.com/zendframework/zf2/pull/4764)
- [4767: Make include&#95;path functionality of Config and Translator opt-in](https://github.com/zendframework/zf2/pull/4767)
- [4781: Adding missing &quot;NOT IN&quot; predicate](https://github.com/zendframework/zf2/pull/4781)
- [4785: CSRF element naming conflicts](https://github.com/zendframework/zf2/issues/4785)
- [4813: Zend log filter sample](https://github.com/zendframework/zf2/pull/4813)
- [4815: Make HTTP auth adapter's challengeClient() method public](https://github.com/zendframework/zf2/pull/4815)
- [4822: Simplification of the HTML class name in Tag\Cloud\Decorator\HtmlCloud](https://github.com/zendframework/zf2/pull/4822)
- [4824: Add Config Reader for Java-style .properties files and strings](https://github.com/zendframework/zf2/pull/4824)
- [4831: Zend\Mvc\Application::run returns ResponseInterface.](https://github.com/zendframework/zf2/pull/4831)
- [4836: Adding warning namespace](https://github.com/zendframework/zf2/pull/4836)
- [4844: Add cas operation for apc adapter](https://github.com/zendframework/zf2/pull/4844)
- [4846: DisableInArrayValidator for Multicheckbox](https://github.com/zendframework/zf2/pull/4846)
- [4849: Fix Application::run() return values](https://github.com/zendframework/zf2/pull/4849)
- [4852: ArrayObject::offsetExists - Fix check on offsetExists](https://github.com/zendframework/zf2/pull/4852)
- [4860: abstract factory for configs reading keys from merged config](https://github.com/zendframework/zf2/pull/4860)
- [4864: enhancement of ProvidesEvents trait](https://github.com/zendframework/zf2/pull/4864)
- [4871: Use .eml extensions for emails stored with Zend\Mail\Transport\File](https://github.com/zendframework/zf2/pull/4871)
- [4884: Allow replacing elements within a form collection](https://github.com/zendframework/zf2/pull/4884)
- [4903: Update MemoryManager.php](https://github.com/zendframework/zf2/pull/4903)
- [4904: Update Feed.php](https://github.com/zendframework/zf2/pull/4904)
- [4907: Changed self::SPECIFICATION&#95;* to static::SPECIFICATION&#95;* in non declarat...](https://github.com/zendframework/zf2/pull/4907)
- [4908: Segregation HydratorInterface](https://github.com/zendframework/zf2/pull/4908)
- [4912: Fix spelling of &quot;marshall&quot;](https://github.com/zendframework/zf2/pull/4912)
- [4913: make use of mickey179/vfsStream in unit tests: Zend\Test](https://github.com/zendframework/zf2/pull/4913)
- [4927: Nested Fieldset value can be a Traversable](https://github.com/zendframework/zf2/pull/4927)
- [4931: Mime\Message: createFromString: really ignore unknown headers](https://github.com/zendframework/zf2/pull/4931)
- [4940: New Zend\Validator\Bitwise](https://github.com/zendframework/zf2/pull/4940)
- [4946: Add assertTemplateName and assertNotTemplateName](https://github.com/zendframework/zf2/pull/4946)
- [4950: Add matching capabilities to the Content-Type header](https://github.com/zendframework/zf2/pull/4950)
- [4962: added &quot;ControllerManager&quot; Manager, and make &quot;ControllerLoader&quot; as alias of it](https://github.com/zendframework/zf2/pull/4962)
- [4969: PartialLoop helper: prevent convert traversable model to array recursive...](https://github.com/zendframework/zf2/pull/4969)
- [4971: Form\Factory can handle config with null elements](https://github.com/zendframework/zf2/pull/4971)
- [4973: Issue 4662 - Zend\Db\PDO adapter driver ignores charset option](https://github.com/zendframework/zf2/pull/4973)
- [4979: Add multiple translation text domains to Zend\Navigation](https://github.com/zendframework/zf2/pull/4979)
- [4980: change of version checks to use PHP&#95;VERSION&#95;ID constant.](https://github.com/zendframework/zf2/pull/4980)
- [4989: &#91;Zend-Code&#92; Find php 5.4 traits with TokenArrayScanner](https://github.com/zendframework/zf2/pull/4989)
- [4995: &#91;SessionManagerFactory&#92; Configuration of validators in SessionManagerFactory](https://github.com/zendframework/zf2/pull/4995)
- [5019: added role attribute](https://github.com/zendframework/zf2/pull/5019)
- [5024: &#91;BC Break&#92; Added the set /getPbkdf2HashAlgorithm() in BlockCipher](https://github.com/zendframework/zf2/pull/5024)
- [5025: Support for 'origin' header value?](https://github.com/zendframework/zf2/issues/5025)
- [5029: Support for Origin header](https://github.com/zendframework/zf2/pull/5029)
- [5032: Added metadata for oracle](https://github.com/zendframework/zf2/pull/5032)
- [5034: Locale aware fix](https://github.com/zendframework/zf2/pull/5034)
- [5043: DocBlock Reflection not returning correct tags](https://github.com/zendframework/zf2/pull/5043)
- [5064: Added optional charset to pdo dsn](https://github.com/zendframework/zf2/pull/5064)
- [5069: Fixed bug that caused the PDO to throw an invalid keyword error](https://github.com/zendframework/zf2/pull/5069)
- [5072: PSR-2 : add space before and after between (if and foreach) and parenthesis](https://github.com/zendframework/zf2/pull/5072)
- [5080: Added separator to model in renderPartial function](https://github.com/zendframework/zf2/pull/5080)
- [5082: Simplification](https://github.com/zendframework/zf2/pull/5082)
- [5089: Test for the getArrayCopy method in AbstractRestultSet](https://github.com/zendframework/zf2/pull/5089)
- [5101: Update label view helper to have html escape by default](https://github.com/zendframework/zf2/pull/5101)
- [5106: Fix CollectionInputFilter validation when empty data is being processed](https://github.com/zendframework/zf2/pull/5106)
- [5108: Hotfix/4879](https://github.com/zendframework/zf2/pull/5108)
- [5136: Zend\Navigation - add to AbstractPage static factories](https://github.com/zendframework/zf2/pull/5136)
- [5138: Zend/Navigation/Page/Mvc add default route name](https://github.com/zendframework/zf2/pull/5138)
- [5139: Zend/Navigation/View/HelperConfig - configurable view helper](https://github.com/zendframework/zf2/pull/5139)
- [5209: increase consistency : call $this-&gt;events, $this-&gt;event, $this-&gt;response, and $this-&gt;request directly at Zend\Mvc\Application.php](https://github.com/zendframework/zf2/pull/5209)
- [5211: Get the connected dsn string that is now stored when the pdo connection is made](https://github.com/zendframework/zf2/pull/5211)
- [5226: Fix/form label options](https://github.com/zendframework/zf2/pull/5226)
- [5237: ServiceManager - fix AbstractFactories performance and service waiting](https://github.com/zendframework/zf2/pull/5237)
- [5238: allow empty fieldset labels in formCollection view helper](https://github.com/zendframework/zf2/pull/5238)
- [5242: form collection attributes](https://github.com/zendframework/zf2/pull/5242)
- [5245: Fix code reflection - getBody/getContents method](https://github.com/zendframework/zf2/pull/5245)
- [5255: Get ViewModel children by capture](https://github.com/zendframework/zf2/pull/5255)
- [5260: Zend/Db/Sql/Insert - implement insert into select construction](https://github.com/zendframework/zf2/pull/5260)
- [5261: DevelopThis is a new PR since the base branch has changed.  Please see #5017](https://github.com/zendframework/zf2/pull/5261)
- [5262: Zend code method prototype](https://github.com/zendframework/zf2/pull/5262)
- [5266: Throw an exception in PhpRenderer when the resolved file path is not rea...](https://github.com/zendframework/zf2/pull/5266)
- [5272: Create Callback adapter for Zend\Paginator](https://github.com/zendframework/zf2/pull/5272)
- [5283: Deprecate ProvidesEvents trait](https://github.com/zendframework/zf2/pull/5283)
- [5289: Abstract Factories handling is inconsistent with normal Factories](https://github.com/zendframework/zf2/issues/5289)
- [5304: &#91;psr-2&#92; Add whitespace for anonymous functions.](https://github.com/zendframework/zf2/pull/5304)
- [5308: Zend\Db\Resultset fix buffering](https://github.com/zendframework/zf2/pull/5308)
- [5312: Locale aware fix](https://github.com/zendframework/zf2/pull/5312)
- [5313: &#91;http&#92; fix many header issues](https://github.com/zendframework/zf2/pull/5313)
- [5316: Added Content Security Policy 1.0 header class](https://github.com/zendframework/zf2/pull/5316)
- [5321: Zend\Db\Adapter alow to use the temporary ResultSetPrototype](https://github.com/zendframework/zf2/pull/5321)
- [5329: change self:: with static:: in call-ing static property/method](https://github.com/zendframework/zf2/pull/5329)
- [5338: ZendTest - added tearDown for Netbeans tests](https://github.com/zendframework/zf2/pull/5338)
- [5341: Missing notIn predicate](https://github.com/zendframework/zf2/pull/5341)
- [5354: Can't inherit abstract function Zend\Validator\Translator\TranslatorInterface::translate()](https://github.com/zendframework/zf2/issues/5354)
- [5355: Handle 'disable&#95;html&#95;escape' option in FormButton helper](https://github.com/zendframework/zf2/pull/5355)
- [5356: Deprecate Zend\Dom\Query in favor of more logical OO approach](https://github.com/zendframework/zf2/pull/5356)
- [5358: &#91;Zend\Navigation&#92; Extracting the translation from &quot;htmlify&quot;-method into ...](https://github.com/zendframework/zf2/pull/5358)
- [5364: Add Naming strategy for Hydrators](https://github.com/zendframework/zf2/pull/5364)
- [5365: &#91;stdlib&#92; Add guard utils and traits](https://github.com/zendframework/zf2/pull/5365)
- [5377: &#91;http&#92; Allow headers without whitespace after &quot;:&quot;](https://github.com/zendframework/zf2/pull/5377)
- [5380: Zf hydrator strategy context](https://github.com/zendframework/zf2/pull/5380)
- [5390: Add regression test for #5237](https://github.com/zendframework/zf2/pull/5390)
- [5391: CS fix for #5245](https://github.com/zendframework/zf2/pull/5391)
- [5393: Properly set only specified methods](https://github.com/zendframework/zf2/pull/5393)
- [5394: use namespaces in versiontest](https://github.com/zendframework/zf2/pull/5394)
- [5395: ServiceManager::has() when assigned non String or Array causes Undefine Notice errors](https://github.com/zendframework/zf2/issues/5395)
- [5396: Fix for issue #5395](https://github.com/zendframework/zf2/pull/5396)
- [5398: fixed typo](https://github.com/zendframework/zf2/pull/5398)
- [5400: fixes #5384 - getValue now returns metadata of the value, added getValueType](https://github.com/zendframework/zf2/pull/5400)
- [5403: README fix of Zend\Dom\Query (#5356)](https://github.com/zendframework/zf2/pull/5403)
- [5406: Make I18n component completely optional for Mvc](https://github.com/zendframework/zf2/pull/5406)
- [5408: Fixes for #5356](https://github.com/zendframework/zf2/pull/5408)
- [5420: Added ability to compose collections via Zend Form annotations](https://github.com/zendframework/zf2/pull/5420)
- [5436: &#91;WIP&#92; Zend\Filter harmonization (Issue 5119)](https://github.com/zendframework/zf2/pull/5436)
- [5456: Enable input filter config from annotations to be passed on via composed collections](https://github.com/zendframework/zf2/pull/5456)
- [5458: &#91;Validator&#92; Refactor Date](https://github.com/zendframework/zf2/pull/5458)
- [5459: fix docblock and exception that still use &quot;Zend&#95;&quot; prefix](https://github.com/zendframework/zf2/pull/5459)
- [5469: Abstract console controller](https://github.com/zendframework/zf2/pull/5469)
- [5470: Add Zend\Mail\Transport\Factory](https://github.com/zendframework/zf2/pull/5470)
- [5484: Db\Sql\Select use functions without table](https://github.com/zendframework/zf2/pull/5484)
- [5496: Oracle hotfix for #5488 (casing in sequence helper)](https://github.com/zendframework/zf2/pull/5496)
- [5533: &#91;WIP&#92; Added option to ensure form element will be rendered inside label tag ev...](https://github.com/zendframework/zf2/pull/5533)
- [5538: Zend\Db\Sql\Ddl\CreateTable - fix create temporary tables](https://github.com/zendframework/zf2/pull/5538)
- [5557: Fixed non-working Spanish validator translation](https://github.com/zendframework/zf2/pull/5557)
- [5562: Add unsetValueOption() to the Form\Element\Select and Form\Element\MultiCheckbox](https://github.com/zendframework/zf2/pull/5562)
- [5569: Fixed boolean/integer BC break in Zend\Config\Writer\PhpArray](https://github.com/zendframework/zf2/pull/5569)
- [5587: Changed the default cost of bcrypt to 10](https://github.com/zendframework/zf2/pull/5587)
- [5593: Added resources/languages/id for Indonesian translation](https://github.com/zendframework/zf2/pull/5593)
- [5602: Update minimum required PHP version to 5.3.23](https://github.com/zendframework/zf2/pull/5602)
- [5604: &#91;2.3.0&#92; change php require version from 5.3.3 to 5.3.23 in all resources and update tests that no longer support 5.3.3](https://github.com/zendframework/zf2/pull/5604)
- [5605: Fixed session&#95;cache&#95;limiter available options](https://github.com/zendframework/zf2/pull/5605)
- [5611: Adding HHVM to build matrix](https://github.com/zendframework/zf2/pull/5611)
- [5612: make 'listeners' key can be configured outside application.config.php](https://github.com/zendframework/zf2/pull/5612)
- [5616: Prettify the output of Zend\Code\Generator\ValueGenerator for multi line arrays](https://github.com/zendframework/zf2/pull/5616)
- [5628: Acl assertions enhancement](https://github.com/zendframework/zf2/pull/5628)
- [5638: BaseInputFilter handles missing data properly](https://github.com/zendframework/zf2/pull/5638)
- [5642: Offset may be specified without a limit. Causes syntax error in mysql, sqlite and maybe others](https://github.com/zendframework/zf2/issues/5642)
- [5643: Fixes #5642](https://github.com/zendframework/zf2/pull/5643)
- [5649: Added a assertion method for the response phrase of a http response.](https://github.com/zendframework/zf2/pull/5649)
- [5650: Set custom class name for active li element](https://github.com/zendframework/zf2/pull/5650)
- [5651: Allow modules to load their own dependencies](https://github.com/zendframework/zf2/pull/5651)
- [5664: &#91;Minor BC&#92; Remove translation of validator keys](https://github.com/zendframework/zf2/pull/5664)
- [5665: &#91;http&#92; Normalize Content-Transfer-Encoding](https://github.com/zendframework/zf2/issues/5665)
- [5666: Remove translations in Zend\Form\View\Helper\FormElementErrors #5646](https://github.com/zendframework/zf2/pull/5666)
- [5670: Add controller namespace prefix to template mapping](https://github.com/zendframework/zf2/pull/5670)
- [5689: Fix BC break with skeleton for Translator Service](https://github.com/zendframework/zf2/pull/5689)
- [5692: Additional MVC Translator BC fixes](https://github.com/zendframework/zf2/pull/5692)
- [5698: #5665 Normalize Http Content-Transfer-Encoding](https://github.com/zendframework/zf2/pull/5698)
- [5702: Stdlib - PriorityList move from Zend\Mvc\Router to Stdlib](https://github.com/zendframework/zf2/pull/5702)
- [5711: Implemented writeTextBlock method in Zend\Console\Adapter\AbstractAdapter](https://github.com/zendframework/zf2/pull/5711)
- [5713: Adding Zend\Console\Getopt option callback hooks](https://github.com/zendframework/zf2/pull/5713)
- [5717: Hotfix/various fixes](https://github.com/zendframework/zf2/pull/5717)
- [5719: Feature/make collection configurable](https://github.com/zendframework/zf2/pull/5719)
- [5720: Fix #5671 - console routing not correct](https://github.com/zendframework/zf2/pull/5720)
- [5724: 5.3.3 -&gt; 5.3.23 missing dump](https://github.com/zendframework/zf2/pull/5724)
- [5730: Zend\Test Fix persistence with multi dispatch](https://github.com/zendframework/zf2/pull/5730)
- [5731: Zend\Test Provide dispatch like a XmlHttpRequest](https://github.com/zendframework/zf2/pull/5731)
- [5732: Fix for issue #5629](https://github.com/zendframework/zf2/pull/5732)
- [5736: fix strange exception message in Mysqli connection](https://github.com/zendframework/zf2/pull/5736)
- [5741: Make allowObjectBinding configurable for Fieldsets](https://github.com/zendframework/zf2/pull/5741)
- [5747: Implementation of inTransaction() in all Zend\Db\Adapter\Drivers](https://github.com/zendframework/zf2/pull/5747)
- [5748: added a submodule loading to testCanLoadMultipleModules](https://github.com/zendframework/zf2/pull/5748)
- [5751: Updated Bulgarian translation](https://github.com/zendframework/zf2/pull/5751)
- [5757: Zend\Config\Writer\PhpArray needs to use var&#95;export for strings, not addslahes()](https://github.com/zendframework/zf2/pull/5757)
- [5759: Update FlashMessenger.php](https://github.com/zendframework/zf2/pull/5759)
- [5780: Allow specifying &quot;break chain on failure&quot; flag as Validator option](https://github.com/zendframework/zf2/pull/5780)
- [5783: Do not exit from loadClass() early](https://github.com/zendframework/zf2/pull/5783)
- [5792: &#91;Soap/Server&#92; add debug mode](https://github.com/zendframework/zf2/pull/5792)
- [5793: &#91;Soap\Client\DotNet&#92;&#91;FIX&#92; Undefined property in void return](https://github.com/zendframework/zf2/pull/5793)
- [5795: ServiceManager::canCreateFromAbstractFactory() missing foreach break after valid abstract factory found](https://github.com/zendframework/zf2/pull/5795)
- [5803: Hide sub menus if all pages in the sub menu is hidden.](https://github.com/zendframework/zf2/pull/5803)
- [5810: &#91;Zend\Soap\Server&#92; Add getException to get caught exceptions](https://github.com/zendframework/zf2/pull/5810)
- [5811: &#91;Zend\Soap\Server&#92;&#91;NEW&#92;&nbsp;add a getSoap method, return the internal instance](https://github.com/zendframework/zf2/pull/5811)
- [5825: New class Translator\Loader\PhpMemoryArray ](https://github.com/zendframework/zf2/pull/5825)
- [5829: Zend\Cache\Storage\Adapter\Memcache](https://github.com/zendframework/zf2/pull/5829)
- [5840: Removed Zend\Http\Client\Cookies](https://github.com/zendframework/zf2/pull/5840)
- [5853: Fixes #4943](https://github.com/zendframework/zf2/pull/5853)
- [5854: Multiple identifiers in `In`](https://github.com/zendframework/zf2/pull/5854)
- [5855: Fixes #5162](https://github.com/zendframework/zf2/pull/5855)
- [5856: #5665 Fix in test for JsonStrategy](https://github.com/zendframework/zf2/pull/5856)
- [5858: Deprecate Proxy auto-generation](https://github.com/zendframework/zf2/pull/5858)
- [5864: patch #5860 barcode analyzer fixes](https://github.com/zendframework/zf2/pull/5864)
- [5869: remove TYPE&#95;SELECT deprecated Constant that marked will go away in 2.1](https://github.com/zendframework/zf2/pull/5869)
- [5875: Logger register shut down](https://github.com/zendframework/zf2/pull/5875)
- [5877: Optional ProxyManager in builds](https://github.com/zendframework/zf2/pull/5877)
- [5880: Updated PhpArray to expand paths using &#95;&#95;DIR&#95;&#95;](https://github.com/zendframework/zf2/pull/5880)
- [5882: Allow setting formatter for Zend\Log\Writer\Db via config options](https://github.com/zendframework/zf2/pull/5882)
- [5885: parametrized-locale-aware routing](https://github.com/zendframework/zf2/pull/5885)
- [5897: Add get decode json data on params controller plugin](https://github.com/zendframework/zf2/pull/5897)
- [5901: Add AuthenticationServiceInterface](https://github.com/zendframework/zf2/pull/5901)
- [5902: Added testcase for BlockCipher using 0 values](https://github.com/zendframework/zf2/pull/5902)
- [5907: &#91;#5616&#92; Adapt array indentation to PSR-2 guidelines by default](https://github.com/zendframework/zf2/pull/5907)
- [5908: Allow merging text domains without plural rules](https://github.com/zendframework/zf2/pull/5908)
- [5910: minor improvements to form labels](https://github.com/zendframework/zf2/pull/5910)
- [5917: Fixes #5192](https://github.com/zendframework/zf2/pull/5917)
- [5918: Hotfix/4785 csrf name conflicts](https://github.com/zendframework/zf2/pull/5918)
- [5919: Default value for labelAttributes](https://github.com/zendframework/zf2/pull/5919)
- [5920: FormRow generetes invalid HTML for MonthSelect](https://github.com/zendframework/zf2/pull/5920)
- [5921: Nicaraguan phone numbering plan once again](https://github.com/zendframework/zf2/pull/5921)
- [5922: Updated catalan Zend/Validate translations](https://github.com/zendframework/zf2/pull/5922)
- [5923: Fix/5906 collection count is ignored when data empty](https://github.com/zendframework/zf2/pull/5923)
- [5925: Update DateStep.php](https://github.com/zendframework/zf2/pull/5925)
- [5926: Fix for missing required option for CollectionInputFilter](https://github.com/zendframework/zf2/pull/5926)
- [5928: Fixed notice on binding entity to form](https://github.com/zendframework/zf2/pull/5928)
- [5930: Fix @cover at travis build from #5853](https://github.com/zendframework/zf2/pull/5930)
- [5931: Disable &lt;label&gt; for input hidden](https://github.com/zendframework/zf2/pull/5931)
- [5933: Allow arbitrary error codes in JSON RPC server](https://github.com/zendframework/zf2/pull/5933)
- [5936: Fix for issue #4267](https://github.com/zendframework/zf2/pull/5936)
- [5937: Fix Zend\Mail\Headers::removeHeader is not removing every header matching header name](https://github.com/zendframework/zf2/pull/5937)
- [5939: Fix annotation on Zend\Mail\Message::getHeaderByName](https://github.com/zendframework/zf2/pull/5939)
- [5940: Zend\Db\Sql Allow MySQL to use limit when only offset was provided](https://github.com/zendframework/zf2/pull/5940)
- [5941: no cast to (int) on limit&amp;offset at Zend\Db\Sql\Select.php](https://github.com/zendframework/zf2/pull/5941)
- [5942: Mvc\I18n\Translator -&gt; setLocale](https://github.com/zendframework/zf2/pull/5942)
- [5943: Fixed route matcher test](https://github.com/zendframework/zf2/pull/5943)
- [5951: Fix console mixed case optional value params](https://github.com/zendframework/zf2/pull/5951)

## 2.2.10 (2015-02-18)

### SECURITY UPDATES

- **ZF2015-02:** `Zend\Db\Adapter\Platform\Postgresql` was incorrectly using
  `\\` to escape double quotes in identifiers and values, which could lead to
  SQL injection vectors. We have provided patches that use proper escaping. If
  you use Postgresql with Zend Framework 2, we recommend upgrading immediately.

## 2.2.9 (2015-01-14)

### SECURITY UPDATES

- **ZF2015-01:** Session validators were not run if set before session start.
  Essentially, the validators were writing to the `$_SESSION` superglobal before
  session start, which meant the data was overwritten once the session began.
  This meant on subsequent calls, the validators had no data to compare against,
  making the sessions automatically valid. We have provided patches to ensure
  that validators are run only after the session has begun, which will ensure
  they validate sessions correctly going forward. If you use `Zend\Session`
  validators, we recommend upgrading immediately.

## 2.2.8 (2014-09-17)

### SECURITY UPDATES

- **ZF2014-05:** Due to an issue that existed in PHP's LDAP extension, it is
  possible to perform an unauthenticated simple bind against a LDAP server by
  using a null byte for the password, regardless of whether or not the user
  normally requires a password. We have provided a patch in order to protect
  users of unpatched PHP versions (PHP 5.5 <= 5.5.11, PHP 5.4 <= 5.4.27, all
  versions of PHP 5.3 and below). If you use `Zend\Ldap` and are on an affected
  version of PHP, we recommend upgrading immediately.
- **ZF2014-06:** A potential SQL injection vector existed when using a SQL
  Server adapter to manually quote values due to the fact that it was not
  escaping null bytes. Code was added to ensure null bytes are escaped, and
  thus mitigate the SQLi vector. We do not recommend manually quoting values,
  but if you do, and use the SQL Server adapter without PDO, we recommend
  upgrading immediately.

## 2.2.7 (2014-04-15)

### SECURITY UPDATES

- **ZF2014-03:** Potential XSS vector in multiple view helpers due to
  inappropriate HTML attribute escaping. Many view helpers were using the
  `escapeHtml()` view helper in order to escape HTML attributes. This release
  patches them to use the `escapeHtmlAttr()` view helper in these situations.
  If you use form or navigation view helpers, or "HTML element" view helpers
  (such as `gravatar()`, `htmlFlash()`, `htmlPage()`, or `htmlQuicktime()`), we
  recommend upgrading immediately.

## 2.2.6 (2014-03-06)

- [4490: Nonvalid literal value for the boolean type, PDO](https://github.com/zendframework/zf2/pull/4490)
- [4993: Zend\Db\TableGateway\Feature\FeatureSet::addFeature() at line 69](https://github.com/zendframework/zf2/issues/4993)
- [5125: Method scanner fixed](https://github.com/zendframework/zf2/pull/5125)
- [5174: SequenceFeature](https://github.com/zendframework/zf2/issues/5174)
- [5186: Minor bugfix: Added missing composer dependency (ServiceManager) to Math package](https://github.com/zendframework/zf2/pull/5186)
- [5221: - Create temporary table instead of create table temporary](https://github.com/zendframework/zf2/pull/5221)
- [5314: Enable persistent connections for IbmDb2.](https://github.com/zendframework/zf2/pull/5314)
- [5322: Fixing a bug that causes fatal error when a RowGateway's primary key wer...](https://github.com/zendframework/zf2/pull/5322)
- [5375: Fixes default type == string](https://github.com/zendframework/zf2/pull/5375)
- [5383: fix for #4614 breaks error handler using Zend\Log](https://github.com/zendframework/zf2/pull/5383)
- [5385: Resolves #4708 - adding transparent background support to barcode](https://github.com/zendframework/zf2/pull/5385)
- [5387: fixes #5062 - No longer throw Filename cannot be empty error](https://github.com/zendframework/zf2/pull/5387)
- [5401: fixed typos](https://github.com/zendframework/zf2/pull/5401)
- [5402: Update range of mobile](https://github.com/zendframework/zf2/pull/5402)
- [5409: &#91;rbac&#92; Typo](https://github.com/zendframework/zf2/pull/5409)
- [5411: Update Czech validator messages ](https://github.com/zendframework/zf2/pull/5411)
- [5412: Zend\Test needs Zend\Console as dependency](https://github.com/zendframework/zf2/pull/5412)
- [5418: Added isset check for REMOTE&#95;ADDR](https://github.com/zendframework/zf2/pull/5418)
- [5421: fix typo &amp; wording](https://github.com/zendframework/zf2/pull/5421)
- [5422: Fix emails that contain lines that start with periods](https://github.com/zendframework/zf2/pull/5422)
- [5423: Zend\Http\Header\SetCookie not compatible with older versions of pcre (and therefore CentOS)](https://github.com/zendframework/zf2/pull/5423)
- [5424: Issue 3104: Form\Element &quot;x-...&quot; attributes](https://github.com/zendframework/zf2/pull/5424)
- [5425: Issue 3249: FormFile does not allow &quot;value&quot; as an attribute](https://github.com/zendframework/zf2/pull/5425)
- [5432: Problem with Forward Plugin](https://github.com/zendframework/zf2/pull/5432)
- [5438: fix typo](https://github.com/zendframework/zf2/pull/5438)
- [5444: fix indentation](https://github.com/zendframework/zf2/pull/5444)
- [5445: Fixing issue with ModuleAutoloader on Windows](https://github.com/zendframework/zf2/pull/5445)
- [5447: Di circular dependancies](https://github.com/zendframework/zf2/pull/5447)
- [5451: Remove duplicate: zend-stdlib is already required](https://github.com/zendframework/zf2/pull/5451)
- [5452: update master's resources/ja Zend&#95;Validate.php message for 2.2](https://github.com/zendframework/zf2/pull/5452)
- [5453: add resources/languages/ja/Zend&#95;Captcha.php with Japanese translated](https://github.com/zendframework/zf2/pull/5453)
- [5457: Zend\Db\Adapter\Driver\PdoResult::current patch](https://github.com/zendframework/zf2/pull/5457)
- [5464: remove unused use](https://github.com/zendframework/zf2/pull/5464)
- [5468: Add security disclosure info to README/CONTRIBUTING docs](https://github.com/zendframework/zf2/pull/5468)
- [5471: Fix typehint for getServiceLocator().](https://github.com/zendframework/zf2/pull/5471)
- [5472: remove unused use statements](https://github.com/zendframework/zf2/pull/5472)
- [5476: Zend\Http\Header\SetCookie changed to support empty cookies](https://github.com/zendframework/zf2/pull/5476)
- [5479: Add element input filters before form input filters](https://github.com/zendframework/zf2/pull/5479)
- [5495: Hotfix/multiple nested collection test](https://github.com/zendframework/zf2/pull/5495)
- [5497: fix for fprg](https://github.com/zendframework/zf2/pull/5497)
- [5499: #5465 use strlen instead of empty](https://github.com/zendframework/zf2/pull/5499)
- [5502: Update collection recursive extract and populating nested fieldsets](https://github.com/zendframework/zf2/pull/5502)
- [5507: Fixed usage of imported namespace.](https://github.com/zendframework/zf2/pull/5507)
- [5508: Specify correct return type for `Pdo\Connection::getLastGeneratedValue`](https://github.com/zendframework/zf2/pull/5508)
- [5523: &#91;Http&#92; Fixes](https://github.com/zendframework/zf2/pull/5523)
- [5534: Added ability to set form option useInputFilterDefaults in factory via s...](https://github.com/zendframework/zf2/pull/5534)
- [5546: Zend/Mvc/Router encoding issue (Fixes #5516)](https://github.com/zendframework/zf2/pull/5546)
- [5551: Fix Zend\Form\Element\Number $inclusive is always true (Fix for #5549)](https://github.com/zendframework/zf2/pull/5551)
- [5552: Add driver options to the Oci8 Db adapter](https://github.com/zendframework/zf2/pull/5552)
- [5555: &#91;Hotfix&#92; Validator\File classes behaviour with empty value](https://github.com/zendframework/zf2/pull/5555)
- [5567: Fixes #4670](https://github.com/zendframework/zf2/pull/5567)
- [5570: fix #5428 only read the stream contents once](https://github.com/zendframework/zf2/pull/5570)
- [5575: Fix graphme&#95;substr for PHP &gt;= 5.4.18 or &gt;=5.5.1](https://github.com/zendframework/zf2/pull/5575)
- [5576: Enable Travis Fast finishing](https://github.com/zendframework/zf2/pull/5576)
- [5577: Fix for #4707 pgsql getLastGeneratedValue() Problem](https://github.com/zendframework/zf2/pull/5577)
- [5588: More lenient db detection in Logger abstract factory](https://github.com/zendframework/zf2/pull/5588)
- [5597: Fix zend server cache](https://github.com/zendframework/zf2/pull/5597)
- [5609: Allow RuntimeDefinition to still process explicit classes](https://github.com/zendframework/zf2/pull/5609)
- [5613: Test rewrite for avoid test skip. Related #5592](https://github.com/zendframework/zf2/pull/5613)
- [5614: Fixed issue with Math\Rand::getInteger() on ranges close to PHP&#95;INT&#95;MAX](https://github.com/zendframework/zf2/pull/5614)
- [5623: Adding attributes to fieldsets. Legends are optional for fieldsets.](https://github.com/zendframework/zf2/pull/5623)
- [5633: Giving a Warning namespaces to FlashMessager](https://github.com/zendframework/zf2/pull/5633)
- [5636: Fix for the implementation of Collection Element](https://github.com/zendframework/zf2/pull/5636)
- [5641: &#91;Hotfix&#92; FilePostRedirectGet plugin and form collections](https://github.com/zendframework/zf2/pull/5641)
- [5644: Addressing issue #5624. Implemented fix and added test case.](https://github.com/zendframework/zf2/pull/5644)
- [5645: Update InArray.php](https://github.com/zendframework/zf2/pull/5645)
- [5647: Adding Hungarian translations](https://github.com/zendframework/zf2/pull/5647)
- [5659: Fix a fatal error when assert WWW-Authenticate header is sent - Hotfix/5658](https://github.com/zendframework/zf2/pull/5659)
- [5669: Fix bug in InjectTemplateListenerTest](https://github.com/zendframework/zf2/pull/5669)
- [5672: &#91;cs&#92; cleanup master](https://github.com/zendframework/zf2/pull/5672)
- [5677: SetCookie With expiry of over 2038 fail on 32bit systems](https://github.com/zendframework/zf2/pull/5677)
- [5680: Update BlockCipher.php](https://github.com/zendframework/zf2/pull/5680)
- [5691: Input Factory supports &quot;break&#95;on&#95;failure&quot; option](https://github.com/zendframework/zf2/pull/5691)
- [5707: update userguide manual link](https://github.com/zendframework/zf2/pull/5707)
- [5714: Change hardcoded event name by its constant.](https://github.com/zendframework/zf2/pull/5714)
- [5718: added a submodule loading to testCanLoadMultipleModules](https://github.com/zendframework/zf2/pull/5718)
- [5729: Fixed module loader to work with *.tar modules in IIS7.5 on Win 2008 R2](https://github.com/zendframework/zf2/pull/5729)
- [5739: &#91;BUGFIX&#92; DI fails with CompilerDefinition; solves #5738](https://github.com/zendframework/zf2/pull/5739)
- [5746: Remove hydrator from collections](https://github.com/zendframework/zf2/pull/5746)
- [5749: shortcircuit rendering if no messages](https://github.com/zendframework/zf2/pull/5749)
- [5750: Change error message when no role found](https://github.com/zendframework/zf2/pull/5750)
- [5752: Get an abstract defined service from an alias](https://github.com/zendframework/zf2/pull/5752)
- [5754: Fixed gz decompress check for false](https://github.com/zendframework/zf2/pull/5754)
- [5755: More explicit name for requested name](https://github.com/zendframework/zf2/pull/5755)
- [5761: fixed typo](https://github.com/zendframework/zf2/pull/5761)
- [5762: remove unneeded createService functions that actually do same with base class ( AbstractPluginManagerFactory )](https://github.com/zendframework/zf2/pull/5762)
- [5768: FIX #5767 Zend\Db\Sql\Select: getRawState('order') is inconsistent](https://github.com/zendframework/zf2/pull/5768)
- [5771: Fix escaped special chars in urlencoded parameters string incorrectly normalized](https://github.com/zendframework/zf2/pull/5771)
- [5772: Zend\Config\Processor\Token converts boolean to string](https://github.com/zendframework/zf2/issues/5772)
- [5773: Hotfix for #5772: token processor should not cast booleans to strings](https://github.com/zendframework/zf2/pull/5773)
- [5775: Update Predicate.php](https://github.com/zendframework/zf2/pull/5775)
- [5781: Support PHPUnit 3.8+ compatibility](https://github.com/zendframework/zf2/pull/5781)
- [5782: remove unneeded key &quot;name&quot; under &quot;input&#95;filter&quot; per-element in FormAbstractServiceFactoryTest](https://github.com/zendframework/zf2/pull/5782)
- [5786: Correct references toPHPUnit&#95;Runner&#95;Version::VERSION](https://github.com/zendframework/zf2/pull/5786)
- [5788: Zend\Filter\Compress\Bz2 and Gz should be fully PHP &gt;= 5.4 compatible](https://github.com/zendframework/zf2/issues/5788)
- [5796: \Zend\Form\Element\Email, with multiple=true leads to &ldquo;Array to string conversion&rdquo;](https://github.com/zendframework/zf2/issues/5796)
- [5808: Fixes #5796](https://github.com/zendframework/zf2/pull/5808)
- [5813: Fixed the classmap autoloader to work under Windows in Phar files.](https://github.com/zendframework/zf2/pull/5813)
- [5814: Fix validate non required fields in CollectionInputFilter](https://github.com/zendframework/zf2/pull/5814)
- [5815: Usage of a function in loops should be avoided](https://github.com/zendframework/zf2/pull/5815)
- [5820: &#91;Zend\InputFilter\InputFilter&#92; SetValidationGroup() VALIDATE&#95;ALL not working recursively](https://github.com/zendframework/zf2/pull/5820)
- [5824: Remove HTTP client restriction on cookies](https://github.com/zendframework/zf2/pull/5824)
- [5830: Run Travis build also on PHP 5.6](https://github.com/zendframework/zf2/pull/5830)
- [5831: Fixes #4926](https://github.com/zendframework/zf2/pull/5831)
- [5833: Avoid function usage in loops](https://github.com/zendframework/zf2/pull/5833)
- [5836: Fixes #3773](https://github.com/zendframework/zf2/pull/5836)
- [5838: Fix Zend\Test for custom response usage](https://github.com/zendframework/zf2/pull/5838)
- [5839: &#91;Zend\Filter\Compress&#92; added PHP 5.4 support for strings in Bz2 and Gz decompress](https://github.com/zendframework/zf2/pull/5839)
- [5846: Enabling the Request object to generate the correct scheme for SSL URI ](https://github.com/zendframework/zf2/pull/5846)
- [5848: Test and quick fix #5847](https://github.com/zendframework/zf2/pull/5848)
- [5861: Post/Redirect/Get should keep query parameters](https://github.com/zendframework/zf2/pull/5861)
- [5868: Fixes #4993](https://github.com/zendframework/zf2/pull/5868)
- [5870: SSL CA File support.](https://github.com/zendframework/zf2/pull/5870)
- [5871: Add processor support to the Logger options.](https://github.com/zendframework/zf2/pull/5871)
- [5874: Update NotEmpty validator to use bitmasking](https://github.com/zendframework/zf2/pull/5874)
- [5879: Update NotEmptyTest tests to use data providers where possible](https://github.com/zendframework/zf2/pull/5879)
- [5883: Fixes #5648](https://github.com/zendframework/zf2/pull/5883)
- [5887: Fixed bug that didn't allow the connection to the SQLite database to be closed](https://github.com/zendframework/zf2/pull/5887)
- [5890: Hotfix/5640 for bug in nested Zend\Form\Element\Collection::extract() recursion](https://github.com/zendframework/zf2/pull/5890)
- [5891: Nicaraguan phone numbering plan](https://github.com/zendframework/zf2/pull/5891)
- [5892: Case-insensitive country for the PhoneNumber validator class](https://github.com/zendframework/zf2/pull/5892)
- [5893: Fix bug in json prettyprint](https://github.com/zendframework/zf2/pull/5893)
- [5899: fix cs from #5613](https://github.com/zendframework/zf2/pull/5899)
- [5900: Fix for #5894 - .il Domain checking](https://github.com/zendframework/zf2/pull/5900)
- [5903: Re-added ConstraintKeyObject which is consumed from the AbstractSource w/ test (Fixes #3512)](https://github.com/zendframework/zf2/pull/5903)
- [5912: clone problem in datetimeselect form element clone method](https://github.com/zendframework/zf2/issues/5912)
- [5913: Hotfix for #5912: wrong datetime select form element cloning logic](https://github.com/zendframework/zf2/pull/5913)
- [5916: Zend\Http: Unit tests for multi-line headers](https://github.com/zendframework/zf2/pull/5916)

### SECURITY UPDATES

- **ZF2014-01:** Potential XXE/XEE attacks using PHP functions:
  `simplexml_load_*`, `DOMDocument::loadXML`, and `xml_parse`. A new component,
  `ZendXml`, was introduced to mitigate XML eXternal Entity and XML Entity
  Expansion vectors that are present in older versions of libxml2 and/or PHP.
  `Zend\Json\Json::fromXml()` and `Zend\XmlRpc`'s `Response` and `Fault` classes
  were potentially vulnerable to these attacks. If you use either of these
  components, we recommend upgrading immediately.

## 2.2.5 (2013-10-31)

- [4604: Zend\Json\Server\Server::addFunction instantiates new class even an object was given as callable](https://github.com/zendframework/zf2/issues/4604)
- [4874: Skip AnnotationScanner if class name information can't be found.](https://github.com/zendframework/zf2/pull/4874)
- [4918: &#91;suggest&#92; Ignore methods without parameters from aware interfaces](https://github.com/zendframework/zf2/pull/4918)
- [5013: ZF2-2454 HTTP 308 Resume Incomplete missing in Zend\Http\Response](https://github.com/zendframework/zf2/pull/5013)
- [5031: Fix input annotation handler in Zend/Form/Annotation/ElementAnnotationsListener](https://github.com/zendframework/zf2/pull/5031)
- [5035: updated Zend&#95;Validate&#95;Hostname translation message IDs and translations](https://github.com/zendframework/zf2/pull/5035)
- [5037: Slovenian translations updated](https://github.com/zendframework/zf2/pull/5037)
- [5040: Correct namespace name DockBlock to DocBlock](https://github.com/zendframework/zf2/pull/5040)
- [5044: Reflection ThrowsTag to handle types correctly](https://github.com/zendframework/zf2/pull/5044)
- [5050: #4996 broke File filters management](https://github.com/zendframework/zf2/pull/5050)
- [5053: add test case for Zend\Validator\IsInstanceOf to pass Traversable to constructor](https://github.com/zendframework/zf2/pull/5053)
- [5054: is bin/pluginmap&#95;generator.php broken ?](https://github.com/zendframework/zf2/pull/5054)
- [5065: &#91;Zend\Http\Client&#92; dupplicate header keys in prepareHeaders](https://github.com/zendframework/zf2/pull/5065)
- [5066: &#95;&#95;invoke parameter should be null by default](https://github.com/zendframework/zf2/pull/5066)
- [5068: using injected response object](https://github.com/zendframework/zf2/pull/5068)
- [5071: Increase readability, fix indentation](https://github.com/zendframework/zf2/pull/5071)
- [5078: hotfix/4508 and make Zend\Http\Header\SetCookie RFC conform](https://github.com/zendframework/zf2/pull/5078)
- [5083: &#91;Barcode&#92; removed some unused variables](https://github.com/zendframework/zf2/pull/5083)
- [5093: Extract and populate values for nested fieldsets in Collection elements](https://github.com/zendframework/zf2/pull/5093)
- [5100: &#91;ServiceManager&#92; Implemented circular alias reference detection](https://github.com/zendframework/zf2/pull/5100)
- [5111: Fix test suite when ext/intl isn't available](https://github.com/zendframework/zf2/pull/5111)
- [5121: Add inline comments](https://github.com/zendframework/zf2/pull/5121)
- [5140: Fix not allowed encoding of content-transfer-encoding and content-type headers in single part encoded mails](https://github.com/zendframework/zf2/pull/5140)
- [5146: Adds an alias for ModuleManager and removes the duplicate service defini...](https://github.com/zendframework/zf2/pull/5146)
- [5150: Fix Validator\PhoneNumber with E.123/E.164 international numbers.](https://github.com/zendframework/zf2/pull/5150)
- [5152: Issue #4669 - Class generator should return uses from file generator](https://github.com/zendframework/zf2/pull/5152)
- [5161: Fix calling View\Helper\BasePath from CLI results in fatal error.](https://github.com/zendframework/zf2/pull/5161)
- [5175: fix delegators to allow usage in plugin managers](https://github.com/zendframework/zf2/pull/5175)
- [5180: Ensure DiAbstractServiceFactory takes lowest possible priority](https://github.com/zendframework/zf2/pull/5180)
- [5183: Fix for CamelCase filter when string contains multiple uppercase letters and Unicode is off](https://github.com/zendframework/zf2/pull/5183)
- [5193: Fix returned NamespaceType for Parameters from Reflection](https://github.com/zendframework/zf2/pull/5193)
- [5196: Fix JsonRpc service name](https://github.com/zendframework/zf2/pull/5196)
- [5212: assertQueryContentContains searching through all nodes found](https://github.com/zendframework/zf2/pull/5212)
- [5216: added missing I18n\Validator\DateTime translations](https://github.com/zendframework/zf2/pull/5216)
- [5220: Bug fix for Zend\Form\Element\Collection::extract()](https://github.com/zendframework/zf2/pull/5220)
- [5223: Cannot use Zend\Stdlib\ResponseInterface as Response because the name is already in use in Zend\Stdlib\DispatchableInterface](https://github.com/zendframework/zf2/issues/5223)
- [5234: added zendframework/zend-session as suggest dependency at Zend\ProgressBar](https://github.com/zendframework/zf2/pull/5234)
- [5239: added zendframework/zend-cache as suggest dependency at Zend\Paginator](https://github.com/zendframework/zf2/pull/5239)
- [5240: fix Debug::getEscaper() never called at Debug::dump() when xdebug is loaded](https://github.com/zendframework/zf2/pull/5240)
- [5246: move zendframework/zend-escaper from require to suggest dependency at Zend\Debug](https://github.com/zendframework/zf2/pull/5246)
- [5250: explode should be made only by colon (:) and not colon+space (: )](https://github.com/zendframework/zf2/pull/5250)
- [5252: Improvements Zend\Form\View\Helper\FormElement](https://github.com/zendframework/zf2/pull/5252)
- [5254: Zend\Log\Writer\Db via config throws exception](https://github.com/zendframework/zf2/pull/5254)
- [5259: Modified PhpArray config writer to generate better readable array format.](https://github.com/zendframework/zf2/pull/5259)
- [5271: fixes #5270](https://github.com/zendframework/zf2/pull/5271)
- [5274: add regression testing for fieldset input filter](https://github.com/zendframework/zf2/pull/5274)
- [5279: Polish translation for Zend\Captcha](https://github.com/zendframework/zf2/pull/5279)
- [5280: Polish translation and fixes in Zend\Validate](https://github.com/zendframework/zf2/pull/5280)
- [5286: Hotfix/5118](https://github.com/zendframework/zf2/pull/5286)
- [5287: Add Not Like Predicate](https://github.com/zendframework/zf2/pull/5287)
- [5291: &#91;mail&#92; Fixes, criteria unification and optimization.](https://github.com/zendframework/zf2/pull/5291)
- [5293: Fix #5289 (abstract factories return type)](https://github.com/zendframework/zf2/pull/5293)
- [5295: Update DateFormat.php to fix deprecated method call: PHP &gt;= 5.5.0.](https://github.com/zendframework/zf2/pull/5295)
- [5301: &#91;http&#92; Adapt header field name validation to RFC definition](https://github.com/zendframework/zf2/pull/5301)
- [5302: &#91;http&#92; Parse headerline](https://github.com/zendframework/zf2/pull/5302)
- [5311: &#91;http&#92; Unify criteria for split name](https://github.com/zendframework/zf2/pull/5311)
- [5317: IbmDb2 Commitment Control](https://github.com/zendframework/zf2/pull/5317)
- [5318: &#91;#5013&#92; Remove custom code response tests](https://github.com/zendframework/zf2/pull/5318)
- [5319: Class not found instead of exception in RedisOptions](https://github.com/zendframework/zf2/pull/5319)
- [5325: fixed typo](https://github.com/zendframework/zf2/pull/5325)
- [5333: Zend\ServiceManager - CS fixes for master](https://github.com/zendframework/zf2/pull/5333)
- [5336: fix typo](https://github.com/zendframework/zf2/pull/5336)
- [5343: Remove date filtering on date elements](https://github.com/zendframework/zf2/pull/5343)
- [5350: fixed typos](https://github.com/zendframework/zf2/pull/5350)
- [5351: fixes #5310](https://github.com/zendframework/zf2/pull/5351)
- [5360: fixed typo](https://github.com/zendframework/zf2/pull/5360)
- [5368: Avoid SOAP constant error in PHPUnit](https://github.com/zendframework/zf2/pull/5368)
- [5369: Php unit windows](https://github.com/zendframework/zf2/pull/5369)
- [5370: fixed typos](https://github.com/zendframework/zf2/pull/5370)
- [5374: Potential security vulnerability ](https://github.com/zendframework/zf2/issues/5374)
- [5378: Exception as one of the possible exception for Soap\Server::registerFaultException](https://github.com/zendframework/zf2/pull/5378)
- [5379: fixes #4604](https://github.com/zendframework/zf2/pull/5379)
- [5382: #4954 Mongodb small changes](https://github.com/zendframework/zf2/pull/5382)

### SECURITY UPDATES

An issue with `Zend\Http\PhpEnvironment\RemoteAddress` was reported in
[#5374](https://github.com/zendframework/zf2/pull/5374). Essentially, the class
was not checking if `$_SERVER['REMOTE_ADDR']` was one of the trusted proxies
configured, and as a result, `getIpAddressFromProxy()` could return an untrusted
IP address. 

The class was updated to check if `$_SERVER['REMOTE_ADDR']` is in the list of
trusted proxies, and, if so, will return that value immediately before
consulting the values in the `X-Forwarded-For` header.

If you use the `RemoteAddr` `Zend\Session` validator, and are configuring
trusted proxies, we recommend updating to 2.2.5 or later immediately.

### Potential Breakage

- [#5343](https://github.com/zendframework/zf2/pull/5343) removed the
  DateTimeFormatter filter from DateTime form elements. This was done
  due to the fact that it led to unexpected behavior when non-date inputs were
  provided. However, since the DateTime element already incorporates a
  DateValidator that accepts a date format, validation can still work as
  expected.

## 2.2.4 (2013-08-26)

- [5008: deprecated feature in classmap generator](https://github.com/zendframework/zf2/issues/5008)
- [5015: Allow set Form::setPreferFormInputFilter via options](https://github.com/zendframework/zf2/issues/5015)
- [5028: Fix forms regression introduced in 2.2.3](https://github.com/zendframework/zf2/issues/5028)

## 2.2.3 (2013-08-21):

- [4851: allow usage of validator and filter plugin managers in input filter factory if form manager injected](https://github.com/zendframework/zf2/issues/4851)
- [4868: Tests for issue with unexpected injection.](https://github.com/zendframework/zf2/issues/4868)
- [4877: Validator\File tests throwing errors in custom PHP 5.3.10 distributions](https://github.com/zendframework/zf2/issues/4877)
- [4878: Form element title attribute test](https://github.com/zendframework/zf2/issues/4878)
- [4881: Update Validator translations](https://github.com/zendframework/zf2/issues/4881)
- [4883: Update Zend&#95;Validate.php](https://github.com/zendframework/zf2/issues/4883)
- [4893: Resolves warning raised when version is not matched.](https://github.com/zendframework/zf2/issues/4893)
- [4895: Small fix for ZendTest\Form\FormTest method name](https://github.com/zendframework/zf2/issues/4895)
- [4897: Support file stream](https://github.com/zendframework/zf2/issues/4897)
- [4905: Update Statement.php](https://github.com/zendframework/zf2/issues/4905)
- [4909: renamed test class according to psr-0](https://github.com/zendframework/zf2/issues/4909)
- [4915: Dependency suggest for MVC plugins](https://github.com/zendframework/zf2/issues/4915)
- [4919: Notices being triggered when hydrating classes with no properties with the reflection hydrator](https://github.com/zendframework/zf2/issues/4919)
- [4920: Redundant conditional](https://github.com/zendframework/zf2/issues/4920)
- [4922: remove unused $typeFormats property at Zend/Code/Generator/DocBlock/Tag.php](https://github.com/zendframework/zf2/issues/4922)
- [4925: HttpClient: adapter always reachable through getter if specified on contructor](https://github.com/zendframework/zf2/issues/4925)
- [4929: Add Zend\Uri as a suggest because it is required by the Uri &amp; Sitemap\Loc validator](https://github.com/zendframework/zf2/issues/4929)
- [4934: Mime\Message: createFromString: decode transfer encoding](https://github.com/zendframework/zf2/issues/4934)
- [4957: Undefined variable: class in Zend/ModuleManager/Listener/ServiceListener.php](https://github.com/zendframework/zf2/issues/4957)
- [4966: Fix issue #4952](https://github.com/zendframework/zf2/issues/4966)
- [4976: Applied trim and strtolower to Gravatar email per Gravatar docs: https://en.gravatar.com/site/implement/hash/](https://github.com/zendframework/zf2/issues/4976)
- [4978: added missing docblock for &quot;@link&quot;, &quot;@copyright&quot;, and &quot;@license&quot; and fix wrong namespace according PSR-0](https://github.com/zendframework/zf2/issues/4978)
- [4981: Revise docblocks in Zend\Session\ContainerAbstractServiceFactory](https://github.com/zendframework/zf2/issues/4981)
- [4988: &#91;Zend-Code&#92; Fix Code Generation for non namespace classes](https://github.com/zendframework/zf2/issues/4988)
- [4990: &#91;Zend-Code&#92; Make sure that a use is only added once in ClassGenerator](https://github.com/zendframework/zf2/issues/4990)
- [4996: BaseInputFilter-&gt;add deasn't work (Form Validation breaks since 2.2)](https://github.com/zendframework/zf2/issues/4996)

## 2.2.2 (2013-07-24):

- [4105: Method &quot;headLink&quot; does not exist](https://github.com/zendframework/zf2/issues/4105)
- [4555: Zend\Http\Response::getBody() tries to decode gzip that has already been decoded by cURL](https://github.com/zendframework/zf2/issues/4555)
- [4564: &#91;Navigation&#92; Allow non-string permissions](https://github.com/zendframework/zf2/issues/4564)
- [4567: &#91;InputFilter&#92;&#91;Hotfix&#92; Missing check for allowEmpty()](https://github.com/zendframework/zf2/issues/4567)
- [4612: Templatemap generator: keys of templatemap not correct?](https://github.com/zendframework/zf2/issues/4612)
- [4631: remove redundance @copyright and @license docblock  because of already written](https://github.com/zendframework/zf2/issues/4631)
- [4640: Split multiple implements into multiple lines](https://github.com/zendframework/zf2/issues/4640)
- [4643: Add use statements](https://github.com/zendframework/zf2/issues/4643)
- [4644: Make ValidatorPluginManager aware of PhoneNumber validator](https://github.com/zendframework/zf2/issues/4644)
- [4646: Docblock subject misspelling](https://github.com/zendframework/zf2/issues/4646)
- [4649: &#91;code&#92; Implement logic for include a file in FileReflection if this exists and is not already included](https://github.com/zendframework/zf2/issues/4649)
- [4650: Some doc block fixes](https://github.com/zendframework/zf2/issues/4650)
- [4652: router defaults not being set properly in console](https://github.com/zendframework/zf2/issues/4652)
- [4654: Make AbstractRestController rest methods non-abstract #4209](https://github.com/zendframework/zf2/issues/4654)
- [4665: Make ValidatorPluginManager aware of DateTime validator](https://github.com/zendframework/zf2/issues/4665)
- [4676: Fix file post redirect get redirection with ModuleRouteListener](https://github.com/zendframework/zf2/issues/4676)
- [4688: Add @todo docblock](https://github.com/zendframework/zf2/issues/4688)
- [4690: Zend\Mail\Protocol\Smtp does not reset protected $auth after disconnect](https://github.com/zendframework/zf2/issues/4690)
- [4692: added zendframework/zend-resources to the global composer.json](https://github.com/zendframework/zf2/issues/4692)
- [4696: &#91;WIP&#92; Enforcing composer version in travis builds](https://github.com/zendframework/zf2/issues/4696)
- [4699: Add use statements](https://github.com/zendframework/zf2/issues/4699)
- [4700: PHP 5.5 can't fail anymore](https://github.com/zendframework/zf2/issues/4700)
- [4702: DocBlock and CS fixes](https://github.com/zendframework/zf2/issues/4702)
- [4705: add zendframework/zend-json to Zend\ProgressBar\composer.json as suggest](https://github.com/zendframework/zf2/issues/4705)
- [4722: remove bloated LICENSE description at header for consistency ](https://github.com/zendframework/zf2/issues/4722)
- [4725: Add sorting to classmap generator](https://github.com/zendframework/zf2/issues/4725)
- [4729: Provide ability to configure ReCaptcha Service public and private keys via options](https://github.com/zendframework/zf2/issues/4729)
- [4734: Fix for #4727](https://github.com/zendframework/zf2/issues/4734)
- [4738: remove unnecessary space after function name](https://github.com/zendframework/zf2/issues/4738)
- [4741: Hotfix/4740](https://github.com/zendframework/zf2/issues/4741)
- [4743: Update PluginManager.php](https://github.com/zendframework/zf2/issues/4743)
- [4744: Remove ZendTest from Composer](https://github.com/zendframework/zf2/issues/4744)
- [4746: Bumping supported ProxyManager version](https://github.com/zendframework/zf2/issues/4746)
- [4754: Update SimpleStreamResponseSenderTest.php](https://github.com/zendframework/zf2/issues/4754)
- [4759: Added pluginmap&#95;generator + templatemap&#95;generator to BIN directory](https://github.com/zendframework/zf2/issues/4759)
- [4761: Remove exceptions from #4734](https://github.com/zendframework/zf2/issues/4761)
- [4762: &#91;Hotfix&#92; Fix conflicting use statement](https://github.com/zendframework/zf2/issues/4762)
- [4771: Form\View\Helper\FormRow label position gets overwritten by &#95;&#95;invoke()](https://github.com/zendframework/zf2/issues/4771)
- [4776: Zend\Http\Header\SetCookie Allow unsetting cookie attibutes by resetting to null](https://github.com/zendframework/zf2/issues/4776)
- [4777: Change file mode from 644 to 755 templatemap&#95;generator.php](https://github.com/zendframework/zf2/issues/4777)
- [4778: Zend\Validator depends on Zend\Filter](https://github.com/zendframework/zf2/issues/4778)
- [4783: Make methods setUp and tearDown protected](https://github.com/zendframework/zf2/issues/4783)
- [4787: Update Zend&#95;Validate.php](https://github.com/zendframework/zf2/issues/4787)
- [4788: set factory in CollectionInputFilter](https://github.com/zendframework/zf2/issues/4788)
- [4790: Add check to DI to see if we have a class to instantiate](https://github.com/zendframework/zf2/issues/4790)
- [4793: &#91;validator&#92; Validate quoted local part of email addresses](https://github.com/zendframework/zf2/issues/4793)
- [4798: Default mode variables HeadScript and InlineScript](https://github.com/zendframework/zf2/issues/4798)
- [4804: Possible Typo in  Zend / Cache / Storage / Adapter / RedisResourceManager](https://github.com/zendframework/zf2/issues/4804)
- [4805: Zend\I18n\View\Helper\CurrencyFormat | showDecimals parameter overrides the default value](https://github.com/zendframework/zf2/issues/4805)
- [4808: Unimplemented REST methods should set a 405 status](https://github.com/zendframework/zf2/issues/4808)
- [4818: Issue4817](https://github.com/zendframework/zf2/issues/4818)
- [4830: Correct spelling of function getMajorVersion](https://github.com/zendframework/zf2/issues/4830)
- [4835: Update templatemap&#95;generator.php](https://github.com/zendframework/zf2/issues/4835)
- [4838: Little fix in InputFilter/Factory](https://github.com/zendframework/zf2/issues/4838)
- [4847: Fix Version::getLatest docblock](https://github.com/zendframework/zf2/issues/4847)
- [4850: Allow form elements created via Annotations to have same default InputFilter as created via array specification](https://github.com/zendframework/zf2/issues/4850)
- [4854: Allow FormElementErrors view helper to translate messages](https://github.com/zendframework/zf2/issues/4854)
- [4856: Zend\Validator\File\MimeType warning with no params](https://github.com/zendframework/zf2/issues/4856)
- [4857: `fault` property must be an instance of \Zend\XmlRpc\Fault](https://github.com/zendframework/zf2/issues/4857)
- [4858: Removed @category, @package and @subpackage docblock tags in ZendTest\Config](https://github.com/zendframework/zf2/issues/4858)
- [4859: doc block changes in head view helpers](https://github.com/zendframework/zf2/issues/4859)
- [4866: update tests/ZendTest/Mvc/ApplicationTest.php](https://github.com/zendframework/zf2/issues/4866)
- [4870: Use MvcTranslator to inject view helpers](https://github.com/zendframework/zf2/issues/4870)

## 2.2.1 (2013-06-12):

- [3647: Problems in the way Zend\Paginator\Adapter\DbSelect count()s](https://github.com/zendframework/zf2/issues/3647)
- [3853: Log formatters shouldn't override referenced values](https://github.com/zendframework/zf2/issues/3853)
- [4421: fix docblocks : `Zend_` should be `Zend\\` and some typos](https://github.com/zendframework/zf2/issues/4421)
- [4452: Zend\Authentication\Result custom result codes not possible](https://github.com/zendframework/zf2/issues/4452)
- [4456: can't override Zend\Log\Logger::registerExceptionHandler](https://github.com/zendframework/zf2/issues/4456)
- [4457: Zend\Code\Scanner\ClassScanner don't parse constants with docblock](https://github.com/zendframework/zf2/issues/4457)
- [4458: Fix for PHP 5.5 unit tests (and XDebug &gt;= 2.2.0)](https://github.com/zendframework/zf2/issues/4458)
- [4465: Add ConstantScanner to Zend\Code\Scanner](https://github.com/zendframework/zf2/issues/4465)
- [4470: sync ZF1 svn r24807 - ZF-12128: File Upload validator should display file na...](https://github.com/zendframework/zf2/issues/4470)
- [4474: Suggest some dependencies in Zend\Mvc](https://github.com/zendframework/zf2/issues/4474)
- [4480: fixed Cache\StorageFactory::factory()](https://github.com/zendframework/zf2/issues/4480)
- [4494: Add build.xml to .gitattributes/export-ignore](https://github.com/zendframework/zf2/issues/4494)
- [4496: Class methods hydrator skips getters with optional parameters](https://github.com/zendframework/zf2/issues/4496)
- [4497: Fix name of LoggerAbstractServiceFactory test](https://github.com/zendframework/zf2/issues/4497)
- [4498: Update the method level comment to reflect change in signature](https://github.com/zendframework/zf2/issues/4498)
- [4499: Add service definition for DateTimeFormatter (related to #3632)](https://github.com/zendframework/zf2/issues/4499)
- [4503: Zend\Session\Storage\AbstractSessionArrayStorage::fromArray() can receive a string causing a fatal error on shutdown](https://github.com/zendframework/zf2/issues/4503)
- [4509: `DateTimeFormatter` Format DateTime values correctly](https://github.com/zendframework/zf2/issues/4509)
- [4516: CollectionInputFilter should respect the keys of collectionData](https://github.com/zendframework/zf2/issues/4516)
- [4518: Update PhpDoc comment](https://github.com/zendframework/zf2/issues/4518)
- [4522: Remove unknown invokables from FilterPluginManager](https://github.com/zendframework/zf2/issues/4522)
- [4524: Add zend-json as a required dependency](https://github.com/zendframework/zf2/issues/4524)
- [4526: Fill SharedEventManager events with identifiers](https://github.com/zendframework/zf2/issues/4526)
- [4528: Fix priority not handled in AggregateHydrator](https://github.com/zendframework/zf2/issues/4528)
- [4529: Allow Zend\Form\Element\Checkbox to return real value instead of always a boolean](https://github.com/zendframework/zf2/issues/4529)
- [4530: Fix for unmatched routes in navigation](https://github.com/zendframework/zf2/issues/4530)
- [4535: Update RoleInterface.php](https://github.com/zendframework/zf2/issues/4535)
- [4538: Zend\Crypt\Password\Bcrypt does not report inability to generate hash](https://github.com/zendframework/zf2/issues/4538)
- [4539: Update StrategyInterface.php](https://github.com/zendframework/zf2/issues/4539)
- [4542: Adds ability to specify a template for exceptions retrieved from Exception::getPrevious](https://github.com/zendframework/zf2/issues/4542)
- [4543: soapVersion key is not reachable](https://github.com/zendframework/zf2/issues/4543)
- [4546: View: correctly validate input in PartialLoop](https://github.com/zendframework/zf2/issues/4546)
- [4552: Wincache unexpected return value on internalGetItem](https://github.com/zendframework/zf2/issues/4552)
- [4553: Remove private variables from AbstractControllerTestCase.](https://github.com/zendframework/zf2/issues/4553)
- [4561: Fix the controller plugin PostRedirectGet wrong redirection (in MVC)](https://github.com/zendframework/zf2/issues/4561)
- [4562: Validator Messages Tests](https://github.com/zendframework/zf2/issues/4562)
- [4566: Fix generating array with unsorted keys](https://github.com/zendframework/zf2/issues/4566)
- [4568: Cast Parameters](https://github.com/zendframework/zf2/issues/4568)
- [4571: INI reader breaks when mbstring function overloading is in place](https://github.com/zendframework/zf2/issues/4571)
- [4572: Zend\Form Should throw exception if try to get() an element that does not exist](https://github.com/zendframework/zf2/issues/4572)
- [4576: Redis Cache Adapter Config - setLibOptions is broken](https://github.com/zendframework/zf2/issues/4576)
- [4577: Fix issue with Redis Cache adapter whereby setOption was being called before connecting to Redis server](https://github.com/zendframework/zf2/issues/4577)
- [4581: Hostname route ignore `HTTP_HOST` and give `SERVER_NAME` precedence](https://github.com/zendframework/zf2/issues/4581)
- [4582: Fix Nested form element wrapping (relative: #4383)](https://github.com/zendframework/zf2/issues/4582)
- [4588: set 0 as header value (issue #4583)](https://github.com/zendframework/zf2/issues/4588)
- [4590: Zend paginator dbselect count](https://github.com/zendframework/zf2/issues/4590)
- [4595: Missing invokable fo Redis Cache Storage, problem with setting password](https://github.com/zendframework/zf2/issues/4595)
- [4596: Missing french translations, and wrong class name](https://github.com/zendframework/zf2/issues/4596)
- [4597: Zend\Validate\Hostname doesn't handle IDN for .UA](https://github.com/zendframework/zf2/issues/4597)
- [4599: `InputFilter` Input merge should copy over the `continue_if_empty` flag](https://github.com/zendframework/zf2/issues/4599)
- [4602: Remove needless check](https://github.com/zendframework/zf2/issues/4602)
- [4603: Redis Storage won't behave correctly after libOptions were set](https://github.com/zendframework/zf2/issues/4603)
- [4605: Possibility to use camelCase for all soap client options](https://github.com/zendframework/zf2/issues/4605)
- [4608: Allow the `gc_probability` option to be set to zero.](https://github.com/zendframework/zf2/issues/4608)
- [4609: Logger: Error/Exception Handler: fixed 3853 &amp; 4456](https://github.com/zendframework/zf2/issues/4609)
- [4615: Fix #4579 `day_attributes` could not be passed in construct](https://github.com/zendframework/zf2/issues/4615)
- [4616: fixed 4614: infinite loop in Zend\Log\Formatter::normalize](https://github.com/zendframework/zf2/issues/4616)
- [4617: Zend\Code: Docblock generates empty line under @tags if docblock was read from existing code](https://github.com/zendframework/zf2/issues/4617)
- [4618: Missed method findRealpathInIncludePath() in Zend\Code\Reflection\FileReflection](https://github.com/zendframework/zf2/issues/4618)
- [4621: Update 'Missing captcha fields' translation](https://github.com/zendframework/zf2/issues/4621)
- [4622: Ensure router factory is used by SM factory](https://github.com/zendframework/zf2/issues/4622)
- [4624: Notification thrown in Zend\Mvc\Service\ViewHelperManagerFactory](https://github.com/zendframework/zf2/issues/4624)
- [4628: Fix misstake detect is active Page\Mvc in IndexController](https://github.com/zendframework/zf2/issues/4628)
- [4629: Zend\Cache\Pattern\CallbackCache doesn't work with NULL](https://github.com/zendframework/zf2/issues/4629)
- [4630: Allow selecting the TranslatorAwareTreeRouteStack via configuration](https://github.com/zendframework/zf2/issues/4630)
- [4632: fixed #4552: Wincache::getItem() have to return NULL in cases of missing items](https://github.com/zendframework/zf2/issues/4632)
- [4633: removed checks of not existing class Zend\Math\BigInteger](https://github.com/zendframework/zf2/issues/4633)
- [4634: Navigation\Page\Mvc Can't return false whithout call parent::isActive](https://github.com/zendframework/zf2/issues/4634)
- [4636: Punycode decoding fails if encoded string has not hyphen](https://github.com/zendframework/zf2/issues/4636)
- [4641: Zend\Paginator\Adapter\DbSelect alternative solution to count, with subselect](https://github.com/zendframework/zf2/issues/4641)

## 2.2.0 (2013-05-15):

- [2865: (Enhancement) Add an easier way to use i18n view helpers.](https://github.com/zendframework/zf2/issues/2865)
- [2903: add AdapterManager in to Zend\Db\Adapter namespace](https://github.com/zendframework/zf2/issues/2903)
- [2984: Add full stop at end of validator messages (fixes #2966)](https://github.com/zendframework/zf2/issues/2984)
- [3490: Added support for callable credential validator](https://github.com/zendframework/zf2/issues/3490)
- [3580: Feature/context aware hydrator strategies](https://github.com/zendframework/zf2/issues/3580)
- [3632: New DateTimeFormatter Filter (#3617)](https://github.com/zendframework/zf2/issues/3632)
- [3646: Zend\I18n\View\Helper\NumberFormat param to set the number of decimals](https://github.com/zendframework/zf2/issues/3646)
- [3693: Add RBAC support for navigation helper.](https://github.com/zendframework/zf2/issues/3693)
- [3709: Redis cache storage](https://github.com/zendframework/zf2/issues/3709)
- [3710: Allow to remove delimiters for DateSelect and fix bugs with some locales](https://github.com/zendframework/zf2/issues/3710)
- [3747: Add getFilename() to Zend\Cache\Pattern\CaptureCache](https://github.com/zendframework/zf2/issues/3747)
- [3754: Update library/Zend/Stdlib/Hydrator/ClassMethods.php](https://github.com/zendframework/zf2/issues/3754)
- [3792: Sets specific attributes (as class,title...) to "Zend\Form\Select" options](https://github.com/zendframework/zf2/issues/3792)
- [3812: Zend\Form\FormInterface causes Di to attempt to instantiate Interface](https://github.com/zendframework/zf2/issues/3812)
- [3814: Improve module manager to accept instance](https://github.com/zendframework/zf2/issues/3814)
- [3818: Invalid instantiator of type “NULL” for “Zend\Form\FormInterface”](https://github.com/zendframework/zf2/issues/3818)
- [3844: Added new option to fix a little issue originated from last PR](https://github.com/zendframework/zf2/issues/3844)
- [3876: Implementing and re-utilizing an abstract aggregate listener](https://github.com/zendframework/zf2/issues/3876)
- [3877: HeadTitle renderTitle returns rendered title without title tags](https://github.com/zendframework/zf2/issues/3877)
- [3878: Created an adapter Zend Paginator instance using TableGateway](https://github.com/zendframework/zf2/issues/3878)
- [3879: Feature CollectionInputFilter](https://github.com/zendframework/zf2/issues/3879)
- [3896: Added ability to ignore namespaces to classmap generator](https://github.com/zendframework/zf2/issues/3896)
- [3919: WSDL Generation rewrite (with new tests also) as a base for future changes.](https://github.com/zendframework/zf2/issues/3919)
- [3922: Added the ability to disable the getValidator input specification on Select Elements](https://github.com/zendframework/zf2/issues/3922)
- [3930: Added abstract service factory for logger component to provide several loggers for application.](https://github.com/zendframework/zf2/issues/3930)
- [3931: Added ability to configure MvcEvent listeners.](https://github.com/zendframework/zf2/issues/3931)
- [3933: Added database adapter abstract service factory.](https://github.com/zendframework/zf2/issues/3933)
- [3942: Feature/zend test load module](https://github.com/zendframework/zf2/issues/3942)
- [3944: Enable ExceptionStrategy to return json](https://github.com/zendframework/zf2/issues/3944)
- [3949: Invalid argument supplied for foreach()](https://github.com/zendframework/zf2/issues/3949)
- [3951: Deprecate Zend\Stdlib\DateTime and use \DateTime constructor internally instead](https://github.com/zendframework/zf2/issues/3951)
- [3958: Oci8 Driver generating "Fetch out of sequence warning"](https://github.com/zendframework/zf2/issues/3958)
- [3965: Add removeMethod method in ClassGenerator](https://github.com/zendframework/zf2/issues/3965)
- [3979: Fixes #3978](https://github.com/zendframework/zf2/issues/3979)
- [3990: Zend\Filter\File\RenameUpload - Added possibility to maintain original file extension](https://github.com/zendframework/zf2/issues/3990)
- [3999: Chain route](https://github.com/zendframework/zf2/issues/3999)
- [4011: extend HeadMeta view helper to allow microdata #3751](https://github.com/zendframework/zf2/issues/4011)
- [4016: Hydrator aware interface](https://github.com/zendframework/zf2/issues/4016)
- [4032: Class was supporting limit + offset or limit, but only offset does not support](https://github.com/zendframework/zf2/issues/4032)
- [4048: Moved ext-intl to suggest instead of require to avoid silent fallback.](https://github.com/zendframework/zf2/issues/4048)
- [4050: Translable routing segments](https://github.com/zendframework/zf2/issues/4050)
- [4073: Fixed issue #3064](https://github.com/zendframework/zf2/issues/4073)
- [4098: fix php docblock : boolean should be bool](https://github.com/zendframework/zf2/issues/4098)
- [4099: fix (bool) casting : add space and use (bool) instead of (boolean) to cast](https://github.com/zendframework/zf2/issues/4099)
- [4104: Allow to change option creations for plugin manager](https://github.com/zendframework/zf2/issues/4104)
- [4120: (Validator) Only return unique messages](https://github.com/zendframework/zf2/issues/4120)
- [4127: Added I18n PhoneNumber validator based off of country](https://github.com/zendframework/zf2/issues/4127)
- [4137: View helpers cleanup](https://github.com/zendframework/zf2/issues/4137)
- [4139: Service manager performance optimized](https://github.com/zendframework/zf2/issues/4139)
- [4145: Delegate factories](https://github.com/zendframework/zf2/issues/4145)
- [4146: Lazy services](https://github.com/zendframework/zf2/issues/4146)
- [4155: Move Identity closure to separate factory](https://github.com/zendframework/zf2/issues/4155)
- [4165: Validate empty with context](https://github.com/zendframework/zf2/issues/4165)
- [4169: Fixed error in adapter paginator DbTableGateway](https://github.com/zendframework/zf2/issues/4169)
- [4170: Hydrator aware interface](https://github.com/zendframework/zf2/issues/4170)
- [4175: AbstractRestfulController uses wrong action for id=0](https://github.com/zendframework/zf2/issues/4175)
- [4178: Allow passing objects to the url helper](https://github.com/zendframework/zf2/issues/4178)
- [4181: Make identifier name configurable for AbstractRestfulController](https://github.com/zendframework/zf2/issues/4181)
- [4187: Add event manager as soft dependency to translator](https://github.com/zendframework/zf2/issues/4187)
- [4202: Zend\Log has dependency on Zend\ServiceManager](https://github.com/zendframework/zf2/issues/4202)
- [4204: Hotfix for #4202](https://github.com/zendframework/zf2/issues/4204)
- [4206: Added sequence name for PostgreSQL](https://github.com/zendframework/zf2/issues/4206)
- [4215: Bugfix for redirection handling in Zend\Http\Client](https://github.com/zendframework/zf2/issues/4215)
- [4219: Custom validators registered through ValidatorProviderInterface not found](https://github.com/zendframework/zf2/issues/4219)
- [4231: (Form) Get Elements for Collection](https://github.com/zendframework/zf2/issues/4231)
- [4238: ValueGenerator constant detection](https://github.com/zendframework/zf2/issues/4238)
- [4247: Added Brazilian IBAN format to IBAN validation](https://github.com/zendframework/zf2/issues/4247)
- [4250: (#4249) Override 'ServiceManager::has' to do not use peering service managers](https://github.com/zendframework/zf2/issues/4250)
- [4251: Create factories for selected view collaborators](https://github.com/zendframework/zf2/issues/4251)
- [4252: Auto-upgrading and then displaying composer version](https://github.com/zendframework/zf2/issues/4252)
- [4253: Create AbstractFactory for Cache](https://github.com/zendframework/zf2/issues/4253)
- [4254: Use prefix in Logger abstract factory](https://github.com/zendframework/zf2/issues/4254)
- [4259: Hotfix: Changed array\_walk to foreach in Zend\Stdlib\Hydrator\ArraySerializable](https://github.com/zendframework/zf2/issues/4259)
- [4260: Validator\Explode can take option validator as array](https://github.com/zendframework/zf2/issues/4260)
- [4262: Fixed console routes when using same name for group and parameter](https://github.com/zendframework/zf2/issues/4262)
- [4263: Remove superfluous indentation from one line of code](https://github.com/zendframework/zf2/issues/4263)
- [4268: Session service factories](https://github.com/zendframework/zf2/issues/4268)
- [4269: Hotfix: cs fixer check](https://github.com/zendframework/zf2/issues/4269)
- [4276: allow default http responses to be sent in mvc stack](https://github.com/zendframework/zf2/issues/4276)
- [4279: Remove needless is\_object check](https://github.com/zendframework/zf2/issues/4279)
- [4282: fix getHref strategy in PageMvc](https://github.com/zendframework/zf2/issues/4282)
- [4284: Main framework composer.json is incorrectly configured](https://github.com/zendframework/zf2/issues/4284)
- [4285: Fix for a problem with Service Manager and Abstract Factories](https://github.com/zendframework/zf2/issues/4285)
- [4288: Reset URI parts before parse](https://github.com/zendframework/zf2/issues/4288)
- [4289: Minor CS fix](https://github.com/zendframework/zf2/issues/4289)
- [4293: Better fix for #4284](https://github.com/zendframework/zf2/issues/4293)
- [4294: BaseInputFilter not populating InputFilters of Element\Collection](https://github.com/zendframework/zf2/issues/4294)
- [4295: Console route defaults should be overridden by entered values](https://github.com/zendframework/zf2/issues/4295)
- [4296: illegal usage of array\_walk in ObjectProperty, ClassMapAutoloader](https://github.com/zendframework/zf2/issues/4296)
- [4298: View\Helper\Navigation\Menu: add flag to set page class to &lt;li&gt;](https://github.com/zendframework/zf2/issues/4298)
- [4299: Suggestion: Don't render empty module console information](https://github.com/zendframework/zf2/issues/4299)
- [4300: Maestro detection improvements in Zend\Validator\CreditCard](https://github.com/zendframework/zf2/issues/4300)
- [4301: remove extra semicolon](https://github.com/zendframework/zf2/issues/4301)
- [4303: Method annotations of Zend\Validator\Hostname constructor](https://github.com/zendframework/zf2/issues/4303)
- [4311: DDL support for Zend\Db](https://github.com/zendframework/zf2/issues/4311)
- [4312: POP3 protocol "return;" is needed after APOP request](https://github.com/zendframework/zf2/issues/4312)
- [4313: update docblock for ZendTest : /Db/, /Code/ , /Di/, /Log/, Mvc/](https://github.com/zendframework/zf2/issues/4313)
- [4317: Fix #4315 - Console routes with dashes are not understood.](https://github.com/zendframework/zf2/issues/4317)
- [4319: Add various plugin manager](https://github.com/zendframework/zf2/issues/4319)
- [4321: Hotfix/cs fixer installation](https://github.com/zendframework/zf2/issues/4321)
- [4326: Add zh\_TW translations ](https://github.com/zendframework/zf2/issues/4326)
- [4328: Fix 4294](https://github.com/zendframework/zf2/issues/4328)
- [4330: Remove SM-Aware requirement from Forward plugin](https://github.com/zendframework/zf2/issues/4330)
- [4331: Changed default version service to Zend.](https://github.com/zendframework/zf2/issues/4331)
- [4336: Use is\_int() instead of is\_integer()](https://github.com/zendframework/zf2/issues/4336)
- [4337: Fix alignment of values, add trailing comma](https://github.com/zendframework/zf2/issues/4337)
- [4339: Remove @return annotation from constructor doc-block](https://github.com/zendframework/zf2/issues/4339)
- [4341: Docblocks do not match](https://github.com/zendframework/zf2/issues/4341)
- [4344: Add missing file level doc-block](https://github.com/zendframework/zf2/issues/4344)
- [4347: Add empty line after namespace declaration](https://github.com/zendframework/zf2/issues/4347)
- [4349: Alphabetically order use statements (related to #4338)](https://github.com/zendframework/zf2/issues/4349)
- [4350: Remove comma before value in array initialization](https://github.com/zendframework/zf2/issues/4350)
- [4351: fix the constructor's type-autodetection accepts wrong parameters](https://github.com/zendframework/zf2/issues/4351)
- [4352: Fix doc blocks consistency and coding standards PSR2](https://github.com/zendframework/zf2/issues/4352)
- [4353: Glob::glob() should throw an exception on error](https://github.com/zendframework/zf2/issues/4353)
- [4354: Corrected wrong year](https://github.com/zendframework/zf2/issues/4354)
- [4355: fix docblock : @throw should be @throws](https://github.com/zendframework/zf2/issues/4355)
- [4356: FormSelect translate optgroup label fix](https://github.com/zendframework/zf2/issues/4356)
- [4358: Form abstract factory](https://github.com/zendframework/zf2/issues/4358)
- [4361: Ldap Ldif Decoder bug fix](https://github.com/zendframework/zf2/issues/4361)
- [4364: AbstractFactory consistency](https://github.com/zendframework/zf2/issues/4364)
- [4365: Use InputFilterPluginManager in InputFilter\Factory](https://github.com/zendframework/zf2/issues/4365)
- [4366: Fix for issue #3945, and fix for PUT with request content](https://github.com/zendframework/zf2/issues/4366)
- [4367: Remove reference to root namespace (fixes #4363)](https://github.com/zendframework/zf2/issues/4367)
- [4372: Ability to load custom form classes from FormElementManager in Mvc.](https://github.com/zendframework/zf2/issues/4372)
- [4373: PHP Warning:  call\_user\_func() expects…when Weakref enabled](https://github.com/zendframework/zf2/issues/4373)
- [4374: CollectionInputFilter returns always valid for empty collections](https://github.com/zendframework/zf2/issues/4374)
- [4376: Fix get with body in ClientStatic](https://github.com/zendframework/zf2/issues/4376)
- [4378: Add patchList method to AbstractRestfulController](https://github.com/zendframework/zf2/issues/4378)
- [4379: Fix for #4175](https://github.com/zendframework/zf2/issues/4379)
- [4380: Decouple I18n\View\Helper\AbstractTranslatorHelper from ext\intl](https://github.com/zendframework/zf2/issues/4380)
- [4382: Fix conflict InputFilter::type with Input::name in InputFilter factory](https://github.com/zendframework/zf2/issues/4382)
- [4383: ensure the wrapElements option in Zend\Form\Form::prepareElement](https://github.com/zendframework/zf2/issues/4383)
- [4389: Remove cache and log abstract factories from MVC](https://github.com/zendframework/zf2/issues/4389)
- [4391: Segregated interfaces for Translator dependency of Validator component](https://github.com/zendframework/zf2/issues/4391)
- [4392: Remove Version dependency from Feed component](https://github.com/zendframework/zf2/issues/4392)
- [4393: 2.2RC1 BC Break: DateTimeFormatter sets blank data to today's date](https://github.com/zendframework/zf2/issues/4393)
- [4394: Ensure that DateTimeFormatter doesn't format an empty string](https://github.com/zendframework/zf2/issues/4394)
- [4396: Make ServiceManager dependency optional in Feed component](https://github.com/zendframework/zf2/issues/4396)
- [4398: Allow DateTimeFormatter to format zero.](https://github.com/zendframework/zf2/issues/4398)
- [4405: 2.2.0RC1 Form\View\Helper\FormRow "partial view" messed up](https://github.com/zendframework/zf2/issues/4405)
- [4408: Optimize MutableCreationOptionsInterface capability](https://github.com/zendframework/zf2/issues/4408)
- [4410: Fix conflict between translator service in ZF2 and skeleton app](https://github.com/zendframework/zf2/issues/4410)
- [4411: Fix BC break in HTTP client resetParameters signature](https://github.com/zendframework/zf2/issues/4411)
- [4412: FormRow: enable partial rendering](https://github.com/zendframework/zf2/issues/4412)
- [4415: Remove URI dependency and make HTTP dependency optional in Feed](https://github.com/zendframework/zf2/issues/4415)
- [4417: add docblock to I18n\Validator\PhoneNumber\{Code\}.php](https://github.com/zendframework/zf2/issues/4417)
- [4418: remove @package docblock from demos files](https://github.com/zendframework/zf2/issues/4418)
- [4420: sync svn r23693 - (ZF-11002) ehancement implemented as proposed](https://github.com/zendframework/zf2/issues/4420)
- [4423: Minor param overflow](https://github.com/zendframework/zf2/issues/4423)
- [4424: Edit config composer.json](https://github.com/zendframework/zf2/issues/4424)
- [4425: Fix FormElementManagerFactory breaks csrf validation (in Mvc)](https://github.com/zendframework/zf2/issues/4425)
- [4431: sync svn r24702 - support application/x-zip in Validator\File\IsCompressed](https://github.com/zendframework/zf2/issues/4431)
- [4432: code concistency : update Zend\Mvc\Application::bootstrap](https://github.com/zendframework/zf2/issues/4432)
- [4435: Di compatibility (#4434)](https://github.com/zendframework/zf2/issues/4435)
- [4437: I18n currencyFormat helper: add the currencyPattern attribute and extend the unittest](https://github.com/zendframework/zf2/issues/4437)
- [4441: Fixed unnecessary error rendering in form row helper.](https://github.com/zendframework/zf2/issues/4441)
- [4444: Issues found by hphp static analysis](https://github.com/zendframework/zf2/issues/4444)
- [4447: typo fixes](https://github.com/zendframework/zf2/issues/4447)
- [4448: Aggregate hydrator ](https://github.com/zendframework/zf2/issues/4448)
- [4450: Fix iterating over empty result set with buffering enabled](https://github.com/zendframework/zf2/issues/4450)
- [4451: Form InputFilterSpecification: incorrect propagation](https://github.com/zendframework/zf2/issues/4451)
- [4454: Fix for expiration value](https://github.com/zendframework/zf2/issues/4454)

### Potential Breakage

`Zend\Validator` was altered to remove the dependency on `Zend\I18n` by creating
[Segregated Interfaces](http://en.wikipedia.org/wiki/Interface_segregation_principle).
The practical upshot is that `Zend\Validator\AbstractValidator` no longer
implements `Zend\I18n\Translator\TranslatorAwareInterface`, but rather
`Zend\Validator\Translator\TranslatorAwareInterface`, which now typehints on
`Zend\Validator\Translator\TranslatorInterface` instead of
`Zend\I18n\Translator\Translator`. This means you cannot pass a
`Zend\I18n\Translator\Translator` instance directly to a validator any longer.

However, we have included a new class, `Zend\Mvc\I18n\Translator`, that extends
the i18n Translator class and implements the Validator TranslatorInterface. This
class may be used as a drop-in replacement. In fact, by default,
`Zend\Validator\ValidatorPluginManager` is now using the `MvcTranslator`
service, which utilizes this new class, making the change seamless for most
users.

The above change will only affect you if you were manually injecting a
translator instance into your validators.

## 2.1.6 (06 Mar 2014):

### SECURITY UPDATES

- **ZF2014-01:** Potential XXE/XEE attacks using PHP functions:
  `simplexml_load_*`, `DOMDocument::loadXML`, and `xml_parse`. A new component,
  `ZendXml`, was introduced to mitigate XML eXternal Entity and XML Entity
  Expansion vectors that are present in older versions of libxml2 and/or PHP.
  `Zend\Json\Json::fromXml()` and `Zend\XmlRpc`'s `Response` and `Fault` classes
  were potentially vulnerable to these attacks. If you use either of these
  components, we recommend upgrading immediately.

## 2.1.5 (17 Apr 2013):

- 2536: `Zend\Validate` translations out of date
  (https://github.com/zendframework/zf2/issues/2536)
- 2898: `ConstructedNavigationFactory` does not inject components
  (https://github.com/zendframework/zf2/issues/2898)
- 3373: `Collection` in `Form` not binds values when form has no object and hydrator set
  (https://github.com/zendframework/zf2/issues/3373)
- 3534: ZF2 2.0.6 Authentication and postgres database
  (https://github.com/zendframework/zf2/issues/3534)
- 3626: `Zend\Form\View\Helper\FormRow`: labels are appended by default
  (https://github.com/zendframework/zf2/issues/3626)
- 3685: Problem on appending new identifier on `EventManager`
  (https://github.com/zendframework/zf2/issues/3685)
- 3695: Adapter name and sequence problems
  (https://github.com/zendframework/zf2/issues/3695)
- 3719: `Zend\Db\Metadata\Source\AbstractSource` Notice: Undefined index
  (https://github.com/zendframework/zf2/issues/3719)
- 3731: Console banners are all shown consecutively
  (https://github.com/zendframework/zf2/issues/3731)
- 3882: `EventManager` or `Stdlib\CallbackHandler` can't handle `WeakRef` enough.
  (https://github.com/zendframework/zf2/issues/3882)
- 3898: `Zend\Navigation\Service\ConstructedNavigationFactory` not inject
  dependences (router, action and etc)
  (https://github.com/zendframework/zf2/issues/3898)
- 3912: Ajustment `SequenceFeature` generic drivers
  (https://github.com/zendframework/zf2/issues/3912)
- 3934: `Acl` allow role access on all resources not honoured if added after resources
  (https://github.com/zendframework/zf2/issues/3934)
- 3983: Update `BaseInputFilter`
  (https://github.com/zendframework/zf2/issues/3983)
- 4002: Update `DocBlockScanner`
  (https://github.com/zendframework/zf2/issues/4002)
- 4013: Fix PHP Notice in `Translator` class
  (https://github.com/zendframework/zf2/issues/4013)
- 4014: update to `FlashMessenger` view helper to allow for classes on separator
  (https://github.com/zendframework/zf2/issues/4014)
- 4020: Add parent roles with traversable object
  (https://github.com/zendframework/zf2/issues/4020)
- 4026: `Zend\Validator` Test Suite Fix
  (https://github.com/zendframework/zf2/issues/4026)
- 4027: Move deprecation notice inside constructor of `Query` class
  (https://github.com/zendframework/zf2/issues/4027)
- 4035: [Router] non existent child route during assembly doesn't throw exception
  (https://github.com/zendframework/zf2/issues/4035)
- 4037: Remove unnecessary `autoload.php` from composer config.
  (https://github.com/zendframework/zf2/issues/4037)
- 4047: Update `InArray.php`
  (https://github.com/zendframework/zf2/issues/4047)
- 4049: removed unused cache test assets from test suite
  (https://github.com/zendframework/zf2/issues/4049)
- 4051: `writeLine()` with console is (literally) breaking when the string is "too long"?
  (https://github.com/zendframework/zf2/issues/4051)
- 4053: Implement better text domain merging support
  (https://github.com/zendframework/zf2/issues/4053)
- 4054: 2.1.4: `Zend/Stdlib/composer.json` requires  "Zend/Stdlib/compatibility/autoload.php"
  (https://github.com/zendframework/zf2/issues/4054)
- 4055: Fix #4051 `console::writeLine()` 
  (https://github.com/zendframework/zf2/issues/4055)
- 4061: Normalize console usage
  (https://github.com/zendframework/zf2/issues/4061)
- 4063: Resolved Issue #2898
  (https://github.com/zendframework/zf2/issues/4063)
- 4064: Fixed issue with invalid `@cover` annotations, pointed to not existed class
  (https://github.com/zendframework/zf2/issues/4064)
- 4066: `HttpControllerTestCase` gives wrong messages for `assertRedirect`/`assertNotRedirect`
  (https://github.com/zendframework/zf2/issues/4066)
- 4070: Hotfix for issue #4069
  (https://github.com/zendframework/zf2/issues/4070)
- 4074: fix typos
  (https://github.com/zendframework/zf2/issues/4074)
- 4075: `Form\Collection`: allow create new objects
  (https://github.com/zendframework/zf2/issues/4075)
- 4077: Fix `Collection` form element replacing bound objects with dummies upon form validation
  (https://github.com/zendframework/zf2/issues/4077)
- 4079: Some fixes for phpDoc in `Zend\Mvc`
  (https://github.com/zendframework/zf2/issues/4079)
- 4084: Introduce query parameter for `Navigation\Page\Mvc`
  (https://github.com/zendframework/zf2/issues/4084)
- 4085: Fix loading of a text domain from different sources, fixes issue #4045
  (https://github.com/zendframework/zf2/issues/4085)
- 4089: Zend\Test - set the request's `requestUri` to the dispatched url
  (https://github.com/zendframework/zf2/issues/4089)
- 4095: `Zend\Navigation\Page\Mvc::getHref` does not use `RouteMatch` parameters
  (https://github.com/zendframework/zf2/issues/4095)
- 4102: simplify constant usage. `FILEINFO_MIME_TYPE` is available since PHP 5.3.0
  (https://github.com/zendframework/zf2/issues/4102)
- 4103: `FormDateTimeSelect` - minutes delimiter always shown
  (https://github.com/zendframework/zf2/issues/4103)
- 4111: Updated translations
  (https://github.com/zendframework/zf2/issues/4111)
- 4117: [InputFilter] Allow specification of error message via `Factory`
  (https://github.com/zendframework/zf2/issues/4117)
- 4118: Fix name of variable used for capturing output when executing shell command
  (https://github.com/zendframework/zf2/issues/4118)
- 4119: Fix weird verbalization
  (https://github.com/zendframework/zf2/issues/4119)
- 4123: Fix#3373
  (https://github.com/zendframework/zf2/issues/4123)
- 4129: Update to `ServiceManager` to provide more precise error messages
  (https://github.com/zendframework/zf2/issues/4129)
- 4133: Fix#4103
  (https://github.com/zendframework/zf2/issues/4133)
- 4134: Zend\Mvc\Router\Console\Simple not compatible with older versions of pcre (and therefore CentOS)
  (https://github.com/zendframework/zf2/issues/4134)
- 4135: Update Czech validator messages
  (https://github.com/zendframework/zf2/issues/4135)
- 4138: Modified Router to use backwards compatible regex expression Issue: 4134
  (https://github.com/zendframework/zf2/issues/4138)
- 4140: When displaying navigations three times last navigation has data of prev...
  (https://github.com/zendframework/zf2/issues/4140)
- 4143: Fixed issue #3626
  (https://github.com/zendframework/zf2/issues/4143)
- 4144: feature / `quoteTrustedValueList`
  (https://github.com/zendframework/zf2/issues/4144)
- 4147: Reset stop-propagation flag when triggering event
  (https://github.com/zendframework/zf2/issues/4147)
- 4148: Filters priority setting when populating filters in inputfilter factory and not losing it when merging filter chains
  (https://github.com/zendframework/zf2/issues/4148)
- 4150: Hotfix - `callable` type introspection for method parameters
  (https://github.com/zendframework/zf2/issues/4150)
- 4152: Fixed some EMail Validation Strings - German
  (https://github.com/zendframework/zf2/issues/4152)
- 4153: [Feed] sync svn r24842 - Fix ZF-4491
  (https://github.com/zendframework/zf2/issues/4153)
- 4154: Catch `LogicException` for Rewind and fix CP errors
  (https://github.com/zendframework/zf2/issues/4154)
- 4157: end autoload classmap generated file with EOL
  (https://github.com/zendframework/zf2/issues/4157)
- 4161: servicemanager is a requirement
  (https://github.com/zendframework/zf2/issues/4161)
- 4164: Fetch model from event parameter
  (https://github.com/zendframework/zf2/issues/4164)
- 4167: `Console` posix adapter `writeLine()` background color bleeding through to the next line.
  (https://github.com/zendframework/zf2/issues/4167)
- 4168: Fix #4167 - Console posix adapter `writeLine()` background color bleeding through to the next line.
  (https://github.com/zendframework/zf2/issues/4168)
- 4171: Fix BC break in 2.1.5dev - Revert to previous `isRequired` behavior for file upload inputs
  (https://github.com/zendframework/zf2/issues/4171)
- 4172: [Form] Remove after Add doesn't restore initial state
  (https://github.com/zendframework/zf2/issues/4172)
- 4180: Radio & Multicheckbox Problem with selected & disabled attributes
  (https://github.com/zendframework/zf2/issues/4180)
- 4182: Issue #3358 - Fix for console router not accepting controller word as part of a route
  (https://github.com/zendframework/zf2/issues/4182)
- 4183: Update `Zend_Validate.php` resource
  (https://github.com/zendframework/zf2/issues/4183)
- 4184: Updated `Page\Mvc::getHref` to grab correct controller name from `routeMatch`
  (https://github.com/zendframework/zf2/issues/4184)
- 4191: `Zend\Stdlib\Hydrator\ClassMethods::hydrate()` - support for `__call()` magic method
  (https://github.com/zendframework/zf2/issues/4191)
- 4198: fixed typo in french `Zend_Validator_StringLength`
  (https://github.com/zendframework/zf2/issues/4198)
- 4199:  Issue #4172 - Fixed empty priority queue state
  (https://github.com/zendframework/zf2/issues/4199)
- 4201: Issue #4172 - Added tests for add/remove sequence in `Zend\Form`
  (https://github.com/zendframework/zf2/issues/4201)
- 4203: Allow an instance of `Zend\Stdlib\AbstractOptions` to set configuration properties of the same class
  (https://github.com/zendframework/zf2/issues/4203)
- 4207: Fixed default plural rule.
  (https://github.com/zendframework/zf2/issues/4207)
- 4210: Fixed failure when implementing custom rbac roles
  (https://github.com/zendframework/zf2/issues/4210)
- 4213: [Curl] `setOptions` should merge config items that can be arrays
  (https://github.com/zendframework/zf2/issues/4213)
- 4216: Require `Zend\Config` in `Zend\Mvc`
  (https://github.com/zendframework/zf2/issues/4216)
- 4224: `Mail\Headers.php`: Adjust regex for field name to RFC 5322
  (https://github.com/zendframework/zf2/issues/4224)
- 4225: change variable naming
  (https://github.com/zendframework/zf2/issues/4225)
- 4226: ZF2 ACL full access
  (https://github.com/zendframework/zf2/issues/4226)
- 4227: Updated `Zend_Captcha` and `Zend_Validate` for catalan language
  (https://github.com/zendframework/zf2/issues/4227)
- 4232: Correct tests for group multicheckbox & radio attributes
  (https://github.com/zendframework/zf2/issues/4232)
- 4233: remove mistake doc for `Zend\Http\PhpEnvironment\Request::detectBaseUrl()`
  (https://github.com/zendframework/zf2/issues/4233)
- 4235: fixed `setEventManager`
  (https://github.com/zendframework/zf2/issues/4235)
- 4236: Update `ProvidesEvents.php`
  (https://github.com/zendframework/zf2/issues/4236)
- 4237: Update `ModuleManager.php`
  (https://github.com/zendframework/zf2/issues/4237)
- 4239: Remove annotation in `Zend\Db\Adapter\AdapterAwareTrait`
  (https://github.com/zendframework/zf2/issues/4239)
- 4240: A Better fix for #3912
  (https://github.com/zendframework/zf2/issues/4240)
- 4241: `Zend\Db\Metadata` - remove quoting of known scalars, use `quoteTrustedValue()` for provided values
  (https://github.com/zendframework/zf2/issues/4241)
- 4242: fix `Zend\Json` doc and little typo
  (https://github.com/zendframework/zf2/issues/4242)
- 4243: remove `if` `else` for same return
  (https://github.com/zendframework/zf2/issues/4243)
- 4244: remove unused `require_once __DIR__ . '/SplAutoloader.php';`
  (https://github.com/zendframework/zf2/issues/4244)
- 4246: replaced `get_called_class()` with `get_class($this)` in non-static context
  (https://github.com/zendframework/zf2/issues/4246)

## 2.1.4 (13 Mar 2013):

- ZF2013-01: Query route (http://framework.zend.com/security/ZF2013-01)
- ZF2013-02: RNG support (http://framework.zend.com/security/ZF2013-02)
- ZF2013-03: DB platform quoting (http://framework.zend.com/security/ZF2013-03)
- 2752: `Zend_Json_Server` to accept null parameters
  (https://github.com/zendframework/zf2/issues/2752)
- 3696: `Zend\Json\Server\Server` should allow parameters with NULL values
  (https://github.com/zendframework/zf2/issues/3696)
- 3767: Allow NULL parameter values in `Zend/Json/Server`
  (https://github.com/zendframework/zf2/issues/3767)
- 3827: Fix mismatches between the PHPDoc and the method signatures
  (https://github.com/zendframework/zf2/issues/3827)
- 3840: allow a null page in pages array, to compensate for ZF issue #3823
  (https://github.com/zendframework/zf2/issues/3840)
- 3842: Hotfix/zend test improve console usage
  (https://github.com/zendframework/zf2/issues/3842)
- 3849: Check if values are set in `Zend\Db\Sql\Insert.php` for prepared
  statement
  (https://github.com/zendframework/zf2/issues/3849)
- 3867: `FileGenerator::setUses()` MUST can take arguments from
  `FileGenerator::getUses()`
  (https://github.com/zendframework/zf2/issues/3867)
- 3868: `ClassGenerator::fromReflection` not generate class properties
  (https://github.com/zendframework/zf2/issues/3868)
- 3869: Remove BC break in `Identical` validator
  (https://github.com/zendframework/zf2/issues/3869)
- 3871: The method delete on the `RowGateway` now returns the affected rows
  (https://github.com/zendframework/zf2/issues/3871)
- 3873: Fixes an issue when binding a model to a form collection element
  (https://github.com/zendframework/zf2/issues/3873)
- 3885: Hotfix/add tests console adapter
  (https://github.com/zendframework/zf2/issues/3885)
- 3886: Add tests console prompt
  (https://github.com/zendframework/zf2/issues/3886)
- 3888: `DefinitionList` `hasMethod` fix
  (https://github.com/zendframework/zf2/issues/3888)
- 3907: Add tests console request response
  (https://github.com/zendframework/zf2/issues/3907)
- 3916: Fix PUT HTTP method usage with params
  (https://github.com/zendframework/zf2/issues/3916)
- 3917: Clean the Console abstract adapter
  (https://github.com/zendframework/zf2/issues/3917)
- 3921: [+BUGFIX] Fixed column names bug `Zend\Db\Sql\Select`
  (https://github.com/zendframework/zf2/issues/3921)
- 3925: Added view and validator dependency
  (https://github.com/zendframework/zf2/issues/3925)
- 3936: Improve the remove of `SendResponseListener`
  (https://github.com/zendframework/zf2/issues/3936)
- 3946: Adding config to `openssl_pkey_export()`
  (https://github.com/zendframework/zf2/issues/3946)
- 3947: fix exception %s passed variable of 'A service by the name or alias %s'  should be $name
  (https://github.com/zendframework/zf2/issues/3947)
- 3948: Bug/merging translator textdomains
  (https://github.com/zendframework/zf2/issues/3948)
- 3950: Fix zero value in argument
  (https://github.com/zendframework/zf2/issues/3950)
- 3957: [Hotfix] Fixed incorrect `PDO_Oci` platform recognition
  (https://github.com/zendframework/zf2/issues/3957)
- 3960: Update toString() to use late static binding for encoding methods
  (https://github.com/zendframework/zf2/issues/3960)
- 3964: Fix fluent interface
  (https://github.com/zendframework/zf2/issues/3964)
- 3966: Better polyfill support for `Stdlib` and `Session`
  (https://github.com/zendframework/zf2/issues/3966)
- 3968: fixed `Exception\InvalidArgumentException` messages in `Zend\Log`
  (https://github.com/zendframework/zf2/issues/3968)
- 3971: SessionArrayStorage doesn't preserve `_REQUEST_ACCESS_TIME`
  (https://github.com/zendframework/zf2/issues/3971)
- 3973: Documentation improvement `Zend\View\Stream`
  (https://github.com/zendframework/zf2/issues/3973)
- 3980: change `HOST_DNS_OR_IPV4_OR_IPV6` to `0x13` for `$validHostTypes`
  (https://github.com/zendframework/zf2/issues/3980)
- 3981: Improve exception messages
  (https://github.com/zendframework/zf2/issues/3981)
- 3982: Fix `\Zend\Soap\AutoDiscover` constructor
  (https://github.com/zendframework/zf2/issues/3982)
- 3984: Update `ArrayStack.php`
  (https://github.com/zendframework/zf2/issues/3984)
- 3987: Fix ChromePhp logger interface and debug level
  (https://github.com/zendframework/zf2/issues/3987)
- 3988: Fix & Unit test for `preparestatement` notices
  (https://github.com/zendframework/zf2/issues/3988)
- 3991: Hotfix/3858 - `findHelper` problem in Navigation Helper
  (https://github.com/zendframework/zf2/issues/3991)
- 3993: `SessionArrayStorage` Request Access Time and Storage Initialization
  (https://github.com/zendframework/zf2/issues/3993)
- 3997: Allow https on scheme without a hostname
  (https://github.com/zendframework/zf2/issues/3997)
- 4001: Fix `ViewFeedStrategyFactory` comment
  (https://github.com/zendframework/zf2/issues/4001)
- 4005: Hotfix/case sensitive console
  (https://github.com/zendframework/zf2/issues/4005)
- 4007: Pass `ClassGenerator` instance instead of boolean
  (https://github.com/zendframework/zf2/issues/4007)
- 4009: Minor if to else if improvement
  (https://github.com/zendframework/zf2/issues/4009)
- 4010: Hotfix/zend test with console route
  (https://github.com/zendframework/zf2/issues/4010)

## 2.1.3 (21 Feb 2013):

- 3714: Zend\Stdlib\ArrayObject::offsetExists() returning by reference
  (https://github.com/zendframework/zf2/issues/3714)
- 3855: Fix #3852
  (https://github.com/zendframework/zf2/issues/3855)
- 3856: Simple route case insensitive
  (https://github.com/zendframework/zf2/issues/3856)

## 2.1.2 (20 Feb 2013):

- 3085: create controller via Zend\Mvc\Controller\ControllerManager
  (https://github.com/zendframework/zf2/issues/3085)
- 3469: ConnectionInterface docblock is wrong or implementation is wrong..
  (https://github.com/zendframework/zf2/issues/3469)
- 3506: [WIP] [#3113] Fix spelling in error validation messages
  (https://github.com/zendframework/zf2/issues/3506)
- 3636: If route has child routes and in URL has arbitrary query like "?lang=de"
  it does not work
  (https://github.com/zendframework/zf2/issues/3636)
- 3652: Query parameter ?action=somevalue will get 404 error
  (https://github.com/zendframework/zf2/issues/3652)
- 3683: Fix to make sure NotEmpty validator is not already set
  (https://github.com/zendframework/zf2/issues/3683)
- 3691: Fix for GitHub issue 3469
  (https://github.com/zendframework/zf2/issues/3691)
- 3698: Openssl error string
  (https://github.com/zendframework/zf2/issues/3698)
- 3699: Certain servers may not set a whitespace after a colon 
  (Set-Cookie: header)
  (https://github.com/zendframework/zf2/issues/3699)
- 3701: Synced pt\_BR\Zend\_Validate.php with en\Zend\_Validate.php
  (https://github.com/zendframework/zf2/issues/3701)
- 3702: added new file: resources\languages\pt\_BR\Zend\_Captcha.php
  (https://github.com/zendframework/zf2/issues/3702)
- 3703: [WIP] Adding parallel testing ANT build configuration and related files
  (https://github.com/zendframework/zf2/issues/3703)
- 3705: Recent composer.json update of stdlib package
  (https://github.com/zendframework/zf2/issues/3705)
- 3706: clear joins and create without columns
  (https://github.com/zendframework/zf2/issues/3706)
- 3707: quoteIdentifier problem in sequence
  (https://github.com/zendframework/zf2/issues/3707)
- 3708: Filter\File\RenameUpload: wrap move\_uploaded\_file to be easly mocked
  (https://github.com/zendframework/zf2/issues/3708)
- 3712: Fix for URIs with a query string not matching
  (https://github.com/zendframework/zf2/issues/3712)
- 3713: Session Container Mismatch & Version Compare fixes for 5.3.3
  (https://github.com/zendframework/zf2/issues/3713)
- 3715: [#3705] Fix autoload.files setting in composer.json
  (https://github.com/zendframework/zf2/issues/3715)
- 3716: Added the Zend\Form decepence in composer.json for Zend\Mvc
  (https://github.com/zendframework/zf2/issues/3716)
- 3721: Created README.md files for each component
  (https://github.com/zendframework/zf2/issues/3721)
- 3722: [Form] [DateTimeSelect] Filter, manager, and view helper fixes
  (https://github.com/zendframework/zf2/issues/3722)
- 3725: Use built-in php constants
  (https://github.com/zendframework/zf2/issues/3725)
- 3729: Zend\Barcode (Fixes #2862)
  (https://github.com/zendframework/zf2/issues/3729)
- 3732: Fix for #2531 - Multiplie navigation don't work
  (https://github.com/zendframework/zf2/issues/3732)
- 3733: Fix/select where
  (https://github.com/zendframework/zf2/issues/3733)
- 3735: [Form] [FormElementManager] don't overwrite form factory if already set
  (https://github.com/zendframework/zf2/issues/3735)
- 3742: Object+hydrator element annotation fix
  (https://github.com/zendframework/zf2/issues/3742)
- 3743: [#3739 & #3740] Using version-compare in accept header handler params.
  (https://github.com/zendframework/zf2/issues/3743)
- 3746: Fix bugs for some locales!
  (https://github.com/zendframework/zf2/issues/3746)
- 3757: Fixed a bug where mail messages were malformed when using the Sendmail
  (https://github.com/zendframework/zf2/issues/3757)
- 3764: Validator File MimeType (IsImage & IsCompressed)
  (https://github.com/zendframework/zf2/issues/3764)
- 3771: Zend\File\Transfer\Adapter\Http on receive : error "File was not found"  in ZF 2.1
  (https://github.com/zendframework/zf2/issues/3771)
- 3778: [#3711] Fix regression in query string matching
  (https://github.com/zendframework/zf2/issues/3778)
- 3782: [WIP] Zend\Di\Di::get() with call parameters ignored shared instances.
  (https://github.com/zendframework/zf2/issues/3782)
- 3783: Provide branch-alias entries for each component composer.json
  (https://github.com/zendframework/zf2/issues/3783)
- 3785: Zend\Db\Sql\Literal Fix when % is used in string
  (https://github.com/zendframework/zf2/issues/3785)
- 3786: Inject shared event manager in initializer
  (https://github.com/zendframework/zf2/issues/3786)
- 3789: Update library/Zend/Mail/Header/AbstractAddressList.php
  (https://github.com/zendframework/zf2/issues/3789)
- 3793: Resolved Issue: #3748 - offsetGet and __get should do a direct proxy to
  $_SESSION
  (https://github.com/zendframework/zf2/issues/3793)
- 3794: Implement query and fragment assembling into the HTTP router itself
  (https://github.com/zendframework/zf2/issues/3794)
- 3797: remove @category, @package, and @subpackage docblocks
  (https://github.com/zendframework/zf2/issues/3797)
- 3798: Remove extra semicolons
  (https://github.com/zendframework/zf2/issues/3798)
- 3803: Fix identical validator
  (https://github.com/zendframework/zf2/issues/3803)
- 3806: Remove obsolete catch statement
  (https://github.com/zendframework/zf2/issues/3806)
- 3807: Resolve undefined classes in phpDoc
  (https://github.com/zendframework/zf2/issues/3807)
- 3808: Add missing @return annotations
  (https://github.com/zendframework/zf2/issues/3808)
- 3813: Bug fix for GlobIterator extending service
  (https://github.com/zendframework/zf2/issues/3813)
- 3817: Add failing tests for Simple console route
  (https://github.com/zendframework/zf2/issues/3817)
- 3819: Allow form element filter to convert a string to array
  (https://github.com/zendframework/zf2/issues/3819)
- 3828: Cannot validate form when keys of collection in data are non consecutive
  (https://github.com/zendframework/zf2/issues/3828)
- 3831: Non-matching argument type for ArrayObject
  (https://github.com/zendframework/zf2/issues/3831)
- 3832: Zend\Db\Sql\Predicate\Predicate->literal() does not work with integer 0
  as $expressionParameters
  (https://github.com/zendframework/zf2/issues/3832)
- 3836: Zend\Db\Sql\Predicate\Predicate Fix for literal() usage
  (https://github.com/zendframework/zf2/issues/3836)
- 3837: Fix for legacy Transfer usage of File Validators
  (https://github.com/zendframework/zf2/issues/3837)
- 3838: Stdlib\ArrayObject & Zend\Session\Container Compatibility with ArrayObject
  (https://github.com/zendframework/zf2/issues/3838)
- 3839: Fixes #2477 - Implemented optional subdomains using regex
  (https://github.com/zendframework/zf2/issues/3839)

## 2.1.1 (06 Feb 2013):

- 2510: Zend\Session\Container does not allow modification by reference
  (https://github.com/zendframework/zf2/issues/2510)
- 2899: Can't inherit abstract function
  Zend\Console\Prompt\PromptInterface::show()
  (https://github.com/zendframework/zf2/issues/2899)
- 3455: Added DISTINCT on Zend\Db\Sql\Select
  (https://github.com/zendframework/zf2/issues/3455)
- 3456: Connection creation added in Pgsql.php createStatement method
  (https://github.com/zendframework/zf2/issues/3456)
- 3608: Fix validate data contains arrays as values
  (https://github.com/zendframework/zf2/issues/3608)
- 3610: Form: rely on specific setter
  (https://github.com/zendframework/zf2/issues/3610)
- 3618: Fix bug when $indent have some string
  (https://github.com/zendframework/zf2/issues/3618)
- 3622: Updated Changelog with BC notes for 2.1 and 2.0.7
  (https://github.com/zendframework/zf2/issues/3622)
- 3623: Authentication using DbTable Adapter doesn't work for 2.1.0
  (https://github.com/zendframework/zf2/issues/3623)
- 3625: Missing instance/object for parameter route upgrading to 2.1.\*
  (https://github.com/zendframework/zf2/issues/3625)
- 3627: Making relative links in Markdown files
  (https://github.com/zendframework/zf2/issues/3627)
- 3629: Zend\Db\Select using alias in joins can results in wrong SQL
  (https://github.com/zendframework/zf2/issues/3629)
- 3638: Fixed method that removed part from parts in Mime\Message
  (https://github.com/zendframework/zf2/issues/3638)
- 3639: Session Metadata and SessionArrayStorage requestaccesstime fixes.
  (https://github.com/zendframework/zf2/issues/3639)
- 3640: [#3625] Do not query abstract factories for registered invokables
  (https://github.com/zendframework/zf2/issues/3640)
- 3641: Zend\Db\Sql\Select Fix for #3629
  (https://github.com/zendframework/zf2/issues/3641)
- 3645: Exception on destructing the SMTP Transport instance
  (https://github.com/zendframework/zf2/issues/3645)
- 3648: Ensure run() always returns Application instance
  (https://github.com/zendframework/zf2/issues/3648)
- 3649: Created script to aggregate return status
  (https://github.com/zendframework/zf2/issues/3649)
- 3650: InjectControllerDependencies initializer overriding an previously
  defined EventManager
  (https://github.com/zendframework/zf2/issues/3650)
- 3651: Hotfix/3650
  (https://github.com/zendframework/zf2/issues/3651)
- 3656: Zend\Validator\Db\AbstractDb.php and mysqli
  (https://github.com/zendframework/zf2/issues/3656)
- 3658: Zend\Validator\Db\AbstractDb.php and mysqli (issue: 3656)
  (https://github.com/zendframework/zf2/issues/3658)
- 3661: ZF HTTP Status Code overwritten
  (https://github.com/zendframework/zf2/issues/3661)
- 3662: Remove double injection in Plugin Controller Manager
  (https://github.com/zendframework/zf2/issues/3662)
- 3663: Remove useless shared in ServiceManager
  (https://github.com/zendframework/zf2/issues/3663)
- 3671: Hotfix/restful head identifier
  (https://github.com/zendframework/zf2/issues/3671)
- 3673: Add translations for Zend\Validator\File\UploadFile
  (https://github.com/zendframework/zf2/issues/3673)
- 3679: remove '\' character from Traversable 
  (https://github.com/zendframework/zf2/issues/3679)
- 3680: Zend\Validator\Db Hotfix (supersedes #3658)
  (https://github.com/zendframework/zf2/issues/3680)
- 3681: [#2899] Remove redundant method declaration
  (https://github.com/zendframework/zf2/issues/3681)
- 3682: Zend\Db\Sql\Select Quantifier (DISTINCT, ALL, + Expression) support -
  supersedes #3455
  (https://github.com/zendframework/zf2/issues/3682)
- 3684: Remove the conditional class declaration of ArrayObject
  (https://github.com/zendframework/zf2/issues/3684)
- 3687: fix invalid docblock
  (https://github.com/zendframework/zf2/issues/3687)
- 3689: [#3684] Polyfill support for version-dependent classes
  (https://github.com/zendframework/zf2/issues/3689)
- 3690: oracle transaction support
  (https://github.com/zendframework/zf2/issues/3690)
- 3692: Hotfix/db parametercontainer mixed use
  (https://github.com/zendframework/zf2/issues/3692)

## 2.1.0 (29 Jan 2013):

- 2378: ZF2-417 Form Annotation Hydrator options support
  (https://github.com/zendframework/zf2/issues/2378)
- 2390: Expose formally protected method in ConfigListener
  (https://github.com/zendframework/zf2/issues/2390)
- 2405: [WIP] Feature/accepted model controller plugin
  (https://github.com/zendframework/zf2/issues/2405)
- 2424: Decorator plugin manager was pointing to an inexistent class
  (https://github.com/zendframework/zf2/issues/2424)
- 2428: Form develop/allow date time
  (https://github.com/zendframework/zf2/issues/2428)
- 2430: [2.1] Added the scrypt key derivation algorithm in Zend\Crypt
  (https://github.com/zendframework/zf2/issues/2430)
- 2439: [2.1] Form File Upload refactor
  (https://github.com/zendframework/zf2/issues/2439)
- 2486: The Upload validator might be broken
  (https://github.com/zendframework/zf2/issues/2486)
- 2506: Throwing exception in template (and/or layout) doesnt fails gracefully
  (https://github.com/zendframework/zf2/issues/2506)
- 2524: Throws exception when trying to generate bcrypt
  (https://github.com/zendframework/zf2/issues/2524)
- 2537: Create a NotIn predicate
  (https://github.com/zendframework/zf2/issues/2537)
- 2616: Initial ZF2 RBAC Component
  (https://github.com/zendframework/zf2/issues/2616)
- 2629: JsonStrategy should set response charset
  (https://github.com/zendframework/zf2/issues/2629)
- 2647: Fix/bcrypt: added the set/get BackwardCompatibility
  (https://github.com/zendframework/zf2/issues/2647)
- 2668: Implement XCache storage adapter (fixes #2581)
  (https://github.com/zendframework/zf2/issues/2668)
- 2671: Added fluent inteface to prepend and set method. Zend\View\Container\AbstractContainer
  (https://github.com/zendframework/zf2/issues/2671)
- 2725: Feature/logger factory
  (https://github.com/zendframework/zf2/issues/2725)
- 2726: Zend\Validator\Explode does not handle NULL
  (https://github.com/zendframework/zf2/issues/2726)
- 2727: Added ability to add additional information to the logs via processors.
  (https://github.com/zendframework/zf2/issues/2727)
- 2772: Adding cookie route. Going to open PR for comments.
  (https://github.com/zendframework/zf2/issues/2772)
- 2815: Fix fro GitHub issue 2600 (Cannot check if a table is read only)
  (https://github.com/zendframework/zf2/issues/2815)
- 2819: Support for ListenerAggregates in SharedEventManager
  (https://github.com/zendframework/zf2/issues/2819)
- 2820: Form plugin manager
  (https://github.com/zendframework/zf2/issues/2820)
- 2863: Handle postgres sequences
  (https://github.com/zendframework/zf2/issues/2863)
- 2876: memcached changes
  (https://github.com/zendframework/zf2/issues/2876)
- 2884: Allow select object to pass on select->join
  (https://github.com/zendframework/zf2/issues/2884)
- 2888: Bugfix dateformat helper
  (https://github.com/zendframework/zf2/issues/2888)
- 2918: \Zend\Mime\Mime::LINEEND causes problems with some SMTP-Servers
  (https://github.com/zendframework/zf2/issues/2918)
- 2945: SOAP 1.2 support for WSDL generation
  (https://github.com/zendframework/zf2/issues/2945)
- 2947: Add DateTimeSelect element to form
  (https://github.com/zendframework/zf2/issues/2947)
- 2950: Abstract row gatewayset from array
  (https://github.com/zendframework/zf2/issues/2950)
- 2968: Zend\Feed\Reader\Extension\Atom\Entry::getAuthors and Feed::getAuthors
  should return Collection\Author
  (https://github.com/zendframework/zf2/issues/2968)
- 2973: Zend\Db\Sql : Create NotIn predicate
  (https://github.com/zendframework/zf2/issues/2973)
- 2977: Method signature of merge() in Zend\Config\Config prevents mocking
  (https://github.com/zendframework/zf2/issues/2977)
- 2988: Cache: Added storage adapter using a session container
  (https://github.com/zendframework/zf2/issues/2988)
- 2990: Added note of new xcache storage adapter
  (https://github.com/zendframework/zf2/issues/2990)
- 3010: [2.1][File Uploads] Multi-File input filtering and FilePRG plugin update
  (https://github.com/zendframework/zf2/issues/3010)
- 3011: Response Json Client
  (https://github.com/zendframework/zf2/issues/3011)
- 3016: [develop] PRG Plugin fixes: Incorrect use of session hops expiration
  (https://github.com/zendframework/zf2/issues/3016)
- 3019: [2.1][develop] PRG Plugins fix
  (https://github.com/zendframework/zf2/issues/3019)
- 3055: Zend Validators complain of array to string conversion for nested array
  values that do not pass validation when using E\_NOTICE
  (https://github.com/zendframework/zf2/issues/3055)
- 3058: [2.1][File Upload] Session Progress fixes
  (https://github.com/zendframework/zf2/issues/3058)
- 3059: [2.1] Add reference to ChromePhp LoggerWriter in WriterPluginManager
  (https://github.com/zendframework/zf2/issues/3059)
- 3069: Hotfix/xcache empty namespace
  (https://github.com/zendframework/zf2/issues/3069)
- 3073: Documentation and code  mismatch
  (https://github.com/zendframework/zf2/issues/3073)
- 3084: Basic support for aggregates in SharedEventManager according to feedback...
  (https://github.com/zendframework/zf2/issues/3084)
- 3086: Updated constructors to accept options array according to AbstractWriter...
  (https://github.com/zendframework/zf2/issues/3086)
- 3088: Zend\Permissions\Rbac roles should inherit parent permissions, not child
  permissions
  (https://github.com/zendframework/zf2/issues/3088)
- 3093: Feature/cookies refactor
  (https://github.com/zendframework/zf2/issues/3093)
- 3105: RFC Send Response Workflow
  (https://github.com/zendframework/zf2/issues/3105)
- 3110: Stdlib\StringUtils
  (https://github.com/zendframework/zf2/issues/3110)
- 3140: Tests for Zend\Cache\Storage\Adapter\MemcachedResourceManager
  (https://github.com/zendframework/zf2/issues/3140)
- 3195: Date element formats not respected in validators.
  (https://github.com/zendframework/zf2/issues/3195)
- 3199: [2.1][FileUploads] FileInput AJAX Post fix
  (https://github.com/zendframework/zf2/issues/3199)
- 3212: Cache: Now an empty namespace means disabling namespace support
  (https://github.com/zendframework/zf2/issues/3212)
- 3215: Check $exception type before throw
  (https://github.com/zendframework/zf2/issues/3215)
- 3219: Fix hook in plugin manager
  (https://github.com/zendframework/zf2/issues/3219)
- 3224: Zend\Db\Sql\Select::getSqlString(Zend\Db\Adapter\Platform\Mysql) doesn't
  work properly with limit param
  (https://github.com/zendframework/zf2/issues/3224)
- 3243: [2.1] Added the support of Apache's passwords
  (https://github.com/zendframework/zf2/issues/3243)
- 3246: [2.1][File Upload] Change file upload filtering to preserve the $\_FILES
  array
  (https://github.com/zendframework/zf2/issues/3246)
- 3247: Fix zend test with the new sendresponselistener
  (https://github.com/zendframework/zf2/issues/3247)
- 3257: Support nested error handler
  (https://github.com/zendframework/zf2/issues/3257)
- 3259: [2.1][File Upload] RenameUpload filter rewrite w/option to use uploaded
  'name'
  (https://github.com/zendframework/zf2/issues/3259)
- 3263: correcting ConsoleResponseSender's __invoke
  (https://github.com/zendframework/zf2/issues/3263)
- 3276: DateElement now support a string
  (https://github.com/zendframework/zf2/issues/3276)
- 3283: fix Undefined function DocBlockReflection::factory error
  (https://github.com/zendframework/zf2/issues/3283)
- 3287: Added missing constructor parameter
  (https://github.com/zendframework/zf2/issues/3287)
- 3308: Update library/Zend/Validator/File/MimeType.php
  (https://github.com/zendframework/zf2/issues/3308)
- 3314: add ContentTransferEncoding Headers
  (https://github.com/zendframework/zf2/issues/3314)
- 3316: Update library/Zend/Mvc/ResponseSender/ConsoleResponseSender.php
  (https://github.com/zendframework/zf2/issues/3316)
- 3334: [2.1][develop] Added missing Exception namespace to Sha1 validator
  (https://github.com/zendframework/zf2/issues/3334)
- 3339: Xterm's 256 colors integration for Console.
  (https://github.com/zendframework/zf2/issues/3339)
- 3343: add SimpleStreamResponseSender + Tests
  (https://github.com/zendframework/zf2/issues/3343)
- 3349: Provide support for more HTTP methods in the AbstractRestfulController
  (https://github.com/zendframework/zf2/issues/3349)
- 3350: Add little more fun to console
  (https://github.com/zendframework/zf2/issues/3350)
- 3357: Add default prototype tags in reflection
  (https://github.com/zendframework/zf2/issues/3357)
- 3359: Added filter possibility
  (https://github.com/zendframework/zf2/issues/3359)
- 3363: Fix minor doc block errors
  (https://github.com/zendframework/zf2/issues/3363)
- 3365: Fix trailing spaces CS error causing all travis builds to fail
  (https://github.com/zendframework/zf2/issues/3365)
- 3366: Zend\Log\Logger::registerErrorHandler() should accept a parameter to set
  the return value of the error_handler callback 
  (https://github.com/zendframework/zf2/issues/3366)
- 3370: [2.1] File PRG plugin issue when merging POST data with nested keys
  (https://github.com/zendframework/zf2/issues/3370)
- 3376: Remove use of deprecated /e-modifier of preg_replace
  (https://github.com/zendframework/zf2/issues/3376)
- 3377: removed test failing since PHP>=5.4
  (https://github.com/zendframework/zf2/issues/3377)
- 3378: Improve code generators consistency
  (https://github.com/zendframework/zf2/issues/3378)
- 3385: render view one last time in case exception thrown from inside view
  (https://github.com/zendframework/zf2/issues/3385)
- 3389: FileExtension validor error in Form context
  (https://github.com/zendframework/zf2/issues/3389)
- 3392: Development branch of AbstractRestfulController->processPostData()
  doesn't handle Content-Type application/x-www-form-urlencoded correctly
  (https://github.com/zendframework/zf2/issues/3392)
- 3404: Provide default $_SESSION array superglobal proxy storage adapter 
  (https://github.com/zendframework/zf2/issues/3404)
- 3405: fix dispatcher to catch legitimate exceptions
  (https://github.com/zendframework/zf2/issues/3405)
- 3414: Zend\Mvc\Controller\AbstractRestfulController: various fixes to Json
  handling
  (https://github.com/zendframework/zf2/issues/3414)
- 3418: [2.1] Additional code comments for FileInput
  (https://github.com/zendframework/zf2/issues/3418)
- 3420: Authentication Validator
  (https://github.com/zendframework/zf2/issues/3420)
- 3421: Allow to set arbitrary status code for Exception strategy
  (https://github.com/zendframework/zf2/issues/3421)
- 3426: Zend\Form\View\Helper\FormSelect
  (https://github.com/zendframework/zf2/issues/3426)
- 3427: `Zend\ModuleManager\Feature\ProvidesDependencyModulesInterface`
  (https://github.com/zendframework/zf2/issues/3427)
- 3440: [#3376] Better fix
  (https://github.com/zendframework/zf2/issues/3440)
- 3442: Better content-type negotiation
  (https://github.com/zendframework/zf2/issues/3442)
- 3446: Zend\Form\Captcha setOptions don't follow interface contract
  (https://github.com/zendframework/zf2/issues/3446)
- 3450: [Session][Auth] Since the recent BC changes to Sessions,
  Zend\Authentication\Storage\Session does not work
  (https://github.com/zendframework/zf2/issues/3450)
- 3454: ACL permissions are not correctly inherited.
  (https://github.com/zendframework/zf2/issues/3454)
- 3458: Session data is empty in Session SaveHandler's write function
  (https://github.com/zendframework/zf2/issues/3458)
- 3461: fix for zendframework/zf2#3458
  (https://github.com/zendframework/zf2/issues/3461)
- 3470: Session not working in current development?
  (https://github.com/zendframework/zf2/issues/3470)
- 3479: Fixed #3454.
  (https://github.com/zendframework/zf2/issues/3479)
- 3482: Feature/rest delete replace collection
  (https://github.com/zendframework/zf2/issues/3482)
- 3483: [#2629] Add charset to Content-Type header
  (https://github.com/zendframework/zf2/issues/3483)
- 3485: Zend\Db Oracle Driver
  (https://github.com/zendframework/zf2/issues/3485)
- 3491: Update library/Zend/Code/Generator/PropertyGenerator.php
  (https://github.com/zendframework/zf2/issues/3491)
- 3493: [Log] fixes #3366: Now Logger::registerErrorHandler() accepts continue
  (https://github.com/zendframework/zf2/issues/3493)
- 3494: [2.1] Zend\Filter\Word\* no longer extends Zend\Filter\PregReplace
  (https://github.com/zendframework/zf2/issues/3494)
- 3495: [2.1] Added Zend\Stdlib\StringUtils::hasPcreUnicodeSupport()
  (https://github.com/zendframework/zf2/issues/3495)
- 3496: [2.1] fixed tons of missing/wrong use statements
  (https://github.com/zendframework/zf2/issues/3496)
- 3498: add method to Zend\Http\Response\Stream
  (https://github.com/zendframework/zf2/issues/3498)
- 3499: removed "self" typehints in Zend\Config and Zend\Mvc
  (https://github.com/zendframework/zf2/issues/3499)
- 3501: Exception while createing RuntimeException in Pdo Connection class
  (https://github.com/zendframework/zf2/issues/3501)
- 3507: hasAcl dosn't cheks $defaultAcl Member Variable
  (https://github.com/zendframework/zf2/issues/3507)
- 3508: Removed all @category, @package, and @subpackage annotations
  (https://github.com/zendframework/zf2/issues/3508)
- 3509: Zend\Form\View\Helper\FormSelect
  (https://github.com/zendframework/zf2/issues/3509)
- 3510: FilePRG: replace array_merge with ArrayUtils::merge
  (https://github.com/zendframework/zf2/issues/3510)
- 3511: Revert PR #3088 as discussed in #3265.
  (https://github.com/zendframework/zf2/issues/3511)
- 3519: Allow to pull route manager from sl
  (https://github.com/zendframework/zf2/issues/3519)
- 3523: Components dependent on Zend\Stdlib but it's not marked in composer.json
  (https://github.com/zendframework/zf2/issues/3523)
- 3531: [2.1] Fix variable Name and Resource on Oracle Driver Test
  (https://github.com/zendframework/zf2/issues/3531)
- 3532: Add legend translation support into formCollection view helper
  (https://github.com/zendframework/zf2/issues/3532)
- 3538: ElementPrepareAwareInterface should use FormInterface
  (https://github.com/zendframework/zf2/issues/3538)
- 3541: \Zend\Filter\Encrypt and \Zend\Filter\Decrypt not working together?
  (https://github.com/zendframework/zf2/issues/3541)
- 3543: Hotfix: Undeprecate PhpEnvironement Response methods
  (https://github.com/zendframework/zf2/issues/3543)
- 3545: Removing service initializer as of zendframework/zf2#3537
  (https://github.com/zendframework/zf2/issues/3545)
- 3546: Add RoleInterface
  (https://github.com/zendframework/zf2/issues/3546)
- 3555: [2.1] [Forms] [Bug] Factory instantiates Elements directly but should be
  using the FormElementManager
  (https://github.com/zendframework/zf2/issues/3555)
- 3556: fix for zendframework/zf2#3555
  (https://github.com/zendframework/zf2/issues/3556)
- 3557: [2.1] Fixes for FilePRG when using nested form elements
  (https://github.com/zendframework/zf2/issues/3557)
- 3559: Feature/translate flash message
  (https://github.com/zendframework/zf2/issues/3559)
- 3561: Zend\Mail SMTP Fix Connection Handling
  (https://github.com/zendframework/zf2/issues/3561)
- 3566: Flash Messenger fixes for PHP < 5.4, and fix for default namespacing
  (https://github.com/zendframework/zf2/issues/3566)
- 3567: Zend\Db: Adapter construction features + IbmDb2 & Oracle Platform
  features
  (https://github.com/zendframework/zf2/issues/3567)
- 3572: Allow to add serializers through config
  (https://github.com/zendframework/zf2/issues/3572)
- 3576: BC Break in Controller Loader, controllers no more present in controller
  loader.
  (https://github.com/zendframework/zf2/issues/3576)
- 3583: [2.1] Fixed an issue on salt check in Apache Password
  (https://github.com/zendframework/zf2/issues/3583)
- 3584: Zend\Db Fix for #3290
  (https://github.com/zendframework/zf2/issues/3584)
- 3585: [2.1] Added the Apache htpasswd support for HTTP Authentication
  (https://github.com/zendframework/zf2/issues/3585)
- 3586: Zend\Db Fix for #2563
  (https://github.com/zendframework/zf2/issues/3586)
- 3587: Zend\Db Fix/Feature for #3294
  (https://github.com/zendframework/zf2/issues/3587)
- 3597: Zend\Db\TableGateway hotfix for MasterSlaveFeature
  (https://github.com/zendframework/zf2/issues/3597)
- 3598: Feature Zend\Db\Adapter\Profiler
  (https://github.com/zendframework/zf2/issues/3598)
- 3599: [WIP] Zend\Db\Sql Literal Objects
  (https://github.com/zendframework/zf2/issues/3599)
- 3600: Fixed the unit test for Zend\Filter\File\Encrypt and Decrypt
  (https://github.com/zendframework/zf2/issues/3600)
- 3605: Restore Zend\File\Transfer
  (https://github.com/zendframework/zf2/issues/3605)
- 3606: Zend\Db\Sql\Select Add Support For SubSelect in Join Table - #2881 &
  #2884
  (https://github.com/zendframework/zf2/issues/3606)

### Potential Breakage

Includes a fix to the classes `Zend\Filter\Encrypt`
and `Zend\Filter\Decrypt` which may pose a small break for end-users. Each
requires an encryption key be passed to either the constructor or the
setKey() method now; this was done to improve the security of each
class.

`Zend\Session` includes a new `Zend\Session\Storage\SessionArrayStorage`
class, which acts as a direct proxy to the $_SESSION superglobal. The
SessionManager class now uses this new storage class by default, in
order to fix an error that occurs when directly manipulating nested
arrays of $_SESSION in third-party code. For most users, the change will
be seamless. Those affected will be those (a) directly accessing the
storage instance, and (b) using object notation to access session
members:

    $foo = null;
    /** @var $storage Zend\Session\Storage\SessionStorage */
    if (isset($storage->foo)) {
        $foo = $storage->foo;
    }

If you are using array notation, as in the following example, your code
remains forwards compatible:

    $foo = null;

    /** @var $storage Zend\Session\Storage\SessionStorage */
    if (isset($storage['foo'])) {
        $foo = $storage['foo'];
    }

If you are not working directly with the storage instance, you will be
unaffected.

For those affected, the following courses of action are possible:

 * Update your code to replace object property notation with array
   notation, OR
 * Initialize and register a Zend\Session\Storage\SessionStorage object
   explicitly with the session manager instance.

## 2.0.8 (13 Mar 2013):

- ZF2013-01: Query route (http://framework.zend.com/security/ZF2013-01)
- ZF2013-02: RNG support (http://framework.zend.com/security/ZF2013-02)
- ZF2013-03: DB platform quoting (http://framework.zend.com/security/ZF2013-03)

## 2.0.7 (29 Jan 2013):

- 1992: [2.1] Adding simple Zend/I18n/Loader/Tmx
  (https://github.com/zendframework/zf2/issues/1992)
- 2024: Add HydratingResultSet::toEntityArray()
  (https://github.com/zendframework/zf2/issues/2024)
- 2031: [2.1] Added MongoDB session save handler
  (https://github.com/zendframework/zf2/issues/2031)
- 2080: [2.1] Added a ChromePhp logger
  (https://github.com/zendframework/zf2/issues/2080)
- 2086: [2.1] Module class map cache
  (https://github.com/zendframework/zf2/issues/2086)
- 2100: [2.1] refresh() method in Redirect plugin
  (https://github.com/zendframework/zf2/issues/2100)
- 2105: [2.1] Feature/unidecoder
  (https://github.com/zendframework/zf2/issues/2105)
- 2106: [2.1] Class annotation scanner
  (https://github.com/zendframework/zf2/issues/2106)
- 2125: [2.1] Add hydrator wildcard and new hydrator strategy
  (https://github.com/zendframework/zf2/issues/2125)
- 2129: [2.1] Feature/overrideable di factories
  (https://github.com/zendframework/zf2/issues/2129)
- 2152: [2.1] [WIP] adding basic table view helper
  (https://github.com/zendframework/zf2/issues/2152)
- 2175: [2.1] Add DateSelect and MonthSelect elements
  (https://github.com/zendframework/zf2/issues/2175)
- 2189: [2.1] Added msgpack serializer
  (https://github.com/zendframework/zf2/issues/2189)
- 2190: [2.1] [WIP] Zend\I18n\Filter\SlugUrl - Made a filter to convert text to
  slugs
  (https://github.com/zendframework/zf2/issues/2190)
- 2208: [2.1] Update library/Zend/View/Helper/HeadScript.php
  (https://github.com/zendframework/zf2/issues/2208)
- 2212: [2.1] Feature/uri normalize filter
  (https://github.com/zendframework/zf2/issues/2212)
- 2225: Zend\Db\Sql : Create NotIn predicate
  (https://github.com/zendframework/zf2/issues/2225)
- 2232: [2.1] Load Messages from other than file
  (https://github.com/zendframework/zf2/issues/2232)
- 2271: [2.1] Ported FingersCrossed handler from monolog to ZF2
  (https://github.com/zendframework/zf2/issues/2271)
- 2288: Allow to create empty option in Select
  (https://github.com/zendframework/zf2/issues/2288)
- 2305: Add support for prev and next link relationships
  (https://github.com/zendframework/zf2/issues/2305)
- 2315: Add MVC service factories for Filters and Validators
  (https://github.com/zendframework/zf2/issues/2315)
- 2316: Add paginator factory & adapter plugin manager
  (https://github.com/zendframework/zf2/issues/2316)
- 2333: Restore mail message from string
  (https://github.com/zendframework/zf2/issues/2333)
- 2339: ZF2-530 Implement PropertyScanner
  (https://github.com/zendframework/zf2/issues/2339)
- 2343: Create Zend Server Monitor Event
  (https://github.com/zendframework/zf2/issues/2343)
- 2367: Convert abstract classes that are only offering static methods
  (https://github.com/zendframework/zf2/issues/2367)
- 2374: Modified Acl/Navigation to be extendable
  (https://github.com/zendframework/zf2/issues/2374)
- 2381: Method Select::from can accept instance of Select as subselect
  (https://github.com/zendframework/zf2/issues/2381)
- 2389: Add plural view helper
  (https://github.com/zendframework/zf2/issues/2389)
- 2396: Rbac component for ZF2
  (https://github.com/zendframework/zf2/issues/2396)
- 2399: Feature/unidecoder new
  (https://github.com/zendframework/zf2/issues/2399)
- 2411: Allow to specify custom pattern for date
  (https://github.com/zendframework/zf2/issues/2411)
- 2414: Added a new validator to check if input is instance of certain class
  (https://github.com/zendframework/zf2/issues/2414)
- 2415: Add plural helper to I18n
  (https://github.com/zendframework/zf2/issues/2415)
- 2417: Allow to render template separately
  (https://github.com/zendframework/zf2/issues/2417)
- 2648: AbstractPluginManager should not respond to...
  (https://github.com/zendframework/zf2/issues/2648)
- 2650: Add view helper and controller plugin to pull the current identity from ...
  (https://github.com/zendframework/zf2/issues/2650)
- 2670: quoteIdentifier() & quoteIdentifierChain() bug
  (https://github.com/zendframework/zf2/issues/2670)
- 2702: Added addUse method in ClassGenerator
  (https://github.com/zendframework/zf2/issues/2702)
- 2704: Functionality/writer plugin manager
  (https://github.com/zendframework/zf2/issues/2704)
- 2706: Feature ini adapter translate
  (https://github.com/zendframework/zf2/issues/2706)
- 2718: Chain authentication storage
  (https://github.com/zendframework/zf2/issues/2718)
- 2774: Fixes #2745 (generate proper query strings).
  (https://github.com/zendframework/zf2/issues/2774)
- 2783: Added methods to allow access to the routes of the SimpleRouteStack.
  (https://github.com/zendframework/zf2/issues/2783)
- 2794: Feature test phpunit lib
  (https://github.com/zendframework/zf2/issues/2794)
- 2801: Improve Zend\Code\Scanner\TokenArrayScanner
  (https://github.com/zendframework/zf2/issues/2801)
- 2807: Add buffer handling to HydratingResultSet
  (https://github.com/zendframework/zf2/issues/2807)
- 2809: Allow Zend\Db\Sql\TableIdentifier in Zend\Db\Sql\Insert, Update & Delete
  (https://github.com/zendframework/zf2/issues/2809)
- 2812: Catch exceptions thrown during rendering
  (https://github.com/zendframework/zf2/issues/2812)
- 2821: Added loadModule.post event to loadModule().
  (https://github.com/zendframework/zf2/issues/2821)
- 2822: Added the ability for FirePhp to understand 'extras' passed to \Zend\Log
  (https://github.com/zendframework/zf2/issues/2822)
- 2841: Allow to remove attribute in form element
  (https://github.com/zendframework/zf2/issues/2841)
- 2844: [Server] & [Soap] Typos and docblocks
  (https://github.com/zendframework/zf2/issues/2844)
- 2848: fixing extract behavior of Zend\Form\Element\Collection and added
  ability to use own fieldset helper within FormCollection-helper
  (https://github.com/zendframework/zf2/issues/2848)
- 2855: add a view event
  (https://github.com/zendframework/zf2/issues/2855)
- 2868: [WIP][Server] Rewrite Reflection API to reuse code from
  Zend\Code\Reflection API
  (https://github.com/zendframework/zf2/issues/2868)
- 2870: [Code] Add support for @throws, multiple types and typed arrays
  (https://github.com/zendframework/zf2/issues/2870)
- 2875: [InputFilter] Adding hasUnknown and getUnknown methods to detect and get
  unknown inputs
  (https://github.com/zendframework/zf2/issues/2875)
- 2919: Select::where should accept PredicateInterface
  (https://github.com/zendframework/zf2/issues/2919)
- 2927: Add a bunch of traits to ZF2
  (https://github.com/zendframework/zf2/issues/2927)
- 2931: Cache: Now an empty namespace means disabling namespace support
  (https://github.com/zendframework/zf2/issues/2931)
- 2953: [WIP] #2743 fix docblock @category/@package/@subpackage
  (https://github.com/zendframework/zf2/issues/2953)
- 2989: Decouple Zend\Db\Sql from concrete Zend\Db\Adapter implementations
  (https://github.com/zendframework/zf2/issues/2989)
- 2995: service proxies / lazy services
  (https://github.com/zendframework/zf2/issues/2995)
- 3017: Fixing the problem with order and \Zend\Db\Sql\Expression
  (https://github.com/zendframework/zf2/issues/3017)
- 3028: Added Json support for POST and PUT operations in restful controller.
  (https://github.com/zendframework/zf2/issues/3028)
- 3056: Add pattern & storage cache factory
  (https://github.com/zendframework/zf2/issues/3056)
- 3057: Pull zend filter compress snappy
  (https://github.com/zendframework/zf2/issues/3057)
- 3078: Allow NodeList to be accessed via array like syntax.
  (https://github.com/zendframework/zf2/issues/3078)
- 3081: Fix for Collection extract method updates targetElement object
  (https://github.com/zendframework/zf2/issues/3081)
- 3106: Added template map generator
  (https://github.com/zendframework/zf2/issues/3106)
- 3189: Added xterm's 256 colors
  (https://github.com/zendframework/zf2/issues/3189)
- 3200: Added ValidatorChain::attach() and ValidatorChain::attachByName() to
  keep consistent with FilterChain
  (https://github.com/zendframework/zf2/issues/3200)
- 3202: Added NTLM authentication support to Zend\Soap\Client\DotNet.
  (https://github.com/zendframework/zf2/issues/3202)
- 3218: Zend-Form: Allow Input Filter Preference Over Element Defaults
  (https://github.com/zendframework/zf2/issues/3218)
- 3230: Add Zend\Stdlib\Hydrator\Strategy\ClosureStrategy
  (https://github.com/zendframework/zf2/issues/3230)
- 3241: Reflection parameter type check
  (https://github.com/zendframework/zf2/issues/3241)
- 3260: Zend/Di, retriving same shared instance for different extra parameters
  (https://github.com/zendframework/zf2/issues/3260)
- 3261: Fix sendmail key
  (https://github.com/zendframework/zf2/issues/3261)
- 3262:  Allows several translation files for same domain / locale 
  (https://github.com/zendframework/zf2/issues/3262)
- 3269: A fix for issue #3195. Date formats are now used during validation.
  (https://github.com/zendframework/zf2/issues/3269)
- 3272: Support for internationalized .IT domain names
  (https://github.com/zendframework/zf2/issues/3272)
- 3273: Parse docblock indented with tabs
  (https://github.com/zendframework/zf2/issues/3273)
- 3285: Fixed wrong return usage and added @throws docblock
  (https://github.com/zendframework/zf2/issues/3285)
- 3286: remove else in already return early
  (https://github.com/zendframework/zf2/issues/3286)
- 3288: Removed unused variable
  (https://github.com/zendframework/zf2/issues/3288)
- 3292: Added Zend Monitor custom event support
  (https://github.com/zendframework/zf2/issues/3292)
- 3295: Proposing removal of subscription record upon unsubscribe
  (https://github.com/zendframework/zf2/issues/3295)
- 3296: Hotfix #3046 - set /dev/urandom as entropy file for Session
  (https://github.com/zendframework/zf2/issues/3296)
- 3298: Add PROPFIND Method to Zend/HTTP/Request
  (https://github.com/zendframework/zf2/issues/3298)
- 3300: Zend\Config - Fix count after merge
  (https://github.com/zendframework/zf2/issues/3300)
- 3302: Fixed #3282
  (https://github.com/zendframework/zf2/issues/3302)
- 3303: Fix indentation, add trailing ',' to last element in array
  (https://github.com/zendframework/zf2/issues/3303)
- 3304: Missed the Zend\Text dependency for Zend\Mvc in composer.json
  (https://github.com/zendframework/zf2/issues/3304)
- 3307: Fix an issue with inheritance of placeholder registry
  (https://github.com/zendframework/zf2/issues/3307)
- 3313: Fix buffering getTotalSpace
  (https://github.com/zendframework/zf2/issues/3313)
- 3317: Fixed FileGenerator::setUse() to ignore already added uses.
  (https://github.com/zendframework/zf2/issues/3317)
- 3318: Fixed FileGenerator::setUses() to allow passing in array of strings.
  (https://github.com/zendframework/zf2/issues/3318)
- 3320: Change @copyright Year : 2012 with 2013
  (https://github.com/zendframework/zf2/issues/3320)
- 3321: remove relative link in CONTRIBUTING.md
  (https://github.com/zendframework/zf2/issues/3321)
- 3322: remove copy variable for no reason
  (https://github.com/zendframework/zf2/issues/3322)
- 3324: enhance strlen to improve performance
  (https://github.com/zendframework/zf2/issues/3324)
- 3326: Minor loop improvements
  (https://github.com/zendframework/zf2/issues/3326)
- 3327: Fix indentation
  (https://github.com/zendframework/zf2/issues/3327)
- 3328: pass on the configured format to the DateValidator instead of hardcoding it
  (https://github.com/zendframework/zf2/issues/3328)
- 3329: Fixed DefinitionList::hasMethod()
  (https://github.com/zendframework/zf2/issues/3329)
- 3331: no chaining in form class' bind method
  (https://github.com/zendframework/zf2/issues/3331)
- 3333: Fixed Zend/Mvc/Router/Http/Segment
  (https://github.com/zendframework/zf2/issues/3333)
- 3340: Add root namespace character
  (https://github.com/zendframework/zf2/issues/3340)
- 3342: change boolean to bool for consistency
  (https://github.com/zendframework/zf2/issues/3342)
- 3345: Update library/Zend/Form/View/Helper/FormRow.php
  (https://github.com/zendframework/zf2/issues/3345)
- 3352: ClassMethods hydrator and wrong method definition
  (https://github.com/zendframework/zf2/issues/3352)
- 3355: Fix for GitHub issue 2511
  (https://github.com/zendframework/zf2/issues/3355)
- 3356: ZF session validators
  (https://github.com/zendframework/zf2/issues/3356)
- 3362: Use CamelCase for naming
  (https://github.com/zendframework/zf2/issues/3362)
- 3369: Removed unused variable in Zend\Json\Decoder.php
  (https://github.com/zendframework/zf2/issues/3369)
- 3386: Adding attributes for a lightweight export
  (https://github.com/zendframework/zf2/issues/3386)
- 3393: [Router] no need to correct ~ in the path encoding
  (https://github.com/zendframework/zf2/issues/3393)
- 3396: change minimal verson of PHPUnit
  (https://github.com/zendframework/zf2/issues/3396)
- 3403: [ZF-8825] Lower-case lookup for "authorization" header
  (https://github.com/zendframework/zf2/issues/3403)
- 3409: Fix for broken handling of
  Zend\ServiceManager\ServiceManager::shareByDefault = false (Issue #3408)
  (https://github.com/zendframework/zf2/issues/3409)
- 3410: [composer] Sync replace package list
  (https://github.com/zendframework/zf2/issues/3410)
- 3415: Remove import of Zend root namespace
  (https://github.com/zendframework/zf2/issues/3415)
- 3423: Issue #3348 fix
  (https://github.com/zendframework/zf2/issues/3423)
- 3425: German Resources Zend\_Validate.php updated.
  (https://github.com/zendframework/zf2/issues/3425)
- 3429: Add __destruct to SessionManager
  (https://github.com/zendframework/zf2/issues/3429)
- 3430: SessionManager: Throw exception when attempting to setId after the
  session has been started
  (https://github.com/zendframework/zf2/issues/3430)
- 3437: Feature/datetime factory format
  (https://github.com/zendframework/zf2/issues/3437)
- 3438: Add @method tags to the AbstractController
  (https://github.com/zendframework/zf2/issues/3438)
- 3439: Individual shared setting does not override the shareByDefault setting
  of the ServiceManager
  (https://github.com/zendframework/zf2/issues/3439)
- 3443: Adding logic to check module dependencies at module loading time
  (https://github.com/zendframework/zf2/issues/3443)
- 3445: Update library/Zend/Validator/Hostname.php
  (https://github.com/zendframework/zf2/issues/3445)
- 3452: Hotfix/session mutability
  (https://github.com/zendframework/zf2/issues/3452)
- 3473: remove surplus call deep namespace
  (https://github.com/zendframework/zf2/issues/3473)
- 3477: The display_exceptions config-option is not passed to 404 views.
  (https://github.com/zendframework/zf2/issues/3477)
- 3480: [Validator][#2538] hostname validator overwrite 
  (https://github.com/zendframework/zf2/issues/3480)
- 3484: [#3055] Remove array to string conversion notice
  (https://github.com/zendframework/zf2/issues/3484)
- 3486: [#3073] Define filter() in Decompress filter
  (https://github.com/zendframework/zf2/issues/3486)
- 3487: [#3446] Allow generic traversable configuration to Captcha element
  (https://github.com/zendframework/zf2/issues/3487)
- 3492: Hotfix/random crypt test fail
  (https://github.com/zendframework/zf2/issues/3492)
- 3502: Features/port supermessenger
  (https://github.com/zendframework/zf2/issues/3502)
- 3513: Fixed bug in acl introduced by acca10b6abe74b3ab51890d5cbe0ab8da4fdf7e0
  (https://github.com/zendframework/zf2/issues/3513)
- 3520: Replace all is_null($value) calls with null === $value
  (https://github.com/zendframework/zf2/issues/3520)
- 3527: Explode validator: allow any value type to be validated
  (https://github.com/zendframework/zf2/issues/3527)
- 3530: The hasACL and hasRole don't check their default member variables
  (https://github.com/zendframework/zf2/issues/3530)
- 3550: Fix for the issue #3541 - salt size for Encrypt/Decrypt Filter
  (https://github.com/zendframework/zf2/issues/3550)
- 3562: Fix: Calling count() results in infinite loop
  (https://github.com/zendframework/zf2/issues/3562)
- 3563: Zend\Db: Fix for #3523 changeset - composer.json and stdlib
  (https://github.com/zendframework/zf2/issues/3563)
- 3571: Correctly parse empty Subject header
  (https://github.com/zendframework/zf2/issues/3571)
- 3575: Fix name of plugin referred to in exception message
  (https://github.com/zendframework/zf2/issues/3575)
- 3579: Some minor fixes in \Zend\View\Helper\HeadScript() class
  (https://github.com/zendframework/zf2/issues/3579)
- 3593: \Zend\Json\Server Fix _getDefaultParams if request-params are an
  associative array
  (https://github.com/zendframework/zf2/issues/3593)
- 3594: Added contstructor to suppressfilter
  (https://github.com/zendframework/zf2/issues/3594)
- 3601: Update Travis to start running tests on PHP 5.5
  (https://github.com/zendframework/zf2/issues/3601)
- 3604: fixed Zend\Log\Logger::registerErrorHandler() doesn't log previous
  exceptions 
  (https://github.com/zendframework/zf2/issues/3604)

### Potential Breakage

Includes a fix to the classes `Zend\Filter\Encrypt`
and `Zend\Filter\Decrypt` which may pose a small break for end-users. Each
requires an encryption key be passed to either the constructor or the
setKey() method now; this was done to improve the security of each
class.

## 2.0.6 (19 Dec 2012):

- 2885: Zend\Db\TableGateway\AbstractTableGateway won't work with Sqlsrv
  db adapter (https://github.com/zendframework/zf2/issues/2885)
- 2922: Fix #2902 (https://github.com/zendframework/zf2/issues/2922)
- 2961: Revert PR #2943 for 5.3.3 fix
  (https://github.com/zendframework/zf2/issues/2961)
- 2962: Allow Accept-Encoding header to be set explicitly by http
  request (https://github.com/zendframework/zf2/issues/2962)
- 3033: Fix error checking on Zend\Http\Client\Adapter\Socket->write().
  (https://github.com/zendframework/zf2/issues/3033)
- 3040: remove unused 'use DOMXPath' and property $count and $xpath
  (https://github.com/zendframework/zf2/issues/3040)
- 3043: improve conditional : reduce file size
  (https://github.com/zendframework/zf2/issues/3043)
- 3044: Extending Zend\Mvc\Router\Http\Segment causes error
  (https://github.com/zendframework/zf2/issues/3044)
- 3047: Fix Zend\Console\Getopt::getUsageMessage()
  (https://github.com/zendframework/zf2/issues/3047)
- 3049: Hotfix/issue #3033
  (https://github.com/zendframework/zf2/issues/3049)
- 3050: Fix : The annotation @\Zend\Form\Annotation\AllowEmpty declared
  on does not accept any values
  (https://github.com/zendframework/zf2/issues/3050)
- 3052: Fixed #3051 (https://github.com/zendframework/zf2/issues/3052)
- 3061: changed it back 'consist' => the 'must' should be applied to all
  parts of the sentence
  (https://github.com/zendframework/zf2/issues/3061)
- 3063: hotfix: change sha382 to sha384 in
  Zend\Crypt\Key\Derivation\SaltedS2k
  (https://github.com/zendframework/zf2/issues/3063)
- 3070: Fix default value unavailable exception for in-build php classes
  (https://github.com/zendframework/zf2/issues/3070)
- 3074: Hotfix/issue #2451 (https://github.com/zendframework/zf2/issues/3074)
- 3091: console exception strategy displays previous exception message
  (https://github.com/zendframework/zf2/issues/3091)
- 3114: Fixed Client to allow also empty passwords in HTTP
  Authentication. (https://github.com/zendframework/zf2/issues/3114)
- 3125: #2607 - Fixing how headers are accessed
  (https://github.com/zendframework/zf2/issues/3125)
- 3126: Fix for GitHub issue 2605
  (https://github.com/zendframework/zf2/issues/3126)
- 3127: fix cs: add space after casting
  (https://github.com/zendframework/zf2/issues/3127)
- 3130: Obey PSR-2 (https://github.com/zendframework/zf2/issues/3130)
- 3144: Zend\Form\View\Helper\Captcha\AbstractWord input and hidden
  attributes (https://github.com/zendframework/zf2/issues/3144)
- 3148: Fixing obsolete method of checking headers, made it use the new
  method. (https://github.com/zendframework/zf2/issues/3148)
- 3149: Zf2634 - Adding missing method Client::encodeAuthHeader
  (https://github.com/zendframework/zf2/issues/3149)
- 3151: Rename variable to what it probably should be
  (https://github.com/zendframework/zf2/issues/3151)
- 3155: strip duplicated semicolon
  (https://github.com/zendframework/zf2/issues/3155)
- 3156: fix typos in docblocks
  (https://github.com/zendframework/zf2/issues/3156)
- 3162: Allow Forms to have an InputFilterSpecification
  (https://github.com/zendframework/zf2/issues/3162)
- 3163: Added support of driver\_options to Mysqli DB Driver
  (https://github.com/zendframework/zf2/issues/3163)
- 3164: Cast $step to float in \Zend\Validator\Step
  (https://github.com/zendframework/zf2/issues/3164)
- 3166: [#2678] Sqlsrv driver incorrectly throwing exception when
  $sqlOrResource... (https://github.com/zendframework/zf2/issues/3166)
- 3167: Fix #3161 by checking if the server port already exists in the
  host (https://github.com/zendframework/zf2/issues/3167)
- 3169: Fixing issue #3036 (https://github.com/zendframework/zf2/issues/3169)
- 3170: Fixing issue #2554 (https://github.com/zendframework/zf2/issues/3170)
- 3171: hotfix : add  '$argName' as 'argument %s' in sprintf ( at 1st
  parameter ) (https://github.com/zendframework/zf2/issues/3171)
- 3178: Maintain priority flag when cloning a Fieldset
  (https://github.com/zendframework/zf2/issues/3178)
- 3184: fix misspelled getCacheStorge()
  (https://github.com/zendframework/zf2/issues/3184)
- 3186: Dispatching to a good controller but wrong action triggers a
  Fatal Error (https://github.com/zendframework/zf2/issues/3186)
- 3187: Fixing ansiColorMap by removing extra m's showed in the console
  (https://github.com/zendframework/zf2/issues/3187)
- 3194: Write clean new line for writeLine method (no background color)
  (https://github.com/zendframework/zf2/issues/3194)
- 3197: Fix spelling error (https://github.com/zendframework/zf2/issues/3197)
- 3201: Session storage set save path
  (https://github.com/zendframework/zf2/issues/3201)
- 3204: [wip] Zend\Http\Client makes 2 requests to url if
  setStream(true) is called
  (https://github.com/zendframework/zf2/issues/3204)
- 3207: dead code clean up.
  (https://github.com/zendframework/zf2/issues/3207)
- 3208: Zend\Mime\Part: Added EOL paramter to getEncodedStream()
  (https://github.com/zendframework/zf2/issues/3208)
- 3213: [#3173] Incorrect creating instance
  Zend/Code/Generator/ClassGenerator.php by fromArray
  (https://github.com/zendframework/zf2/issues/3213)
- 3214: Fix passing of tags to constructor of docblock generator class
  (https://github.com/zendframework/zf2/issues/3214)
- 3217: Cache: Optimized Filesystem::setItem with locking enabled by
  writing the... (https://github.com/zendframework/zf2/issues/3217)
- 3220: [2.0] Log Writer support for MongoClient driver class
  (https://github.com/zendframework/zf2/issues/3220)
- 3226: Licence is not accessable via web
  (https://github.com/zendframework/zf2/issues/3226)
- 3229: fixed bug in DefinitionList::hasMethod()
  (https://github.com/zendframework/zf2/issues/3229)
- 3234: Removed old Form TODO since all items are complete
  (https://github.com/zendframework/zf2/issues/3234)
- 3236: Issue #3222 - Added suport for multi-level nested ini config
  variables (https://github.com/zendframework/zf2/issues/3236)
- 3237: [BUG] Service Manager Not Shared Duplicate new Instance with
  multiple Abstract Factories
  (https://github.com/zendframework/zf2/issues/3237)
- 3238: Added French translation for captcha
  (https://github.com/zendframework/zf2/issues/3238)
- 3250: Issue #2912 - Fix for LicenseTag generation
  (https://github.com/zendframework/zf2/issues/3250)
- 3252: subject prepend text in options for Log\Writer\Mail
  (https://github.com/zendframework/zf2/issues/3252)
- 3254: Better capabilities surrounding console notFoundAction
  (https://github.com/zendframework/zf2/issues/3254)


## 2.0.5 (29 Nov 2012):

- 3004: Zend\Db unit tests fail with code coverage enabled
  (https://github.com/zendframework/zf2/issues/3004)
- 3039: combine double if into single conditional
  (https://github.com/zendframework/zf2/issues/3039)
- 3042: fix typo 'consist of' should be 'consists of' in singular
  (https://github.com/zendframework/zf2/issues/3042)
- 3045: Reduced the #calls of rawurlencode() using a cache mechanism
  (https://github.com/zendframework/zf2/issues/3045)
- 3048: Applying quickfix for zendframework/zf2#3004
  (https://github.com/zendframework/zf2/issues/3048)
- 3095: Process X-Forwarded-For header in correct order
  (https://github.com/zendframework/zf2/issues/3095)

## 2.0.4 (20 Nov 2012):

- 2808: Add serializer better inheritance and extension
  (https://github.com/zendframework/zf2/issues/2808)
- 2813: Add test on canonical name with the ServiceManager
  (https://github.com/zendframework/zf2/issues/2813)
- 2832: bugfix: The helper DateFormat does not cache correctly when a pattern is
  set. (https://github.com/zendframework/zf2/issues/2832)
- 2837: Add empty option before empty check
  (https://github.com/zendframework/zf2/issues/2837)
- 2843: change self:: with static:: in call-ing static property/method
  (https://github.com/zendframework/zf2/issues/2843)
- 2857: Unnecessary path assembly on return in
  Zend\Mvc\Router\Http\TreeRouteStack->assemble() line 236
  (https://github.com/zendframework/zf2/issues/2857)
- 2867: Enable view sub-directories when using ModuleRouteListener
  (https://github.com/zendframework/zf2/issues/2867)
- 2872: Resolve naming conflicts in foreach statements
  (https://github.com/zendframework/zf2/issues/2872)
- 2878: Fix : change self:: with static:: in call-ing static property/method()
  in other components ( all ) (https://github.com/zendframework/zf2/issues/2878)
- 2879: remove unused const in Zend\Barcode\Barcode.php
  (https://github.com/zendframework/zf2/issues/2879)
- 2896: Constraints in Zend\Db\Metadata\Source\AbstractSource::getTable not
  initalised (https://github.com/zendframework/zf2/issues/2896)
- 2907: Fixed proxy adapter keys being incorrectly set due Zend\Http\Client
  (https://github.com/zendframework/zf2/issues/2907)
- 2909: Change format of Form element DateTime and DateTimeLocal
  (https://github.com/zendframework/zf2/issues/2909)
- 2921: Added Chinese translations for zf2 validate/captcha resources
  (https://github.com/zendframework/zf2/issues/2921)
- 2924: small speed-up of Zend\EventManager\EventManager::triggerListeners()
  (https://github.com/zendframework/zf2/issues/2924)
- 2929: SetCookie::getFieldValue() always uses urlencode() for cookie values,
  even in case they are already encoded
  (https://github.com/zendframework/zf2/issues/2929)
- 2930: Add minor test coverage to MvcEvent
  (https://github.com/zendframework/zf2/issues/2930)
- 2932: Sessions: SessionConfig does not allow setting non-directory save path
  (https://github.com/zendframework/zf2/issues/2932)
- 2937: preserve matched route name within route match instance while
  forwarding... (https://github.com/zendframework/zf2/issues/2937)
- 2940: change 'Cloud\Decorator\Tag' to 'Cloud\Decorator\AbstractTag'
  (https://github.com/zendframework/zf2/issues/2940)
- 2941: Logical operator fix : 'or' change to '||' and 'and' change to '&&'
  (https://github.com/zendframework/zf2/issues/2941)
- 2952: Various Zend\Mvc\Router\Http routers turn + into a space in path
  segments (https://github.com/zendframework/zf2/issues/2952)
- 2957: Make Partial proxy to view render function
  (https://github.com/zendframework/zf2/issues/2957)
- 2971: Zend\Http\Cookie undefined self::CONTEXT_REQUEST
  (https://github.com/zendframework/zf2/issues/2971)
- 2976: Fix for #2541 (https://github.com/zendframework/zf2/issues/2976)
- 2981: Controller action HttpResponse is not used by SendResponseListener
  (https://github.com/zendframework/zf2/issues/2981)
- 2983: replaced all calls to $this->xpath with $this->getXpath() to always
  have... (https://github.com/zendframework/zf2/issues/2983)
- 2986: Add class to file missing a class (fixes #2789)
  (https://github.com/zendframework/zf2/issues/2986)
- 2987: fixed Zend\Session\Container::exchangeArray
  (https://github.com/zendframework/zf2/issues/2987)
- 2994: Fixes #2993 - Add missing asterisk to method docblock
  (https://github.com/zendframework/zf2/issues/2994)
- 2997: Fixing abstract factory instantiation time
  (https://github.com/zendframework/zf2/issues/2997)
- 2999: Fix for GitHub issue 2579
  (https://github.com/zendframework/zf2/issues/2999)
- 3002: update master's resources/ja Zend_Validate.php message
  (https://github.com/zendframework/zf2/issues/3002)
- 3003: Adding tests for zendframework/zf2#2593
  (https://github.com/zendframework/zf2/issues/3003)
- 3006: Hotfix for #2497 (https://github.com/zendframework/zf2/issues/3006)
- 3007: Fix for issue 3001 Zend\Db\Sql\Predicate\Between fails with min and max
  ... (https://github.com/zendframework/zf2/issues/3007)
- 3008: Hotfix for #2482 (https://github.com/zendframework/zf2/issues/3008)
- 3009: Hotfix for #2451 (https://github.com/zendframework/zf2/issues/3009)
- 3013: Solved Issue 2857 (https://github.com/zendframework/zf2/issues/3013)
- 3025: Removing the separator between the hidden and the visible inputs. As
  the... (https://github.com/zendframework/zf2/issues/3025)
- 3027: Reduced #calls of plugin() in PhpRenderer using a cache mechanism
  (https://github.com/zendframework/zf2/issues/3027)
- 3029: Fixed the pre-commit script, missed the fix command
  (https://github.com/zendframework/zf2/issues/3029)
- 3030: Mark module as loaded before trigginer EVENT_LOAD_MODULE
  (https://github.com/zendframework/zf2/issues/3030)
- 3031: Zend\Db\Sql Fix for Insert's Merge and Set capabilities with simlar keys
  (https://github.com/zendframework/zf2/issues/3031)


## 2.0.3 (17 Oct 2012):

- 2244: Fix for issue ZF2-503 (https://github.com/zendframework/zf2/issues/2244)
- 2318: Allow to remove decimals in CurrencyFormat
  (https://github.com/zendframework/zf2/issues/2318)
- 2363: Hotfix db features with eventfeature
  (https://github.com/zendframework/zf2/issues/2363)
- 2380: ZF2-482 Attempt to fix the buffer. Also added extra unit tests.
  (https://github.com/zendframework/zf2/issues/2380)
- 2392: Update library/Zend/Db/Adapter/Platform/Mysql.php
  (https://github.com/zendframework/zf2/issues/2392)
- 2395: Fix for http://framework.zend.com/issues/browse/ZF2-571
  (https://github.com/zendframework/zf2/issues/2395)
- 2397: Memcached option merge issuse
  (https://github.com/zendframework/zf2/issues/2397)
- 2402: Adding missing dependencies
  (https://github.com/zendframework/zf2/issues/2402)
- 2404: Fix to comments (https://github.com/zendframework/zf2/issues/2404)
- 2416: Fix expressionParamIndex for AbstractSql
  (https://github.com/zendframework/zf2/issues/2416)
- 2420: Zend\Db\Sql\Select: Fixed issue with join expression named parameters
  overlapping. (https://github.com/zendframework/zf2/issues/2420)
- 2421: Update library/Zend/Http/Header/SetCookie.php
  (https://github.com/zendframework/zf2/issues/2421)
- 2422: fix add 2 space after @param in Zend\Loader
  (https://github.com/zendframework/zf2/issues/2422)
- 2423: ManagerInterface must be interface, remove 'interface' description
  (https://github.com/zendframework/zf2/issues/2423)
- 2425: Use built-in Travis composer
  (https://github.com/zendframework/zf2/issues/2425)
- 2426: Remove need of setter in ClassMethods hydrator
  (https://github.com/zendframework/zf2/issues/2426)
- 2432: Prevent space before end of tag with HTML5 doctype
  (https://github.com/zendframework/zf2/issues/2432)
- 2433: fix for setJsonpCallback not called when recieved JsonModel + test
  (https://github.com/zendframework/zf2/issues/2433)
- 2434: added phpdoc in Zend\Db
  (https://github.com/zendframework/zf2/issues/2434)
- 2437: Hotfix/console 404 reporting
  (https://github.com/zendframework/zf2/issues/2437)
- 2438: Improved previous fix for ZF2-558.
  (https://github.com/zendframework/zf2/issues/2438)
- 2440: Turkish Translations for Captcha and Validate
  (https://github.com/zendframework/zf2/issues/2440)
- 2441: Allow form collection to have any helper
  (https://github.com/zendframework/zf2/issues/2441)
- 2516: limit(20) -> generates LIMIT '20' and throws an IllegalQueryException
  (https://github.com/zendframework/zf2/issues/2516)
- 2545: getSqlStringForSqlObject() returns an invalid SQL statement with LIMIT
  and OFFSET clauses (https://github.com/zendframework/zf2/issues/2545)
- 2595: Pgsql adapater has codes related to MySQL
  (https://github.com/zendframework/zf2/issues/2595)
- 2613: Prevent password to be rendered if form validation fails
  (https://github.com/zendframework/zf2/issues/2613)
- 2617: Fixed Zend\Validator\Iban class name
  (https://github.com/zendframework/zf2/issues/2617)
- 2619: Form enctype fix when File elements are within a collection
  (https://github.com/zendframework/zf2/issues/2619)
- 2620: InputFilter/Input when merging was not using raw value
  (https://github.com/zendframework/zf2/issues/2620)
- 2622: Added ability to specify port
  (https://github.com/zendframework/zf2/issues/2622)
- 2624: Form's default input filters added multiple times
  (https://github.com/zendframework/zf2/issues/2624)
- 2630: fix relative link ( remove the relative links ) in README.md
  (https://github.com/zendframework/zf2/issues/2630)
- 2631: Update library/Zend/Loader/AutoloaderFactory.php
  (https://github.com/zendframework/zf2/issues/2631)
- 2633: fix redundance errors "The input does not appear to be a valid date"
  show twice (https://github.com/zendframework/zf2/issues/2633)
- 2635: Fix potential issue with Sitemap test
  (https://github.com/zendframework/zf2/issues/2635)
- 2636: add isset checks around timeout and maxredirects
  (https://github.com/zendframework/zf2/issues/2636)
- 2641: hotfix : formRow() element error multi-checkbox and radio renderError
  not shown (https://github.com/zendframework/zf2/issues/2641)
- 2642: Fix Travis build for CS issue
  (https://github.com/zendframework/zf2/issues/2642)
- 2643: fix for setJsonpCallback not called when recieved JsonModel + test
  (https://github.com/zendframework/zf2/issues/2643)
- 2644: Add fluidity to the prepare() function for a form
  (https://github.com/zendframework/zf2/issues/2644)
- 2652: Zucchi/filter tweaks (https://github.com/zendframework/zf2/issues/2652)
- 2665: pdftest fix (https://github.com/zendframework/zf2/issues/2665)
- 2666: fixed url change (https://github.com/zendframework/zf2/issues/2666)
- 2667: Possible fix for rartests
  (https://github.com/zendframework/zf2/issues/2667)
- 2669: skip whem gmp is loaded
  (https://github.com/zendframework/zf2/issues/2669)
- 2673: Input fallback value option
  (https://github.com/zendframework/zf2/issues/2673)
- 2676: mysqli::close() never called
  (https://github.com/zendframework/zf2/issues/2676)
- 2677: added phpdoc to Zend\Stdlib
  (https://github.com/zendframework/zf2/issues/2677)
- 2678: Zend\Db\Adapter\Sqlsrv\Sqlsrv never calls Statement\initialize() (fix
  within) (https://github.com/zendframework/zf2/issues/2678)
- 2679: Zend/Log/Logger.php using incorrect php errorLevel
  (https://github.com/zendframework/zf2/issues/2679)
- 2680: Cache: fixed bug on getTotalSpace of filesystem and dba adapter
  (https://github.com/zendframework/zf2/issues/2680)
- 2681: Cache/Dba: fixed notices on tearDown db4 tests
  (https://github.com/zendframework/zf2/issues/2681)
- 2682: Replace 'Configuration' with 'Config' when retrieving configuration
  (https://github.com/zendframework/zf2/issues/2682)
- 2683: Hotfix: Allow items from Abstract Factories to have setShared() called
  (https://github.com/zendframework/zf2/issues/2683)
- 2685: Remove unused Uses (https://github.com/zendframework/zf2/issues/2685)
- 2686: Adding code to allow EventManager trigger listeners using wildcard
  identifier (https://github.com/zendframework/zf2/issues/2686)
- 2687: Hotfix/db sql nested expressions
  (https://github.com/zendframework/zf2/issues/2687)
- 2688: Hotfix/tablegateway event feature
  (https://github.com/zendframework/zf2/issues/2688)
- 2689: Hotfix/composer phpunit
  (https://github.com/zendframework/zf2/issues/2689)
- 2690: Use RFC-3339 full-date format (Y-m-d) in Date element
  (https://github.com/zendframework/zf2/issues/2690)
- 2691: join on conditions don't accept alternatives to columns
  (https://github.com/zendframework/zf2/issues/2691)
- 2693: Update library/Zend/Db/Adapter/Driver/Mysqli/Connection.php
  (https://github.com/zendframework/zf2/issues/2693)
- 2694: Bring fluid interface to Feed Writer
  (https://github.com/zendframework/zf2/issues/2694)
- 2698: fix typo in # should be :: in exception
  (https://github.com/zendframework/zf2/issues/2698)
- 2699: fix elseif in javascript Upload Demo
  (https://github.com/zendframework/zf2/issues/2699)
- 2700: fix cs in casting variable
  (https://github.com/zendframework/zf2/issues/2700)
- 2705: Fix french translation
  (https://github.com/zendframework/zf2/issues/2705)
- 2707: Improved error message when ServiceManager does not find an invokable
  class (https://github.com/zendframework/zf2/issues/2707)
- 2710: #2461 - correcting the url encoding of path segments
  (https://github.com/zendframework/zf2/issues/2710)
- 2711: Fix/demos ProgressBar/ZendForm.php : Object of class Zend\Form\Form
  could not be converted to string
  (https://github.com/zendframework/zf2/issues/2711)
- 2712: fix cs casting variable for (array)
  (https://github.com/zendframework/zf2/issues/2712)
- 2713: Update library/Zend/Mvc/Service/ViewHelperManagerFactory.php
  (https://github.com/zendframework/zf2/issues/2713)
- 2714: Don't add separator if not prefixing columns
  (https://github.com/zendframework/zf2/issues/2714)
- 2717: Extends when it can : Validator\DateStep extends Validator\Date to
  reduce code redundancy (https://github.com/zendframework/zf2/issues/2717)
- 2719: Fixing the Cache Storage Factory Adapter Factory
  (https://github.com/zendframework/zf2/issues/2719)
- 2728: Bad Regex for Content Type header
  (https://github.com/zendframework/zf2/issues/2728)
- 2731: Reset the Order part when resetting Select
  (https://github.com/zendframework/zf2/issues/2731)
- 2732: Removed references to Mysqli in Zend\Db\Adapter\Driver\Pgsql
  (https://github.com/zendframework/zf2/issues/2732)
- 2733: fix @package Zend\_Validate should be Zend\_Validator
  (https://github.com/zendframework/zf2/issues/2733)
- 2734: fix i18n @package and @subpackage value
  (https://github.com/zendframework/zf2/issues/2734)
- 2736: fix captcha helper test.
  (https://github.com/zendframework/zf2/issues/2736)
- 2737: Issue #2728 - Bad Regex for Content Type header
  (https://github.com/zendframework/zf2/issues/2737)
- 2738: fix link 'quickstart' to version 2.0
  (https://github.com/zendframework/zf2/issues/2738)
- 2739: remove '@subpackage'  because Zend\Math is not in subpackage
  (https://github.com/zendframework/zf2/issues/2739)
- 2742: remove () in echo-ing (https://github.com/zendframework/zf2/issues/2742)
- 2749: Fix for #2678 (Zend\Db's Sqlsrv Driver)
  (https://github.com/zendframework/zf2/issues/2749)
- 2750: Adds the ability to instanciate by factory to AbstractPluginManager
  (https://github.com/zendframework/zf2/issues/2750)
- 2754: add the support to register module paths over namespace
  (https://github.com/zendframework/zf2/issues/2754)
- 2755:  remove Zend\Mvc\Controller\PluginBroker from aliases in
  "$defaultServiceConfig" (https://github.com/zendframework/zf2/issues/2755)
- 2759: Fix Zend\Code\Scanner\TokenArrayScanner
  (https://github.com/zendframework/zf2/issues/2759)
- 2764: Fixed Zend\Math\Rand::getString() to pass the parameter $strong to
  ::getBytes() (https://github.com/zendframework/zf2/issues/2764)
- 2765: Csrf: always use dedicated setter
  (https://github.com/zendframework/zf2/issues/2765)
- 2766: Session\Storage: always preserve REQUEST\_ACCESS\_TIME
  (https://github.com/zendframework/zf2/issues/2766)
- 2768: Zend\Validator dependency is missed in Zend\Cache composer.json
  (https://github.com/zendframework/zf2/issues/2768)
- 2769: change valueToLDAP to valueToLdap and valueFromLDAP to valueFromLdap
  (https://github.com/zendframework/zf2/issues/2769)
- 2770: Memcached (https://github.com/zendframework/zf2/issues/2770)
- 2775: Zend\Db\Sql: Fix for Mysql quoting during limit and offset
  (https://github.com/zendframework/zf2/issues/2775)
- 2776: Allow whitespace in Iban
  (https://github.com/zendframework/zf2/issues/2776)
- 2777: Fix issue when PREG\_BAD\_UTF8__OFFSET_ERROR is defined but Unicode support
  is not enabled on PCRE (https://github.com/zendframework/zf2/issues/2777)
- 2778: Undefined Index fix in ViewHelperManagerFactory
  (https://github.com/zendframework/zf2/issues/2778)
- 2779: Allow forms that have been added as fieldsets to bind values to bound
  ob... (https://github.com/zendframework/zf2/issues/2779)
- 2782: Issue 2781 (https://github.com/zendframework/zf2/issues/2782)


## 2.0.2 (21 Sep 2012):

- 2383: Changed unreserved char definition in Zend\Uri (ZF2-533) and added shell
  escaping to the test runner (https://github.com/zendframework/zf2/pull/2383)
- 2393: Trying to solve issue ZF2-558
  (https://github.com/zendframework/zf2/pull/2393)
- 2398: Segment route: add fix for optional groups within optional groups
  (https://github.com/zendframework/zf2/pull/2398)
- 2400: Use 'Router' in http env and 'HttpRouter' in cli
  (https://github.com/zendframework/zf2/pull/2400)
- 2401: Better precision for userland fmod algorithm
  (https://github.com/zendframework/zf2/pull/2401)


## 2.0.1 (20 Sep 2012):

- 2285: Seed RouteMatch params as long as params is set. This permits setting an
  empty array. (https://github.com/zendframework/zf2/pull/2285)
- 2286: prepareNotFoundViewModel listner -  eventResult as ViewModel if set
  (https://github.com/zendframework/zf2/pull/2286)
- 2290: <span>$label</span> only when filled
  (https://github.com/zendframework/zf2/pull/2290)
- 2292: Allow (int)0 in coomments count in entry feed
  (https://github.com/zendframework/zf2/pull/2292)
- 2295: force to check className parameters
  (https://github.com/zendframework/zf2/pull/2295)
- 2296: mini-fix in controller plugin manager
  (https://github.com/zendframework/zf2/pull/2296)
- 2297: fixed phpdoc in Zend\Mvc\ApplicationInterface
  (https://github.com/zendframework/zf2/pull/2297)
- 2298: Update to Date element use statements to make it clearer which DateTime
  (https://github.com/zendframework/zf2/pull/2298)
- 2300: FormRow translate label fix (#ZF2-516)
  (https://github.com/zendframework/zf2/pull/2300)
- 2302: Notifications now to #zftalk.dev
  (https://github.com/zendframework/zf2/pull/2302)
- 2306: Fix several cs (https://github.com/zendframework/zf2/pull/2306)
- 2307: Removed comment about non existent Zend\_Tool
  (https://github.com/zendframework/zf2/pull/2307)
- 2308: Fix pluginmanager get method error
  (https://github.com/zendframework/zf2/pull/2308)
- 2309: Add consistency with event name
  (https://github.com/zendframework/zf2/pull/2309)
- 2310: Update library/Zend/Db/Sql/Select.php
  (https://github.com/zendframework/zf2/pull/2310)
- 2311: Version update (https://github.com/zendframework/zf2/pull/2311)
- 2312: Validator Translations (https://github.com/zendframework/zf2/pull/2312)
- 2313: ZF2-336: Zend\Form adds enctype attribute as multipart/form-data
  (https://github.com/zendframework/zf2/pull/2313)
- 2317: Make Fieldset constructor consistent with parent Element class
  (https://github.com/zendframework/zf2/pull/2317)
- 2321: ZF2-534 Zend\Log\Writer\Syslog prevents setting application name
  (https://github.com/zendframework/zf2/pull/2321)
- 2322: Jump to cache-storing instead of returning
  (https://github.com/zendframework/zf2/pull/2322)
- 2323: Conditional statements improved(minor changes).
  (https://github.com/zendframework/zf2/pull/2323)
- 2324: Fix for ZF2-517: Zend\Mail\Header\GenericHeader fails to parse empty
  header (https://github.com/zendframework/zf2/pull/2324)
- 2328: Wrong \_\_clone method (https://github.com/zendframework/zf2/pull/2328)
- 2331: added validation support for optgroups
  (https://github.com/zendframework/zf2/pull/2331)
- 2332: README-GIT update with optional pre-commit hook
  (https://github.com/zendframework/zf2/pull/2332)
- 2334: Mail\Message::getSubject() should return value the way it was set
  (https://github.com/zendframework/zf2/pull/2334)
- 2335: ZF2-511 Updated refactored names and other fixes
  (https://github.com/zendframework/zf2/pull/2335)
- 2336: ZF-546 Remove duplicate check for time
  (https://github.com/zendframework/zf2/pull/2336)
- 2337: ZF2-539 Input type of image should not have attribute value
  (https://github.com/zendframework/zf2/pull/2337)
- 2338: ZF2-543: removed linked but not implemented cache adapters
  (https://github.com/zendframework/zf2/pull/2338)
- 2341: Updated Zend_Validate.php pt_BR translation to 25.Jul.2011 EN Revision
  (https://github.com/zendframework/zf2/pull/2341)
- 2342: ZF2-549 Zend\Log\Formatter\ErrorHandler does not handle complex events
  (https://github.com/zendframework/zf2/pull/2342)
- 2346: updated Page\Mvc::isActive to check if the controller param was
  tinkered (https://github.com/zendframework/zf2/pull/2346)
- 2349: Zend\Feed Added unittests for more code coverage
  (https://github.com/zendframework/zf2/pull/2349)
- 2350: Bug in Zend\ModuleManager\Listener\LocatorRegistrationListener
  (https://github.com/zendframework/zf2/pull/2350)
- 2351: ModuleManagerInterface is never used
  (https://github.com/zendframework/zf2/pull/2351)
- 2352: Hotfix for AbstractDb and Csrf Validators
  (https://github.com/zendframework/zf2/pull/2352)
- 2354: Update library/Zend/Feed/Writer/AbstractFeed.php
  (https://github.com/zendframework/zf2/pull/2354)
- 2355: Allow setting CsrfValidatorOptions in constructor
  (https://github.com/zendframework/zf2/pull/2355)
- 2356: Update library/Zend/Http/Cookies.php
  (https://github.com/zendframework/zf2/pull/2356)
- 2357: Update library/Zend/Barcode/Object/AbstractObject.php
  (https://github.com/zendframework/zf2/pull/2357)
- 2358: Update library/Zend/ServiceManager/AbstractPluginManager.php
  (https://github.com/zendframework/zf2/pull/2358)
- 2359: Update library/Zend/Server/Method/Parameter.php
  (https://github.com/zendframework/zf2/pull/2359)
- 2361: Zend\Form Added extra unit tests and some code improvements
  (https://github.com/zendframework/zf2/pull/2361)
- 2364: Remove unused use statements
  (https://github.com/zendframework/zf2/pull/2364)
- 2365: Resolve undefined classes and constants
  (https://github.com/zendframework/zf2/pull/2365)
- 2366: fixed typo in Zend\View\HelperPluginManager
  (https://github.com/zendframework/zf2/pull/2366)
- 2370: Error handling in AbstractWriter::write using Zend\Stdlib\ErrorHandler
  (https://github.com/zendframework/zf2/pull/2370)
- 2372: Update library/Zend/ServiceManager/Config.php
  (https://github.com/zendframework/zf2/pull/2372)
- 2375: zend-inputfilter already requires
  (https://github.com/zendframework/zf2/pull/2375)
- 2376: Activate the new GitHub feature: Contributing Guidelines
  (https://github.com/zendframework/zf2/pull/2376)
- 2377: Update library/Zend/Mvc/Controller/AbstractController.php
  (https://github.com/zendframework/zf2/pull/2377)
- 2379: Typo in property name in Zend/Db/Metadata/Object/AbstractTableObject.php
  (https://github.com/zendframework/zf2/pull/2379)
- 2382: PHPDoc params in AbstractTableGateway.php
  (https://github.com/zendframework/zf2/pull/2382)
- 2384: Replace Router with Http router in url view helper
  (https://github.com/zendframework/zf2/pull/2384)
- 2387: Replace PHP internal fmod function because it gives false negatives
  (https://github.com/zendframework/zf2/pull/2387)
- 2388: Proposed fix for ZF2-569 validating float with trailing 0's (10.0,
  10.10) (https://github.com/zendframework/zf2/pull/2388)
- 2391: clone in Filter\FilterChain
  (https://github.com/zendframework/zf2/pull/2391)
- Security fix: a number of classes were not using the Escaper component in
  order to perform URL, HTML, and/or HTML attribute escaping. Please see
  http://framework.zend.com/security/advisory/ZF2012-03 for more details.
