.\" Copyright 1991, 1994, 1998  The Open Group
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.\" $XFree86: xc/programs/xmag/xmag.man,v 1.9 2006/01/09 15:01:36 dawes Exp $
.\"
.TH XMAG 1 __vendorversion__
.SH NAME
xmag \- magnify parts of the screen
.SH SYNOPSIS
.B xmag
[
.B \-mag
.I magfactor
] [
.B \-source
.I geom
] [
.I \-toolkitoption
\&.\|.\|. ]
.SH DESCRIPTION
The \fIxmag\fP program allows you to magnify portions of an X screen.  If no 
explicit region is specified, a square with the pointer in the upper left 
corner is displayed indicating the area to be enlarged.  The area can be 
dragged out to the desired size by pressing Button 2.  Once a region has 
been selected, a window is popped up showing a blown up version of the region 
in which each pixel in the source image is represented by a small square of 
the same color.  Pressing Button1 in the enlargement window 
shows the position and RGB value
of the pixel under the pointer until the button is released.  Typing ``Q'' 
or ``^C'' in the enlargement window exits the program.  The application has
5 buttons across its top.
\fIClose\fP deletes this particular magnification instance.
\fIReplace\fP brings up the rubber band selector again to select another
region for this magnification instance.
\fINew\fP brings up the rubber band
selector to create a new magnification instance.
\fICut\fP puts the magnification image into the primary selection.
\fIPaste\fP copies the primary selection buffer into \fIxmag\fP.
Note that you can cut and paste between \fIxmag\fP and the \fIbitmap\fP
program.  Resizing \fIxmag\fP resizes the magnification area.
\fIxmag\fP preserves
the colormap, visual, and window depth of the source.
.SH WIDGETS
\fIxmag\fP uses the X Toolkit and the Athena Widget Set.
The magnified image is displayed in the Scale widget.  
For more information, see the Athena Widget Set documentation.
Below is the widget structure of the \fIxmag\fP application.
Indentation indicates hierarchical  structure.  The widget class
name is given first, followed by the widget instance name.
.sp
.nf
	Xmag xmag
		RootWindow root
		TopLevelShell xmag
			Paned pane1
				Paned pane2
					Command close
					Command replace
					Command new
					Command select
					Command paste
					Label xmag label
				Paned pane2
					Scale scale
		OverrideShell pixShell 
			Label pixLabel
		
.fi
.SH OPTIONS
.TP 15
.B \-source\fI geom\fP
This option specifies the size and/or location of the source region 
on the screen.  By default, a 64x64 square is provided for the user to select 
an area of the screen.
.TP 15
.B \-mag\fI integer\fP
This option indicates the magnification to be used.  5 is the default.
.SH AUTHORS
Dave Sternlicht and Davor Matic, MIT X Consortium.
