#
#      Copyright (C) 2005-2008 Team XBMC
#      http://www.xbmc.org
#
#  This Program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This Program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with XBMC; see the file COPYING.  If not, write to
#  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#  http://www.gnu.org/copyleft/gpl.html
#

Enter = '\n'
from IMDbLib import IMDb, IMDbSearch, IMDbGallery


Search        = IMDbSearch('star wars').SearchResults
Movie         = IMDb(Search.values()[15])

Title         = Movie.Title
Genres        = Movie.Genres
Details       = Movie.Details

Gallery1      = IMDbGallery(Search.values()[15] + 'photogallery')
Gal1info      = Gallery1.Gal1_info
in_Gal1info   = Gal1info.keys()

Gallery2   = IMDbGallery(in_Gal1info[0])
Gal2info      = Gallery2.Gal2_info
in_Gal2info   = Gal2info.keys()

Gallery3   = IMDbGallery(in_Gal2info[0])
Gal3info      = Gallery3.Gal3_info
Gal3xy        = Gallery3.Gal3_xy


# Please uncomment the entries below to see the results of the above code.

#print Title
#print Genres
#print Details + Enter + Enter

#for a,b in zip(in_Gal1info,in_Gal2info):
#    print a
#    print b
#print Gal3info
#for a,b in zip(Gal3xy.keys(),Gal3xy.values()):
#    print '%s x %s' % (a,b)
#print Enter + Enter + Enter

print 'Executes IMDbSearch, returning a dictionary of Titles (keys) and thier respective URLs (values):'
print "    Search        = IMDbSearch('star wars').SearchResults" + Enter * 2
print 'Executes IMDb using the 15th entry (Star Wars) from "Search" results:'
print '    Movie         = IMDb(Search.values()[15])"' + Enter * 2
print 'Retrieves some movie information from "Movie" results:'
print '    Title         = Movie.Title' + Enter + '    Genres        = Movie.Genres' + Enter + '    Details       = Movie.Details' + Enter * 2
print 'Executes IMDbGallery Level 1 Information using the 15th (Star Wars) entry in "Search" results:'
print "    Gallery1      = IMDbGallery(Search.values()[15] + 'photogallery')" + Enter * 2
print 'Retrieves IMDbGallery Level 1 Information (Gal1_info) dictionary and saves the keys as: Gal1keys'
print '    Gal1info      = Gallery1.Gal1_info' + Enter + '    in_Gal1info   = Gal1info.keys()' + Enter * 2

print 'Executes IMDbGallery Level 2 Information using the first entry in: Gal1keys'
print '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~'
print '    Gallery2      = IMDbGallery(Gal1keys[0])' + Enter * 2

print 'Retrieves IMDbGallery Level 2 Information (Gal2_info) dictionary and saves the keys as: Gal2keys'
print '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~'
print '    Gal2info      = Gallery2.Gal2_info' + Enter + '    in_Gal2info   = Gal2info.keys()' + Enter * 2

print 'Executes IMDbGallery Level 3 Information using the first entry in: Gal2keys'
print '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~'
print '    Gallery3      = IMDbGallery(Gal2keys[0])' + Enter * 2

print 'Retrieves IMDbGallery Level 3 Information (Gal3_info) list and saves it as: Gal2keys'
print '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~'
print '    Gal3info      = Gallery3.Gal3_info' + Enter + '    Gal3xy        = Gallery3.Gal3_xy' + Enter * 2

print 'Some Examples Of How To Use The Results From Each Class'
print '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~' + Enter

print 'IMDb Example:'
print '~~~~~~~~~~~~~'
print '    print Title' + Enter + '    print Genres' + Enter + '    print Details' + Enter

print 'Results:'
print '~~~~~~~~'
print '    Star Wars (1977)'
print "    ['Action', 'Adventure', 'Fantasy', 'Sci-Fi']"
print '    Part IV in a George Lucas epic, Star Wars: A New Hope opens with a rebel ship being boarded by the tyrannical Darth Vader. The plot then follows the life of a simple farmboy, Luke Skywalker, as he and his newly met allies (Han Solo, Chewbacca, Ben Kenobi, C-3PO, R2-D2) attempt to rescue a rebel leader, Princess Leia, from the clutches of the Empire. The conclusion is culminated as the Rebels, including Skywalker and flying ace Wedge Antilles make an attack on the Empires most powerful and ominous weapon, the Death Star.' + Enter * 2

print 'IMDbGallery Example:'
print '~~~~~~~~~~~~~~~~~~~~'
print '    for a,b in zip(in_Gal1info,in_Gal2info):' + Enter + '        print a' + Enter + '        print b' + Enter
print "    for a,b in zip(Gal3xy.keys(),Gal3xy.values()):" + Enter + "        print ' %s x %s' % (a,b)" + Enter

print 'Results:'
print '~~~~~~~~'
print '    http://www.imdb.com/title/tt0076759/photogallery-mptv-0'
print '    http://www.imdb.com/gallery/mptv/1360/Mptv/1360/3748_0183.jpg?path=gallery&path_key=0076759'
print '    http://www.imdb.com/title/tt0076759/photogallery-hh-0'
print '    http://www.imdb.com/gallery/mptv/1360/Mptv/1360/3748_0174.jpg?path=gallery&path_key=0076759'
print '    http://i.imdb.com/Photos/Mptv/1360/3748_0183.jpg'
print '    258 x 420'

