/** @file RNAdos_cmdl.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef RNADOS_CMDL_H
#define RNADOS_CMDL_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef RNADOS_CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define RNADOS_CMDLINE_PARSER_PACKAGE "RNAdos"
#endif

#ifndef RNADOS_CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define RNADOS_CMDLINE_PARSER_PACKAGE_NAME "RNAdos"
#endif

#ifndef RNADOS_CMDLINE_PARSER_VERSION
/** @brief the program version */
#define RNADOS_CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct RNAdos_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *detailed_help_help; /**< @brief Print help, including all details and hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int verbose_flag;	/**< @brief Be verbose.
  
 (default=off).  */
  const char *verbose_help; /**< @brief Be verbose.
  
 help description.  */
  char * sequence_arg;	/**< @brief The RNA sequence (ACGU)
.  */
  char * sequence_orig;	/**< @brief The RNA sequence (ACGU)
 original value given at command line.  */
  const char *sequence_help; /**< @brief The RNA sequence (ACGU)
 help description.  */
  int max_energy_arg;	/**< @brief Structures are only counted until this threshold is reached. Default is 0 kcal/mol.
 (default='0').  */
  char * max_energy_orig;	/**< @brief Structures are only counted until this threshold is reached. Default is 0 kcal/mol.
 original value given at command line.  */
  const char *max_energy_help; /**< @brief Structures are only counted until this threshold is reached. Default is 0 kcal/mol.
 help description.  */
  int numThreads_arg;	/**< @brief Set the number of threads used for calculations (only available when compiled with OpenMP support)
  
.  */
  char * numThreads_orig;	/**< @brief Set the number of threads used for calculations (only available when compiled with OpenMP support)
  
 original value given at command line.  */
  const char *numThreads_help; /**< @brief Set the number of threads used for calculations (only available when compiled with OpenMP support)
  
 help description.  */
  double temp_arg;	/**< @brief Rescale energy parameters to a temperature of temp C. Default is 37C.
  
.  */
  char * temp_orig;	/**< @brief Rescale energy parameters to a temperature of temp C. Default is 37C.
  
 original value given at command line.  */
  const char *temp_help; /**< @brief Rescale energy parameters to a temperature of temp C. Default is 37C.
  
 help description.  */
  int dangles_arg;	/**< @brief How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops
 (default='2').  */
  char * dangles_orig;	/**< @brief How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops
 original value given at command line.  */
  const char *dangles_help; /**< @brief How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops
 help description.  */
  char * paramFile_arg;	/**< @brief Read energy parameters from paramfile, instead of using the default parameter set.
.  */
  char * paramFile_orig;	/**< @brief Read energy parameters from paramfile, instead of using the default parameter set.
 original value given at command line.  */
  const char *paramFile_help; /**< @brief Read energy parameters from paramfile, instead of using the default parameter set.
 help description.  */
  int hashtable_bits_arg;	/**< @brief Set the size of the hash table for each cell in the dp-matrices.
  
 (default='20').  */
  char * hashtable_bits_orig;	/**< @brief Set the size of the hash table for each cell in the dp-matrices.
  
 original value given at command line.  */
  const char *hashtable_bits_help; /**< @brief Set the size of the hash table for each cell in the dp-matrices.
  
 help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int detailed_help_given ;	/**< @brief Whether detailed-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int sequence_given ;	/**< @brief Whether sequence was given.  */
  unsigned int max_energy_given ;	/**< @brief Whether max-energy was given.  */
  unsigned int numThreads_given ;	/**< @brief Whether numThreads was given.  */
  unsigned int temp_given ;	/**< @brief Whether temp was given.  */
  unsigned int dangles_given ;	/**< @brief Whether dangles was given.  */
  unsigned int paramFile_given ;	/**< @brief Whether paramFile was given.  */
  unsigned int hashtable_bits_given ;	/**< @brief Whether hashtable-bits was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct RNAdos_cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure RNAdos_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure RNAdos_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *RNAdos_args_info_purpose;
/** @brief the usage string of the program */
extern const char *RNAdos_args_info_usage;
/** @brief the description string of the program */
extern const char *RNAdos_args_info_description;
/** @brief all the lines making the help output */
extern const char *RNAdos_args_info_help[];
/** @brief all the lines making the detailed help output (including hidden options and details) */
extern const char *RNAdos_args_info_detailed_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAdos_cmdline_parser (int argc, char **argv,
  struct RNAdos_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use RNAdos_cmdline_parser_ext() instead
 */
int RNAdos_cmdline_parser2 (int argc, char **argv,
  struct RNAdos_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAdos_cmdline_parser_ext (int argc, char **argv,
  struct RNAdos_args_info *args_info,
  struct RNAdos_cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAdos_cmdline_parser_dump(FILE *outfile,
  struct RNAdos_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAdos_cmdline_parser_file_save(const char *filename,
  struct RNAdos_args_info *args_info);

/**
 * Print the help
 */
void RNAdos_cmdline_parser_print_help(void);
/**
 * Print the detailed help (including hidden options and details)
 */
void RNAdos_cmdline_parser_print_detailed_help(void);
/**
 * Print the version
 */
void RNAdos_cmdline_parser_print_version(void);

/**
 * Initializes all the fields a RNAdos_cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void RNAdos_cmdline_parser_params_init(struct RNAdos_cmdline_parser_params *params);

/**
 * Allocates dynamically a RNAdos_cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized RNAdos_cmdline_parser_params structure
 */
struct RNAdos_cmdline_parser_params *RNAdos_cmdline_parser_params_create(void);

/**
 * Initializes the passed RNAdos_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void RNAdos_cmdline_parser_init (struct RNAdos_args_info *args_info);
/**
 * Deallocates the string fields of the RNAdos_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void RNAdos_cmdline_parser_free (struct RNAdos_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int RNAdos_cmdline_parser_required (struct RNAdos_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* RNADOS_CMDL_H */
