/*
  File autogenerated by gengetopt version 2.22.6
  generated with the following command:
  /usr/bin/gengetopt -i RNAcofold.ggo --file-name=RNAcofold_cmdl --include-getopt --default-optional --unamed-opts --func-name=RNAcofold_cmdline_parser --arg-struct-name=RNAcofold_args_info

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif


#include "RNAcofold_cmdl.h"

const char *RNAcofold_args_info_purpose = "calculate secondary structures of two RNAs with dimerization";

const char *RNAcofold_args_info_usage = "Usage: RNAcofold [OPTIONS]... [FILES]...";

const char *RNAcofold_args_info_versiontext = "";

const char *RNAcofold_args_info_description = "The program works much like RNAfold, but allows one to specify two RNA\nsequences which are then allowed to form a dimer structure. RNA sequences are\nread from stdin in the usual format, i.e. each line of input corresponds to one\nsequence, except for lines starting with \">\" which contain the name of the\nnext sequence.\nTo compute the hybrid structure of two molecules, the two sequences must be\nconcatenated using the \'&\' character as separator.\nRNAcofold can compute minimum free energy (mfe) structures, as well as\npartition function (pf) and base pairing probability matrix (using the -p\nswitch)\nSince dimer formation is concentration dependent, RNAcofold can be used to\ncompute equilibrium concentrations for all five monomer and (homo/hetero)-dimer\nspecies, given input concentrations for the monomers.\nOutput consists of the mfe structure in bracket notation as well as PostScript\nstructure plots and \"dot plot\" files containing the pair probabilities, see\nthe RNAfold man page for details. In the dot plots a cross marks the chain\nbreak between the two concatenated sequences.\nThe program will continue to read new sequences until a line consisting of the\nsingle character @ or an end of file condition is encountered.\n\n";

const char *RNAcofold_args_info_detailed_help[] = {
  "  -h, --help                    Print help and exit",
  "      --detailed-help           Print help, including all details and hidden\n                                  options, and exit",
  "      --full-help               Print help, including hidden options, and exit",
  "  -V, --version                 Print version and exit",
  "\nGeneral Options:",
  "  Command line options which alter the general behavior of this program\n\n",
  "  -v, --verbose                 Be verbose.\n\n                                    (default=off)",
  "  -j, --jobs[=number]           Split batch input into jobs and start\n                                  processing in parallel using multiple\n                                  threads. A value of 0 indicates to use as\n                                  many parallel threads as computation cores\n                                  are available.\n                                    (default=`0')",
  "  Default processing of input data is performed in a serial fashion, i.e. one\n  sequence pair at a time. Using this switch, a user can instead start the\n  computation for many sequence pairs in the input in parallel. RNAcofold will\n  create as many parallel computation slots as specified and assigns input\n  sequences of the input file(s) to the available slots. Note, that this\n  increases memory consumption since input alignments have to be kept in memory\n  until an empty compute slot is available and each running job requires its\n  own dynamic programming matrices.\n\n",
  "      --unordered               Do not try to keep output in order with input\n                                  while parallel processing is in place.\n                                    (default=off)",
  "  When parallel input processing (--jobs flag) is enabled, the order in which\n  input is processed depends on the host machines job scheduler. Therefore, any\n  output to stdout or files generated by this program will most likely not\n  follow the order of the corresponding input data set. The default of\n  RNAcofold is to use a specialized data structure to still keep the results\n  output in order with the input data. However, this comes with a trade-off in\n  terms of memory consumption, since all output must be kept in memory for as\n  long as no chunks of consecutive, ordered output are available. By setting\n  this flag, RNAcofold will not buffer individual results but print them as\n  soon as they have been computated.\n\n",
  "      --noPS                    Do not produce postscript drawing of the mfe\n                                  structure.\n\n                                    (default=off)",
  "      --noconv                  Do not automatically substitute nucleotide\n                                  \"T\" with \"U\"\n\n                                    (default=off)",
  "      --auto-id                 Automatically generate an ID for each sequence.\n                                    (default=off)",
  "  The default mode of RNAcofold is to automatically determine an ID from the\n  input sequence data if the input file format allows to do that. Sequence IDs\n  are usually given in the FASTA header of input sequences. If this flag is\n  active, RNAcofold ignores any IDs retrieved from the input and automatically\n  generates an ID for each sequence. This ID consists of a prefix and an\n  increasing number. This flag can also be used to add a FASTA header to the\n  output even if the input has none.\n\n",
  "      --id-prefix=prefix        Prefix for automatically generated IDs (as used\n                                  in output file names)\n\n                                    (default=`sequence')",
  "  If this parameter is set, each sequence will be prefixed with the provided\n  string. Hence, the output files will obey the following naming scheme:\n  \"prefix_xxxx_ss.ps\" (secondary structure plot), \"prefix_xxxx_dp.ps\"\n  (dot-plot), \"prefix_xxxx_dp2.ps\" (stack probabilities), etc. where xxxx is\n  the sequence number. Note: Setting this parameter implies --auto-id.\n\n",
  "      --id-delim=delimiter      Change the delimiter between prefix and\n                                  increasing number for automatically generated\n                                  IDs (as used in output file names)\n\n                                    (default=`_')",
  "  This parameter can be used to change the default delimiter \"_\" between\n   the prefix string and the increasing number for automatically generated ID.\n\n",
  "      --id-digits=INT           Specify the number of digits of the counter in\n                                  automatically generated alignment IDs.\n                                    (default=`4')",
  "  When alignments IDs are automatically generated, they receive an increasing\n  number, starting with 1. This number will always be left-padded by leading\n  zeros, such that the number takes up a certain width. Using this parameter,\n  the width can be specified to the users need. We allow numbers in the range\n  [1:18]. This option implies --auto-id.\n\n",
  "      --id-start=LONG           Specify the first number in automatically\n                                  generated alignment IDs.\n                                    (default=`1')",
  "  When sequence IDs are automatically generated, they receive an increasing\n  number, usually starting with 1. Using this parameter, the first number can\n  be specified to the users requirements. Note: negative numbers are not\n  allowed.\n  Note: Setting this parameter implies to ignore any IDs retrieved from the\n  input data, i.e. it activates the --auto-id flag.\n\n",
  "      --filename-delim=delimiter\n                                Change the delimiting character that is used\n                                  for sanitized filenames\n\n                                    (default=`ID-delimiter')",
  "  This parameter can be used to change the delimiting character used while\n  sanitizing filenames, i.e. replacing invalid characters. Note, that the\n  default delimiter ALWAYS is the first character of the \"ID delimiter\" as\n  supplied through the --id-delim option. If the delimiter is a whitespace\n  character or empty, invalid characters will be simply removed rather than\n  substituted. Currently, we regard the following characters as illegal for use\n  in filenames: backslash '\', slash '/', question mark '?', percent sign '%',\n  asterisk '*', colon ':', pipe symbol '|', double quote '\"', triangular\n  brackets '<' and '>'.\n\n",
  "      --filename-full           Use full FASTA header to create filenames\n\n                                    (default=off)",
  "  This parameter can be used to deactivate the default behavior of limiting\n  output filenames to the first word of the sequence ID. Consider the following\n  example: An input with FASTA header \">NM_0001 Homo Sapiens some gene\"\n  usually produces output files with the prefix \"NM_0001\" without the\n  additional data available in the FASTA header, e.g. \"NM_0001_ss.ps\" for\n  secondary structure plots. With this flag set, no truncation of the output\n  filenames is done, i.e. output filenames receive the full FASTA header data\n  as prefixes. Note, however, that invalid characters (such as whitespace) will\n  be substituted by a delimiting character or simply removed, (see also the\n  parameter option --filename-delim).\n\n",
  "      --output-format=format-character\n                                Change the default output format\n\n                                    (default=`V')",
  "  The following output formats are currently supported:\n   ViennaRNA format (V), Delimiter-separated format (D) also known as CSV\n  format.\n\n",
  "      --csv-delim=delimiter     Change the delimiting character for\n                                  Delimiter-separated output format, such as\n                                  CSV\n\n                                    (default=`,')",
  "  Delimiter-separated output defaults to comma separated values (CSV), i.e. all\n  data in one data set is delimited by a comma character. This option allows\n  one to change the delimiting character to something else. Note, to switch to\n  tab-separated data, use $'\\t' as delimiting character.\n\n",
  "      --csv-noheader            Do not print header for Delimiter-separated\n                                  output, such as CSV\n\n                                    (default=off)",
  "\nStructure Constraints:",
  "  Command line options to interact with the structure constraints feature of\n  this program\n\n",
  "      --maxBPspan=INT           Set the maximum base pair span\n\n                                    (default=`-1')",
  "  -C, --constraint[=<filename>] Calculate structures subject to constraints.\n                                    (default=`')",
  "  The program reads first the sequence, then a string containing constraints on\n  the structure encoded with the symbols:\n\n  . (no constraint for this base)\n\n  | (the corresponding base has to be paired\n\n  x (the base is unpaired)\n\n  < (base i is paired with a base j>i)\n\n  > (base i is paired with a base j<i)\n\n  and matching brackets ( ) (base i pairs base j)\n\n  With the exception of \"|\", constraints will disallow all pairs conflicting\n  with the constraint. This is usually sufficient to enforce the constraint,\n  but occasionally a base may stay unpaired in spite of constraints. PF folding\n  ignores constraints of type \"|\".\n\n",
  "      --batch                   Use constraints for multiple sequences.\n                                    (default=off)",
  "  Usually, constraints provided from input file only apply to a single input\n  sequence. Therefore, RNAcofold will stop its computation and quit after the\n  first input sequence was processed. Using this switch, RNAcofold processes\n  multiple input sequences and applies the same provided constraints to each of\n  them.\n\n",
  "      --canonicalBPonly         Remove non-canonical base pairs from the\n                                  structure constraint\n\n                                    (default=off)",
  "      --enforceConstraint       Enforce base pairs given by round brackets ( )\n                                  in structure constraint\n\n                                    (default=off)",
  "      --shape=<filename>        Use SHAPE reactivity data to guide structure\n                                  predictions\n\n",
  "      --shapeMethod=[D/Z/W] + [optional parameters]\n                                Select method to incorporate SHAPE reactivity\n                                  data.\n                                    (default=`D')",
  "  The following methods can be used to convert SHAPE reactivities into pseudo\n  energy contributions.\n\n  'D': Convert by using a linear equation according to Deigan et al 2009. The\n  calculated pseudo energies will be applied for every nucleotide involved in a\n  stacked pair. This method is recognized by a capital 'D' in the provided\n  parameter, i.e.: --shapeMethod=\"D\" is the default setting. The slope 'm'\n  and the intercept 'b' can be set to a non-default value if necessary,\n  otherwise m=1.8 and b=-0.6. To alter these parameters, e.g. m=1.9 and b=-0.7,\n  use a parameter string like this: --shapeMethod=\"Dm1.9b-0.7\". You may also\n  provide only one of the two parameters like: --shapeMethod=\"Dm1.9\" or\n  --shapeMethod=\"Db-0.7\".\n\n  'Z': Convert SHAPE reactivities to pseudo energies according to Zarringhalam\n  et al 2012. SHAPE reactivities will be converted to pairing probabilities by\n  using linear mapping. Aberration from the observed pairing probabilities will\n  be penalized during the folding recursion. The magnitude of the penalties can\n  affected by adjusting the factor beta (e.g. --shapeMethod=\"Zb0.8\").\n\n  'W': Apply a given vector of perturbation energies to unpaired nucleotides\n  according to Washietl et al 2012. Perturbation vectors can be calculated by\n  using RNApvmin.\n\n",
  "      --shapeConversion=M/C/S/L/O  + [optional parameters]\n                                Select method to convert SHAPE reactivities to\n                                  pairing probabilities.\n                                    (default=`O')",
  "  This parameter is useful when dealing with the SHAPE incorporation according\n  to Zarringhalam et al. The following methods can be used to convert SHAPE\n  reactivities into the probability for a certain nucleotide to be unpaired.\n\n  'M': Use linear mapping according to Zarringhalam et al.\n  'C': Use a cutoff-approach to divide into paired and unpaired nucleotides\n  (e.g. \"C0.25\")\n  'S': Skip the normalizing step since the input data already represents\n  probabilities for being unpaired rather than raw reactivity values\n  'L': Use a linear model to convert the reactivity into a probability for\n  being unpaired (e.g. \"Ls0.68i0.2\" to use a slope of 0.68 and an intercept\n  of 0.2)\n  'O': Use a linear model to convert the log of the reactivity into a\n  probability for being unpaired (e.g. \"Os1.6i-2.29\" to use a slope of 1.6\n  and an intercept of -2.29)\n\n",
  "      --commands=<filename>     Read additional commands from file\n",
  "  Commands include hard and soft constraints, but also structure motifs in\n  hairpin and interior loops that need to be treeted differently. Furthermore,\n  commands can be set for unstructured and structured domains.\n\n",
  "\nAlgorithms:",
  "  Select additional algorithms which should be included in the calculations.\n  The Minimum free energy (MFE) and a structure representative are calculated\n  in any case.\n\n",
  "  -p, --partfunc[=INT]          Calculate the partition function and base\n                                  pairing probability matrix in addition to the\n                                  mfe structure. Default is calculation of mfe\n                                  structure only.\n                                    (default=`1')",
  "  In addition to the MFE structure we print a coarse representation of the pair\n  probabilities in form of a pseudo bracket notation, followed by the ensemble\n  free energy, as well as the centroid structure derived from the pair\n  probabilities together with its free energy and distance to the ensemble.\n  Finally it prints the frequency of the mfe structure, and the structural\n  diversity (mean distance between the structures in the ensemble).\n  See the description of pf_fold() and mean_bp_dist() and centroid() in the\n  RNAlib documentation for details.\n  Note that unless you also specify -d2 or -d0, the partition function and mfe\n  calculations will use a slightly different energy model. See the discussion\n  of dangling end options below.\n\n  An additionally passed value to this option changes the behavior of partition\n  function calculation:\n\n   In order to calculate the partition function but not the pair probabilities\n  use the -p0 option and save about\n   50% in runtime. This prints the ensemble free energy -kT ln(Z).\n\n",
  "  -a, --all_pf[=INT]            Compute the partition function and free\n                                  energies not only of the hetero-dimer\n                                  consisting of the two input sequences (the\n                                  \"AB dimer\"), but also of the homo-dimers AA\n                                  and BB as well as A and B monomers.\n                                    (default=`1')",
  "  The output will contain the free energies for each of these species, as well\n  as 5 dot plots containing the conditional pair probabilities, called\n  \"ABname5.ps\", \"AAname5.ps\" and so on. For later use, these dot plot files\n  also contain the free energy of the ensemble as a comment. Using -a\n  automatically switches on the -p option. Base pair probability computations\n  may be turned off altogether by providing \"0\" as an argument to this\n  parameter. In that case, no dot plot files will be generated.\n\n",
  "  -c, --concentrations          In addition to everything listed under the -a\n                                  option, read in initial monomer\n                                  concentrations and compute the expected\n                                  equilibrium concentrations of the 5 possible\n                                  species (AB, AA, BB, A, B).\n                                    (default=off)",
  "  Start concentrations are read from stdin (unless the -f option is used) in\n  [mol/l], equilibrium concentrations are given realtive to the sum of the two\n  inputs. An arbitrary number of initial concentrations can be specified (one\n  pair of concentrations per line).\n\n",
  "  -f, --concfile=filename       Specify a file with initial concentrations for\n                                  the two sequences.",
  "  The table consits of arbitrary many lines with just two numbers (the\n  concentration of sequence A and B). This option will automatically toggle the\n  -c (and thus -a and -p) options (see above).\n\n",
  "      --centroid                Compute the centroid structure.\n                                    (default=off)",
  "  Additionally to the MFE structure, compute the centroid representative of the\n  structure ensemble. Here, we apply the base pair distance as distance\n  measure, and report the structure that minimizes its Boltzmann weighted base\n  pair distance to the rest of the ensemble. Computing the centroid structure\n  requires equilibrium base pair probabilities. Therefore, this option implies\n  the -p switch. For historical reasons, the centroid structure output is\n  deactivated by default.\n\n",
  "      --MEA[=gamma]             Calculate an MEA (maximum expected accuracy)\n                                  structure, where the expected accuracy is\n                                  computed from the pair probabilities: each\n                                  base pair (i,j) gets a score 2*gamma*p_ij and\n                                  the score of an unpaired base is given by the\n                                  probability of not forming a pair.\n                                    (default=`1.')",
  "  The parameter gamma tunes the importance of correctly predicted pairs versus\n  unpaired bases. Thus, for small values of gamma the MEA structure will\n  contain only pairs with very high probability.\n  Using --MEA implies -p for computing the pair probabilities.\n\n",
  "  -S, --pfScale=scaling factor  In the calculation of the pf use scale*mfe as\n                                  an estimate for the ensemble free energy\n                                  (used to avoid overflows).\n",
  "  The default is 1.07, useful values are 1.0 to 1.2. Occasionally needed for\n  long sequences.\n  You can also recompile the program to use double precision (see the README\n  file).\n\n",
  "      --bppmThreshold=<value>   Set the threshold for base pair probabilities\n                                  included in the postscript output\n                                    (default=`1e-5')",
  "  By setting the threshold the base pair probabilities that are included in the\n  output can be varied. By default only those exceeding 1e-5 in probability\n  will be shown as squares in the dot plot. Changing the threshold to any other\n  value allows for increase or decrease of data.\n\n",
  "  -g, --gquad                   Incoorporate G-Quadruplex formation into the\n                                  structure prediction algorithm.\n\n                                    (default=off)",
  "\nModel Details:",
  "  -T, --temp=DOUBLE             Rescale energy parameters to a temperature of\n                                  temp C. Default is 37C.\n\n",
  "  -4, --noTetra                 Do not include special tabulated stabilizing\n                                  energies for tri-, tetra- and hexaloop\n                                  hairpins.\n\n                                    (default=off)",
  "  Mostly for testing.\n\n",
  "  -d, --dangles=INT             How to treat \"dangling end\" energies for\n                                  bases adjacent to helices in free ends and\n                                  multi-loops\n                                    (default=`2')",
  "  \n  With -d1 only unpaired bases can participate in at most one dangling end.\n  With -d2 this check is ignored, dangling energies will be added for the bases\n  adjacent to a helix on both sides in any case; this is the default for mfe\n  and partition function folding (-p).\n  The option -d0 ignores dangling ends altogether (mostly for debugging).\n  With -d3 mfe folding will allow coaxial stacking of adjacent helices in\n  multi-loops. At the moment the implementation will not allow coaxial stacking\n  of the two interior pairs in a loop of degree 3 and works only for mfe\n  folding.\n\n  Note that with -d1 and -d3 only the MFE computations will be using this\n  setting while partition function uses -d2 setting, i.e. dangling ends will be\n  treated differently.\n\n",
  "      --noLP                    Produce structures without lonely pairs\n                                  (helices of length 1).\n                                    (default=off)",
  "  For partition function folding this only disallows pairs that can only occur\n  isolated. Other pairs may still occasionally occur as helices of length 1.\n\n",
  "      --noGU                    Do not allow GU pairs\n\n                                    (default=off)",
  "      --noClosingGU             Do not allow GU pairs at the end of helices\n\n                                    (default=off)",
  "  -P, --paramFile=paramfile     Read energy parameters from paramfile, instead\n                                  of using the default parameter set.\n",
  "  Different sets of energy parameters for RNA and DNA should accompany your\n  distribution.\n  See the RNAlib documentation for details on the file format. When passing the\n  placeholder file name \"DNA\", DNA parameters are loaded without the need to\n  actually specify any input file.\n\n",
  "      --nsp=STRING              Allow other pairs in addition to the usual\n                                  AU,GC,and GU pairs.\n",
  "  Its argument is a comma separated list of additionally allowed pairs. If the\n  first character is a \"-\" then AB will imply that AB and BA are allowed\n  pairs.\n  e.g. RNAcofold -nsp -GA  will allow GA and AG pairs. Nonstandard pairs are\n  given 0 stacking energy.\n\n",
  "  -e, --energyModel=INT         Rarely used option to fold sequences from the\n                                  artificial ABCD... alphabet, where A pairs B,\n                                  C-D etc.  Use the energy parameters for GC\n                                  (-e 1) or AU (-e 2) pairs.\n\n",
  "      --betaScale=DOUBLE        Set the scaling of the Boltzmann factors\n                                    (default=`1.')",
  "  The argument provided with this option enables to scale the thermodynamic\n  temperature used in the Boltzmann factors independently from the temperature\n  used to scale the individual energy contributions of the loop types. The\n  Boltzmann factors then become exp(-dG/(kT*betaScale)) where k is the\n  Boltzmann constant, dG the free energy contribution of the state and T the\n  absolute temperature.\n\n",
  "\nIf in doubt our program is right, nature is at fault.\nComments should be sent to rna@tbi.univie.ac.at.\n\n",
    0
};
static void
init_full_help_array(void)
{
  RNAcofold_args_info_full_help[0] = RNAcofold_args_info_detailed_help[0];
  RNAcofold_args_info_full_help[1] = RNAcofold_args_info_detailed_help[1];
  RNAcofold_args_info_full_help[2] = RNAcofold_args_info_detailed_help[2];
  RNAcofold_args_info_full_help[3] = RNAcofold_args_info_detailed_help[3];
  RNAcofold_args_info_full_help[4] = RNAcofold_args_info_detailed_help[4];
  RNAcofold_args_info_full_help[5] = RNAcofold_args_info_detailed_help[5];
  RNAcofold_args_info_full_help[6] = RNAcofold_args_info_detailed_help[6];
  RNAcofold_args_info_full_help[7] = RNAcofold_args_info_detailed_help[7];
  RNAcofold_args_info_full_help[8] = RNAcofold_args_info_detailed_help[9];
  RNAcofold_args_info_full_help[9] = RNAcofold_args_info_detailed_help[11];
  RNAcofold_args_info_full_help[10] = RNAcofold_args_info_detailed_help[12];
  RNAcofold_args_info_full_help[11] = RNAcofold_args_info_detailed_help[13];
  RNAcofold_args_info_full_help[12] = RNAcofold_args_info_detailed_help[15];
  RNAcofold_args_info_full_help[13] = RNAcofold_args_info_detailed_help[17];
  RNAcofold_args_info_full_help[14] = RNAcofold_args_info_detailed_help[19];
  RNAcofold_args_info_full_help[15] = RNAcofold_args_info_detailed_help[21];
  RNAcofold_args_info_full_help[16] = RNAcofold_args_info_detailed_help[23];
  RNAcofold_args_info_full_help[17] = RNAcofold_args_info_detailed_help[25];
  RNAcofold_args_info_full_help[18] = RNAcofold_args_info_detailed_help[27];
  RNAcofold_args_info_full_help[19] = RNAcofold_args_info_detailed_help[29];
  RNAcofold_args_info_full_help[20] = RNAcofold_args_info_detailed_help[31];
  RNAcofold_args_info_full_help[21] = RNAcofold_args_info_detailed_help[32];
  RNAcofold_args_info_full_help[22] = RNAcofold_args_info_detailed_help[33];
  RNAcofold_args_info_full_help[23] = RNAcofold_args_info_detailed_help[34];
  RNAcofold_args_info_full_help[24] = RNAcofold_args_info_detailed_help[35];
  RNAcofold_args_info_full_help[25] = RNAcofold_args_info_detailed_help[37];
  RNAcofold_args_info_full_help[26] = RNAcofold_args_info_detailed_help[39];
  RNAcofold_args_info_full_help[27] = RNAcofold_args_info_detailed_help[40];
  RNAcofold_args_info_full_help[28] = RNAcofold_args_info_detailed_help[41];
  RNAcofold_args_info_full_help[29] = RNAcofold_args_info_detailed_help[42];
  RNAcofold_args_info_full_help[30] = RNAcofold_args_info_detailed_help[44];
  RNAcofold_args_info_full_help[31] = RNAcofold_args_info_detailed_help[46];
  RNAcofold_args_info_full_help[32] = RNAcofold_args_info_detailed_help[48];
  RNAcofold_args_info_full_help[33] = RNAcofold_args_info_detailed_help[49];
  RNAcofold_args_info_full_help[34] = RNAcofold_args_info_detailed_help[50];
  RNAcofold_args_info_full_help[35] = RNAcofold_args_info_detailed_help[52];
  RNAcofold_args_info_full_help[36] = RNAcofold_args_info_detailed_help[54];
  RNAcofold_args_info_full_help[37] = RNAcofold_args_info_detailed_help[56];
  RNAcofold_args_info_full_help[38] = RNAcofold_args_info_detailed_help[58];
  RNAcofold_args_info_full_help[39] = RNAcofold_args_info_detailed_help[60];
  RNAcofold_args_info_full_help[40] = RNAcofold_args_info_detailed_help[62];
  RNAcofold_args_info_full_help[41] = RNAcofold_args_info_detailed_help[64];
  RNAcofold_args_info_full_help[42] = RNAcofold_args_info_detailed_help[66];
  RNAcofold_args_info_full_help[43] = RNAcofold_args_info_detailed_help[67];
  RNAcofold_args_info_full_help[44] = RNAcofold_args_info_detailed_help[68];
  RNAcofold_args_info_full_help[45] = RNAcofold_args_info_detailed_help[69];
  RNAcofold_args_info_full_help[46] = RNAcofold_args_info_detailed_help[71];
  RNAcofold_args_info_full_help[47] = RNAcofold_args_info_detailed_help[73];
  RNAcofold_args_info_full_help[48] = RNAcofold_args_info_detailed_help[75];
  RNAcofold_args_info_full_help[49] = RNAcofold_args_info_detailed_help[76];
  RNAcofold_args_info_full_help[50] = RNAcofold_args_info_detailed_help[77];
  RNAcofold_args_info_full_help[51] = RNAcofold_args_info_detailed_help[79];
  RNAcofold_args_info_full_help[52] = RNAcofold_args_info_detailed_help[81];
  RNAcofold_args_info_full_help[53] = RNAcofold_args_info_detailed_help[82];
  RNAcofold_args_info_full_help[54] = RNAcofold_args_info_detailed_help[84];
  RNAcofold_args_info_full_help[55] = 0; 
  
}

const char *RNAcofold_args_info_full_help[56];

static void
init_help_array(void)
{
  RNAcofold_args_info_help[0] = RNAcofold_args_info_detailed_help[0];
  RNAcofold_args_info_help[1] = RNAcofold_args_info_detailed_help[1];
  RNAcofold_args_info_help[2] = RNAcofold_args_info_detailed_help[2];
  RNAcofold_args_info_help[3] = RNAcofold_args_info_detailed_help[3];
  RNAcofold_args_info_help[4] = RNAcofold_args_info_detailed_help[4];
  RNAcofold_args_info_help[5] = RNAcofold_args_info_detailed_help[5];
  RNAcofold_args_info_help[6] = RNAcofold_args_info_detailed_help[6];
  RNAcofold_args_info_help[7] = RNAcofold_args_info_detailed_help[7];
  RNAcofold_args_info_help[8] = RNAcofold_args_info_detailed_help[11];
  RNAcofold_args_info_help[9] = RNAcofold_args_info_detailed_help[12];
  RNAcofold_args_info_help[10] = RNAcofold_args_info_detailed_help[13];
  RNAcofold_args_info_help[11] = RNAcofold_args_info_detailed_help[15];
  RNAcofold_args_info_help[12] = RNAcofold_args_info_detailed_help[32];
  RNAcofold_args_info_help[13] = RNAcofold_args_info_detailed_help[33];
  RNAcofold_args_info_help[14] = RNAcofold_args_info_detailed_help[34];
  RNAcofold_args_info_help[15] = RNAcofold_args_info_detailed_help[35];
  RNAcofold_args_info_help[16] = RNAcofold_args_info_detailed_help[37];
  RNAcofold_args_info_help[17] = RNAcofold_args_info_detailed_help[39];
  RNAcofold_args_info_help[18] = RNAcofold_args_info_detailed_help[40];
  RNAcofold_args_info_help[19] = RNAcofold_args_info_detailed_help[41];
  RNAcofold_args_info_help[20] = RNAcofold_args_info_detailed_help[42];
  RNAcofold_args_info_help[21] = RNAcofold_args_info_detailed_help[44];
  RNAcofold_args_info_help[22] = RNAcofold_args_info_detailed_help[48];
  RNAcofold_args_info_help[23] = RNAcofold_args_info_detailed_help[49];
  RNAcofold_args_info_help[24] = RNAcofold_args_info_detailed_help[50];
  RNAcofold_args_info_help[25] = RNAcofold_args_info_detailed_help[52];
  RNAcofold_args_info_help[26] = RNAcofold_args_info_detailed_help[54];
  RNAcofold_args_info_help[27] = RNAcofold_args_info_detailed_help[56];
  RNAcofold_args_info_help[28] = RNAcofold_args_info_detailed_help[58];
  RNAcofold_args_info_help[29] = RNAcofold_args_info_detailed_help[60];
  RNAcofold_args_info_help[30] = RNAcofold_args_info_detailed_help[66];
  RNAcofold_args_info_help[31] = RNAcofold_args_info_detailed_help[67];
  RNAcofold_args_info_help[32] = RNAcofold_args_info_detailed_help[68];
  RNAcofold_args_info_help[33] = RNAcofold_args_info_detailed_help[69];
  RNAcofold_args_info_help[34] = RNAcofold_args_info_detailed_help[71];
  RNAcofold_args_info_help[35] = RNAcofold_args_info_detailed_help[73];
  RNAcofold_args_info_help[36] = RNAcofold_args_info_detailed_help[75];
  RNAcofold_args_info_help[37] = RNAcofold_args_info_detailed_help[76];
  RNAcofold_args_info_help[38] = RNAcofold_args_info_detailed_help[77];
  RNAcofold_args_info_help[39] = RNAcofold_args_info_detailed_help[84];
  RNAcofold_args_info_help[40] = 0; 
  
}

const char *RNAcofold_args_info_help[41];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_LONG
  , ARG_FLOAT
  , ARG_DOUBLE
} RNAcofold_cmdline_parser_arg_type;

static
void clear_given (struct RNAcofold_args_info *args_info);
static
void clear_args (struct RNAcofold_args_info *args_info);

static int
RNAcofold_cmdline_parser_internal (int argc, char **argv, struct RNAcofold_args_info *args_info,
                        struct RNAcofold_cmdline_parser_params *params, const char *additional_error);

static int
RNAcofold_cmdline_parser_required2 (struct RNAcofold_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct RNAcofold_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->detailed_help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->jobs_given = 0 ;
  args_info->unordered_given = 0 ;
  args_info->noPS_given = 0 ;
  args_info->noconv_given = 0 ;
  args_info->auto_id_given = 0 ;
  args_info->id_prefix_given = 0 ;
  args_info->id_delim_given = 0 ;
  args_info->id_digits_given = 0 ;
  args_info->id_start_given = 0 ;
  args_info->filename_delim_given = 0 ;
  args_info->filename_full_given = 0 ;
  args_info->output_format_given = 0 ;
  args_info->csv_delim_given = 0 ;
  args_info->csv_noheader_given = 0 ;
  args_info->maxBPspan_given = 0 ;
  args_info->constraint_given = 0 ;
  args_info->batch_given = 0 ;
  args_info->canonicalBPonly_given = 0 ;
  args_info->enforceConstraint_given = 0 ;
  args_info->shape_given = 0 ;
  args_info->shapeMethod_given = 0 ;
  args_info->shapeConversion_given = 0 ;
  args_info->commands_given = 0 ;
  args_info->partfunc_given = 0 ;
  args_info->all_pf_given = 0 ;
  args_info->concentrations_given = 0 ;
  args_info->concfile_given = 0 ;
  args_info->centroid_given = 0 ;
  args_info->MEA_given = 0 ;
  args_info->pfScale_given = 0 ;
  args_info->bppmThreshold_given = 0 ;
  args_info->gquad_given = 0 ;
  args_info->temp_given = 0 ;
  args_info->noTetra_given = 0 ;
  args_info->dangles_given = 0 ;
  args_info->noLP_given = 0 ;
  args_info->noGU_given = 0 ;
  args_info->noClosingGU_given = 0 ;
  args_info->paramFile_given = 0 ;
  args_info->nsp_given = 0 ;
  args_info->energyModel_given = 0 ;
  args_info->betaScale_given = 0 ;
}

static
void clear_args (struct RNAcofold_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->verbose_flag = 0;
  args_info->jobs_arg = 0;
  args_info->jobs_orig = NULL;
  args_info->unordered_flag = 0;
  args_info->noPS_flag = 0;
  args_info->noconv_flag = 0;
  args_info->auto_id_flag = 0;
  args_info->id_prefix_arg = gengetopt_strdup ("sequence");
  args_info->id_prefix_orig = NULL;
  args_info->id_delim_arg = gengetopt_strdup ("_");
  args_info->id_delim_orig = NULL;
  args_info->id_digits_arg = 4;
  args_info->id_digits_orig = NULL;
  args_info->id_start_arg = 1;
  args_info->id_start_orig = NULL;
  args_info->filename_delim_arg = gengetopt_strdup ("ID-delimiter");
  args_info->filename_delim_orig = NULL;
  args_info->filename_full_flag = 0;
  args_info->output_format_arg = gengetopt_strdup ("V");
  args_info->output_format_orig = NULL;
  args_info->csv_delim_arg = gengetopt_strdup (",");
  args_info->csv_delim_orig = NULL;
  args_info->csv_noheader_flag = 0;
  args_info->maxBPspan_arg = -1;
  args_info->maxBPspan_orig = NULL;
  args_info->constraint_arg = gengetopt_strdup ("");
  args_info->constraint_orig = NULL;
  args_info->batch_flag = 0;
  args_info->canonicalBPonly_flag = 0;
  args_info->enforceConstraint_flag = 0;
  args_info->shape_arg = NULL;
  args_info->shape_orig = NULL;
  args_info->shapeMethod_arg = gengetopt_strdup ("D");
  args_info->shapeMethod_orig = NULL;
  args_info->shapeConversion_arg = gengetopt_strdup ("O");
  args_info->shapeConversion_orig = NULL;
  args_info->commands_arg = NULL;
  args_info->commands_orig = NULL;
  args_info->partfunc_arg = 1;
  args_info->partfunc_orig = NULL;
  args_info->all_pf_arg = 1;
  args_info->all_pf_orig = NULL;
  args_info->concentrations_flag = 0;
  args_info->concfile_arg = NULL;
  args_info->concfile_orig = NULL;
  args_info->centroid_flag = 0;
  args_info->MEA_arg = 1.;
  args_info->MEA_orig = NULL;
  args_info->pfScale_orig = NULL;
  args_info->bppmThreshold_arg = 1e-5;
  args_info->bppmThreshold_orig = NULL;
  args_info->gquad_flag = 0;
  args_info->temp_orig = NULL;
  args_info->noTetra_flag = 0;
  args_info->dangles_arg = 2;
  args_info->dangles_orig = NULL;
  args_info->noLP_flag = 0;
  args_info->noGU_flag = 0;
  args_info->noClosingGU_flag = 0;
  args_info->paramFile_arg = NULL;
  args_info->paramFile_orig = NULL;
  args_info->nsp_arg = NULL;
  args_info->nsp_orig = NULL;
  args_info->energyModel_orig = NULL;
  args_info->betaScale_arg = 1.;
  args_info->betaScale_orig = NULL;
  
}

static
void init_args_info(struct RNAcofold_args_info *args_info)
{
  init_full_help_array(); 
  init_help_array(); 
  args_info->help_help = RNAcofold_args_info_detailed_help[0] ;
  args_info->detailed_help_help = RNAcofold_args_info_detailed_help[1] ;
  args_info->full_help_help = RNAcofold_args_info_detailed_help[2] ;
  args_info->version_help = RNAcofold_args_info_detailed_help[3] ;
  args_info->verbose_help = RNAcofold_args_info_detailed_help[6] ;
  args_info->jobs_help = RNAcofold_args_info_detailed_help[7] ;
  args_info->unordered_help = RNAcofold_args_info_detailed_help[9] ;
  args_info->noPS_help = RNAcofold_args_info_detailed_help[11] ;
  args_info->noconv_help = RNAcofold_args_info_detailed_help[12] ;
  args_info->auto_id_help = RNAcofold_args_info_detailed_help[13] ;
  args_info->id_prefix_help = RNAcofold_args_info_detailed_help[15] ;
  args_info->id_delim_help = RNAcofold_args_info_detailed_help[17] ;
  args_info->id_digits_help = RNAcofold_args_info_detailed_help[19] ;
  args_info->id_start_help = RNAcofold_args_info_detailed_help[21] ;
  args_info->filename_delim_help = RNAcofold_args_info_detailed_help[23] ;
  args_info->filename_full_help = RNAcofold_args_info_detailed_help[25] ;
  args_info->output_format_help = RNAcofold_args_info_detailed_help[27] ;
  args_info->csv_delim_help = RNAcofold_args_info_detailed_help[29] ;
  args_info->csv_noheader_help = RNAcofold_args_info_detailed_help[31] ;
  args_info->maxBPspan_help = RNAcofold_args_info_detailed_help[34] ;
  args_info->constraint_help = RNAcofold_args_info_detailed_help[35] ;
  args_info->batch_help = RNAcofold_args_info_detailed_help[37] ;
  args_info->canonicalBPonly_help = RNAcofold_args_info_detailed_help[39] ;
  args_info->enforceConstraint_help = RNAcofold_args_info_detailed_help[40] ;
  args_info->shape_help = RNAcofold_args_info_detailed_help[41] ;
  args_info->shapeMethod_help = RNAcofold_args_info_detailed_help[42] ;
  args_info->shapeConversion_help = RNAcofold_args_info_detailed_help[44] ;
  args_info->commands_help = RNAcofold_args_info_detailed_help[46] ;
  args_info->partfunc_help = RNAcofold_args_info_detailed_help[50] ;
  args_info->all_pf_help = RNAcofold_args_info_detailed_help[52] ;
  args_info->concentrations_help = RNAcofold_args_info_detailed_help[54] ;
  args_info->concfile_help = RNAcofold_args_info_detailed_help[56] ;
  args_info->centroid_help = RNAcofold_args_info_detailed_help[58] ;
  args_info->MEA_help = RNAcofold_args_info_detailed_help[60] ;
  args_info->pfScale_help = RNAcofold_args_info_detailed_help[62] ;
  args_info->bppmThreshold_help = RNAcofold_args_info_detailed_help[64] ;
  args_info->gquad_help = RNAcofold_args_info_detailed_help[66] ;
  args_info->temp_help = RNAcofold_args_info_detailed_help[68] ;
  args_info->noTetra_help = RNAcofold_args_info_detailed_help[69] ;
  args_info->dangles_help = RNAcofold_args_info_detailed_help[71] ;
  args_info->noLP_help = RNAcofold_args_info_detailed_help[73] ;
  args_info->noGU_help = RNAcofold_args_info_detailed_help[75] ;
  args_info->noClosingGU_help = RNAcofold_args_info_detailed_help[76] ;
  args_info->paramFile_help = RNAcofold_args_info_detailed_help[77] ;
  args_info->nsp_help = RNAcofold_args_info_detailed_help[79] ;
  args_info->energyModel_help = RNAcofold_args_info_detailed_help[81] ;
  args_info->betaScale_help = RNAcofold_args_info_detailed_help[82] ;
  
}

void
RNAcofold_cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(RNACOFOLD_CMDLINE_PARSER_PACKAGE_NAME) ? RNACOFOLD_CMDLINE_PARSER_PACKAGE_NAME : RNACOFOLD_CMDLINE_PARSER_PACKAGE),
     RNACOFOLD_CMDLINE_PARSER_VERSION);

  if (strlen(RNAcofold_args_info_versiontext) > 0)
    printf("\n%s\n", RNAcofold_args_info_versiontext);
}

static void print_help_common(void) {
  RNAcofold_cmdline_parser_print_version ();

  if (strlen(RNAcofold_args_info_purpose) > 0)
    printf("\n%s\n", RNAcofold_args_info_purpose);

  if (strlen(RNAcofold_args_info_usage) > 0)
    printf("\n%s\n", RNAcofold_args_info_usage);

  printf("\n");

  if (strlen(RNAcofold_args_info_description) > 0)
    printf("%s\n\n", RNAcofold_args_info_description);
}

void
RNAcofold_cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAcofold_args_info_help[i])
    printf("%s\n", RNAcofold_args_info_help[i++]);
}

void
RNAcofold_cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAcofold_args_info_full_help[i])
    printf("%s\n", RNAcofold_args_info_full_help[i++]);
}

void
RNAcofold_cmdline_parser_print_detailed_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAcofold_args_info_detailed_help[i])
    printf("%s\n", RNAcofold_args_info_detailed_help[i++]);
}

void
RNAcofold_cmdline_parser_init (struct RNAcofold_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
RNAcofold_cmdline_parser_params_init(struct RNAcofold_cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct RNAcofold_cmdline_parser_params *
RNAcofold_cmdline_parser_params_create(void)
{
  struct RNAcofold_cmdline_parser_params *params = 
    (struct RNAcofold_cmdline_parser_params *)malloc(sizeof(struct RNAcofold_cmdline_parser_params));
  RNAcofold_cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
RNAcofold_cmdline_parser_release (struct RNAcofold_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->jobs_orig));
  free_string_field (&(args_info->id_prefix_arg));
  free_string_field (&(args_info->id_prefix_orig));
  free_string_field (&(args_info->id_delim_arg));
  free_string_field (&(args_info->id_delim_orig));
  free_string_field (&(args_info->id_digits_orig));
  free_string_field (&(args_info->id_start_orig));
  free_string_field (&(args_info->filename_delim_arg));
  free_string_field (&(args_info->filename_delim_orig));
  free_string_field (&(args_info->output_format_arg));
  free_string_field (&(args_info->output_format_orig));
  free_string_field (&(args_info->csv_delim_arg));
  free_string_field (&(args_info->csv_delim_orig));
  free_string_field (&(args_info->maxBPspan_orig));
  free_string_field (&(args_info->constraint_arg));
  free_string_field (&(args_info->constraint_orig));
  free_string_field (&(args_info->shape_arg));
  free_string_field (&(args_info->shape_orig));
  free_string_field (&(args_info->shapeMethod_arg));
  free_string_field (&(args_info->shapeMethod_orig));
  free_string_field (&(args_info->shapeConversion_arg));
  free_string_field (&(args_info->shapeConversion_orig));
  free_string_field (&(args_info->commands_arg));
  free_string_field (&(args_info->commands_orig));
  free_string_field (&(args_info->partfunc_orig));
  free_string_field (&(args_info->all_pf_orig));
  free_string_field (&(args_info->concfile_arg));
  free_string_field (&(args_info->concfile_orig));
  free_string_field (&(args_info->MEA_orig));
  free_string_field (&(args_info->pfScale_orig));
  free_string_field (&(args_info->bppmThreshold_orig));
  free_string_field (&(args_info->temp_orig));
  free_string_field (&(args_info->dangles_orig));
  free_string_field (&(args_info->paramFile_arg));
  free_string_field (&(args_info->paramFile_orig));
  free_string_field (&(args_info->nsp_arg));
  free_string_field (&(args_info->nsp_orig));
  free_string_field (&(args_info->energyModel_orig));
  free_string_field (&(args_info->betaScale_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
RNAcofold_cmdline_parser_dump(FILE *outfile, struct RNAcofold_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", RNACOFOLD_CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->detailed_help_given)
    write_into_file(outfile, "detailed-help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", 0, 0 );
  if (args_info->jobs_given)
    write_into_file(outfile, "jobs", args_info->jobs_orig, 0);
  if (args_info->unordered_given)
    write_into_file(outfile, "unordered", 0, 0 );
  if (args_info->noPS_given)
    write_into_file(outfile, "noPS", 0, 0 );
  if (args_info->noconv_given)
    write_into_file(outfile, "noconv", 0, 0 );
  if (args_info->auto_id_given)
    write_into_file(outfile, "auto-id", 0, 0 );
  if (args_info->id_prefix_given)
    write_into_file(outfile, "id-prefix", args_info->id_prefix_orig, 0);
  if (args_info->id_delim_given)
    write_into_file(outfile, "id-delim", args_info->id_delim_orig, 0);
  if (args_info->id_digits_given)
    write_into_file(outfile, "id-digits", args_info->id_digits_orig, 0);
  if (args_info->id_start_given)
    write_into_file(outfile, "id-start", args_info->id_start_orig, 0);
  if (args_info->filename_delim_given)
    write_into_file(outfile, "filename-delim", args_info->filename_delim_orig, 0);
  if (args_info->filename_full_given)
    write_into_file(outfile, "filename-full", 0, 0 );
  if (args_info->output_format_given)
    write_into_file(outfile, "output-format", args_info->output_format_orig, 0);
  if (args_info->csv_delim_given)
    write_into_file(outfile, "csv-delim", args_info->csv_delim_orig, 0);
  if (args_info->csv_noheader_given)
    write_into_file(outfile, "csv-noheader", 0, 0 );
  if (args_info->maxBPspan_given)
    write_into_file(outfile, "maxBPspan", args_info->maxBPspan_orig, 0);
  if (args_info->constraint_given)
    write_into_file(outfile, "constraint", args_info->constraint_orig, 0);
  if (args_info->batch_given)
    write_into_file(outfile, "batch", 0, 0 );
  if (args_info->canonicalBPonly_given)
    write_into_file(outfile, "canonicalBPonly", 0, 0 );
  if (args_info->enforceConstraint_given)
    write_into_file(outfile, "enforceConstraint", 0, 0 );
  if (args_info->shape_given)
    write_into_file(outfile, "shape", args_info->shape_orig, 0);
  if (args_info->shapeMethod_given)
    write_into_file(outfile, "shapeMethod", args_info->shapeMethod_orig, 0);
  if (args_info->shapeConversion_given)
    write_into_file(outfile, "shapeConversion", args_info->shapeConversion_orig, 0);
  if (args_info->commands_given)
    write_into_file(outfile, "commands", args_info->commands_orig, 0);
  if (args_info->partfunc_given)
    write_into_file(outfile, "partfunc", args_info->partfunc_orig, 0);
  if (args_info->all_pf_given)
    write_into_file(outfile, "all_pf", args_info->all_pf_orig, 0);
  if (args_info->concentrations_given)
    write_into_file(outfile, "concentrations", 0, 0 );
  if (args_info->concfile_given)
    write_into_file(outfile, "concfile", args_info->concfile_orig, 0);
  if (args_info->centroid_given)
    write_into_file(outfile, "centroid", 0, 0 );
  if (args_info->MEA_given)
    write_into_file(outfile, "MEA", args_info->MEA_orig, 0);
  if (args_info->pfScale_given)
    write_into_file(outfile, "pfScale", args_info->pfScale_orig, 0);
  if (args_info->bppmThreshold_given)
    write_into_file(outfile, "bppmThreshold", args_info->bppmThreshold_orig, 0);
  if (args_info->gquad_given)
    write_into_file(outfile, "gquad", 0, 0 );
  if (args_info->temp_given)
    write_into_file(outfile, "temp", args_info->temp_orig, 0);
  if (args_info->noTetra_given)
    write_into_file(outfile, "noTetra", 0, 0 );
  if (args_info->dangles_given)
    write_into_file(outfile, "dangles", args_info->dangles_orig, 0);
  if (args_info->noLP_given)
    write_into_file(outfile, "noLP", 0, 0 );
  if (args_info->noGU_given)
    write_into_file(outfile, "noGU", 0, 0 );
  if (args_info->noClosingGU_given)
    write_into_file(outfile, "noClosingGU", 0, 0 );
  if (args_info->paramFile_given)
    write_into_file(outfile, "paramFile", args_info->paramFile_orig, 0);
  if (args_info->nsp_given)
    write_into_file(outfile, "nsp", args_info->nsp_orig, 0);
  if (args_info->energyModel_given)
    write_into_file(outfile, "energyModel", args_info->energyModel_orig, 0);
  if (args_info->betaScale_given)
    write_into_file(outfile, "betaScale", args_info->betaScale_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
RNAcofold_cmdline_parser_file_save(const char *filename, struct RNAcofold_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", RNACOFOLD_CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = RNAcofold_cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
RNAcofold_cmdline_parser_free (struct RNAcofold_args_info *args_info)
{
  RNAcofold_cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
RNAcofold_cmdline_parser (int argc, char **argv, struct RNAcofold_args_info *args_info)
{
  return RNAcofold_cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
RNAcofold_cmdline_parser_ext (int argc, char **argv, struct RNAcofold_args_info *args_info,
                   struct RNAcofold_cmdline_parser_params *params)
{
  int result;
  result = RNAcofold_cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAcofold_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAcofold_cmdline_parser2 (int argc, char **argv, struct RNAcofold_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct RNAcofold_cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = RNAcofold_cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAcofold_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAcofold_cmdline_parser_required (struct RNAcofold_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (RNAcofold_cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      RNAcofold_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAcofold_cmdline_parser_required2 (struct RNAcofold_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  
  /* checks for dependences among options */
  if (args_info->unordered_given && ! args_info->jobs_given)
    {
      fprintf (stderr, "%s: '--unordered' option depends on option 'jobs'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->batch_given && ! args_info->constraint_given)
    {
      fprintf (stderr, "%s: '--batch' option depends on option 'constraint'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->canonicalBPonly_given && ! args_info->constraint_given)
    {
      fprintf (stderr, "%s: '--canonicalBPonly' option depends on option 'constraint'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->enforceConstraint_given && ! args_info->constraint_given)
    {
      fprintf (stderr, "%s: '--enforceConstraint' option depends on option 'constraint'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->shapeMethod_given && ! args_info->shape_given)
    {
      fprintf (stderr, "%s: '--shapeMethod' option depends on option 'shape'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }

  return error_occurred;
}

/*
 * Extracted from the glibc source tree, version 2.3.6
 *
 * Licensed under the GPL as per the whole glibc source tree.
 *
 * This file was modified so that getopt_long can be called
 * many times without risking previous memory to be spoiled.
 *
 * Modified by Andre Noll and Lorenzo Bettini for use in
 * GNU gengetopt generated files.
 *
 */

/* 
 * we must include anything we need since this file is not thought to be
 * inserted in a file already using getopt.h
 *
 * Lorenzo
 */

struct option
{
  const char *name;
  /* has_arg can't be an enum because some compilers complain about
     type mismatches in all the code that assumes it is an int.  */
  int has_arg;
  int *flag;
  int val;
};

/* This version of `getopt' appears to the caller like standard Unix `getopt'
   but it behaves differently for the user, since it allows the user
   to intersperse the options with the other arguments.

   As `getopt' works, it permutes the elements of ARGV so that,
   when it is done, all the options precede everything else.  Thus
   all application programs are extended to handle flexible argument order.
*/
/*
   If the field `flag' is not NULL, it points to a variable that is set
   to the value given in the field `val' when the option is found, but
   left unchanged if the option is not found.

   To have a long-named option do something other than set an `int' to
   a compiled-in constant, such as set a value from `custom_optarg', set the
   option's `flag' field to zero and its `val' field to a nonzero
   value (the equivalent single-letter option character, if there is
   one).  For long options that have a zero `flag' field, `getopt'
   returns the contents of the `val' field.  */

/* Names for the values of the `has_arg' field of `struct option'.  */
#ifndef no_argument
#define no_argument		0
#endif

#ifndef required_argument
#define required_argument	1
#endif

#ifndef optional_argument
#define optional_argument	2
#endif

struct custom_getopt_data {
	/*
	 * These have exactly the same meaning as the corresponding global variables,
	 * except that they are used for the reentrant versions of getopt.
	 */
	int custom_optind;
	int custom_opterr;
	int custom_optopt;
	char *custom_optarg;

	/* True if the internal members have been initialized.  */
	int initialized;

	/*
	 * The next char to be scanned in the option-element in which the last option
	 * character we returned was found.  This allows us to pick up the scan where
	 * we left off.  If this is zero, or a null string, it means resume the scan by
	 * advancing to the next ARGV-element.
	 */
	char *nextchar;

	/*
	 * Describe the part of ARGV that contains non-options that have been skipped.
	 * `first_nonopt' is the index in ARGV of the first of them; `last_nonopt' is
	 * the index after the last of them.
	 */
	int first_nonopt;
	int last_nonopt;
};

/*
 * the variables optarg, optind, opterr and optopt are renamed with
 * the custom_ prefix so that they don't interfere with getopt ones.
 *
 * Moreover they're static so they are visible only from within the
 * file where this very file will be included.
 */

/*
 * For communication from `custom_getopt' to the caller.  When `custom_getopt' finds an
 * option that takes an argument, the argument value is returned here.
 */
static char *custom_optarg;

/*
 * Index in ARGV of the next element to be scanned.  This is used for
 * communication to and from the caller and for communication between
 * successive calls to `custom_getopt'.
 *
 * On entry to `custom_getopt', 1 means this is the first call; initialize.
 *
 * When `custom_getopt' returns -1, this is the index of the first of the non-option
 * elements that the caller should itself scan.
 *
 * Otherwise, `custom_optind' communicates from one call to the next how much of ARGV
 * has been scanned so far.
 *
 * 1003.2 says this must be 1 before any call.
 */
static int custom_optind = 1;

/*
 * Callers store zero here to inhibit the error message for unrecognized
 * options.
 */
static int custom_opterr = 1;

/*
 * Set to an option character which was unrecognized.  This must be initialized
 * on some systems to avoid linking in the system's own getopt implementation.
 */
static int custom_optopt = '?';

/*
 * Exchange two adjacent subsequences of ARGV.  One subsequence is elements
 * [first_nonopt,last_nonopt) which contains all the non-options that have been
 * skipped so far.  The other is elements [last_nonopt,custom_optind), which contains
 * all the options processed since those non-options were skipped.
 * `first_nonopt' and `last_nonopt' are relocated so that they describe the new
 * indices of the non-options in ARGV after they are moved.
 */
static void exchange(char **argv, struct custom_getopt_data *d)
{
	int bottom = d->first_nonopt;
	int middle = d->last_nonopt;
	int top = d->custom_optind;
	char *tem;

	/*
	 * Exchange the shorter segment with the far end of the longer segment.
	 * That puts the shorter segment into the right place.  It leaves the
	 * longer segment in the right place overall, but it consists of two
	 * parts that need to be swapped next.
	 */
	while (top > middle && middle > bottom) {
		if (top - middle > middle - bottom) {
			/* Bottom segment is the short one.  */
			int len = middle - bottom;
			int i;

			/* Swap it with the top part of the top segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] =
					argv[top - (middle - bottom) + i];
				argv[top - (middle - bottom) + i] = tem;
			}
			/* Exclude the moved bottom segment from further swapping.  */
			top -= len;
		} else {
			/* Top segment is the short one.  */
			int len = top - middle;
			int i;

			/* Swap it with the bottom part of the bottom segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] = argv[middle + i];
				argv[middle + i] = tem;
			}
			/* Exclude the moved top segment from further swapping.  */
			bottom += len;
		}
	}
	/* Update records for the slots the non-options now occupy.  */
	d->first_nonopt += (d->custom_optind - d->last_nonopt);
	d->last_nonopt = d->custom_optind;
}

/* Initialize the internal data when the first call is made.  */
static void custom_getopt_initialize(struct custom_getopt_data *d)
{
	/*
	 * Start processing options with ARGV-element 1 (since ARGV-element 0
	 * is the program name); the sequence of previously skipped non-option
	 * ARGV-elements is empty.
	 */
	d->first_nonopt = d->last_nonopt = d->custom_optind;
	d->nextchar = NULL;
	d->initialized = 1;
}

#define NONOPTION_P (argv[d->custom_optind][0] != '-' || argv[d->custom_optind][1] == '\0')

/* return: zero: continue, nonzero: return given value to user */
static int shuffle_argv(int argc, char *const *argv,const struct option *longopts,
	struct custom_getopt_data *d)
{
	/*
	 * Give FIRST_NONOPT & LAST_NONOPT rational values if CUSTOM_OPTIND has been
	 * moved back by the user (who may also have changed the arguments).
	 */
	if (d->last_nonopt > d->custom_optind)
		d->last_nonopt = d->custom_optind;
	if (d->first_nonopt > d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * If we have just processed some options following some
	 * non-options, exchange them so that the options come first.
	 */
	if (d->first_nonopt != d->last_nonopt &&
			d->last_nonopt != d->custom_optind)
		exchange((char **) argv, d);
	else if (d->last_nonopt != d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * Skip any additional non-options and extend the range of
	 * non-options previously skipped.
	 */
	while (d->custom_optind < argc && NONOPTION_P)
		d->custom_optind++;
	d->last_nonopt = d->custom_optind;
	/*
	 * The special ARGV-element `--' means premature end of options.  Skip
	 * it like a null option, then exchange with previous non-options as if
	 * it were an option, then skip everything else like a non-option.
	 */
	if (d->custom_optind != argc && !strcmp(argv[d->custom_optind], "--")) {
		d->custom_optind++;
		if (d->first_nonopt != d->last_nonopt
				&& d->last_nonopt != d->custom_optind)
			exchange((char **) argv, d);
		else if (d->first_nonopt == d->last_nonopt)
			d->first_nonopt = d->custom_optind;
		d->last_nonopt = argc;
		d->custom_optind = argc;
	}
	/*
	 * If we have done all the ARGV-elements, stop the scan and back over
	 * any non-options that we skipped and permuted.
	 */
	if (d->custom_optind == argc) {
		/*
		 * Set the next-arg-index to point at the non-options that we
		 * previously skipped, so the caller will digest them.
		 */
		if (d->first_nonopt != d->last_nonopt)
			d->custom_optind = d->first_nonopt;
		return -1;
	}
	/*
	 * If we have come to a non-option and did not permute it, either stop
	 * the scan or describe it to the caller and pass it by.
	 */
	if (NONOPTION_P) {
		d->custom_optarg = argv[d->custom_optind++];
		return 1;
	}
	/*
	 * We have found another option-ARGV-element. Skip the initial
	 * punctuation.
	 */
	d->nextchar = (argv[d->custom_optind] + 1 + (longopts != NULL && argv[d->custom_optind][1] == '-'));
	return 0;
}

/*
 * Check whether the ARGV-element is a long option.
 *
 * If there's a long option "fubar" and the ARGV-element is "-fu", consider
 * that an abbreviation of the long option, just like "--fu", and not "-f" with
 * arg "u".
 *
 * This distinction seems to be the most useful approach.
 *
 */
static int check_long_opt(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		int print_errors, struct custom_getopt_data *d)
{
	char *nameend;
	const struct option *p;
	const struct option *pfound = NULL;
	int exact = 0;
	int ambig = 0;
	int indfound = -1;
	int option_index;

	for (nameend = d->nextchar; *nameend && *nameend != '='; nameend++)
		/* Do nothing.  */ ;

	/* Test all long options for either exact match or abbreviated matches */
	for (p = longopts, option_index = 0; p->name; p++, option_index++)
		if (!strncmp(p->name, d->nextchar, nameend - d->nextchar)) {
			if ((unsigned int) (nameend - d->nextchar)
					== (unsigned int) strlen(p->name)) {
				/* Exact match found.  */
				pfound = p;
				indfound = option_index;
				exact = 1;
				break;
			} else if (pfound == NULL) {
				/* First nonexact match found.  */
				pfound = p;
				indfound = option_index;
			} else if (pfound->has_arg != p->has_arg
					|| pfound->flag != p->flag
					|| pfound->val != p->val)
				/* Second or later nonexact match found.  */
				ambig = 1;
		}
	if (ambig && !exact) {
		if (print_errors) {
			fprintf(stderr,
				"%s: option `%s' is ambiguous\n",
				argv[0], argv[d->custom_optind]);
		}
		d->nextchar += strlen(d->nextchar);
		d->custom_optind++;
		d->custom_optopt = 0;
		return '?';
	}
	if (pfound) {
		option_index = indfound;
		d->custom_optind++;
		if (*nameend) {
			if (pfound->has_arg != no_argument)
				d->custom_optarg = nameend + 1;
			else {
				if (print_errors) {
					if (argv[d->custom_optind - 1][1] == '-') {
						/* --option */
						fprintf(stderr, "%s: option `--%s' doesn't allow an argument\n",
							argv[0], pfound->name);
					} else {
						/* +option or -option */
						fprintf(stderr, "%s: option `%c%s' doesn't allow an argument\n",
							argv[0], argv[d->custom_optind - 1][0], pfound->name);
					}

				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return '?';
			}
		} else if (pfound->has_arg == required_argument) {
			if (d->custom_optind < argc)
				d->custom_optarg = argv[d->custom_optind++];
			else {
				if (print_errors) {
					fprintf(stderr,
						"%s: option `%s' requires an argument\n",
						argv[0],
						argv[d->custom_optind - 1]);
				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return optstring[0] == ':' ? ':' : '?';
			}
		}
		d->nextchar += strlen(d->nextchar);
		if (longind != NULL)
			*longind = option_index;
		if (pfound->flag) {
			*(pfound->flag) = pfound->val;
			return 0;
		}
		return pfound->val;
	}
	/*
	 * Can't find it as a long option.  If this is not getopt_long_only, or
	 * the option starts with '--' or is not a valid short option, then
	 * it's an error.  Otherwise interpret it as a short option.
	 */
	if (print_errors) {
		if (argv[d->custom_optind][1] == '-') {
			/* --option */
			fprintf(stderr,
				"%s: unrecognized option `--%s'\n",
				argv[0], d->nextchar);
		} else {
			/* +option or -option */
			fprintf(stderr,
				"%s: unrecognized option `%c%s'\n",
				argv[0], argv[d->custom_optind][0],
				d->nextchar);
		}
	}
	d->nextchar = (char *) "";
	d->custom_optind++;
	d->custom_optopt = 0;
	return '?';
}

static int check_short_opt(int argc, char *const *argv, const char *optstring,
		int print_errors, struct custom_getopt_data *d)
{
	char c = *d->nextchar++;
	const char *temp = strchr(optstring, c);

	/* Increment `custom_optind' when we start to process its last character.  */
	if (*d->nextchar == '\0')
		++d->custom_optind;
	if (!temp || c == ':') {
		if (print_errors)
			fprintf(stderr, "%s: invalid option -- %c\n", argv[0], c);

		d->custom_optopt = c;
		return '?';
	}
	if (temp[1] == ':') {
		if (temp[2] == ':') {
			/* This is an option that accepts an argument optionally.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				d->custom_optind++;
			} else
				d->custom_optarg = NULL;
			d->nextchar = NULL;
		} else {
			/* This is an option that requires an argument.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				/*
				 * If we end this ARGV-element by taking the
				 * rest as an arg, we must advance to the next
				 * element now.
				 */
				d->custom_optind++;
			} else if (d->custom_optind == argc) {
				if (print_errors) {
					fprintf(stderr,
						"%s: option requires an argument -- %c\n",
						argv[0], c);
				}
				d->custom_optopt = c;
				if (optstring[0] == ':')
					c = ':';
				else
					c = '?';
			} else
				/*
				 * We already incremented `custom_optind' once;
				 * increment it again when taking next ARGV-elt
				 * as argument.
				 */
				d->custom_optarg = argv[d->custom_optind++];
			d->nextchar = NULL;
		}
	}
	return c;
}

/*
 * Scan elements of ARGV for option characters given in OPTSTRING.
 *
 * If an element of ARGV starts with '-', and is not exactly "-" or "--",
 * then it is an option element.  The characters of this element
 * (aside from the initial '-') are option characters.  If `getopt'
 * is called repeatedly, it returns successively each of the option characters
 * from each of the option elements.
 *
 * If `getopt' finds another option character, it returns that character,
 * updating `custom_optind' and `nextchar' so that the next call to `getopt' can
 * resume the scan with the following option character or ARGV-element.
 *
 * If there are no more option characters, `getopt' returns -1.
 * Then `custom_optind' is the index in ARGV of the first ARGV-element
 * that is not an option.  (The ARGV-elements have been permuted
 * so that those that are not options now come last.)
 *
 * OPTSTRING is a string containing the legitimate option characters.
 * If an option character is seen that is not listed in OPTSTRING,
 * return '?' after printing an error message.  If you set `custom_opterr' to
 * zero, the error message is suppressed but we still return '?'.
 *
 * If a char in OPTSTRING is followed by a colon, that means it wants an arg,
 * so the following text in the same ARGV-element, or the text of the following
 * ARGV-element, is returned in `custom_optarg'.  Two colons mean an option that
 * wants an optional arg; if there is text in the current ARGV-element,
 * it is returned in `custom_optarg', otherwise `custom_optarg' is set to zero.
 *
 * If OPTSTRING starts with `-' or `+', it requests different methods of
 * handling the non-option ARGV-elements.
 * See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.
 *
 * Long-named options begin with `--' instead of `-'.
 * Their names may be abbreviated as long as the abbreviation is unique
 * or is an exact match for some defined option.  If they have an
 * argument, it follows the option name in the same ARGV-element, separated
 * from the option name by a `=', or else the in next ARGV-element.
 * When `getopt' finds a long-named option, it returns 0 if that option's
 * `flag' field is nonzero, the value of the option's `val' field
 * if the `flag' field is zero.
 *
 * The elements of ARGV aren't really const, because we permute them.
 * But we pretend they're const in the prototype to be compatible
 * with other systems.
 *
 * LONGOPTS is a vector of `struct option' terminated by an
 * element containing a name which is zero.
 *
 * LONGIND returns the index in LONGOPT of the long-named option found.
 * It is only valid when a long-named option has been found by the most
 * recent call.
 *
 * Return the option character from OPTS just read.  Return -1 when there are
 * no more options.  For unrecognized options, or options missing arguments,
 * `custom_optopt' is set to the option letter, and '?' is returned.
 *
 * The OPTS string is a list of characters which are recognized option letters,
 * optionally followed by colons, specifying that that letter takes an
 * argument, to be placed in `custom_optarg'.
 *
 * If a letter in OPTS is followed by two colons, its argument is optional.
 * This behavior is specific to the GNU `getopt'.
 *
 * The argument `--' causes premature termination of argument scanning,
 * explicitly telling `getopt' that there are no more options.  If OPTS begins
 * with `--', then non-option arguments are treated as arguments to the option
 * '\0'.  This behavior is specific to the GNU `getopt'.
 */

static int getopt_internal_r(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		struct custom_getopt_data *d)
{
	int ret, print_errors = d->custom_opterr;

	if (optstring[0] == ':')
		print_errors = 0;
	if (argc < 1)
		return -1;
	d->custom_optarg = NULL;

	/* 
	 * This is a big difference with GNU getopt, since optind == 0
	 * means initialization while here 1 means first call.
	 */
	if (d->custom_optind == 0 || !d->initialized) {
		if (d->custom_optind == 0)
			d->custom_optind = 1;	/* Don't scan ARGV[0], the program name.  */
		custom_getopt_initialize(d);
	}
	if (d->nextchar == NULL || *d->nextchar == '\0') {
		ret = shuffle_argv(argc, argv, longopts, d);
		if (ret)
			return ret;
	}
	if (longopts && (argv[d->custom_optind][1] == '-' ))
		return check_long_opt(argc, argv, optstring, longopts,
			longind, print_errors, d);
	return check_short_opt(argc, argv, optstring, print_errors, d);
}

static int custom_getopt_internal(int argc, char *const *argv, const char *optstring,
	const struct option *longopts, int *longind)
{
	int result;
	/* Keep a global copy of all internal members of d */
	static struct custom_getopt_data d;

	d.custom_optind = custom_optind;
	d.custom_opterr = custom_opterr;
	result = getopt_internal_r(argc, argv, optstring, longopts,
		longind, &d);
	custom_optind = d.custom_optind;
	custom_optarg = d.custom_optarg;
	custom_optopt = d.custom_optopt;
	return result;
}

static int custom_getopt_long (int argc, char *const *argv, const char *options,
	const struct option *long_options, int *opt_index)
{
	return custom_getopt_internal(argc, argv, options, long_options,
		opt_index);
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see RNAcofold_cmdline_parser_params.check_ambiguity
 * @param override @see RNAcofold_cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               RNAcofold_cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_LONG:
    if (val) *((long *)field) = (long)strtol (val, &stop_char, 0);
    break;
  case ARG_FLOAT:
    if (val) *((float *)field) = (float)strtod (val, &stop_char);
    break;
  case ARG_DOUBLE:
    if (val) *((double *)field) = strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_LONG:
  case ARG_FLOAT:
  case ARG_DOUBLE:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
RNAcofold_cmdline_parser_internal (
  int argc, char **argv, struct RNAcofold_args_info *args_info,
                        struct RNAcofold_cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct RNAcofold_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;

  char *optarg;
  int optind;
  int opterr;
  int optopt;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    RNAcofold_cmdline_parser_init (args_info);

  RNAcofold_cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "detailed-help",	0, NULL, 0 },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "verbose",	0, NULL, 'v' },
        { "jobs",	2, NULL, 'j' },
        { "unordered",	0, NULL, 0 },
        { "noPS",	0, NULL, 0 },
        { "noconv",	0, NULL, 0 },
        { "auto-id",	0, NULL, 0 },
        { "id-prefix",	1, NULL, 0 },
        { "id-delim",	1, NULL, 0 },
        { "id-digits",	1, NULL, 0 },
        { "id-start",	1, NULL, 0 },
        { "filename-delim",	1, NULL, 0 },
        { "filename-full",	0, NULL, 0 },
        { "output-format",	1, NULL, 0 },
        { "csv-delim",	1, NULL, 0 },
        { "csv-noheader",	0, NULL, 0 },
        { "maxBPspan",	1, NULL, 0 },
        { "constraint",	2, NULL, 'C' },
        { "batch",	0, NULL, 0 },
        { "canonicalBPonly",	0, NULL, 0 },
        { "enforceConstraint",	0, NULL, 0 },
        { "shape",	1, NULL, 0 },
        { "shapeMethod",	1, NULL, 0 },
        { "shapeConversion",	1, NULL, 0 },
        { "commands",	1, NULL, 0 },
        { "partfunc",	2, NULL, 'p' },
        { "all_pf",	2, NULL, 'a' },
        { "concentrations",	0, NULL, 'c' },
        { "concfile",	1, NULL, 'f' },
        { "centroid",	0, NULL, 0 },
        { "MEA",	2, NULL, 0 },
        { "pfScale",	1, NULL, 'S' },
        { "bppmThreshold",	1, NULL, 0 },
        { "gquad",	0, NULL, 'g' },
        { "temp",	1, NULL, 'T' },
        { "noTetra",	0, NULL, '4' },
        { "dangles",	1, NULL, 'd' },
        { "noLP",	0, NULL, 0 },
        { "noGU",	0, NULL, 0 },
        { "noClosingGU",	0, NULL, 0 },
        { "paramFile",	1, NULL, 'P' },
        { "nsp",	1, NULL, 0 },
        { "energyModel",	1, NULL, 'e' },
        { "betaScale",	1, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      custom_optarg = optarg;
      custom_optind = optind;
      custom_opterr = opterr;
      custom_optopt = optopt;

      c = custom_getopt_long (argc, argv, "hVvj::C::p::a::cf:S:gT:4d:P:e:", long_options, &option_index);

      optarg = custom_optarg;
      optind = custom_optind;
      opterr = custom_opterr;
      optopt = custom_optopt;

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          RNAcofold_cmdline_parser_print_help ();
          RNAcofold_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          RNAcofold_cmdline_parser_print_version ();
          RNAcofold_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'v':	/* Be verbose.
        
.  */
        
        
          if (update_arg((void *)&(args_info->verbose_flag), 0, &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "verbose", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'j':	/* Split batch input into jobs and start processing in parallel using multiple threads. A value of 0 indicates to use as many parallel threads as computation cores are available.
.  */
        
        
          if (update_arg( (void *)&(args_info->jobs_arg), 
               &(args_info->jobs_orig), &(args_info->jobs_given),
              &(local_args_info.jobs_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "jobs", 'j',
              additional_error))
            goto failure;
        
          break;
        case 'C':	/* Calculate structures subject to constraints.
.  */
        
        
          if (update_arg( (void *)&(args_info->constraint_arg), 
               &(args_info->constraint_orig), &(args_info->constraint_given),
              &(local_args_info.constraint_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "constraint", 'C',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* Calculate the partition function and base pairing probability matrix in addition to the mfe structure. Default is calculation of mfe structure only.
.  */
        
        
          if (update_arg( (void *)&(args_info->partfunc_arg), 
               &(args_info->partfunc_orig), &(args_info->partfunc_given),
              &(local_args_info.partfunc_given), optarg, 0, "1", ARG_INT,
              check_ambiguity, override, 0, 0,
              "partfunc", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'a':	/* Compute the partition function and free energies not only of the hetero-dimer consisting of the two input sequences (the \"AB dimer\"), but also of the homo-dimers AA and BB as well as A and B monomers.
.  */
        
        
          if (update_arg( (void *)&(args_info->all_pf_arg), 
               &(args_info->all_pf_orig), &(args_info->all_pf_given),
              &(local_args_info.all_pf_given), optarg, 0, "1", ARG_INT,
              check_ambiguity, override, 0, 0,
              "all_pf", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* In addition to everything listed under the -a option, read in initial monomer concentrations and compute the expected equilibrium concentrations of the 5 possible species (AB, AA, BB, A, B).
.  */
        
        
          if (update_arg((void *)&(args_info->concentrations_flag), 0, &(args_info->concentrations_given),
              &(local_args_info.concentrations_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "concentrations", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* Specify a file with initial concentrations for the two sequences..  */
        
        
          if (update_arg( (void *)&(args_info->concfile_arg), 
               &(args_info->concfile_orig), &(args_info->concfile_given),
              &(local_args_info.concfile_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "concfile", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* In the calculation of the pf use scale*mfe as an estimate for the ensemble free energy (used to avoid overflows).
.  */
        
        
          if (update_arg( (void *)&(args_info->pfScale_arg), 
               &(args_info->pfScale_orig), &(args_info->pfScale_given),
              &(local_args_info.pfScale_given), optarg, 0, 0, ARG_DOUBLE,
              check_ambiguity, override, 0, 0,
              "pfScale", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'g':	/* Incoorporate G-Quadruplex formation into the structure prediction algorithm.
        
.  */
        
        
          if (update_arg((void *)&(args_info->gquad_flag), 0, &(args_info->gquad_given),
              &(local_args_info.gquad_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "gquad", 'g',
              additional_error))
            goto failure;
        
          break;
        case 'T':	/* Rescale energy parameters to a temperature of temp C. Default is 37C.
        
.  */
        
        
          if (update_arg( (void *)&(args_info->temp_arg), 
               &(args_info->temp_orig), &(args_info->temp_given),
              &(local_args_info.temp_given), optarg, 0, 0, ARG_DOUBLE,
              check_ambiguity, override, 0, 0,
              "temp", 'T',
              additional_error))
            goto failure;
        
          break;
        case '4':	/* Do not include special tabulated stabilizing energies for tri-, tetra- and hexaloop hairpins.
        
.  */
        
        
          if (update_arg((void *)&(args_info->noTetra_flag), 0, &(args_info->noTetra_given),
              &(local_args_info.noTetra_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "noTetra", '4',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops
.  */
        
        
          if (update_arg( (void *)&(args_info->dangles_arg), 
               &(args_info->dangles_orig), &(args_info->dangles_given),
              &(local_args_info.dangles_given), optarg, 0, "2", ARG_INT,
              check_ambiguity, override, 0, 0,
              "dangles", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Read energy parameters from paramfile, instead of using the default parameter set.
.  */
        
        
          if (update_arg( (void *)&(args_info->paramFile_arg), 
               &(args_info->paramFile_orig), &(args_info->paramFile_given),
              &(local_args_info.paramFile_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "paramFile", 'P',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Rarely used option to fold sequences from the artificial ABCD... alphabet, where A pairs B, C-D etc.  Use the energy parameters for GC (-e 1) or AU (-e 2) pairs.
        
.  */
        
        
          if (update_arg( (void *)&(args_info->energyModel_arg), 
               &(args_info->energyModel_orig), &(args_info->energyModel_given),
              &(local_args_info.energyModel_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "energyModel", 'e',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "detailed-help") == 0) {
            RNAcofold_cmdline_parser_print_detailed_help ();
            RNAcofold_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            RNAcofold_cmdline_parser_print_full_help ();
            RNAcofold_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* Do not try to keep output in order with input while parallel processing is in place.
.  */
          if (strcmp (long_options[option_index].name, "unordered") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->unordered_flag), 0, &(args_info->unordered_given),
                &(local_args_info.unordered_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "unordered", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not produce postscript drawing of the mfe structure.
          
.  */
          else if (strcmp (long_options[option_index].name, "noPS") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noPS_flag), 0, &(args_info->noPS_given),
                &(local_args_info.noPS_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noPS", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not automatically substitute nucleotide \"T\" with \"U\"
          
.  */
          else if (strcmp (long_options[option_index].name, "noconv") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noconv_flag), 0, &(args_info->noconv_given),
                &(local_args_info.noconv_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noconv", '-',
                additional_error))
              goto failure;
          
          }
          /* Automatically generate an ID for each sequence.
.  */
          else if (strcmp (long_options[option_index].name, "auto-id") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->auto_id_flag), 0, &(args_info->auto_id_given),
                &(local_args_info.auto_id_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "auto-id", '-',
                additional_error))
              goto failure;
          
          }
          /* Prefix for automatically generated IDs (as used in output file names)
          
.  */
          else if (strcmp (long_options[option_index].name, "id-prefix") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_prefix_arg), 
                 &(args_info->id_prefix_orig), &(args_info->id_prefix_given),
                &(local_args_info.id_prefix_given), optarg, 0, "sequence", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "id-prefix", '-',
                additional_error))
              goto failure;
          
          }
          /* Change the delimiter between prefix and increasing number for automatically generated IDs (as used in output file names)
          
.  */
          else if (strcmp (long_options[option_index].name, "id-delim") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_delim_arg), 
                 &(args_info->id_delim_orig), &(args_info->id_delim_given),
                &(local_args_info.id_delim_given), optarg, 0, "_", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "id-delim", '-',
                additional_error))
              goto failure;
          
          }
          /* Specify the number of digits of the counter in automatically generated alignment IDs.
.  */
          else if (strcmp (long_options[option_index].name, "id-digits") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_digits_arg), 
                 &(args_info->id_digits_orig), &(args_info->id_digits_given),
                &(local_args_info.id_digits_given), optarg, 0, "4", ARG_INT,
                check_ambiguity, override, 0, 0,
                "id-digits", '-',
                additional_error))
              goto failure;
          
          }
          /* Specify the first number in automatically generated alignment IDs.
.  */
          else if (strcmp (long_options[option_index].name, "id-start") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_start_arg), 
                 &(args_info->id_start_orig), &(args_info->id_start_given),
                &(local_args_info.id_start_given), optarg, 0, "1", ARG_LONG,
                check_ambiguity, override, 0, 0,
                "id-start", '-',
                additional_error))
              goto failure;
          
          }
          /* Change the delimiting character that is used for sanitized filenames
          
.  */
          else if (strcmp (long_options[option_index].name, "filename-delim") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->filename_delim_arg), 
                 &(args_info->filename_delim_orig), &(args_info->filename_delim_given),
                &(local_args_info.filename_delim_given), optarg, 0, "ID-delimiter", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "filename-delim", '-',
                additional_error))
              goto failure;
          
          }
          /* Use full FASTA header to create filenames
          
.  */
          else if (strcmp (long_options[option_index].name, "filename-full") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->filename_full_flag), 0, &(args_info->filename_full_given),
                &(local_args_info.filename_full_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "filename-full", '-',
                additional_error))
              goto failure;
          
          }
          /* Change the default output format
          
.  */
          else if (strcmp (long_options[option_index].name, "output-format") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->output_format_arg), 
                 &(args_info->output_format_orig), &(args_info->output_format_given),
                &(local_args_info.output_format_given), optarg, 0, "V", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "output-format", '-',
                additional_error))
              goto failure;
          
          }
          /* Change the delimiting character for Delimiter-separated output format, such as CSV
          
.  */
          else if (strcmp (long_options[option_index].name, "csv-delim") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->csv_delim_arg), 
                 &(args_info->csv_delim_orig), &(args_info->csv_delim_given),
                &(local_args_info.csv_delim_given), optarg, 0, ",", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "csv-delim", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not print header for Delimiter-separated output, such as CSV
          
.  */
          else if (strcmp (long_options[option_index].name, "csv-noheader") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->csv_noheader_flag), 0, &(args_info->csv_noheader_given),
                &(local_args_info.csv_noheader_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "csv-noheader", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the maximum base pair span
          
.  */
          else if (strcmp (long_options[option_index].name, "maxBPspan") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->maxBPspan_arg), 
                 &(args_info->maxBPspan_orig), &(args_info->maxBPspan_given),
                &(local_args_info.maxBPspan_given), optarg, 0, "-1", ARG_INT,
                check_ambiguity, override, 0, 0,
                "maxBPspan", '-',
                additional_error))
              goto failure;
          
          }
          /* Use constraints for multiple sequences.
.  */
          else if (strcmp (long_options[option_index].name, "batch") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->batch_flag), 0, &(args_info->batch_given),
                &(local_args_info.batch_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "batch", '-',
                additional_error))
              goto failure;
          
          }
          /* Remove non-canonical base pairs from the structure constraint
          
.  */
          else if (strcmp (long_options[option_index].name, "canonicalBPonly") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->canonicalBPonly_flag), 0, &(args_info->canonicalBPonly_given),
                &(local_args_info.canonicalBPonly_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "canonicalBPonly", '-',
                additional_error))
              goto failure;
          
          }
          /* Enforce base pairs given by round brackets ( ) in structure constraint
          
.  */
          else if (strcmp (long_options[option_index].name, "enforceConstraint") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->enforceConstraint_flag), 0, &(args_info->enforceConstraint_given),
                &(local_args_info.enforceConstraint_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "enforceConstraint", '-',
                additional_error))
              goto failure;
          
          }
          /* Use SHAPE reactivity data to guide structure predictions
          
.  */
          else if (strcmp (long_options[option_index].name, "shape") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->shape_arg), 
                 &(args_info->shape_orig), &(args_info->shape_given),
                &(local_args_info.shape_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "shape", '-',
                additional_error))
              goto failure;
          
          }
          /* Select method to incorporate SHAPE reactivity data.
.  */
          else if (strcmp (long_options[option_index].name, "shapeMethod") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->shapeMethod_arg), 
                 &(args_info->shapeMethod_orig), &(args_info->shapeMethod_given),
                &(local_args_info.shapeMethod_given), optarg, 0, "D", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "shapeMethod", '-',
                additional_error))
              goto failure;
          
          }
          /* Select method to convert SHAPE reactivities to pairing probabilities.
.  */
          else if (strcmp (long_options[option_index].name, "shapeConversion") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->shapeConversion_arg), 
                 &(args_info->shapeConversion_orig), &(args_info->shapeConversion_given),
                &(local_args_info.shapeConversion_given), optarg, 0, "O", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "shapeConversion", '-',
                additional_error))
              goto failure;
          
          }
          /* Read additional commands from file
.  */
          else if (strcmp (long_options[option_index].name, "commands") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->commands_arg), 
                 &(args_info->commands_orig), &(args_info->commands_given),
                &(local_args_info.commands_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "commands", '-',
                additional_error))
              goto failure;
          
          }
          /* Compute the centroid structure.
.  */
          else if (strcmp (long_options[option_index].name, "centroid") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->centroid_flag), 0, &(args_info->centroid_given),
                &(local_args_info.centroid_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "centroid", '-',
                additional_error))
              goto failure;
          
          }
          /* Calculate an MEA (maximum expected accuracy) structure, where the expected accuracy is computed from the pair probabilities: each base pair (i,j) gets a score 2*gamma*p_ij and the score of an unpaired base is given by the probability of not forming a pair.
.  */
          else if (strcmp (long_options[option_index].name, "MEA") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->MEA_arg), 
                 &(args_info->MEA_orig), &(args_info->MEA_given),
                &(local_args_info.MEA_given), optarg, 0, "1.", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "MEA", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the threshold for base pair probabilities included in the postscript output
.  */
          else if (strcmp (long_options[option_index].name, "bppmThreshold") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->bppmThreshold_arg), 
                 &(args_info->bppmThreshold_orig), &(args_info->bppmThreshold_given),
                &(local_args_info.bppmThreshold_given), optarg, 0, "1e-5", ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "bppmThreshold", '-',
                additional_error))
              goto failure;
          
          }
          /* Produce structures without lonely pairs (helices of length 1).
.  */
          else if (strcmp (long_options[option_index].name, "noLP") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noLP_flag), 0, &(args_info->noLP_given),
                &(local_args_info.noLP_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noLP", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not allow GU pairs
          
.  */
          else if (strcmp (long_options[option_index].name, "noGU") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noGU_flag), 0, &(args_info->noGU_given),
                &(local_args_info.noGU_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noGU", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not allow GU pairs at the end of helices
          
.  */
          else if (strcmp (long_options[option_index].name, "noClosingGU") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noClosingGU_flag), 0, &(args_info->noClosingGU_given),
                &(local_args_info.noClosingGU_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noClosingGU", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow other pairs in addition to the usual AU,GC,and GU pairs.
.  */
          else if (strcmp (long_options[option_index].name, "nsp") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->nsp_arg), 
                 &(args_info->nsp_orig), &(args_info->nsp_given),
                &(local_args_info.nsp_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "nsp", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the scaling of the Boltzmann factors
.  */
          else if (strcmp (long_options[option_index].name, "betaScale") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->betaScale_arg), 
                 &(args_info->betaScale_orig), &(args_info->betaScale_given),
                &(local_args_info.betaScale_given), optarg, 0, "1.", ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "betaScale", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", RNACOFOLD_CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
      error_occurred += RNAcofold_cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  RNAcofold_cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */


      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;
    }

  return 0;

failure:
  
  RNAcofold_cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
