/** @file RNAlocmin_cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef RNALOCMIN_CMDLINE_H
#define RNALOCMIN_CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "RNAlocmin"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "RNAlocmin"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION "2.1"
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *detailed_help_help; /**< @brief Print help, including all details and hidden options, and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * seq_arg;	/**< @brief Sequence file in FASTA format. If the sequence is the first line of the input file, this is not needed (default='seq.txt').  */
  char * seq_orig;	/**< @brief Sequence file in FASTA format. If the sequence is the first line of the input file, this is not needed original value given at command line.  */
  const char *seq_help; /**< @brief Sequence file in FASTA format. If the sequence is the first line of the input file, this is not needed help description.  */
  char * previous_arg;	/**< @brief Previously found LM (output from RNAlocmin or barriers), if specified does not need --seq option.  */
  char * previous_orig;	/**< @brief Previously found LM (output from RNAlocmin or barriers), if specified does not need --seq option original value given at command line.  */
  const char *previous_help; /**< @brief Previously found LM (output from RNAlocmin or barriers), if specified does not need --seq option help description.  */
  char * move_arg;	/**< @brief Move set:
  I ==> insertion & deletion of base pairs
  S ==> I&D& switch of base pairs (default='I').  */
  char * move_orig;	/**< @brief Move set:
  I ==> insertion & deletion of base pairs
  S ==> I&D& switch of base pairs original value given at command line.  */
  const char *move_help; /**< @brief Move set:
  I ==> insertion & deletion of base pairs
  S ==> I&D& switch of base pairs help description.  */
  int min_num_arg;	/**< @brief Maximal number of local minima returned
  (0 == unlimited) (default='100000').  */
  char * min_num_orig;	/**< @brief Maximal number of local minima returned
  (0 == unlimited) original value given at command line.  */
  const char *min_num_help; /**< @brief Maximal number of local minima returned
  (0 == unlimited) help description.  */
  int find_num_arg;	/**< @brief Maximal number of local minima found
  (default = unlimited - crawl through whole input file).  */
  char * find_num_orig;	/**< @brief Maximal number of local minima found
  (default = unlimited - crawl through whole input file) original value given at command line.  */
  const char *find_num_help; /**< @brief Maximal number of local minima found
  (default = unlimited - crawl through whole input file) help description.  */
  int verbose_lvl_arg;	/**< @brief Level of verbosity (0 = nothing, 4 = full)
  WARNING: higher verbose levels increase the computation time (default='0').  */
  char * verbose_lvl_orig;	/**< @brief Level of verbosity (0 = nothing, 4 = full)
  WARNING: higher verbose levels increase the computation time original value given at command line.  */
  const char *verbose_lvl_help; /**< @brief Level of verbosity (0 = nothing, 4 = full)
  WARNING: higher verbose levels increase the computation time help description.  */
  int depth_arg;	/**< @brief Depth of findpath search (higher value increases running time linearly) (default='10').  */
  char * depth_orig;	/**< @brief Depth of findpath search (higher value increases running time linearly) original value given at command line.  */
  const char *depth_help; /**< @brief Depth of findpath search (higher value increases running time linearly) help description.  */
  double minh_arg;	/**< @brief Print only minima with energy barrier greater than this (default='0.0').  */
  char * minh_orig;	/**< @brief Print only minima with energy barrier greater than this original value given at command line.  */
  const char *minh_help; /**< @brief Print only minima with energy barrier greater than this help description.  */
  int minh_lite_flag;	/**< @brief When flooding with --minh option, search for only saddle (do not search for a LM that is lower). Increases efficiency a tiny bit, but when turned on, the results may omit some non-shallow minima, especially with higher --minh value. (default=off).  */
  const char *minh_lite_help; /**< @brief When flooding with --minh option, search for only saddle (do not search for a LM that is lower). Increases efficiency a tiny bit, but when turned on, the results may omit some non-shallow minima, especially with higher --minh value. help description.  */
  char * walk_arg;	/**< @brief Walking method used
  D ==> gradient descent
  F ==> use first found lower energy structure
  R ==> use random lower energy structure (does not work with --noLP and -m S options) (default='D').  */
  char * walk_orig;	/**< @brief Walking method used
  D ==> gradient descent
  F ==> use first found lower energy structure
  R ==> use random lower energy structure (does not work with --noLP and -m S options) original value given at command line.  */
  const char *walk_help; /**< @brief Walking method used
  D ==> gradient descent
  F ==> use first found lower energy structure
  R ==> use random lower energy structure (does not work with --noLP and -m S options) help description.  */
  int noLP_flag;	/**< @brief Work only with canonical RNA structures (w/o isolated base pairs, cannot be combined with ranodm walk (-w R option) and shift move set (-m S)) (default=off).  */
  const char *noLP_help; /**< @brief Work only with canonical RNA structures (w/o isolated base pairs, cannot be combined with ranodm walk (-w R option) and shift move set (-m S)) help description.  */
  int useEOS_flag;	/**< @brief Use energy_of_structure_pt calculation instead of energy_of_move (slower, it should not affect results) (default=off).  */
  const char *useEOS_help; /**< @brief Use energy_of_structure_pt calculation instead of energy_of_move (slower, it should not affect results) help description.  */
  char * paramFile_arg;	/**< @brief Read energy parameters from paramfile, instead of using the default parameter set.  */
  char * paramFile_orig;	/**< @brief Read energy parameters from paramfile, instead of using the default parameter set original value given at command line.  */
  const char *paramFile_help; /**< @brief Read energy parameters from paramfile, instead of using the default parameter set help description.  */
  int dangles_arg;	/**< @brief How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops
 (default='2').  */
  char * dangles_orig;	/**< @brief How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops
 original value given at command line.  */
  const char *dangles_help; /**< @brief How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops
 help description.  */
  char * fix_barriers_arg;	/**< @brief Fix barrier file for interior loops (just recompute if all LM in barrier output are LM), if specified, does not need neither --previous nor --seq option.  */
  char * fix_barriers_orig;	/**< @brief Fix barrier file for interior loops (just recompute if all LM in barrier output are LM), if specified, does not need neither --previous nor --seq option original value given at command line.  */
  const char *fix_barriers_help; /**< @brief Fix barrier file for interior loops (just recompute if all LM in barrier output are LM), if specified, does not need neither --previous nor --seq option help description.  */
  int pseudoknots_flag;	/**< @brief Allow for pseudoknots according to \"gfold\" model - H, K, L, and M types (genus one) of pseudoknots are allowed (increases computation time greatly), cannot be combined with shift move set (-m S) (default=off).  */
  const char *pseudoknots_help; /**< @brief Allow for pseudoknots according to \"gfold\" model - H, K, L, and M types (genus one) of pseudoknots are allowed (increases computation time greatly), cannot be combined with shift move set (-m S) help description.  */
  int just_read_flag;	/**< @brief Do not expect input from stdin, just do postprocessing. (default=off).  */
  const char *just_read_help; /**< @brief Do not expect input from stdin, just do postprocessing. help description.  */
  int neighborhood_flag;	/**< @brief Use the Neighborhood routines to perform gradient descend. Cannot be combined with shift move set (-m S) and pseudoknots (-k). Test option. (default=off).  */
  const char *neighborhood_help; /**< @brief Use the Neighborhood routines to perform gradient descend. Cannot be combined with shift move set (-m S) and pseudoknots (-k). Test option. help description.  */
  int degeneracy_off_flag;	/**< @brief Do not deal with degeneracy, select the lexicographically first from the same energy neighbors. (default=off).  */
  const char *degeneracy_off_help; /**< @brief Do not deal with degeneracy, select the lexicographically first from the same energy neighbors. help description.  */
  int just_output_flag;	/**< @brief Do not store the minima and optimize, just compute directly minima and output them. Output file can contain duplicates. (default=off).  */
  const char *just_output_help; /**< @brief Do not store the minima and optimize, just compute directly minima and output them. Output file can contain duplicates. help description.  */
  int bartree_flag;	/**< @brief Generate an approximate barrier tree. (default=off).  */
  const char *bartree_help; /**< @brief Generate an approximate barrier tree. help description.  */
  char * barr_name_arg;	/**< @brief Name of barrier tree output file, switches on -b flag. (default='treeRNAloc.ps').  */
  char * barr_name_orig;	/**< @brief Name of barrier tree output file, switches on -b flag. original value given at command line.  */
  const char *barr_name_help; /**< @brief Name of barrier tree output file, switches on -b flag. help description.  */
  char * barrier_file_arg;	/**< @brief File for saddle heights between LM (simulates the output format of barriers program).  */
  char * barrier_file_orig;	/**< @brief File for saddle heights between LM (simulates the output format of barriers program) original value given at command line.  */
  const char *barrier_file_help; /**< @brief File for saddle heights between LM (simulates the output format of barriers program) help description.  */
  int rates_flag;	/**< @brief Create rates for treekin (default=off).  */
  const char *rates_help; /**< @brief Create rates for treekin help description.  */
  char * rates_file_arg;	/**< @brief File where to write rates, switches on -r flag (default='rates.out').  */
  char * rates_file_orig;	/**< @brief File where to write rates, switches on -r flag original value given at command line.  */
  const char *rates_file_help; /**< @brief File where to write rates, switches on -r flag help description.  */
  double temp_arg;	/**< @brief Temperature in Celsius (only for rates) (default='37.0').  */
  char * temp_orig;	/**< @brief Temperature in Celsius (only for rates) original value given at command line.  */
  const char *temp_help; /**< @brief Temperature in Celsius (only for rates) help description.  */
  double floodPortion_arg;	/**< @brief Fraction of minima to flood (floods first minima with low number of inwalking sample structures)
  (0.0 -> no flood; 1.0 -> try to flood all) Usable only with -r or -b options. (default='0.95').  */
  char * floodPortion_orig;	/**< @brief Fraction of minima to flood (floods first minima with low number of inwalking sample structures)
  (0.0 -> no flood; 1.0 -> try to flood all) Usable only with -r or -b options. original value given at command line.  */
  const char *floodPortion_help; /**< @brief Fraction of minima to flood (floods first minima with low number of inwalking sample structures)
  (0.0 -> no flood; 1.0 -> try to flood all) Usable only with -r or -b options. help description.  */
  int floodMax_arg;	/**< @brief Flood cap - how many structures to flood in one basin (default='1000').  */
  char * floodMax_orig;	/**< @brief Flood cap - how many structures to flood in one basin original value given at command line.  */
  const char *floodMax_help; /**< @brief Flood cap - how many structures to flood in one basin help description.  */
  int numIntervals_arg;	/**< @brief Number of intervals for Jing's visualisation (default='0').  */
  char * numIntervals_orig;	/**< @brief Number of intervals for Jing's visualisation original value given at command line.  */
  const char *numIntervals_help; /**< @brief Number of intervals for Jing's visualisation help description.  */
  float eRange_arg;	/**< @brief Report only LM, which energy is in range <MFE (or lowest found LM), MFE+eRange> in kcal/mol..  */
  char * eRange_orig;	/**< @brief Report only LM, which energy is in range <MFE (or lowest found LM), MFE+eRange> in kcal/mol. original value given at command line.  */
  const char *eRange_help; /**< @brief Report only LM, which energy is in range <MFE (or lowest found LM), MFE+eRange> in kcal/mol. help description.  */
  char * allegiance_arg;	/**< @brief Filename where to output the allegiance of structures. Works properly only with RNAsubopt -e list..  */
  char * allegiance_orig;	/**< @brief Filename where to output the allegiance of structures. Works properly only with RNAsubopt -e list. original value given at command line.  */
  const char *allegiance_help; /**< @brief Filename where to output the allegiance of structures. Works properly only with RNAsubopt -e list. help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int detailed_help_given ;	/**< @brief Whether detailed-help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int seq_given ;	/**< @brief Whether seq was given.  */
  unsigned int previous_given ;	/**< @brief Whether previous was given.  */
  unsigned int move_given ;	/**< @brief Whether move was given.  */
  unsigned int min_num_given ;	/**< @brief Whether min-num was given.  */
  unsigned int find_num_given ;	/**< @brief Whether find-num was given.  */
  unsigned int verbose_lvl_given ;	/**< @brief Whether verbose-lvl was given.  */
  unsigned int depth_given ;	/**< @brief Whether depth was given.  */
  unsigned int minh_given ;	/**< @brief Whether minh was given.  */
  unsigned int minh_lite_given ;	/**< @brief Whether minh-lite was given.  */
  unsigned int walk_given ;	/**< @brief Whether walk was given.  */
  unsigned int noLP_given ;	/**< @brief Whether noLP was given.  */
  unsigned int useEOS_given ;	/**< @brief Whether useEOS was given.  */
  unsigned int paramFile_given ;	/**< @brief Whether paramFile was given.  */
  unsigned int dangles_given ;	/**< @brief Whether dangles was given.  */
  unsigned int fix_barriers_given ;	/**< @brief Whether fix-barriers was given.  */
  unsigned int pseudoknots_given ;	/**< @brief Whether pseudoknots was given.  */
  unsigned int just_read_given ;	/**< @brief Whether just-read was given.  */
  unsigned int neighborhood_given ;	/**< @brief Whether neighborhood was given.  */
  unsigned int degeneracy_off_given ;	/**< @brief Whether degeneracy-off was given.  */
  unsigned int just_output_given ;	/**< @brief Whether just-output was given.  */
  unsigned int bartree_given ;	/**< @brief Whether bartree was given.  */
  unsigned int barr_name_given ;	/**< @brief Whether barr-name was given.  */
  unsigned int barrier_file_given ;	/**< @brief Whether barrier-file was given.  */
  unsigned int rates_given ;	/**< @brief Whether rates was given.  */
  unsigned int rates_file_given ;	/**< @brief Whether rates-file was given.  */
  unsigned int temp_given ;	/**< @brief Whether temp was given.  */
  unsigned int floodPortion_given ;	/**< @brief Whether floodPortion was given.  */
  unsigned int floodMax_given ;	/**< @brief Whether floodMax was given.  */
  unsigned int numIntervals_given ;	/**< @brief Whether numIntervals was given.  */
  unsigned int eRange_given ;	/**< @brief Whether eRange was given.  */
  unsigned int allegiance_given ;	/**< @brief Whether allegiance was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *gengetopt_args_info_full_help[];
/** @brief all the lines making the detailed help output (including hidden options and details) */
extern const char *gengetopt_args_info_detailed_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void cmdline_parser_print_full_help(void);
/**
 * Print the detailed help (including hidden options and details)
 */
void cmdline_parser_print_detailed_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern const char *cmdline_parser_move_values[];  /**< @brief Possible values for move. */
extern const char *cmdline_parser_walk_values[];  /**< @brief Possible values for walk. */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* RNALOCMIN_CMDLINE_H */
