/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePropertyMap<T>
implements PropertyMap {
    private final PropertyId<T> pid;
    private final T value;

    private SinglePropertyMap(PropertyId<T> propertyId, T t) {
        if (!propertyId.getValueClass().isInstance(t)) {
            if (t == null) {
                throw new NullPointerException();
            }
            throw new ClassCastException();
        }
        this.pid = propertyId;
        this.value = t;
    }

    public <V> V get(PropertyId<V> propertyId) {
        if (propertyId != this.pid) {
            return null;
        }
        return propertyId.getValueClass().cast(this.value);
    }

    @Override
    public boolean contains(PropertyId<?> propertyId) {
        return propertyId == this.pid;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public PropertyId<?> getKey(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.pid;
    }

    public static <T> SinglePropertyMap newInstance(PropertyId<T> propertyId, T t) {
        return new SinglePropertyMap<T>(propertyId, t);
    }
}

