/*
SRFullScreenImageController.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRFullScreenImageController.h"

#import "SRFullScreenImageWindow.h"

@implementation SRFullScreenImageController

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (id)init
{
    self = [super initWithWindowNibName:@"FullScreenImage"];
    if (!self) {
        return nil;
    }
    
    // Initialize instance variables
    
    return self;
}

- (void)windowDidLoad
{
    // Configure window
    NSWindow*   window;
    window = [self window];
    [window setOpaque:NO];
    [window setLevel:NSFloatingWindowLevel];
    [window setHasShadow:NO];
    
    // Set content view
    NSView*                         oldView;
    SRFullScreenImageControlView*   contentView;
    oldView = [window contentView];
    contentView = [[SRFullScreenImageControlView alloc] initWithFrame:[oldView frame]];
    
    NSEnumerator*   enumerator;
    NSView*         subview;
    enumerator = [[oldView subviews] objectEnumerator];
    while (subview = [enumerator nextObject]) {
        [subview removeFromSuperview];
        [contentView addSubview:subview];
    }
    
    [window setContentView:contentView];
    [contentView release];
    
    // Extend window
    NSScreen*   screen;
    screen = [window screen];
    [window setFrame:[screen frame] display:YES];
}

- (void)dealloc
{
    [super dealloc];
}

//--------------------------------------------------------------//
#pragma mark -- Image --
//--------------------------------------------------------------//

- (NSImage*)image
{
    return [_imageView image];
}

- (void)setImage:(NSImage*)image
{
    [_imageView setImage:image];
}

//--------------------------------------------------------------//
#pragma mark -- NSWindow delegate --
//--------------------------------------------------------------//

- (void)windowWillClose:(NSNotification*)notification
{
    // Clear image
    [_imageView setImage:nil];
}

@end
