-   [Getting Connected](get-started/)
-   [Making Queries](queries.html)
-   [Keyboard Shortcuts](shortcuts.html)
-   [Reference](ref/)
-   [Bundles](bundles/)
-   [Contribute](contribute/)

<hr>

### Keyboard Shortcuts

Get the most out of Sequel Pro by remembering the following keyboard shortcuts.

#### Main Tabs

| Keyboard shortcut | Description     |
|:------------------|:----------------|
| `⌘ 1`             | Table Structure |
| `⌘ 2`             | Table Content   |
| `⌘ 3`             | Table Relations |
| `⌘ 4`             | Table Info      |
| `⌘ 5`             | Custom Query    |
| `⌘ 6`             | Table Triggers  |

#### General Shortcuts

| Keyboard shortcut | Description                                |
|:------------------|:-------------------------------------------|
| `⌘ N`             | New Window (Connection File)               |
| `⌘ T`             | New Tab(Connection File)                   |
| `⇧ ⌘ A`           | Add Connection To Favorites                |
| `⌘ O`             | Open (Connection File or SQL File)         |
| `⌥ ⌘ O`           | Open current Connection File in New Window |
| `⌘ S`             | Save (Connection File)                     |
| `⇧ ⌘ S`           | Save As (Connection File)                  |
| `^ ⌘ S`           | Save Query                                 |
| `⌘ W`             | Close (Connection File)                    |
| `⌥ ⌘ W`           | Close All (Connection File)                |
| `⌘ P`             | Print                                      |
| `⇧ ⌘ I`           | Import                                     |
| `⇧ ⌘ K`           | Show Console Window                        |
| `⌘ K`             | Clear Console                              |
| `⌃ ⌥ ←`           | Back in History                            |
| `⌃ ⌥ →`           | Forward in History                         |
| `⌃ ⇥`             | Select Next Tab                            |
| `⌃ ⇧ ⇥`           | Select Previous Tab                        |
| `⌃ ⇧ N`           | Insert NULL value                          |
| `⇧ ⌘ C`           | Copy Create Table Syntax                   |
| `⌥ ⌘ S`           | Show Create Table Syntax                   |
| `⇧ ⌘ R`           | Refresh Databases                          |
| `⇧ ⌘ D`           | Choose Database                            |
| `⇧ ⌘ V`           | Show Server Variables                      |
| `⌥ ⌘ P`           | Show Server Processes                      |
| `⌃ ⌘ R`           | Refresh Tables                             |
| `⇧ ⌘ F`           | Flush Privileges                           |
| `⌘ U`             | User Accounts                              |
| `⌘ C`             | Copy selection / Copy selected row(s)      |
| `⌥ ⌘ C`           | Copy selected row(s) with column names     |
| `⌃ ⌥ ⌘ C`         | Copy selected row(s) as SQL INSERT         |
| `⇧ ⌘ T`           | Show/Hide Toolbar                          |
| `⌃ ⌘ F`           | Filter Table Content                       |
| `⌃ ⌥ ⌘ F`         | Filter Tables                              |
| `⌃ ⌥ ⌘ B`         | Bundle Editor                              |
| `⌃ ⌥ ⌘ N`         | Navigator                                  |

#### Select

| Keyboard shortcut | Description               |
|:------------------|:--------------------------|
| `⌃ W`             | Select current word       |
| `⌃ L`             | Select current line       |
| `⇧ ⌘ B`           | Select enclosing brackets |
| `⌘ A`             | Select all                |

#### Table Structure Tab

| Keyboard shortcut | Description              |
|:------------------|:-------------------------|
| `⌥ ⌘ A`           | Add a new field          |
| `⌫`               | Delete selected field    |
| `⌘ D`             | Duplicate selected field |
| `⌘ R`             | Refresh table structure  |
| `⌘ 4`             | Edit table details       |

#### Table Content Tab

| Keyboard shortcut | Description            |
|:------------------|:-----------------------|
| `⌥ ⌘ A`           | Add a new row          |
| `⌫`               | Delete selected row(s) |
| `⌘ D`             | Duplicate selected row |
| `⌘ R`             | Refresh table contents |

#### Custom Query Tab

| Keyboard shortcut                | Description                                  |
|:---------------------------------|:---------------------------------------------|
| `⌥ ⌘ R`                          | Run all queries                              |
| `⌅` or `⌘ R`                     | Run current query or selection               |
| `⌘ [`                            | Shift line or selection rightwards           |
| `⌘ ]`                            | Shift line or selection leftwards            |
| `⌘ /`                            | (Un)Comment line or selection                |
| `⌥ ⌘ /`                          | (Un)Comment current query                    |
| `⎋`                              | Completion (narrow-down list / fuzzy search) |
| `↩`, `⇥`, `Double-Click`         | Insertion of an item                         |
| `⇧ + ↩`, `⇧ ⇥`, `⇧ Double-Click` | Insertion full schema reference              |

Keep Window Open after Insertion by _holding down `⌃` while insertion_

| Keyboard shortcut | Description                                                   |
|:------------------|:--------------------------------------------------------------|
| `⌃ ⎋`             | Fuzzy Search                                                  |
| `⎋`               | Close Window                                                  |
| `F5`              | Spell Checker Completion (narrow-down list)                   |
| `⌃ Y`             | Select current query                                          |
| `⌃ H`             | Show MySQL help for current word or selection                 |
| `⌥ ⌘ F`           | Open query favorites popup menu                               |
| `⌥ ⌘ Y`           | Open query history popup menu                                 |
| `⌃ + ↑`           | Insert previous history item (successively)                   |
| `⌃ ↓`             | Insert next history item (successively)                       |
| `⌥ ⌘ 1`           | Show all database names as completion list                    |
| `⌥ ⌘ 2`           | Show all table and view names as completion list              |
| `⌥ ⌘ 3`           | Show all table names from current database as completion list |
