/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGStarTrackerTarget.h
 *
 * Star Tracker target. Sent to startracker.target message queue for other plugins to use.
 */

#ifndef SWGStarTrackerTarget_H_
#define SWGStarTrackerTarget_H_

#include <QJsonObject>


#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGStarTrackerTarget: public SWGObject {
public:
    SWGStarTrackerTarget();
    SWGStarTrackerTarget(QString* json);
    virtual ~SWGStarTrackerTarget();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGStarTrackerTarget* fromJson(QString &jsonString) override;

    QString* getName();
    void setName(QString* name);

    float getAzimuth();
    void setAzimuth(float azimuth);

    float getElevation();
    void setElevation(float elevation);

    float getRa();
    void setRa(float ra);

    float getDec();
    void setDec(float dec);

    float getB();
    void setB(float b);

    float getL();
    void setL(float l);

    float getEarthRotationVelocity();
    void setEarthRotationVelocity(float earth_rotation_velocity);

    float getEarthOrbitVelocityBcrs();
    void setEarthOrbitVelocityBcrs(float earth_orbit_velocity_bcrs);

    float getSunVelocityLsr();
    void setSunVelocityLsr(float sun_velocity_lsr);

    float getSolarFlux();
    void setSolarFlux(float solar_flux);

    float getAirTemperature();
    void setAirTemperature(float air_temperature);

    float getSkyTemperature();
    void setSkyTemperature(float sky_temperature);

    float getHpbw();
    void setHpbw(float hpbw);


    virtual bool isSet() override;

private:
    QString* name;
    bool m_name_isSet;

    float azimuth;
    bool m_azimuth_isSet;

    float elevation;
    bool m_elevation_isSet;

    float ra;
    bool m_ra_isSet;

    float dec;
    bool m_dec_isSet;

    float b;
    bool m_b_isSet;

    float l;
    bool m_l_isSet;

    float earth_rotation_velocity;
    bool m_earth_rotation_velocity_isSet;

    float earth_orbit_velocity_bcrs;
    bool m_earth_orbit_velocity_bcrs_isSet;

    float sun_velocity_lsr;
    bool m_sun_velocity_lsr_isSet;

    float solar_flux;
    bool m_solar_flux_isSet;

    float air_temperature;
    bool m_air_temperature_isSet;

    float sky_temperature;
    bool m_sky_temperature_isSet;

    float hpbw;
    bool m_hpbw_isSet;

};

}

#endif /* SWGStarTrackerTarget_H_ */
