/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGPacketModActions.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGPacketModActions::SWGPacketModActions(QString* json) {
    init();
    this->fromJson(*json);
}

SWGPacketModActions::SWGPacketModActions() {
    tx = 0;
    m_tx_isSet = false;
    payload = nullptr;
    m_payload_isSet = false;
}

SWGPacketModActions::~SWGPacketModActions() {
    this->cleanup();
}

void
SWGPacketModActions::init() {
    tx = 0;
    m_tx_isSet = false;
    payload = new SWGPacketModActions_payload();
    m_payload_isSet = false;
}

void
SWGPacketModActions::cleanup() {

    if(payload != nullptr) { 
        delete payload;
    }
}

SWGPacketModActions*
SWGPacketModActions::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGPacketModActions::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&tx, pJson["tx"], "qint32", "");
    
    ::SWGSDRangel::setValue(&payload, pJson["payload"], "SWGPacketModActions_payload", "SWGPacketModActions_payload");
    
}

QString
SWGPacketModActions::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGPacketModActions::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_tx_isSet){
        obj->insert("tx", QJsonValue(tx));
    }
    if((payload != nullptr) && (payload->isSet())){
        toJsonValue(QString("payload"), payload, obj, QString("SWGPacketModActions_payload"));
    }

    return obj;
}

qint32
SWGPacketModActions::getTx() {
    return tx;
}
void
SWGPacketModActions::setTx(qint32 tx) {
    this->tx = tx;
    this->m_tx_isSet = true;
}

SWGPacketModActions_payload*
SWGPacketModActions::getPayload() {
    return payload;
}
void
SWGPacketModActions::setPayload(SWGPacketModActions_payload* payload) {
    this->payload = payload;
    this->m_payload_isSet = true;
}


bool
SWGPacketModActions::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_tx_isSet){
            isObjectUpdated = true; break;
        }
        if(payload && payload->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

