/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGDOA2Settings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGDOA2Settings::SWGDOA2Settings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGDOA2Settings::SWGDOA2Settings() {
    correlation_type = 0;
    m_correlation_type_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    log2_decim = 0;
    m_log2_decim_isSet = false;
    filter_chain_hash = 0;
    m_filter_chain_hash_isSet = false;
    phase = 0;
    m_phase_isSet = false;
    antenna_az = 0;
    m_antenna_az_isSet = false;
    baseband_distance = 0;
    m_baseband_distance_isSet = false;
    squelchd_b = 0;
    m_squelchd_b_isSet = false;
    fft_averaging_value = 0;
    m_fft_averaging_value_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    scope_config = nullptr;
    m_scope_config_isSet = false;
    channel_marker = nullptr;
    m_channel_marker_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
}

SWGDOA2Settings::~SWGDOA2Settings() {
    this->cleanup();
}

void
SWGDOA2Settings::init() {
    correlation_type = 0;
    m_correlation_type_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    log2_decim = 0;
    m_log2_decim_isSet = false;
    filter_chain_hash = 0;
    m_filter_chain_hash_isSet = false;
    phase = 0;
    m_phase_isSet = false;
    antenna_az = 0;
    m_antenna_az_isSet = false;
    baseband_distance = 0;
    m_baseband_distance_isSet = false;
    squelchd_b = 0;
    m_squelchd_b_isSet = false;
    fft_averaging_value = 0;
    m_fft_averaging_value_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    scope_config = new SWGGLScope();
    m_scope_config_isSet = false;
    channel_marker = new SWGChannelMarker();
    m_channel_marker_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
}

void
SWGDOA2Settings::cleanup() {


    if(title != nullptr) { 
        delete title;
    }








    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



    if(scope_config != nullptr) { 
        delete scope_config;
    }
    if(channel_marker != nullptr) { 
        delete channel_marker;
    }
    if(rollup_state != nullptr) { 
        delete rollup_state;
    }
}

SWGDOA2Settings*
SWGDOA2Settings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGDOA2Settings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&correlation_type, pJson["correlationType"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&log2_decim, pJson["log2Decim"], "qint32", "");
    
    ::SWGSDRangel::setValue(&filter_chain_hash, pJson["filterChainHash"], "qint32", "");
    
    ::SWGSDRangel::setValue(&phase, pJson["phase"], "qint32", "");
    
    ::SWGSDRangel::setValue(&antenna_az, pJson["antennaAz"], "qint32", "");
    
    ::SWGSDRangel::setValue(&baseband_distance, pJson["basebandDistance"], "qint32", "");
    
    ::SWGSDRangel::setValue(&squelchd_b, pJson["squelchdB"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fft_averaging_value, pJson["fftAveragingValue"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_device_index, pJson["reverseAPIDeviceIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_channel_index, pJson["reverseAPIChannelIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&scope_config, pJson["scopeConfig"], "SWGGLScope", "SWGGLScope");
    
    ::SWGSDRangel::setValue(&channel_marker, pJson["channelMarker"], "SWGChannelMarker", "SWGChannelMarker");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
}

QString
SWGDOA2Settings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGDOA2Settings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_correlation_type_isSet){
        obj->insert("correlationType", QJsonValue(correlation_type));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_log2_decim_isSet){
        obj->insert("log2Decim", QJsonValue(log2_decim));
    }
    if(m_filter_chain_hash_isSet){
        obj->insert("filterChainHash", QJsonValue(filter_chain_hash));
    }
    if(m_phase_isSet){
        obj->insert("phase", QJsonValue(phase));
    }
    if(m_antenna_az_isSet){
        obj->insert("antennaAz", QJsonValue(antenna_az));
    }
    if(m_baseband_distance_isSet){
        obj->insert("basebandDistance", QJsonValue(baseband_distance));
    }
    if(m_squelchd_b_isSet){
        obj->insert("squelchdB", QJsonValue(squelchd_b));
    }
    if(m_fft_averaging_value_isSet){
        obj->insert("fftAveragingValue", QJsonValue(fft_averaging_value));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_device_index_isSet){
        obj->insert("reverseAPIDeviceIndex", QJsonValue(reverse_api_device_index));
    }
    if(m_reverse_api_channel_index_isSet){
        obj->insert("reverseAPIChannelIndex", QJsonValue(reverse_api_channel_index));
    }
    if((scope_config != nullptr) && (scope_config->isSet())){
        toJsonValue(QString("scopeConfig"), scope_config, obj, QString("SWGGLScope"));
    }
    if((channel_marker != nullptr) && (channel_marker->isSet())){
        toJsonValue(QString("channelMarker"), channel_marker, obj, QString("SWGChannelMarker"));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }

    return obj;
}

qint32
SWGDOA2Settings::getCorrelationType() {
    return correlation_type;
}
void
SWGDOA2Settings::setCorrelationType(qint32 correlation_type) {
    this->correlation_type = correlation_type;
    this->m_correlation_type_isSet = true;
}

qint32
SWGDOA2Settings::getRgbColor() {
    return rgb_color;
}
void
SWGDOA2Settings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

QString*
SWGDOA2Settings::getTitle() {
    return title;
}
void
SWGDOA2Settings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGDOA2Settings::getLog2Decim() {
    return log2_decim;
}
void
SWGDOA2Settings::setLog2Decim(qint32 log2_decim) {
    this->log2_decim = log2_decim;
    this->m_log2_decim_isSet = true;
}

qint32
SWGDOA2Settings::getFilterChainHash() {
    return filter_chain_hash;
}
void
SWGDOA2Settings::setFilterChainHash(qint32 filter_chain_hash) {
    this->filter_chain_hash = filter_chain_hash;
    this->m_filter_chain_hash_isSet = true;
}

qint32
SWGDOA2Settings::getPhase() {
    return phase;
}
void
SWGDOA2Settings::setPhase(qint32 phase) {
    this->phase = phase;
    this->m_phase_isSet = true;
}

qint32
SWGDOA2Settings::getAntennaAz() {
    return antenna_az;
}
void
SWGDOA2Settings::setAntennaAz(qint32 antenna_az) {
    this->antenna_az = antenna_az;
    this->m_antenna_az_isSet = true;
}

qint32
SWGDOA2Settings::getBasebandDistance() {
    return baseband_distance;
}
void
SWGDOA2Settings::setBasebandDistance(qint32 baseband_distance) {
    this->baseband_distance = baseband_distance;
    this->m_baseband_distance_isSet = true;
}

qint32
SWGDOA2Settings::getSquelchdB() {
    return squelchd_b;
}
void
SWGDOA2Settings::setSquelchdB(qint32 squelchd_b) {
    this->squelchd_b = squelchd_b;
    this->m_squelchd_b_isSet = true;
}

qint32
SWGDOA2Settings::getFftAveragingValue() {
    return fft_averaging_value;
}
void
SWGDOA2Settings::setFftAveragingValue(qint32 fft_averaging_value) {
    this->fft_averaging_value = fft_averaging_value;
    this->m_fft_averaging_value_isSet = true;
}

qint32
SWGDOA2Settings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGDOA2Settings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGDOA2Settings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGDOA2Settings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGDOA2Settings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGDOA2Settings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGDOA2Settings::getReverseApiDeviceIndex() {
    return reverse_api_device_index;
}
void
SWGDOA2Settings::setReverseApiDeviceIndex(qint32 reverse_api_device_index) {
    this->reverse_api_device_index = reverse_api_device_index;
    this->m_reverse_api_device_index_isSet = true;
}

qint32
SWGDOA2Settings::getReverseApiChannelIndex() {
    return reverse_api_channel_index;
}
void
SWGDOA2Settings::setReverseApiChannelIndex(qint32 reverse_api_channel_index) {
    this->reverse_api_channel_index = reverse_api_channel_index;
    this->m_reverse_api_channel_index_isSet = true;
}

SWGGLScope*
SWGDOA2Settings::getScopeConfig() {
    return scope_config;
}
void
SWGDOA2Settings::setScopeConfig(SWGGLScope* scope_config) {
    this->scope_config = scope_config;
    this->m_scope_config_isSet = true;
}

SWGChannelMarker*
SWGDOA2Settings::getChannelMarker() {
    return channel_marker;
}
void
SWGDOA2Settings::setChannelMarker(SWGChannelMarker* channel_marker) {
    this->channel_marker = channel_marker;
    this->m_channel_marker_isSet = true;
}

SWGRollupState*
SWGDOA2Settings::getRollupState() {
    return rollup_state;
}
void
SWGDOA2Settings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}


bool
SWGDOA2Settings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_correlation_type_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_log2_decim_isSet){
            isObjectUpdated = true; break;
        }
        if(m_filter_chain_hash_isSet){
            isObjectUpdated = true; break;
        }
        if(m_phase_isSet){
            isObjectUpdated = true; break;
        }
        if(m_antenna_az_isSet){
            isObjectUpdated = true; break;
        }
        if(m_baseband_distance_isSet){
            isObjectUpdated = true; break;
        }
        if(m_squelchd_b_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fft_averaging_value_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_device_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_channel_index_isSet){
            isObjectUpdated = true; break;
        }
        if(scope_config && scope_config->isSet()){
            isObjectUpdated = true; break;
        }
        if(channel_marker && channel_marker->isSet()){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

