/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGM17DemodSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGM17DemodSettings::SWGM17DemodSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGM17DemodSettings::SWGM17DemodSettings() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    rf_bandwidth = 0.0f;
    m_rf_bandwidth_isSet = false;
    fm_deviation = 0.0f;
    m_fm_deviation_isSet = false;
    volume = 0.0f;
    m_volume_isSet = false;
    demod_gain = 0.0f;
    m_demod_gain_isSet = false;
    baud_rate = 0;
    m_baud_rate_isSet = false;
    squelch_gate = 0;
    m_squelch_gate_isSet = false;
    squelch = 0.0f;
    m_squelch_isSet = false;
    audio_mute = 0;
    m_audio_mute_isSet = false;
    sync_or_constellation = 0;
    m_sync_or_constellation_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    high_pass_filter = 0;
    m_high_pass_filter_isSet = false;
    trace_length_mutliplier = 0;
    m_trace_length_mutliplier_isSet = false;
    trace_stroke = 0;
    m_trace_stroke_isSet = false;
    trace_decay = 0;
    m_trace_decay_isSet = false;
    audio_device_name = nullptr;
    m_audio_device_name_isSet = false;
    status_log_enabled = 0;
    m_status_log_enabled_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    channel_marker = nullptr;
    m_channel_marker_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
}

SWGM17DemodSettings::~SWGM17DemodSettings() {
    this->cleanup();
}

void
SWGM17DemodSettings::init() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    rf_bandwidth = 0.0f;
    m_rf_bandwidth_isSet = false;
    fm_deviation = 0.0f;
    m_fm_deviation_isSet = false;
    volume = 0.0f;
    m_volume_isSet = false;
    demod_gain = 0.0f;
    m_demod_gain_isSet = false;
    baud_rate = 0;
    m_baud_rate_isSet = false;
    squelch_gate = 0;
    m_squelch_gate_isSet = false;
    squelch = 0.0f;
    m_squelch_isSet = false;
    audio_mute = 0;
    m_audio_mute_isSet = false;
    sync_or_constellation = 0;
    m_sync_or_constellation_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    high_pass_filter = 0;
    m_high_pass_filter_isSet = false;
    trace_length_mutliplier = 0;
    m_trace_length_mutliplier_isSet = false;
    trace_stroke = 0;
    m_trace_stroke_isSet = false;
    trace_decay = 0;
    m_trace_decay_isSet = false;
    audio_device_name = new QString("");
    m_audio_device_name_isSet = false;
    status_log_enabled = 0;
    m_status_log_enabled_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    channel_marker = new SWGChannelMarker();
    m_channel_marker_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
}

void
SWGM17DemodSettings::cleanup() {











    if(title != nullptr) { 
        delete title;
    }




    if(audio_device_name != nullptr) { 
        delete audio_device_name;
    }



    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



    if(channel_marker != nullptr) { 
        delete channel_marker;
    }
    if(rollup_state != nullptr) { 
        delete rollup_state;
    }
}

SWGM17DemodSettings*
SWGM17DemodSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGM17DemodSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&input_frequency_offset, pJson["inputFrequencyOffset"], "qint64", "");
    
    ::SWGSDRangel::setValue(&rf_bandwidth, pJson["rfBandwidth"], "float", "");
    
    ::SWGSDRangel::setValue(&fm_deviation, pJson["fmDeviation"], "float", "");
    
    ::SWGSDRangel::setValue(&volume, pJson["volume"], "float", "");
    
    ::SWGSDRangel::setValue(&demod_gain, pJson["demodGain"], "float", "");
    
    ::SWGSDRangel::setValue(&baud_rate, pJson["baudRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&squelch_gate, pJson["squelchGate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&squelch, pJson["squelch"], "float", "");
    
    ::SWGSDRangel::setValue(&audio_mute, pJson["audioMute"], "qint32", "");
    
    ::SWGSDRangel::setValue(&sync_or_constellation, pJson["syncOrConstellation"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&high_pass_filter, pJson["highPassFilter"], "qint32", "");
    
    ::SWGSDRangel::setValue(&trace_length_mutliplier, pJson["traceLengthMutliplier"], "qint32", "");
    
    ::SWGSDRangel::setValue(&trace_stroke, pJson["traceStroke"], "qint32", "");
    
    ::SWGSDRangel::setValue(&trace_decay, pJson["traceDecay"], "qint32", "");
    
    ::SWGSDRangel::setValue(&audio_device_name, pJson["audioDeviceName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&status_log_enabled, pJson["statusLogEnabled"], "qint32", "");
    
    ::SWGSDRangel::setValue(&stream_index, pJson["streamIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_device_index, pJson["reverseAPIDeviceIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_channel_index, pJson["reverseAPIChannelIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&channel_marker, pJson["channelMarker"], "SWGChannelMarker", "SWGChannelMarker");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
}

QString
SWGM17DemodSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGM17DemodSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_input_frequency_offset_isSet){
        obj->insert("inputFrequencyOffset", QJsonValue(input_frequency_offset));
    }
    if(m_rf_bandwidth_isSet){
        obj->insert("rfBandwidth", QJsonValue(rf_bandwidth));
    }
    if(m_fm_deviation_isSet){
        obj->insert("fmDeviation", QJsonValue(fm_deviation));
    }
    if(m_volume_isSet){
        obj->insert("volume", QJsonValue(volume));
    }
    if(m_demod_gain_isSet){
        obj->insert("demodGain", QJsonValue(demod_gain));
    }
    if(m_baud_rate_isSet){
        obj->insert("baudRate", QJsonValue(baud_rate));
    }
    if(m_squelch_gate_isSet){
        obj->insert("squelchGate", QJsonValue(squelch_gate));
    }
    if(m_squelch_isSet){
        obj->insert("squelch", QJsonValue(squelch));
    }
    if(m_audio_mute_isSet){
        obj->insert("audioMute", QJsonValue(audio_mute));
    }
    if(m_sync_or_constellation_isSet){
        obj->insert("syncOrConstellation", QJsonValue(sync_or_constellation));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_high_pass_filter_isSet){
        obj->insert("highPassFilter", QJsonValue(high_pass_filter));
    }
    if(m_trace_length_mutliplier_isSet){
        obj->insert("traceLengthMutliplier", QJsonValue(trace_length_mutliplier));
    }
    if(m_trace_stroke_isSet){
        obj->insert("traceStroke", QJsonValue(trace_stroke));
    }
    if(m_trace_decay_isSet){
        obj->insert("traceDecay", QJsonValue(trace_decay));
    }
    if(audio_device_name != nullptr && *audio_device_name != QString("")){
        toJsonValue(QString("audioDeviceName"), audio_device_name, obj, QString("QString"));
    }
    if(m_status_log_enabled_isSet){
        obj->insert("statusLogEnabled", QJsonValue(status_log_enabled));
    }
    if(m_stream_index_isSet){
        obj->insert("streamIndex", QJsonValue(stream_index));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_device_index_isSet){
        obj->insert("reverseAPIDeviceIndex", QJsonValue(reverse_api_device_index));
    }
    if(m_reverse_api_channel_index_isSet){
        obj->insert("reverseAPIChannelIndex", QJsonValue(reverse_api_channel_index));
    }
    if((channel_marker != nullptr) && (channel_marker->isSet())){
        toJsonValue(QString("channelMarker"), channel_marker, obj, QString("SWGChannelMarker"));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }

    return obj;
}

qint64
SWGM17DemodSettings::getInputFrequencyOffset() {
    return input_frequency_offset;
}
void
SWGM17DemodSettings::setInputFrequencyOffset(qint64 input_frequency_offset) {
    this->input_frequency_offset = input_frequency_offset;
    this->m_input_frequency_offset_isSet = true;
}

float
SWGM17DemodSettings::getRfBandwidth() {
    return rf_bandwidth;
}
void
SWGM17DemodSettings::setRfBandwidth(float rf_bandwidth) {
    this->rf_bandwidth = rf_bandwidth;
    this->m_rf_bandwidth_isSet = true;
}

float
SWGM17DemodSettings::getFmDeviation() {
    return fm_deviation;
}
void
SWGM17DemodSettings::setFmDeviation(float fm_deviation) {
    this->fm_deviation = fm_deviation;
    this->m_fm_deviation_isSet = true;
}

float
SWGM17DemodSettings::getVolume() {
    return volume;
}
void
SWGM17DemodSettings::setVolume(float volume) {
    this->volume = volume;
    this->m_volume_isSet = true;
}

float
SWGM17DemodSettings::getDemodGain() {
    return demod_gain;
}
void
SWGM17DemodSettings::setDemodGain(float demod_gain) {
    this->demod_gain = demod_gain;
    this->m_demod_gain_isSet = true;
}

qint32
SWGM17DemodSettings::getBaudRate() {
    return baud_rate;
}
void
SWGM17DemodSettings::setBaudRate(qint32 baud_rate) {
    this->baud_rate = baud_rate;
    this->m_baud_rate_isSet = true;
}

qint32
SWGM17DemodSettings::getSquelchGate() {
    return squelch_gate;
}
void
SWGM17DemodSettings::setSquelchGate(qint32 squelch_gate) {
    this->squelch_gate = squelch_gate;
    this->m_squelch_gate_isSet = true;
}

float
SWGM17DemodSettings::getSquelch() {
    return squelch;
}
void
SWGM17DemodSettings::setSquelch(float squelch) {
    this->squelch = squelch;
    this->m_squelch_isSet = true;
}

qint32
SWGM17DemodSettings::getAudioMute() {
    return audio_mute;
}
void
SWGM17DemodSettings::setAudioMute(qint32 audio_mute) {
    this->audio_mute = audio_mute;
    this->m_audio_mute_isSet = true;
}

qint32
SWGM17DemodSettings::getSyncOrConstellation() {
    return sync_or_constellation;
}
void
SWGM17DemodSettings::setSyncOrConstellation(qint32 sync_or_constellation) {
    this->sync_or_constellation = sync_or_constellation;
    this->m_sync_or_constellation_isSet = true;
}

qint32
SWGM17DemodSettings::getRgbColor() {
    return rgb_color;
}
void
SWGM17DemodSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

QString*
SWGM17DemodSettings::getTitle() {
    return title;
}
void
SWGM17DemodSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGM17DemodSettings::getHighPassFilter() {
    return high_pass_filter;
}
void
SWGM17DemodSettings::setHighPassFilter(qint32 high_pass_filter) {
    this->high_pass_filter = high_pass_filter;
    this->m_high_pass_filter_isSet = true;
}

qint32
SWGM17DemodSettings::getTraceLengthMutliplier() {
    return trace_length_mutliplier;
}
void
SWGM17DemodSettings::setTraceLengthMutliplier(qint32 trace_length_mutliplier) {
    this->trace_length_mutliplier = trace_length_mutliplier;
    this->m_trace_length_mutliplier_isSet = true;
}

qint32
SWGM17DemodSettings::getTraceStroke() {
    return trace_stroke;
}
void
SWGM17DemodSettings::setTraceStroke(qint32 trace_stroke) {
    this->trace_stroke = trace_stroke;
    this->m_trace_stroke_isSet = true;
}

qint32
SWGM17DemodSettings::getTraceDecay() {
    return trace_decay;
}
void
SWGM17DemodSettings::setTraceDecay(qint32 trace_decay) {
    this->trace_decay = trace_decay;
    this->m_trace_decay_isSet = true;
}

QString*
SWGM17DemodSettings::getAudioDeviceName() {
    return audio_device_name;
}
void
SWGM17DemodSettings::setAudioDeviceName(QString* audio_device_name) {
    this->audio_device_name = audio_device_name;
    this->m_audio_device_name_isSet = true;
}

qint32
SWGM17DemodSettings::getStatusLogEnabled() {
    return status_log_enabled;
}
void
SWGM17DemodSettings::setStatusLogEnabled(qint32 status_log_enabled) {
    this->status_log_enabled = status_log_enabled;
    this->m_status_log_enabled_isSet = true;
}

qint32
SWGM17DemodSettings::getStreamIndex() {
    return stream_index;
}
void
SWGM17DemodSettings::setStreamIndex(qint32 stream_index) {
    this->stream_index = stream_index;
    this->m_stream_index_isSet = true;
}

qint32
SWGM17DemodSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGM17DemodSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGM17DemodSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGM17DemodSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGM17DemodSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGM17DemodSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGM17DemodSettings::getReverseApiDeviceIndex() {
    return reverse_api_device_index;
}
void
SWGM17DemodSettings::setReverseApiDeviceIndex(qint32 reverse_api_device_index) {
    this->reverse_api_device_index = reverse_api_device_index;
    this->m_reverse_api_device_index_isSet = true;
}

qint32
SWGM17DemodSettings::getReverseApiChannelIndex() {
    return reverse_api_channel_index;
}
void
SWGM17DemodSettings::setReverseApiChannelIndex(qint32 reverse_api_channel_index) {
    this->reverse_api_channel_index = reverse_api_channel_index;
    this->m_reverse_api_channel_index_isSet = true;
}

SWGChannelMarker*
SWGM17DemodSettings::getChannelMarker() {
    return channel_marker;
}
void
SWGM17DemodSettings::setChannelMarker(SWGChannelMarker* channel_marker) {
    this->channel_marker = channel_marker;
    this->m_channel_marker_isSet = true;
}

SWGRollupState*
SWGM17DemodSettings::getRollupState() {
    return rollup_state;
}
void
SWGM17DemodSettings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}


bool
SWGM17DemodSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_input_frequency_offset_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rf_bandwidth_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fm_deviation_isSet){
            isObjectUpdated = true; break;
        }
        if(m_volume_isSet){
            isObjectUpdated = true; break;
        }
        if(m_demod_gain_isSet){
            isObjectUpdated = true; break;
        }
        if(m_baud_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_squelch_gate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_squelch_isSet){
            isObjectUpdated = true; break;
        }
        if(m_audio_mute_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sync_or_constellation_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_high_pass_filter_isSet){
            isObjectUpdated = true; break;
        }
        if(m_trace_length_mutliplier_isSet){
            isObjectUpdated = true; break;
        }
        if(m_trace_stroke_isSet){
            isObjectUpdated = true; break;
        }
        if(m_trace_decay_isSet){
            isObjectUpdated = true; break;
        }
        if(audio_device_name && *audio_device_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_status_log_enabled_isSet){
            isObjectUpdated = true; break;
        }
        if(m_stream_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_device_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_channel_index_isSet){
            isObjectUpdated = true; break;
        }
        if(channel_marker && channel_marker->isSet()){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

