/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGCapture.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGCapture::SWGCapture(QString* json) {
    init();
    this->fromJson(*json);
}

SWGCapture::SWGCapture() {
    tsms = 0L;
    m_tsms_isSet = false;
    center_frequency = 0L;
    m_center_frequency_isSet = false;
    sample_rate = 0;
    m_sample_rate_isSet = false;
    sample_start = 0L;
    m_sample_start_isSet = false;
    length = 0L;
    m_length_isSet = false;
    cumulative_time = 0L;
    m_cumulative_time_isSet = false;
}

SWGCapture::~SWGCapture() {
    this->cleanup();
}

void
SWGCapture::init() {
    tsms = 0L;
    m_tsms_isSet = false;
    center_frequency = 0L;
    m_center_frequency_isSet = false;
    sample_rate = 0;
    m_sample_rate_isSet = false;
    sample_start = 0L;
    m_sample_start_isSet = false;
    length = 0L;
    m_length_isSet = false;
    cumulative_time = 0L;
    m_cumulative_time_isSet = false;
}

void
SWGCapture::cleanup() {






}

SWGCapture*
SWGCapture::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGCapture::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&tsms, pJson["tsms"], "qint64", "");
    
    ::SWGSDRangel::setValue(&center_frequency, pJson["centerFrequency"], "qint64", "");
    
    ::SWGSDRangel::setValue(&sample_rate, pJson["sampleRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&sample_start, pJson["sampleStart"], "qint64", "");
    
    ::SWGSDRangel::setValue(&length, pJson["length"], "qint64", "");
    
    ::SWGSDRangel::setValue(&cumulative_time, pJson["cumulativeTime"], "qint64", "");
    
}

QString
SWGCapture::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGCapture::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_tsms_isSet){
        obj->insert("tsms", QJsonValue(tsms));
    }
    if(m_center_frequency_isSet){
        obj->insert("centerFrequency", QJsonValue(center_frequency));
    }
    if(m_sample_rate_isSet){
        obj->insert("sampleRate", QJsonValue(sample_rate));
    }
    if(m_sample_start_isSet){
        obj->insert("sampleStart", QJsonValue(sample_start));
    }
    if(m_length_isSet){
        obj->insert("length", QJsonValue(length));
    }
    if(m_cumulative_time_isSet){
        obj->insert("cumulativeTime", QJsonValue(cumulative_time));
    }

    return obj;
}

qint64
SWGCapture::getTsms() {
    return tsms;
}
void
SWGCapture::setTsms(qint64 tsms) {
    this->tsms = tsms;
    this->m_tsms_isSet = true;
}

qint64
SWGCapture::getCenterFrequency() {
    return center_frequency;
}
void
SWGCapture::setCenterFrequency(qint64 center_frequency) {
    this->center_frequency = center_frequency;
    this->m_center_frequency_isSet = true;
}

qint32
SWGCapture::getSampleRate() {
    return sample_rate;
}
void
SWGCapture::setSampleRate(qint32 sample_rate) {
    this->sample_rate = sample_rate;
    this->m_sample_rate_isSet = true;
}

qint64
SWGCapture::getSampleStart() {
    return sample_start;
}
void
SWGCapture::setSampleStart(qint64 sample_start) {
    this->sample_start = sample_start;
    this->m_sample_start_isSet = true;
}

qint64
SWGCapture::getLength() {
    return length;
}
void
SWGCapture::setLength(qint64 length) {
    this->length = length;
    this->m_length_isSet = true;
}

qint64
SWGCapture::getCumulativeTime() {
    return cumulative_time;
}
void
SWGCapture::setCumulativeTime(qint64 cumulative_time) {
    this->cumulative_time = cumulative_time;
    this->m_cumulative_time_isSet = true;
}


bool
SWGCapture::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_tsms_isSet){
            isObjectUpdated = true; break;
        }
        if(m_center_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sample_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sample_start_isSet){
            isObjectUpdated = true; break;
        }
        if(m_length_isSet){
            isObjectUpdated = true; break;
        }
        if(m_cumulative_time_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

