/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGMapItem.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGMapItem::SWGMapItem(QString* json) {
    init();
    this->fromJson(*json);
}

SWGMapItem::SWGMapItem() {
    name = nullptr;
    m_name_isSet = false;
    image = nullptr;
    m_image_isSet = false;
    image_rotation = 0;
    m_image_rotation_isSet = false;
    image_min_zoom = 0;
    m_image_min_zoom_isSet = false;
    text = nullptr;
    m_text_isSet = false;
    latitude = 0.0f;
    m_latitude_isSet = false;
    longitude = 0.0f;
    m_longitude_isSet = false;
    altitude = 0.0f;
    m_altitude_isSet = false;
}

SWGMapItem::~SWGMapItem() {
    this->cleanup();
}

void
SWGMapItem::init() {
    name = new QString("");
    m_name_isSet = false;
    image = new QString("");
    m_image_isSet = false;
    image_rotation = 0;
    m_image_rotation_isSet = false;
    image_min_zoom = 0;
    m_image_min_zoom_isSet = false;
    text = new QString("");
    m_text_isSet = false;
    latitude = 0.0f;
    m_latitude_isSet = false;
    longitude = 0.0f;
    m_longitude_isSet = false;
    altitude = 0.0f;
    m_altitude_isSet = false;
}

void
SWGMapItem::cleanup() {
    if(name != nullptr) { 
        delete name;
    }
    if(image != nullptr) { 
        delete image;
    }


    if(text != nullptr) { 
        delete text;
    }



}

SWGMapItem*
SWGMapItem::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGMapItem::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&name, pJson["name"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&image, pJson["image"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&image_rotation, pJson["imageRotation"], "qint32", "");
    
    ::SWGSDRangel::setValue(&image_min_zoom, pJson["imageMinZoom"], "qint32", "");
    
    ::SWGSDRangel::setValue(&text, pJson["text"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&latitude, pJson["latitude"], "float", "");
    
    ::SWGSDRangel::setValue(&longitude, pJson["longitude"], "float", "");
    
    ::SWGSDRangel::setValue(&altitude, pJson["altitude"], "float", "");
    
}

QString
SWGMapItem::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGMapItem::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(name != nullptr && *name != QString("")){
        toJsonValue(QString("name"), name, obj, QString("QString"));
    }
    if(image != nullptr && *image != QString("")){
        toJsonValue(QString("image"), image, obj, QString("QString"));
    }
    if(m_image_rotation_isSet){
        obj->insert("imageRotation", QJsonValue(image_rotation));
    }
    if(m_image_min_zoom_isSet){
        obj->insert("imageMinZoom", QJsonValue(image_min_zoom));
    }
    if(text != nullptr && *text != QString("")){
        toJsonValue(QString("text"), text, obj, QString("QString"));
    }
    if(m_latitude_isSet){
        obj->insert("latitude", QJsonValue(latitude));
    }
    if(m_longitude_isSet){
        obj->insert("longitude", QJsonValue(longitude));
    }
    if(m_altitude_isSet){
        obj->insert("altitude", QJsonValue(altitude));
    }

    return obj;
}

QString*
SWGMapItem::getName() {
    return name;
}
void
SWGMapItem::setName(QString* name) {
    this->name = name;
    this->m_name_isSet = true;
}

QString*
SWGMapItem::getImage() {
    return image;
}
void
SWGMapItem::setImage(QString* image) {
    this->image = image;
    this->m_image_isSet = true;
}

qint32
SWGMapItem::getImageRotation() {
    return image_rotation;
}
void
SWGMapItem::setImageRotation(qint32 image_rotation) {
    this->image_rotation = image_rotation;
    this->m_image_rotation_isSet = true;
}

qint32
SWGMapItem::getImageMinZoom() {
    return image_min_zoom;
}
void
SWGMapItem::setImageMinZoom(qint32 image_min_zoom) {
    this->image_min_zoom = image_min_zoom;
    this->m_image_min_zoom_isSet = true;
}

QString*
SWGMapItem::getText() {
    return text;
}
void
SWGMapItem::setText(QString* text) {
    this->text = text;
    this->m_text_isSet = true;
}

float
SWGMapItem::getLatitude() {
    return latitude;
}
void
SWGMapItem::setLatitude(float latitude) {
    this->latitude = latitude;
    this->m_latitude_isSet = true;
}

float
SWGMapItem::getLongitude() {
    return longitude;
}
void
SWGMapItem::setLongitude(float longitude) {
    this->longitude = longitude;
    this->m_longitude_isSet = true;
}

float
SWGMapItem::getAltitude() {
    return altitude;
}
void
SWGMapItem::setAltitude(float altitude) {
    this->altitude = altitude;
    this->m_altitude_isSet = true;
}


bool
SWGMapItem::isSet(){
    bool isObjectUpdated = false;
    do{
        if(name && *name != QString("")){
            isObjectUpdated = true; break;
        }
        if(image && *image != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_image_rotation_isSet){
            isObjectUpdated = true; break;
        }
        if(m_image_min_zoom_isSet){
            isObjectUpdated = true; break;
        }
        if(text && *text != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_latitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_longitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_altitude_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

