/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGMapActions.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGMapActions::SWGMapActions(QString* json) {
    init();
    this->fromJson(*json);
}

SWGMapActions::SWGMapActions() {
    find = nullptr;
    m_find_isSet = false;
    set_date_time = nullptr;
    m_set_date_time_isSet = false;
}

SWGMapActions::~SWGMapActions() {
    this->cleanup();
}

void
SWGMapActions::init() {
    find = new QString("");
    m_find_isSet = false;
    set_date_time = new QString("");
    m_set_date_time_isSet = false;
}

void
SWGMapActions::cleanup() {
    if(find != nullptr) { 
        delete find;
    }
    if(set_date_time != nullptr) { 
        delete set_date_time;
    }
}

SWGMapActions*
SWGMapActions::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGMapActions::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&find, pJson["find"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&set_date_time, pJson["setDateTime"], "QString", "QString");
    
}

QString
SWGMapActions::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGMapActions::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(find != nullptr && *find != QString("")){
        toJsonValue(QString("find"), find, obj, QString("QString"));
    }
    if(set_date_time != nullptr && *set_date_time != QString("")){
        toJsonValue(QString("setDateTime"), set_date_time, obj, QString("QString"));
    }

    return obj;
}

QString*
SWGMapActions::getFind() {
    return find;
}
void
SWGMapActions::setFind(QString* find) {
    this->find = find;
    this->m_find_isSet = true;
}

QString*
SWGMapActions::getSetDateTime() {
    return set_date_time;
}
void
SWGMapActions::setSetDateTime(QString* set_date_time) {
    this->set_date_time = set_date_time;
    this->m_set_date_time_isSet = true;
}


bool
SWGMapActions::isSet(){
    bool isObjectUpdated = false;
    do{
        if(find && *find != QString("")){
            isObjectUpdated = true; break;
        }
        if(set_date_time && *set_date_time != QString("")){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

