/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGVORLocalizerSettings_vorDemodChannels.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGVORLocalizerSettings_vorDemodChannels::SWGVORLocalizerSettings_vorDemodChannels(QString* json) {
    init();
    this->fromJson(*json);
}

SWGVORLocalizerSettings_vorDemodChannels::SWGVORLocalizerSettings_vorDemodChannels() {
    device_set_index = 0;
    m_device_set_index_isSet = false;
    channel_index = 0;
    m_channel_index_isSet = false;
}

SWGVORLocalizerSettings_vorDemodChannels::~SWGVORLocalizerSettings_vorDemodChannels() {
    this->cleanup();
}

void
SWGVORLocalizerSettings_vorDemodChannels::init() {
    device_set_index = 0;
    m_device_set_index_isSet = false;
    channel_index = 0;
    m_channel_index_isSet = false;
}

void
SWGVORLocalizerSettings_vorDemodChannels::cleanup() {


}

SWGVORLocalizerSettings_vorDemodChannels*
SWGVORLocalizerSettings_vorDemodChannels::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGVORLocalizerSettings_vorDemodChannels::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&device_set_index, pJson["deviceSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&channel_index, pJson["channelIndex"], "qint32", "");
    
}

QString
SWGVORLocalizerSettings_vorDemodChannels::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGVORLocalizerSettings_vorDemodChannels::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_device_set_index_isSet){
        obj->insert("deviceSetIndex", QJsonValue(device_set_index));
    }
    if(m_channel_index_isSet){
        obj->insert("channelIndex", QJsonValue(channel_index));
    }

    return obj;
}

qint32
SWGVORLocalizerSettings_vorDemodChannels::getDeviceSetIndex() {
    return device_set_index;
}
void
SWGVORLocalizerSettings_vorDemodChannels::setDeviceSetIndex(qint32 device_set_index) {
    this->device_set_index = device_set_index;
    this->m_device_set_index_isSet = true;
}

qint32
SWGVORLocalizerSettings_vorDemodChannels::getChannelIndex() {
    return channel_index;
}
void
SWGVORLocalizerSettings_vorDemodChannels::setChannelIndex(qint32 channel_index) {
    this->channel_index = channel_index;
    this->m_channel_index_isSet = true;
}


bool
SWGVORLocalizerSettings_vorDemodChannels::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_device_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_channel_index_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

