/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGSpectrumWaterfallMarker.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGSpectrumWaterfallMarker::SWGSpectrumWaterfallMarker(QString* json) {
    init();
    this->fromJson(*json);
}

SWGSpectrumWaterfallMarker::SWGSpectrumWaterfallMarker() {
    frequency = 0.0f;
    m_frequency_isSet = false;
    time = 0.0f;
    m_time_isSet = false;
    marker_color = 0;
    m_marker_color_isSet = false;
    show = 0;
    m_show_isSet = false;
}

SWGSpectrumWaterfallMarker::~SWGSpectrumWaterfallMarker() {
    this->cleanup();
}

void
SWGSpectrumWaterfallMarker::init() {
    frequency = 0.0f;
    m_frequency_isSet = false;
    time = 0.0f;
    m_time_isSet = false;
    marker_color = 0;
    m_marker_color_isSet = false;
    show = 0;
    m_show_isSet = false;
}

void
SWGSpectrumWaterfallMarker::cleanup() {




}

SWGSpectrumWaterfallMarker*
SWGSpectrumWaterfallMarker::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGSpectrumWaterfallMarker::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&frequency, pJson["frequency"], "float", "");
    
    ::SWGSDRangel::setValue(&time, pJson["time"], "float", "");
    
    ::SWGSDRangel::setValue(&marker_color, pJson["markerColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&show, pJson["show"], "qint32", "");
    
}

QString
SWGSpectrumWaterfallMarker::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGSpectrumWaterfallMarker::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_frequency_isSet){
        obj->insert("frequency", QJsonValue(frequency));
    }
    if(m_time_isSet){
        obj->insert("time", QJsonValue(time));
    }
    if(m_marker_color_isSet){
        obj->insert("markerColor", QJsonValue(marker_color));
    }
    if(m_show_isSet){
        obj->insert("show", QJsonValue(show));
    }

    return obj;
}

float
SWGSpectrumWaterfallMarker::getFrequency() {
    return frequency;
}
void
SWGSpectrumWaterfallMarker::setFrequency(float frequency) {
    this->frequency = frequency;
    this->m_frequency_isSet = true;
}

float
SWGSpectrumWaterfallMarker::getTime() {
    return time;
}
void
SWGSpectrumWaterfallMarker::setTime(float time) {
    this->time = time;
    this->m_time_isSet = true;
}

qint32
SWGSpectrumWaterfallMarker::getMarkerColor() {
    return marker_color;
}
void
SWGSpectrumWaterfallMarker::setMarkerColor(qint32 marker_color) {
    this->marker_color = marker_color;
    this->m_marker_color_isSet = true;
}

qint32
SWGSpectrumWaterfallMarker::getShow() {
    return show;
}
void
SWGSpectrumWaterfallMarker::setShow(qint32 show) {
    this->show = show;
    this->m_show_isSet = true;
}


bool
SWGSpectrumWaterfallMarker::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(m_time_isSet){
            isObjectUpdated = true; break;
        }
        if(m_marker_color_isSet){
            isObjectUpdated = true; break;
        }
        if(m_show_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

