/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGChannelMarker.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGChannelMarker::SWGChannelMarker(QString* json) {
    init();
    this->fromJson(*json);
}

SWGChannelMarker::SWGChannelMarker() {
    center_frequency = 0;
    m_center_frequency_isSet = false;
    color = 0;
    m_color_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    frequency_scale_display_type = 0;
    m_frequency_scale_display_type_isSet = false;
}

SWGChannelMarker::~SWGChannelMarker() {
    this->cleanup();
}

void
SWGChannelMarker::init() {
    center_frequency = 0;
    m_center_frequency_isSet = false;
    color = 0;
    m_color_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    frequency_scale_display_type = 0;
    m_frequency_scale_display_type_isSet = false;
}

void
SWGChannelMarker::cleanup() {


    if(title != nullptr) { 
        delete title;
    }

}

SWGChannelMarker*
SWGChannelMarker::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGChannelMarker::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&center_frequency, pJson["centerFrequency"], "qint32", "");
    
    ::SWGSDRangel::setValue(&color, pJson["color"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&frequency_scale_display_type, pJson["frequencyScaleDisplayType"], "qint32", "");
    
}

QString
SWGChannelMarker::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGChannelMarker::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_center_frequency_isSet){
        obj->insert("centerFrequency", QJsonValue(center_frequency));
    }
    if(m_color_isSet){
        obj->insert("color", QJsonValue(color));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_frequency_scale_display_type_isSet){
        obj->insert("frequencyScaleDisplayType", QJsonValue(frequency_scale_display_type));
    }

    return obj;
}

qint32
SWGChannelMarker::getCenterFrequency() {
    return center_frequency;
}
void
SWGChannelMarker::setCenterFrequency(qint32 center_frequency) {
    this->center_frequency = center_frequency;
    this->m_center_frequency_isSet = true;
}

qint32
SWGChannelMarker::getColor() {
    return color;
}
void
SWGChannelMarker::setColor(qint32 color) {
    this->color = color;
    this->m_color_isSet = true;
}

QString*
SWGChannelMarker::getTitle() {
    return title;
}
void
SWGChannelMarker::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGChannelMarker::getFrequencyScaleDisplayType() {
    return frequency_scale_display_type;
}
void
SWGChannelMarker::setFrequencyScaleDisplayType(qint32 frequency_scale_display_type) {
    this->frequency_scale_display_type = frequency_scale_display_type;
    this->m_frequency_scale_display_type_isSet = true;
}


bool
SWGChannelMarker::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_center_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(m_color_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_frequency_scale_display_type_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

