/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGADSBDemodSettings.h
 *
 * ADSBDemod
 */

#ifndef SWGADSBDemodSettings_H_
#define SWGADSBDemodSettings_H_

#include <QJsonObject>


#include "SWGChannelMarker.h"
#include "SWGRollupState.h"
#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGADSBDemodSettings: public SWGObject {
public:
    SWGADSBDemodSettings();
    SWGADSBDemodSettings(QString* json);
    virtual ~SWGADSBDemodSettings();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGADSBDemodSettings* fromJson(QString &jsonString) override;

    qint64 getInputFrequencyOffset();
    void setInputFrequencyOffset(qint64 input_frequency_offset);

    float getRfBandwidth();
    void setRfBandwidth(float rf_bandwidth);

    float getCorrelationThreshold();
    void setCorrelationThreshold(float correlation_threshold);

    qint32 getSamplesPerBit();
    void setSamplesPerBit(qint32 samples_per_bit);

    qint32 getCorrelateFullPreamble();
    void setCorrelateFullPreamble(qint32 correlate_full_preamble);

    qint32 getDemodModeS();
    void setDemodModeS(qint32 demod_mode_s);

    qint32 getInterpolatorPhaseSteps();
    void setInterpolatorPhaseSteps(qint32 interpolator_phase_steps);

    float getInterpolatorTapsPerPhase();
    void setInterpolatorTapsPerPhase(float interpolator_taps_per_phase);

    qint32 getRemoveTimeout();
    void setRemoveTimeout(qint32 remove_timeout);

    qint32 getBeastEnabled();
    void setBeastEnabled(qint32 beast_enabled);

    QString* getBeastHost();
    void setBeastHost(QString* beast_host);

    qint32 getBeastPort();
    void setBeastPort(qint32 beast_port);

    qint32 getFeedFormat();
    void setFeedFormat(qint32 feed_format);

    QString* getLogFilename();
    void setLogFilename(QString* log_filename);

    qint32 getLogEnabled();
    void setLogEnabled(qint32 log_enabled);

    qint32 getRgbColor();
    void setRgbColor(qint32 rgb_color);

    QString* getTitle();
    void setTitle(QString* title);

    qint32 getStreamIndex();
    void setStreamIndex(qint32 stream_index);

    qint32 getUseReverseApi();
    void setUseReverseApi(qint32 use_reverse_api);

    QString* getReverseApiAddress();
    void setReverseApiAddress(QString* reverse_api_address);

    qint32 getReverseApiPort();
    void setReverseApiPort(qint32 reverse_api_port);

    qint32 getReverseApiDeviceIndex();
    void setReverseApiDeviceIndex(qint32 reverse_api_device_index);

    qint32 getReverseApiChannelIndex();
    void setReverseApiChannelIndex(qint32 reverse_api_channel_index);

    SWGChannelMarker* getChannelMarker();
    void setChannelMarker(SWGChannelMarker* channel_marker);

    SWGRollupState* getRollupState();
    void setRollupState(SWGRollupState* rollup_state);


    virtual bool isSet() override;

private:
    qint64 input_frequency_offset;
    bool m_input_frequency_offset_isSet;

    float rf_bandwidth;
    bool m_rf_bandwidth_isSet;

    float correlation_threshold;
    bool m_correlation_threshold_isSet;

    qint32 samples_per_bit;
    bool m_samples_per_bit_isSet;

    qint32 correlate_full_preamble;
    bool m_correlate_full_preamble_isSet;

    qint32 demod_mode_s;
    bool m_demod_mode_s_isSet;

    qint32 interpolator_phase_steps;
    bool m_interpolator_phase_steps_isSet;

    float interpolator_taps_per_phase;
    bool m_interpolator_taps_per_phase_isSet;

    qint32 remove_timeout;
    bool m_remove_timeout_isSet;

    qint32 beast_enabled;
    bool m_beast_enabled_isSet;

    QString* beast_host;
    bool m_beast_host_isSet;

    qint32 beast_port;
    bool m_beast_port_isSet;

    qint32 feed_format;
    bool m_feed_format_isSet;

    QString* log_filename;
    bool m_log_filename_isSet;

    qint32 log_enabled;
    bool m_log_enabled_isSet;

    qint32 rgb_color;
    bool m_rgb_color_isSet;

    QString* title;
    bool m_title_isSet;

    qint32 stream_index;
    bool m_stream_index_isSet;

    qint32 use_reverse_api;
    bool m_use_reverse_api_isSet;

    QString* reverse_api_address;
    bool m_reverse_api_address_isSet;

    qint32 reverse_api_port;
    bool m_reverse_api_port_isSet;

    qint32 reverse_api_device_index;
    bool m_reverse_api_device_index_isSet;

    qint32 reverse_api_channel_index;
    bool m_reverse_api_channel_index_isSet;

    SWGChannelMarker* channel_marker;
    bool m_channel_marker_isSet;

    SWGRollupState* rollup_state;
    bool m_rollup_state_isSet;

};

}

#endif /* SWGADSBDemodSettings_H_ */
