/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGRemoteOutputReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGRemoteOutputReport::SWGRemoteOutputReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGRemoteOutputReport::SWGRemoteOutputReport() {
    center_frequency = 0L;
    m_center_frequency_isSet = false;
    sample_rate = 0;
    m_sample_rate_isSet = false;
    queue_length = 0;
    m_queue_length_isSet = false;
    queue_size = 0;
    m_queue_size_isSet = false;
    sample_count = 0;
    m_sample_count_isSet = false;
    correctable_errors_count = 0;
    m_correctable_errors_count_isSet = false;
    uncorrectable_errors_count = 0;
    m_uncorrectable_errors_count_isSet = false;
    tv_sec = 0;
    m_tv_sec_isSet = false;
    tv_u_sec = 0;
    m_tv_u_sec_isSet = false;
}

SWGRemoteOutputReport::~SWGRemoteOutputReport() {
    this->cleanup();
}

void
SWGRemoteOutputReport::init() {
    center_frequency = 0L;
    m_center_frequency_isSet = false;
    sample_rate = 0;
    m_sample_rate_isSet = false;
    queue_length = 0;
    m_queue_length_isSet = false;
    queue_size = 0;
    m_queue_size_isSet = false;
    sample_count = 0;
    m_sample_count_isSet = false;
    correctable_errors_count = 0;
    m_correctable_errors_count_isSet = false;
    uncorrectable_errors_count = 0;
    m_uncorrectable_errors_count_isSet = false;
    tv_sec = 0;
    m_tv_sec_isSet = false;
    tv_u_sec = 0;
    m_tv_u_sec_isSet = false;
}

void
SWGRemoteOutputReport::cleanup() {









}

SWGRemoteOutputReport*
SWGRemoteOutputReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGRemoteOutputReport::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&center_frequency, pJson["centerFrequency"], "qint64", "");
    
    ::SWGSDRangel::setValue(&sample_rate, pJson["sampleRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&queue_length, pJson["queueLength"], "qint32", "");
    
    ::SWGSDRangel::setValue(&queue_size, pJson["queueSize"], "qint32", "");
    
    ::SWGSDRangel::setValue(&sample_count, pJson["sampleCount"], "qint32", "");
    
    ::SWGSDRangel::setValue(&correctable_errors_count, pJson["correctableErrorsCount"], "qint32", "");
    
    ::SWGSDRangel::setValue(&uncorrectable_errors_count, pJson["uncorrectableErrorsCount"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tv_sec, pJson["tvSec"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tv_u_sec, pJson["tvUSec"], "qint32", "");
    
}

QString
SWGRemoteOutputReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGRemoteOutputReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_center_frequency_isSet){
        obj->insert("centerFrequency", QJsonValue(center_frequency));
    }
    if(m_sample_rate_isSet){
        obj->insert("sampleRate", QJsonValue(sample_rate));
    }
    if(m_queue_length_isSet){
        obj->insert("queueLength", QJsonValue(queue_length));
    }
    if(m_queue_size_isSet){
        obj->insert("queueSize", QJsonValue(queue_size));
    }
    if(m_sample_count_isSet){
        obj->insert("sampleCount", QJsonValue(sample_count));
    }
    if(m_correctable_errors_count_isSet){
        obj->insert("correctableErrorsCount", QJsonValue(correctable_errors_count));
    }
    if(m_uncorrectable_errors_count_isSet){
        obj->insert("uncorrectableErrorsCount", QJsonValue(uncorrectable_errors_count));
    }
    if(m_tv_sec_isSet){
        obj->insert("tvSec", QJsonValue(tv_sec));
    }
    if(m_tv_u_sec_isSet){
        obj->insert("tvUSec", QJsonValue(tv_u_sec));
    }

    return obj;
}

qint64
SWGRemoteOutputReport::getCenterFrequency() {
    return center_frequency;
}
void
SWGRemoteOutputReport::setCenterFrequency(qint64 center_frequency) {
    this->center_frequency = center_frequency;
    this->m_center_frequency_isSet = true;
}

qint32
SWGRemoteOutputReport::getSampleRate() {
    return sample_rate;
}
void
SWGRemoteOutputReport::setSampleRate(qint32 sample_rate) {
    this->sample_rate = sample_rate;
    this->m_sample_rate_isSet = true;
}

qint32
SWGRemoteOutputReport::getQueueLength() {
    return queue_length;
}
void
SWGRemoteOutputReport::setQueueLength(qint32 queue_length) {
    this->queue_length = queue_length;
    this->m_queue_length_isSet = true;
}

qint32
SWGRemoteOutputReport::getQueueSize() {
    return queue_size;
}
void
SWGRemoteOutputReport::setQueueSize(qint32 queue_size) {
    this->queue_size = queue_size;
    this->m_queue_size_isSet = true;
}

qint32
SWGRemoteOutputReport::getSampleCount() {
    return sample_count;
}
void
SWGRemoteOutputReport::setSampleCount(qint32 sample_count) {
    this->sample_count = sample_count;
    this->m_sample_count_isSet = true;
}

qint32
SWGRemoteOutputReport::getCorrectableErrorsCount() {
    return correctable_errors_count;
}
void
SWGRemoteOutputReport::setCorrectableErrorsCount(qint32 correctable_errors_count) {
    this->correctable_errors_count = correctable_errors_count;
    this->m_correctable_errors_count_isSet = true;
}

qint32
SWGRemoteOutputReport::getUncorrectableErrorsCount() {
    return uncorrectable_errors_count;
}
void
SWGRemoteOutputReport::setUncorrectableErrorsCount(qint32 uncorrectable_errors_count) {
    this->uncorrectable_errors_count = uncorrectable_errors_count;
    this->m_uncorrectable_errors_count_isSet = true;
}

qint32
SWGRemoteOutputReport::getTvSec() {
    return tv_sec;
}
void
SWGRemoteOutputReport::setTvSec(qint32 tv_sec) {
    this->tv_sec = tv_sec;
    this->m_tv_sec_isSet = true;
}

qint32
SWGRemoteOutputReport::getTvUSec() {
    return tv_u_sec;
}
void
SWGRemoteOutputReport::setTvUSec(qint32 tv_u_sec) {
    this->tv_u_sec = tv_u_sec;
    this->m_tv_u_sec_isSet = true;
}


bool
SWGRemoteOutputReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_center_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sample_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_queue_length_isSet){
            isObjectUpdated = true; break;
        }
        if(m_queue_size_isSet){
            isObjectUpdated = true; break;
        }
        if(m_sample_count_isSet){
            isObjectUpdated = true; break;
        }
        if(m_correctable_errors_count_isSet){
            isObjectUpdated = true; break;
        }
        if(m_uncorrectable_errors_count_isSet){
            isObjectUpdated = true; break;
        }
        if(m_tv_sec_isSet){
            isObjectUpdated = true; break;
        }
        if(m_tv_u_sec_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

