/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGAPTDemodActions.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGAPTDemodActions::SWGAPTDemodActions(QString* json) {
    init();
    this->fromJson(*json);
}

SWGAPTDemodActions::SWGAPTDemodActions() {
    aos = nullptr;
    m_aos_isSet = false;
    los = nullptr;
    m_los_isSet = false;
}

SWGAPTDemodActions::~SWGAPTDemodActions() {
    this->cleanup();
}

void
SWGAPTDemodActions::init() {
    aos = new SWGAPTDemodActions_aos();
    m_aos_isSet = false;
    los = new SWGAPTDemodActions_los();
    m_los_isSet = false;
}

void
SWGAPTDemodActions::cleanup() {
    if(aos != nullptr) { 
        delete aos;
    }
    if(los != nullptr) { 
        delete los;
    }
}

SWGAPTDemodActions*
SWGAPTDemodActions::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGAPTDemodActions::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&aos, pJson["aos"], "SWGAPTDemodActions_aos", "SWGAPTDemodActions_aos");
    
    ::SWGSDRangel::setValue(&los, pJson["los"], "SWGAPTDemodActions_los", "SWGAPTDemodActions_los");
    
}

QString
SWGAPTDemodActions::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGAPTDemodActions::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if((aos != nullptr) && (aos->isSet())){
        toJsonValue(QString("aos"), aos, obj, QString("SWGAPTDemodActions_aos"));
    }
    if((los != nullptr) && (los->isSet())){
        toJsonValue(QString("los"), los, obj, QString("SWGAPTDemodActions_los"));
    }

    return obj;
}

SWGAPTDemodActions_aos*
SWGAPTDemodActions::getAos() {
    return aos;
}
void
SWGAPTDemodActions::setAos(SWGAPTDemodActions_aos* aos) {
    this->aos = aos;
    this->m_aos_isSet = true;
}

SWGAPTDemodActions_los*
SWGAPTDemodActions::getLos() {
    return los;
}
void
SWGAPTDemodActions::setLos(SWGAPTDemodActions_los* los) {
    this->los = los;
    this->m_los_isSet = true;
}


bool
SWGAPTDemodActions::isSet(){
    bool isObjectUpdated = false;
    do{
        if(aos && aos->isSet()){
            isObjectUpdated = true; break;
        }
        if(los && los->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

