/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGFeaturePresetTransfer.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGFeaturePresetTransfer::SWGFeaturePresetTransfer(QString* json) {
    init();
    this->fromJson(*json);
}

SWGFeaturePresetTransfer::SWGFeaturePresetTransfer() {
    feature_set_index = 0;
    m_feature_set_index_isSet = false;
    preset = nullptr;
    m_preset_isSet = false;
}

SWGFeaturePresetTransfer::~SWGFeaturePresetTransfer() {
    this->cleanup();
}

void
SWGFeaturePresetTransfer::init() {
    feature_set_index = 0;
    m_feature_set_index_isSet = false;
    preset = new SWGFeaturePresetIdentifier();
    m_preset_isSet = false;
}

void
SWGFeaturePresetTransfer::cleanup() {

    if(preset != nullptr) { 
        delete preset;
    }
}

SWGFeaturePresetTransfer*
SWGFeaturePresetTransfer::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGFeaturePresetTransfer::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&feature_set_index, pJson["featureSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&preset, pJson["preset"], "SWGFeaturePresetIdentifier", "SWGFeaturePresetIdentifier");
    
}

QString
SWGFeaturePresetTransfer::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGFeaturePresetTransfer::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_feature_set_index_isSet){
        obj->insert("featureSetIndex", QJsonValue(feature_set_index));
    }
    if((preset != nullptr) && (preset->isSet())){
        toJsonValue(QString("preset"), preset, obj, QString("SWGFeaturePresetIdentifier"));
    }

    return obj;
}

qint32
SWGFeaturePresetTransfer::getFeatureSetIndex() {
    return feature_set_index;
}
void
SWGFeaturePresetTransfer::setFeatureSetIndex(qint32 feature_set_index) {
    this->feature_set_index = feature_set_index;
    this->m_feature_set_index_isSet = true;
}

SWGFeaturePresetIdentifier*
SWGFeaturePresetTransfer::getPreset() {
    return preset;
}
void
SWGFeaturePresetTransfer::setPreset(SWGFeaturePresetIdentifier* preset) {
    this->preset = preset;
    this->m_preset_isSet = true;
}


bool
SWGFeaturePresetTransfer::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_feature_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(preset && preset->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

