/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGStarTrackerSettings.h
 *
 * Star Tracker settings
 */

#ifndef SWGStarTrackerSettings_H_
#define SWGStarTrackerSettings_H_

#include <QJsonObject>


#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGStarTrackerSettings: public SWGObject {
public:
    SWGStarTrackerSettings();
    SWGStarTrackerSettings(QString* json);
    virtual ~SWGStarTrackerSettings();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGStarTrackerSettings* fromJson(QString &jsonString) override;

    QString* getTarget();
    void setTarget(QString* target);

    QString* getRa();
    void setRa(QString* ra);

    QString* getDec();
    void setDec(QString* dec);

    float getLatitude();
    void setLatitude(float latitude);

    float getLongitude();
    void setLongitude(float longitude);

    QString* getDateTime();
    void setDateTime(QString* date_time);

    QString* getRefraction();
    void setRefraction(QString* refraction);

    float getPressure();
    void setPressure(float pressure);

    float getTemperature();
    void setTemperature(float temperature);

    float getHumidity();
    void setHumidity(float humidity);

    float getHeightAboveSeaLevel();
    void setHeightAboveSeaLevel(float height_above_sea_level);

    float getTemperatureLapseRate();
    void setTemperatureLapseRate(float temperature_lapse_rate);

    float getFrequency();
    void setFrequency(float frequency);

    qint32 getStellariumServerEnabled();
    void setStellariumServerEnabled(qint32 stellarium_server_enabled);

    qint32 getStellariumPort();
    void setStellariumPort(qint32 stellarium_port);

    float getUpdatePeriod();
    void setUpdatePeriod(float update_period);

    QString* getEpoch();
    void setEpoch(QString* epoch);

    qint32 getDrawSunOnMap();
    void setDrawSunOnMap(qint32 draw_sun_on_map);

    qint32 getDrawMoonOnMap();
    void setDrawMoonOnMap(qint32 draw_moon_on_map);

    qint32 getDrawStarOnMap();
    void setDrawStarOnMap(qint32 draw_star_on_map);

    QString* getTitle();
    void setTitle(QString* title);

    qint32 getRgbColor();
    void setRgbColor(qint32 rgb_color);

    qint32 getUseReverseApi();
    void setUseReverseApi(qint32 use_reverse_api);

    QString* getReverseApiAddress();
    void setReverseApiAddress(QString* reverse_api_address);

    qint32 getReverseApiPort();
    void setReverseApiPort(qint32 reverse_api_port);

    qint32 getReverseApiFeatureSetIndex();
    void setReverseApiFeatureSetIndex(qint32 reverse_api_feature_set_index);

    qint32 getReverseApiFeatureIndex();
    void setReverseApiFeatureIndex(qint32 reverse_api_feature_index);


    virtual bool isSet() override;

private:
    QString* target;
    bool m_target_isSet;

    QString* ra;
    bool m_ra_isSet;

    QString* dec;
    bool m_dec_isSet;

    float latitude;
    bool m_latitude_isSet;

    float longitude;
    bool m_longitude_isSet;

    QString* date_time;
    bool m_date_time_isSet;

    QString* refraction;
    bool m_refraction_isSet;

    float pressure;
    bool m_pressure_isSet;

    float temperature;
    bool m_temperature_isSet;

    float humidity;
    bool m_humidity_isSet;

    float height_above_sea_level;
    bool m_height_above_sea_level_isSet;

    float temperature_lapse_rate;
    bool m_temperature_lapse_rate_isSet;

    float frequency;
    bool m_frequency_isSet;

    qint32 stellarium_server_enabled;
    bool m_stellarium_server_enabled_isSet;

    qint32 stellarium_port;
    bool m_stellarium_port_isSet;

    float update_period;
    bool m_update_period_isSet;

    QString* epoch;
    bool m_epoch_isSet;

    qint32 draw_sun_on_map;
    bool m_draw_sun_on_map_isSet;

    qint32 draw_moon_on_map;
    bool m_draw_moon_on_map_isSet;

    qint32 draw_star_on_map;
    bool m_draw_star_on_map_isSet;

    QString* title;
    bool m_title_isSet;

    qint32 rgb_color;
    bool m_rgb_color_isSet;

    qint32 use_reverse_api;
    bool m_use_reverse_api_isSet;

    QString* reverse_api_address;
    bool m_reverse_api_address_isSet;

    qint32 reverse_api_port;
    bool m_reverse_api_port_isSet;

    qint32 reverse_api_feature_set_index;
    bool m_reverse_api_feature_set_index_isSet;

    qint32 reverse_api_feature_index;
    bool m_reverse_api_feature_index_isSet;

};

}

#endif /* SWGStarTrackerSettings_H_ */
