/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGAntennaToolsSettings.h
 *
 * Antenna Tools
 */

#ifndef SWGAntennaToolsSettings_H_
#define SWGAntennaToolsSettings_H_

#include <QJsonObject>


#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGAntennaToolsSettings: public SWGObject {
public:
    SWGAntennaToolsSettings();
    SWGAntennaToolsSettings(QString* json);
    virtual ~SWGAntennaToolsSettings();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGAntennaToolsSettings* fromJson(QString &jsonString) override;

    float getDipoleFrequencyMHz();
    void setDipoleFrequencyMHz(float dipole_frequency_m_hz);

    float getDipoleEndEffectFactor();
    void setDipoleEndEffectFactor(float dipole_end_effect_factor);

    float getDishFrequencyMHz();
    void setDishFrequencyMHz(float dish_frequency_m_hz);

    float getDishDiameter();
    void setDishDiameter(float dish_diameter);

    float getDishDepth();
    void setDishDepth(float dish_depth);

    qint32 getDishEfficiency();
    void setDishEfficiency(qint32 dish_efficiency);

    QString* getTitle();
    void setTitle(QString* title);

    qint32 getRgbColor();
    void setRgbColor(qint32 rgb_color);

    qint32 getUseReverseApi();
    void setUseReverseApi(qint32 use_reverse_api);

    QString* getReverseApiAddress();
    void setReverseApiAddress(QString* reverse_api_address);

    qint32 getReverseApiPort();
    void setReverseApiPort(qint32 reverse_api_port);

    qint32 getReverseApiDeviceIndex();
    void setReverseApiDeviceIndex(qint32 reverse_api_device_index);

    qint32 getReverseApiChannelIndex();
    void setReverseApiChannelIndex(qint32 reverse_api_channel_index);


    virtual bool isSet() override;

private:
    float dipole_frequency_m_hz;
    bool m_dipole_frequency_m_hz_isSet;

    float dipole_end_effect_factor;
    bool m_dipole_end_effect_factor_isSet;

    float dish_frequency_m_hz;
    bool m_dish_frequency_m_hz_isSet;

    float dish_diameter;
    bool m_dish_diameter_isSet;

    float dish_depth;
    bool m_dish_depth_isSet;

    qint32 dish_efficiency;
    bool m_dish_efficiency_isSet;

    QString* title;
    bool m_title_isSet;

    qint32 rgb_color;
    bool m_rgb_color_isSet;

    qint32 use_reverse_api;
    bool m_use_reverse_api_isSet;

    QString* reverse_api_address;
    bool m_reverse_api_address_isSet;

    qint32 reverse_api_port;
    bool m_reverse_api_port_isSet;

    qint32 reverse_api_device_index;
    bool m_reverse_api_device_index_isSet;

    qint32 reverse_api_channel_index;
    bool m_reverse_api_channel_index_isSet;

};

}

#endif /* SWGAntennaToolsSettings_H_ */
