/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGSDRPlayV3Report.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGSDRPlayV3Report::SWGSDRPlayV3Report(QString* json) {
    init();
    this->fromJson(*json);
}

SWGSDRPlayV3Report::SWGSDRPlayV3Report() {
    bandwidths = nullptr;
    m_bandwidths_isSet = false;
    intermediate_frequencies = nullptr;
    m_intermediate_frequencies_isSet = false;
}

SWGSDRPlayV3Report::~SWGSDRPlayV3Report() {
    this->cleanup();
}

void
SWGSDRPlayV3Report::init() {
    bandwidths = new QList<SWGBandwidth*>();
    m_bandwidths_isSet = false;
    intermediate_frequencies = new QList<SWGFrequency*>();
    m_intermediate_frequencies_isSet = false;
}

void
SWGSDRPlayV3Report::cleanup() {
    if(bandwidths != nullptr) { 
        auto arr = bandwidths;
        for(auto o: *arr) { 
            delete o;
        }
        delete bandwidths;
    }
    if(intermediate_frequencies != nullptr) { 
        auto arr = intermediate_frequencies;
        for(auto o: *arr) { 
            delete o;
        }
        delete intermediate_frequencies;
    }
}

SWGSDRPlayV3Report*
SWGSDRPlayV3Report::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGSDRPlayV3Report::fromJsonObject(QJsonObject &pJson) {
    
    ::SWGSDRangel::setValue(&bandwidths, pJson["bandwidths"], "QList", "SWGBandwidth");
    
    ::SWGSDRangel::setValue(&intermediate_frequencies, pJson["intermediateFrequencies"], "QList", "SWGFrequency");
}

QString
SWGSDRPlayV3Report::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGSDRPlayV3Report::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(bandwidths && bandwidths->size() > 0){
        toJsonArray((QList<void*>*)bandwidths, obj, "bandwidths", "SWGBandwidth");
    }
    if(intermediate_frequencies && intermediate_frequencies->size() > 0){
        toJsonArray((QList<void*>*)intermediate_frequencies, obj, "intermediateFrequencies", "SWGFrequency");
    }

    return obj;
}

QList<SWGBandwidth*>*
SWGSDRPlayV3Report::getBandwidths() {
    return bandwidths;
}
void
SWGSDRPlayV3Report::setBandwidths(QList<SWGBandwidth*>* bandwidths) {
    this->bandwidths = bandwidths;
    this->m_bandwidths_isSet = true;
}

QList<SWGFrequency*>*
SWGSDRPlayV3Report::getIntermediateFrequencies() {
    return intermediate_frequencies;
}
void
SWGSDRPlayV3Report::setIntermediateFrequencies(QList<SWGFrequency*>* intermediate_frequencies) {
    this->intermediate_frequencies = intermediate_frequencies;
    this->m_intermediate_frequencies_isSet = true;
}


bool
SWGSDRPlayV3Report::isSet(){
    bool isObjectUpdated = false;
    do{
        if(bandwidths && (bandwidths->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(intermediate_frequencies && (intermediate_frequencies->size() > 0)){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

