/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1, USRP and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 4.15.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGFeatureSetPreset.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGFeatureSetPreset::SWGFeatureSetPreset(QString* json) {
    init();
    this->fromJson(*json);
}

SWGFeatureSetPreset::SWGFeatureSetPreset() {
    group = nullptr;
    m_group_isSet = false;
    description = nullptr;
    m_description_isSet = false;
    feature_configs = nullptr;
    m_feature_configs_isSet = false;
}

SWGFeatureSetPreset::~SWGFeatureSetPreset() {
    this->cleanup();
}

void
SWGFeatureSetPreset::init() {
    group = new QString("");
    m_group_isSet = false;
    description = new QString("");
    m_description_isSet = false;
    feature_configs = new QList<SWGFeatureConfig*>();
    m_feature_configs_isSet = false;
}

void
SWGFeatureSetPreset::cleanup() {
    if(group != nullptr) { 
        delete group;
    }
    if(description != nullptr) { 
        delete description;
    }
    if(feature_configs != nullptr) { 
        auto arr = feature_configs;
        for(auto o: *arr) { 
            delete o;
        }
        delete feature_configs;
    }
}

SWGFeatureSetPreset*
SWGFeatureSetPreset::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGFeatureSetPreset::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&group, pJson["group"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&description, pJson["description"], "QString", "QString");
    
    
    ::SWGSDRangel::setValue(&feature_configs, pJson["featureConfigs"], "QList", "SWGFeatureConfig");
}

QString
SWGFeatureSetPreset::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGFeatureSetPreset::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(group != nullptr && *group != QString("")){
        toJsonValue(QString("group"), group, obj, QString("QString"));
    }
    if(description != nullptr && *description != QString("")){
        toJsonValue(QString("description"), description, obj, QString("QString"));
    }
    if(feature_configs && feature_configs->size() > 0){
        toJsonArray((QList<void*>*)feature_configs, obj, "featureConfigs", "SWGFeatureConfig");
    }

    return obj;
}

QString*
SWGFeatureSetPreset::getGroup() {
    return group;
}
void
SWGFeatureSetPreset::setGroup(QString* group) {
    this->group = group;
    this->m_group_isSet = true;
}

QString*
SWGFeatureSetPreset::getDescription() {
    return description;
}
void
SWGFeatureSetPreset::setDescription(QString* description) {
    this->description = description;
    this->m_description_isSet = true;
}

QList<SWGFeatureConfig*>*
SWGFeatureSetPreset::getFeatureConfigs() {
    return feature_configs;
}
void
SWGFeatureSetPreset::setFeatureConfigs(QList<SWGFeatureConfig*>* feature_configs) {
    this->feature_configs = feature_configs;
    this->m_feature_configs_isSet = true;
}


bool
SWGFeatureSetPreset::isSet(){
    bool isObjectUpdated = false;
    do{
        if(group && *group != QString("")){
            isObjectUpdated = true; break;
        }
        if(description && *description != QString("")){
            isObjectUpdated = true; break;
        }
        if(feature_configs && (feature_configs->size() > 0)){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

