/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 4.15.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGFeatureSetList.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGFeatureSetList::SWGFeatureSetList(QString* json) {
    init();
    this->fromJson(*json);
}

SWGFeatureSetList::SWGFeatureSetList() {
    featuresetcount = 0;
    m_featuresetcount_isSet = false;
    feature_sets = nullptr;
    m_feature_sets_isSet = false;
}

SWGFeatureSetList::~SWGFeatureSetList() {
    this->cleanup();
}

void
SWGFeatureSetList::init() {
    featuresetcount = 0;
    m_featuresetcount_isSet = false;
    feature_sets = new QList<SWGFeatureSet*>();
    m_feature_sets_isSet = false;
}

void
SWGFeatureSetList::cleanup() {

    if(feature_sets != nullptr) { 
        auto arr = feature_sets;
        for(auto o: *arr) { 
            delete o;
        }
        delete feature_sets;
    }
}

SWGFeatureSetList*
SWGFeatureSetList::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGFeatureSetList::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&featuresetcount, pJson["featuresetcount"], "qint32", "");
    
    
    ::SWGSDRangel::setValue(&feature_sets, pJson["featureSets"], "QList", "SWGFeatureSet");
}

QString
SWGFeatureSetList::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGFeatureSetList::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_featuresetcount_isSet){
        obj->insert("featuresetcount", QJsonValue(featuresetcount));
    }
    if(feature_sets && feature_sets->size() > 0){
        toJsonArray((QList<void*>*)feature_sets, obj, "featureSets", "SWGFeatureSet");
    }

    return obj;
}

qint32
SWGFeatureSetList::getFeaturesetcount() {
    return featuresetcount;
}
void
SWGFeatureSetList::setFeaturesetcount(qint32 featuresetcount) {
    this->featuresetcount = featuresetcount;
    this->m_featuresetcount_isSet = true;
}

QList<SWGFeatureSet*>*
SWGFeatureSetList::getFeatureSets() {
    return feature_sets;
}
void
SWGFeatureSetList::setFeatureSets(QList<SWGFeatureSet*>* feature_sets) {
    this->feature_sets = feature_sets;
    this->m_feature_sets_isSet = true;
}


bool
SWGFeatureSetList::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_featuresetcount_isSet){
            isObjectUpdated = true; break;
        }
        if(feature_sets && (feature_sets->size() > 0)){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

