/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 4.13.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGSoapySDRInputSettings.h
 *
 * SoapySDR
 */

#ifndef SWGSoapySDRInputSettings_H_
#define SWGSoapySDRInputSettings_H_

#include <QJsonObject>


#include "SWGArgValue.h"
#include "SWGComplex.h"
#include <QList>
#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGSoapySDRInputSettings: public SWGObject {
public:
    SWGSoapySDRInputSettings();
    SWGSoapySDRInputSettings(QString* json);
    virtual ~SWGSoapySDRInputSettings();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGSoapySDRInputSettings* fromJson(QString &jsonString) override;

    qint64 getCenterFrequency();
    void setCenterFrequency(qint64 center_frequency);

    qint32 getLOppmTenths();
    void setLOppmTenths(qint32 l_oppm_tenths);

    qint32 getDevSampleRate();
    void setDevSampleRate(qint32 dev_sample_rate);

    qint32 getLog2Decim();
    void setLog2Decim(qint32 log2_decim);

    qint32 getFcPos();
    void setFcPos(qint32 fc_pos);

    qint32 getSoftDcCorrection();
    void setSoftDcCorrection(qint32 soft_dc_correction);

    qint32 getSoftIqCorrection();
    void setSoftIqCorrection(qint32 soft_iq_correction);

    qint32 getTransverterMode();
    void setTransverterMode(qint32 transverter_mode);

    qint64 getTransverterDeltaFrequency();
    void setTransverterDeltaFrequency(qint64 transverter_delta_frequency);

    QString* getFileRecordName();
    void setFileRecordName(QString* file_record_name);

    QString* getAntenna();
    void setAntenna(QString* antenna);

    qint32 getBandwidth();
    void setBandwidth(qint32 bandwidth);

    QList<SWGArgValue*>* getTunableElements();
    void setTunableElements(QList<SWGArgValue*>* tunable_elements);

    qint32 getGlobalGain();
    void setGlobalGain(qint32 global_gain);

    QList<SWGArgValue*>* getIndividualGains();
    void setIndividualGains(QList<SWGArgValue*>* individual_gains);

    qint32 getAutoGain();
    void setAutoGain(qint32 auto_gain);

    qint32 getAutoDcCorrection();
    void setAutoDcCorrection(qint32 auto_dc_correction);

    qint32 getAutoIqCorrection();
    void setAutoIqCorrection(qint32 auto_iq_correction);

    SWGComplex* getDcCorrection();
    void setDcCorrection(SWGComplex* dc_correction);

    SWGComplex* getIqCorrection();
    void setIqCorrection(SWGComplex* iq_correction);

    QList<SWGArgValue*>* getStreamArgSettings();
    void setStreamArgSettings(QList<SWGArgValue*>* stream_arg_settings);

    QList<SWGArgValue*>* getDeviceArgSettings();
    void setDeviceArgSettings(QList<SWGArgValue*>* device_arg_settings);

    qint32 getUseReverseApi();
    void setUseReverseApi(qint32 use_reverse_api);

    QString* getReverseApiAddress();
    void setReverseApiAddress(QString* reverse_api_address);

    qint32 getReverseApiPort();
    void setReverseApiPort(qint32 reverse_api_port);

    qint32 getReverseApiDeviceIndex();
    void setReverseApiDeviceIndex(qint32 reverse_api_device_index);


    virtual bool isSet() override;

private:
    qint64 center_frequency;
    bool m_center_frequency_isSet;

    qint32 l_oppm_tenths;
    bool m_l_oppm_tenths_isSet;

    qint32 dev_sample_rate;
    bool m_dev_sample_rate_isSet;

    qint32 log2_decim;
    bool m_log2_decim_isSet;

    qint32 fc_pos;
    bool m_fc_pos_isSet;

    qint32 soft_dc_correction;
    bool m_soft_dc_correction_isSet;

    qint32 soft_iq_correction;
    bool m_soft_iq_correction_isSet;

    qint32 transverter_mode;
    bool m_transverter_mode_isSet;

    qint64 transverter_delta_frequency;
    bool m_transverter_delta_frequency_isSet;

    QString* file_record_name;
    bool m_file_record_name_isSet;

    QString* antenna;
    bool m_antenna_isSet;

    qint32 bandwidth;
    bool m_bandwidth_isSet;

    QList<SWGArgValue*>* tunable_elements;
    bool m_tunable_elements_isSet;

    qint32 global_gain;
    bool m_global_gain_isSet;

    QList<SWGArgValue*>* individual_gains;
    bool m_individual_gains_isSet;

    qint32 auto_gain;
    bool m_auto_gain_isSet;

    qint32 auto_dc_correction;
    bool m_auto_dc_correction_isSet;

    qint32 auto_iq_correction;
    bool m_auto_iq_correction_isSet;

    SWGComplex* dc_correction;
    bool m_dc_correction_isSet;

    SWGComplex* iq_correction;
    bool m_iq_correction_isSet;

    QList<SWGArgValue*>* stream_arg_settings;
    bool m_stream_arg_settings_isSet;

    QList<SWGArgValue*>* device_arg_settings;
    bool m_device_arg_settings_isSet;

    qint32 use_reverse_api;
    bool m_use_reverse_api_isSet;

    QString* reverse_api_address;
    bool m_reverse_api_address_isSet;

    qint32 reverse_api_port;
    bool m_reverse_api_port_isSet;

    qint32 reverse_api_device_index;
    bool m_reverse_api_device_index_isSet;

};

}

#endif /* SWGSoapySDRInputSettings_H_ */
