% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaries.R
\name{zstd_train_dict_compress}
\alias{zstd_train_dict_compress}
\title{Train a dictionary for use with \code{zstd_compress()} and \code{zstd_decompress()}}
\usage{
zstd_train_dict_compress(
  samples,
  size = 1e+05,
  optim = FALSE,
  optim_shrink_allow = 0
)
}
\arguments{
\item{samples}{list of raw vectors, or length-1 character vectors.
Each raw vector or string, should be a complete
example of something to be compressed with \code{zstd_compress()}}

\item{size}{Maximum size of dictionary in bytes. Default: 112640 (110 kB) 
matches the default size set by the command line version of \code{zstd}.
Actual dictionary created may be smaller than this if (1) there was not
enough training data to make use of this size (2) \code{optim_shrink_allow}
was set and a smaller dictionary was found to be almost as 
useful.}

\item{optim}{optimize the dictionary. Default FALSE.  If TRUE, then ZSTD
will spend time optimizing the dictionary.  This can be a very 
length operation.}

\item{optim_shrink_allow}{integer value representing a percentage.
If non-zero, then a search will be carried out for dictionaries of a 
smaller size which are up to \code{optim_shrink_allow} percent worse than
the maximum sized dictionary.  Default: 0 means that no 
shrinking will be done.}
}
\value{
raw vector containing a ZSTD dictionary
}
\description{
This function requires multiple samples representative of the expected data to 
train a dictionary for use during compression.
}
\examples{
# This example shows the mechanics of creating and training a dictionary but
# may not be a great example of when a dictionary might be useful
cars <- rownames(mtcars)
samples <- lapply(seq_len(1000), \(x) serialize(sample(cars), NULL))
zstd_train_dict_compress(samples, size = 5000)
}
