% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialize.R
\name{zstd_serialize}
\alias{zstd_serialize}
\alias{zstd_unserialize}
\title{Serialize/Unserialize arbitrary R objects to a compressed stream of bytes using Zstandard}
\usage{
zstd_serialize(robj, ..., file = NULL, cctx = NULL, use_file_streaming = FALSE)

zstd_unserialize(src, ..., dctx = NULL, use_file_streaming = FALSE)
}
\arguments{
\item{robj}{Any R object understood by \code{base::serialize()}}

\item{...}{extra arguments passed to \code{zstd_cctx()} or \code{zstd_dctx()}
context initializers. 
Note: These argument are only used when \code{cctx} or \code{dctx} is NULL}

\item{file}{filename in which to serialize data. If NULL (the default), then 
serialize the results to a raw vector}

\item{cctx}{ZSTD Compression Context created by \code{zstd_cctx()} or NULL.
Default: NULL will create a default compression context on-the-fly}

\item{use_file_streaming}{Use the streaming interface when reading or writing
to a file?  This may reduce memory allocations
and make better use of mutlithreading.  Default: FALSE}

\item{src}{Raw vector or filename containing a ZSTD compressed serialized representation of
an R object}

\item{dctx}{ZSTD Decompression Context created by \code{zstd_dctx()} or NULL.
Default: NULL will create a default decompression context on-the-fly.}
}
\value{
Raw vector of compressed serialized data, or \code{NULL} if file 
        created with compressed data
}
\description{
Serialize/Unserialize arbitrary R objects to a compressed stream of bytes using Zstandard
}
\examples{
vec <- zstd_serialize(mtcars)
zstd_unserialize(vec)

tmp <- tempfile()
zstd_serialize(mtcars, file = tmp)
zstd_unserialize(tmp)
}
