% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_tree.R
\name{build_tree}
\alias{build_tree}
\title{Convert the objects loaded from YAML fragments into a tree}
\usage{
build_tree(
  x,
  idName = "id",
  parentIdName = "parentId",
  childrenName = "children",
  autofill = c(label = "id"),
  rankdir = "LR",
  directed = "false",
  silent = TRUE
)
}
\arguments{
\item{x}{Either a list of YAML fragments loaded from a file with
\code{\link[=load_yaml_fragments]{load_yaml_fragments()}}, or a list of such lists loaded from all files
in a directory with \code{\link[=load_yaml_dir]{load_yaml_dir()}}.}

\item{idName}{The name of the field containing each elements' identifier,
used to build the data tree when there are references to a parent from a child
element.}

\item{parentIdName}{The name of the field containing references to an element's
parent element (i.e. the field containing the identifier of the corresponding
parent element).}

\item{childrenName}{The name of the field containing an element's children, either
as a list of elements, or using the 'shorthand' notation, in which case a vector
is supplied with the identifiers of the children.}

\item{autofill}{A named vector where the names represent fields to fill with
the values of the fields specified in the vector values. Note that autofill
replacements are only applied if the fields to be autofilled (i.e. the names of
the vector specified in \code{autofill}) do not already have a value.}

\item{rankdir}{How to plot the plot when it's plotted: the default \code{"LR"} plots from
left to right. Specify e.g. \code{"TB"} to plot from top to bottom.}

\item{directed}{Whether the edges should have arrows (\code{"forward"} or \code{"backward"})
or not (\code{"false"}).}

\item{silent}{Whether to provide (\code{FALSE}) or suppress (\code{TRUE}) more detailed progress updates.}
}
\value{
a \code{\link[data.tree:Node]{data.tree::Node()}} object.
}
\description{
If the \link[data.tree:data.tree]{data.tree::data.tree} package is installed, this function
can be used to convert a list of objects, as loaded from extracted
YAML fragments, into a \code{\link[data.tree:Node]{data.tree::Node()}}.
}
\examples{
loadedYum <- yum::load_yaml_fragments(text=c(
"---",
"-",
"  id: firstFragment",
"---",
"Outside of YAML",
"---",
"-",
"  id: secondFragment",
"  parentId: firstFragment",
"---",
"Also outside of YAML"));
yum::build_tree(loadedYum);
}
