% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-spec.R
\name{spec}
\alias{spec}
\alias{spec.data.frame}
\alias{spec_vec}
\alias{specificity}
\alias{specificity.data.frame}
\alias{specificity_vec}
\title{Specificity}
\usage{
spec(data, ...)

\method{spec}{data.frame}(
  data,
  truth,
  estimate,
  estimator = NULL,
  na_rm = TRUE,
  case_weights = NULL,
  event_level = yardstick_event_level(),
  ...
)

spec_vec(
  truth,
  estimate,
  estimator = NULL,
  na_rm = TRUE,
  case_weights = NULL,
  event_level = yardstick_event_level(),
  ...
)

specificity(data, ...)

\method{specificity}{data.frame}(
  data,
  truth,
  estimate,
  estimator = NULL,
  na_rm = TRUE,
  case_weights = NULL,
  event_level = yardstick_event_level(),
  ...
)

specificity_vec(
  truth,
  estimate,
  estimator = NULL,
  na_rm = TRUE,
  case_weights = NULL,
  event_level = yardstick_event_level(),
  ...
)
}
\arguments{
\item{data}{Either a \code{data.frame} containing the columns specified by the
\code{truth} and \code{estimate} arguments, or a \code{table}/\code{matrix} where the true
class results should be in the columns of the table.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true class results
(that is a \code{factor}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{factor} vector.}

\item{estimate}{The column identifier for the predicted class
results (that is also \code{factor}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{factor} vector.}

\item{estimator}{One of: \code{"binary"}, \code{"macro"}, \code{"macro_weighted"},
or \code{"micro"} to specify the type of averaging to be done. \code{"binary"} is
only relevant for the two class case. The other three are general methods
for calculating multiclass metrics. The default will automatically choose
\code{"binary"} or \code{"macro"} based on \code{estimate}.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{case_weights}{The optional column identifier for case weights.
This should be an unquoted column name that evaluates to a numeric column
in \code{data}. For \verb{_vec()} functions, a numeric vector,
\code{\link[hardhat:importance_weights]{hardhat::importance_weights()}}, or \code{\link[hardhat:frequency_weights]{hardhat::frequency_weights()}}.}

\item{event_level}{A single string. Either \code{"first"} or \code{"second"} to specify
which level of \code{truth} to consider as the "event". This argument is only
applicable when \code{estimator = "binary"}. The default uses an internal helper
that defaults to \code{"first"}.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{spec_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
These functions calculate the \code{\link[=spec]{spec()}} (specificity) of a measurement system
compared to a reference result (the "truth" or gold standard).
Highly related functions are \code{\link[=sens]{sens()}}, \code{\link[=ppv]{ppv()}}, and \code{\link[=npv]{npv()}}.
}
\details{
The specificity measures the proportion of negatives that are correctly
identified as negatives.

When the denominator of the calculation is \code{0}, specificity is undefined.
This happens when both \verb{# true_negative = 0} and \verb{# false_positive = 0}
are true, which mean that there were no true negatives. When computing binary
specificity, a \code{NA} value will be returned with a warning. When computing
multiclass specificity, the individual \code{NA} values will be removed, and the
computation will procede, with a warning.
}
\section{Relevant Level}{


There is no common convention on which factor level should
automatically be considered the "event" or "positive" result
when computing binary classification metrics. In \code{yardstick}, the default
is to use the \emph{first} level. To alter this, change the argument
\code{event_level} to \code{"second"} to consider the \emph{last} level of the factor the
level of interest. For multiclass extensions involving one-vs-all
comparisons (such as macro averaging), this option is ignored and
the "one" level is always the relevant result.
}

\section{Multiclass}{


Macro, micro, and macro-weighted averaging is available for this metric.
The default is to select macro averaging if a \code{truth} factor with more
than 2 levels is provided. Otherwise, a standard binary calculation is done.
See \code{vignette("multiclass", "yardstick")} for more information.
}

\section{Implementation}{


Suppose a 2x2 table with notation:

\tabular{rcc}{ \tab Reference \tab \cr Predicted \tab Positive \tab Negative
\cr Positive \tab A \tab B \cr Negative \tab C \tab D \cr }

The formulas used here are:

\deqn{Sensitivity = A/(A+C)}
\deqn{Specificity = D/(B+D)}
\deqn{Prevalence = (A+C)/(A+B+C+D)}
\deqn{PPV = (Sensitivity * Prevalence) / ((Sensitivity * Prevalence) + ((1-Specificity) * (1-Prevalence)))}
\deqn{NPV = (Specificity * (1-Prevalence)) / (((1-Sensitivity) * Prevalence) + ((Specificity) * (1-Prevalence)))}

See the references for discussions of the statistics.
}

\examples{
# Two class
data("two_class_example")
spec(two_class_example, truth, predicted)

# Multiclass
library(dplyr)
data(hpc_cv)

hpc_cv \%>\%
  filter(Resample == "Fold01") \%>\%
  spec(obs, pred)

# Groups are respected
hpc_cv \%>\%
  group_by(Resample) \%>\%
  spec(obs, pred)

# Weighted macro averaging
hpc_cv \%>\%
  group_by(Resample) \%>\%
  spec(obs, pred, estimator = "macro_weighted")

# Vector version
spec_vec(
  two_class_example$truth,
  two_class_example$predicted
)

# Making Class2 the "relevant" level
spec_vec(
  two_class_example$truth,
  two_class_example$predicted,
  event_level = "second"
)
}
\references{
Altman, D.G., Bland, J.M. (1994) ``Diagnostic tests 1:
sensitivity and specificity,'' \emph{British Medical Journal},
vol 308, 1552.
}
\seealso{
Other class metrics: 
\code{\link{accuracy}()},
\code{\link{bal_accuracy}()},
\code{\link{detection_prevalence}()},
\code{\link{f_meas}()},
\code{\link{j_index}()},
\code{\link{kap}()},
\code{\link{mcc}()},
\code{\link{npv}()},
\code{\link{ppv}()},
\code{\link{precision}()},
\code{\link{recall}()},
\code{\link{sens}()}

Other sensitivity metrics: 
\code{\link{npv}()},
\code{\link{ppv}()},
\code{\link{sens}()}
}
\author{
Max Kuhn
}
\concept{class metrics}
\concept{sensitivity metrics}
