% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric-tweak.R
\name{metric_tweak}
\alias{metric_tweak}
\title{Tweak a metric function}
\usage{
metric_tweak(.name, .fn, ...)
}
\arguments{
\item{.name}{A single string giving the name of the new metric. This will be
used in the \code{".metric"} column of the output.}

\item{.fn}{An existing yardstick metric function to tweak.}

\item{...}{Name-value pairs specifying which optional arguments to override
and the values to replace them with.

Arguments \code{data}, \code{truth}, and \code{estimate} are considered \emph{protected},
and cannot be overridden, but all other optional arguments can be
altered.}
}
\value{
A tweaked version of \code{.fn}, updated to use new defaults supplied in \code{...}.
}
\description{
\code{metric_tweak()} allows you to tweak an existing metric \code{.fn}, giving it a
new \code{.name} and setting new optional argument defaults through \code{...}. It
is similar to \code{purrr::partial()}, but is designed specifically for yardstick
metrics.

\code{metric_tweak()} is especially useful when constructing a \code{\link[=metric_set]{metric_set()}} for
tuning with the tune package. After the metric set has been constructed,
there is no way to adjust the value of any optional arguments (such as
\code{beta} in \code{\link[=f_meas]{f_meas()}}). Using \code{metric_tweak()}, you can set optional arguments
to custom values ahead of time, before they go into the metric set.
}
\details{
The function returned from \code{metric_tweak()} only takes \code{...} as arguments,
which are passed through to the original \code{.fn}. Passing \code{data}, \code{truth},
and \code{estimate} through by position should generally be safe, but it is
recommended to pass any other optional arguments through by name to ensure
that they are evaluated correctly.
}
\examples{
mase12 <- metric_tweak("mase12", mase, m = 12)

# Defaults to `m = 1`
mase(solubility_test, solubility, prediction)

# Updated to use `m = 12`. `mase12()` has this set already.
mase(solubility_test, solubility, prediction, m = 12)
mase12(solubility_test, solubility, prediction)

# This is most useful to set optional argument values ahead of time when
# using a metric set
mase10 <- metric_tweak("mase10", mase, m = 10)
metrics <- metric_set(mase, mase10, mase12)
metrics(solubility_test, solubility, prediction)
}
