% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-mcc.R
\name{mcc}
\alias{mcc}
\alias{mcc.data.frame}
\alias{mcc_vec}
\title{Matthews correlation coefficient}
\usage{
mcc(data, ...)

\method{mcc}{data.frame}(data, truth, estimate, na_rm = TRUE, case_weights = NULL, ...)

mcc_vec(truth, estimate, na_rm = TRUE, case_weights = NULL, ...)
}
\arguments{
\item{data}{Either a \code{data.frame} containing the columns specified by the
\code{truth} and \code{estimate} arguments, or a \code{table}/\code{matrix} where the true
class results should be in the columns of the table.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true class results
(that is a \code{factor}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{factor} vector.}

\item{estimate}{The column identifier for the predicted class
results (that is also \code{factor}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{factor} vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{case_weights}{The optional column identifier for case weights.
This should be an unquoted column name that evaluates to a numeric column
in \code{data}. For \verb{_vec()} functions, a numeric vector.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{mcc_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Matthews correlation coefficient
}
\section{Relevant Level}{


There is no common convention on which factor level should
automatically be considered the "event" or "positive" result
when computing binary classification metrics. In \code{yardstick}, the default
is to use the \emph{first} level. To alter this, change the argument
\code{event_level} to \code{"second"} to consider the \emph{last} level of the factor the
level of interest. For multiclass extensions involving one-vs-all
comparisons (such as macro averaging), this option is ignored and
the "one" level is always the relevant result.
}

\section{Multiclass}{


\code{mcc()} has a known multiclass generalization and that is computed
automatically if a factor with more than 2 levels is provided. Because
of this, no averaging methods are provided.
}

\examples{
library(dplyr)
data("two_class_example")
data("hpc_cv")

# Two class
mcc(two_class_example, truth, predicted)

# Multiclass
# mcc() has a natural multiclass extension
hpc_cv \%>\%
  filter(Resample == "Fold01") \%>\%
  mcc(obs, pred)

# Groups are respected
hpc_cv \%>\%
  group_by(Resample) \%>\%
  mcc(obs, pred)
}
\references{
Giuseppe, J. (2012). "A Comparison of MCC and CEN Error
Measures in Multi-Class Prediction". \emph{PLOS ONE}. Vol 7, Iss 8, e41882.
}
\seealso{
Other class metrics: 
\code{\link{accuracy}()},
\code{\link{bal_accuracy}()},
\code{\link{detection_prevalence}()},
\code{\link{f_meas}()},
\code{\link{j_index}()},
\code{\link{kap}()},
\code{\link{npv}()},
\code{\link{ppv}()},
\code{\link{precision}()},
\code{\link{recall}()},
\code{\link{sens}()},
\code{\link{spec}()}
}
\author{
Max Kuhn
}
\concept{class metrics}
