% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob-brier_class.R
\name{brier_class}
\alias{brier_class}
\alias{brier_class.data.frame}
\alias{brier_class_vec}
\title{Brier score for classification models}
\usage{
brier_class(data, ...)

\method{brier_class}{data.frame}(data, truth, ..., na_rm = TRUE, case_weights = NULL)

brier_class_vec(truth, estimate, na_rm = TRUE, case_weights = NULL, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by \code{truth} and
\code{...}.}

\item{...}{A set of unquoted column names or one or more
\code{dplyr} selector functions to choose which variables contain the
class probabilities. If \code{truth} is binary, only 1 column should be selected,
and it should correspond to the value of \code{event_level}. Otherwise, there
should be as many columns as factor levels of \code{truth} and the ordering of
the columns should be the same as the factor levels of \code{truth}.}

\item{truth}{The column identifier for the true class results
(that is a \code{factor}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{factor} vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{case_weights}{The optional column identifier for case weights.
This should be an unquoted column name that evaluates to a numeric column
in \code{data}. For \verb{_vec()} functions, a numeric vector.}

\item{estimate}{If \code{truth} is binary, a numeric vector of class probabilities
corresponding to the "relevant" class. Otherwise, a matrix with as many
columns as factor levels of \code{truth}. \emph{It is assumed that these are in the
same order as the levels of \code{truth}.}}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{brier_class_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Compute the Brier score for a classification model.
}
\details{
The Brier score is analogous to the mean squared error in regression models.
The difference between a binary indicator for a class and its corresponding
class probability are squared and averaged.

This function uses the convention in Kruppa \emph{et al} (2014) and divides the
result by two.

Smaller values of the score are associated with better model performance.
}
\section{Multiclass}{

Brier scores can be computed in the same way for any number of classes.
Because of this, no averaging types are supported.
}

\examples{
# Two class
data("two_class_example")
brier_class(two_class_example, truth, Class1)

# Multiclass
library(dplyr)
data(hpc_cv)

# You can use the col1:colN tidyselect syntax
hpc_cv \%>\%
  filter(Resample == "Fold01") \%>\%
  brier_class(obs, VF:L)

# Groups are respected
hpc_cv \%>\%
  group_by(Resample) \%>\%
  brier_class(obs, VF:L)

}
\references{
Kruppa, J., Liu, Y., Diener, H.-C., Holste, T., Weimar, C.,
Koonig, I. R., and Ziegler, A. (2014) Probability estimation with machine
learning methods for dichotomous and multicategory outcome: Applications.
Biometrical Journal, 56 (4): 564-583.
}
\seealso{
Other class probability metrics: 
\code{\link{average_precision}()},
\code{\link{classification_cost}()},
\code{\link{gain_capture}()},
\code{\link{mn_log_loss}()},
\code{\link{pr_auc}()},
\code{\link{roc_auc}()},
\code{\link{roc_aunp}()},
\code{\link{roc_aunu}()}
}
\author{
Max Kuhn
}
\concept{class probability metrics}
