% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{collect_metrics.workflow_set}
\alias{collect_metrics.workflow_set}
\alias{collect_predictions.workflow_set}
\title{Obtain and format results produced by tuning functions for workflow sets}
\usage{
\method{collect_metrics}{workflow_set}(x, summarize = TRUE, ...)

\method{collect_predictions}{workflow_set}(
  x,
  summarize = TRUE,
  parameters = NULL,
  select_best = FALSE,
  metric = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{\link[=workflow_set]{workflow_set}} object that has been evaluated
with \code{\link[=workflow_map]{workflow_map()}}.}

\item{summarize}{A logical for whether the performance estimates should be
summarized via the mean (over resamples) or the raw performance values (per
resample) should be returned along with the resampling identifiers. When
collecting predictions, these are averaged if multiple assessment sets
contain the same row.}

\item{...}{Not currently used.}

\item{parameters}{An optional tibble of tuning parameter values that can be
used to filter the predicted values before processing. This tibble should
only have columns for each tuning parameter identifier (e.g. \code{"my_param"}
if \code{tune("my_param")} was used).}

\item{select_best}{A single logical for whether the numerically best results
are retained. If \code{TRUE}, the \code{parameters} argument is ignored.}

\item{metric}{A character string for the metric that is used for
\code{select_best}.}
}
\value{
A tibble.
}
\description{
Return a tibble of performance metrics for all models or submodels.
}
\details{
When applied to a workflow set, the metrics and predictions that are returned
do not contain the actual tuning parameter columns and values (unlike when
these collect functions are run on other objects). The reason is that workflow
sets can contain different types of models or models with different tuning
parameters.

If the columns are needed, there are two options. First, the \code{.config} column
can be used to merge the tuning parameter columns into an appropriate object.
Alternatively, the \code{map()} function can be used to get the metrics from the
original objects (see the example below).
}
\note{
The package supplies two pre-generated workflow sets, \code{two_class_set}
and \code{chi_features_set}, and associated sets of model fits
\code{two_class_res} and \code{chi_features_res}.

The \verb{two_class_*} objects are based on a binary classification problem
using the \code{two_class_dat} data from the modeldata package. The six
models utilize either a bare formula or a basic recipe utilizing
\code{recipes::step_YeoJohnson()} as a preprocessor, and a decision tree,
logistic regression, or MARS model specification. See \code{?two_class_set}
for source code.

The \verb{chi_features_*} objects are based on a regression problem using the
\code{Chicago} data from the modeldata package. Each of the three models
utilize a linear regression model specification, with three different
recipes of varying complexity. The objects are meant to approximate the
sequence of models built in Section 1.3 of Kuhn and Johnson (2019). See
\code{?chi_features_set} for source code.
}
\examples{
library(dplyr)
library(purrr)
library(tidyr)

two_class_res

# ------------------------------------------------------------------------------
\donttest{
collect_metrics(two_class_res)

# Alternatively, if the tuning parameter values are needed:
two_class_res \%>\%
  dplyr::filter(grepl("cart", wflow_id)) \%>\%
  mutate(metrics = map(result, collect_metrics)) \%>\%
  dplyr::select(wflow_id, metrics) \%>\%
  tidyr::unnest(cols = metrics)
}

collect_metrics(two_class_res, summarize = FALSE)
}
\seealso{
\code{\link[tune:collect_predictions]{tune::collect_metrics()}}, \code{\link[=rank_results]{rank_results()}}
}
