% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdnet-package.R
\docType{package}
\name{wdnet}
\alias{wdnet}
\title{wdnet: Weighted and Directed Networks}
\description{
This package provides functions to conduct network analysis
\itemize{
\item Assortativity, centrality, clustering coefficient
for weighted and directed networks
\item Rewire an unweighted network with given assortativity coefficient(s)
\item Preferential attachment (PA) network generation
}
}
\section{wdnet networks}{
 wdnet networks have a class \code{wdnet}. It is a
  list containing the following components:
\itemize{
\item A logical value \code{directed} indicating if the network is directed.
\item A logical value \code{weighted} indicating if the network is weighted.
\item A two-column matrix representing the edges.
\item A data frame \code{node.attr} that includes node attributes,
such as node strengths.
\item A data frame \code{edge.attr} that includes edge attributes,
such as edge weights.
}
}

\section{Creating a \code{wdnet} Object}{

\itemize{
\item To generate a preferential attachment (PA) network,
use \code{rpanet()}.
\item To create a \code{wdnet} object from an edge list
and edge weights, use \code{edgelist_to_wdnet()}.
\item To create a \code{wdnet} object from an adjacency
matrix, use \code{adj_to_wdnet()}.
\item To convert an \code{igraph} object to a \code{wdnet}
object, use \code{igraph_to_wdnet()}.
}
}

\section{Further information}{
 The development version of this package is
  available on Gitlab (\url{https://gitlab.com/wdnetwork/wdnet}).
}

