% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{auth_twitter_dev}
\alias{auth_twitter_dev}
\title{Twitter Dev API authentication}
\usage{
auth_twitter_dev(
  app_name = "r twitter app",
  api_key,
  api_secret,
  access_token,
  access_token_secret,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{app_name}{Character string. Registered twitter app name associated with the API keys.}

\item{api_key}{Character string. API consumer key to authenticate (also called API key).}

\item{api_secret}{Character string. API consumer secret to authenticate (also called API secret).}

\item{access_token}{Character string. API access token to authenticate.}

\item{access_token_secret}{Character string. API access token secret to authenticate.}

\item{verbose}{Logical. Output additional information. Default is \code{FALSE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
A \code{credential} object containing an access token \code{$auth} and social media type descriptor
\code{$socialmedia} set to \code{"twitter"}. Object has the class names \code{"credential"} and \code{"twitter"}.
}
\description{
Twitter authentication uses OAuth and typically requires four developer API keys generated when you
create a twitter app via the twitter developer web site. These keys and the authentication object produced are
referenced as developer keys and developer access in this package. Software using developer access to the API can
operate with full access to the API including within the user-context but with the understanding that it is an app.
The \pkg{rtweet} package refers to this as 'bot' authentication.
}
\note{
\pkg{vosonSML} uses the \pkg{rtweet} package for twitter data collection and also gratefully acknowledges the
techniques and code written by its authors reproduced in this package for creating twitter API access tokens.
}
\examples{
\dontrun{
# twitter authentication using developer app API keys
auth <- auth_twitter_dev(
  app_name = "My App",
  api_key = "xxxxxxxxxxxx",
  api_secret = "xxxxxxxxxxxx",
  access_token = "xxxxxxxxxxxx",
  access_token_secret = "xxxxxxxxxxxx"
)
}

}
