% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lollipops.R
\name{lollipops}
\alias{lollipops}
\title{Visualize Probabilities using a Lollipop Chart}
\usage{
lollipops(
  data,
  plotBackgroundColor = "white",
  plotBackgroundOpacity = 0.8,
  title = "Probability of an impact",
  leftArea = "Negative",
  rightArea = "Positive",
  mediumText = 18,
  bigText = 28,
  width = NULL,
  height = NULL,
  elementId = NULL,
  logoPath = NULL,
  logoSize = 100,
  logoLocation = c("bottom-left", "top-left", "top-right", "bottom-right"),
  rightAreaText = "A positive impact is not necesarly a large impact.",
  leftAreaText = "A negative impact is not necesarly a large impact."
)
}
\arguments{
\item{data}{A data frame containing the probabilities to visualize.}

\item{plotBackgroundColor}{The background color of the plot.}

\item{plotBackgroundOpacity}{The opacity of the plot background.}

\item{title}{The title of the plot.}

\item{leftArea}{The label for the left area of the plot.}

\item{rightArea}{The label for the right area of the plot.}

\item{mediumText}{The font size for medium text elements.}

\item{bigText}{The font size for big text elements.}

\item{width}{The width of the widget (optional).}

\item{height}{The height of the widget (optional).}

\item{elementId}{The element ID of the widget (optional).}

\item{logoPath}{Logo path. Defaults to \code{NULL}.}

\item{logoSize}{Logo size. Defaults to \code{FALSE}.}

\item{logoLocation}{Logo location. \code{c('bottom-right', 'top-left', 'top-right', 'bottom-left')}.}

\item{rightAreaText}{The tooltip text for the right area of the plot.}

\item{leftAreaText}{The tooltip text for the left area of the plot.}
}
\value{
A HTML widget object representing the lollipop chart.
}
\description{
This function creates a lollipop chart to visualize probabilities.
}
\details{
The data frame should have three columns: `name`, `value`, and `color`.
The `name` column specifies the names of the data points, while the
`value` column specifies the corresponding probabilities. The `color`
column specifies the color of each lollipop.
}
\examples{
data <- data.frame(
  Name = c("Outcome 1", "Outcome 2", "Outcome 3"),
  Prior = c(0.5, 0.5, 0.5),
  Posterior = c(0.2, 0.6, 0.9)
)
lollipops(data,
  logoPath = 'https://upload.wikimedia.org/wikipedia/commons/b/b8/YouTube_Logo_2017.svg',
  logoLocation = 'bottom-left')

}
