% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.t.R
\name{visualize.t}
\alias{visualize.t}
\title{Visualize Student's t distribution}
\usage{
visualize.t(stat = 1, df = 3, section = "lower")
}
\arguments{
\item{stat}{a statistic to obtain the probability from. When using the
"bounded" condition, you must supply the parameter as \code{stat = c(lower_bound, upper_bound)}. Otherwise, a simple \code{stat = desired_point} will suffice.}

\item{df}{Degrees of freedom}

\item{section}{Select how you want the statistic(s) evaluated via
\verb{section=} either \code{"lower"},\code{"bounded"}, \code{"upper"},
or\code{"tails"}.}
}
\value{
Returns a plot of the distribution according to the conditions
supplied.
}
\description{
Generates a plot of the Student's t distribution with user specified
parameters.
}
\examples{

# Evaluates lower tail.
visualize.t(stat = 1, df = 4, section = "lower") 

# Evaluates bounded region.
visualize.t(stat = c(3,5), df = 6, section = "bounded") 

# Evaluates upper tail.
visualize.t(stat = 1, df = 4, section = "upper") 

}
\seealso{
\code{\link[=visualize.it]{visualize.it()}}, \code{\link[=dt]{dt()}}.
}
\author{
James Balamuta
}
\keyword{continuous-distribution}
