"normality.test" <-
function(x, multivariate.only = TRUE){
  if(!(is(x, "varest") || is(x, "vec2var"))){
    stop("\nPlease provide an object of class 'varest', generated by 'var()', or an object of class 'vec2var' generated by 'vec2var()'.\n")
  }
  obj.name <- deparse(substitute(x))
  K <- x$K
  obs <- x$obs
  resid <- resid(x)
  resids <- scale(resid, scale=FALSE)
  ## Jarque Bera Test (multivariate)
  jbm.resids <- .jb.multi(resids, obs = obs, K = K, obj.name = obj.name)
  if(multivariate.only){
    result <- list(resid = resid, jb.mul = jbm.resids)
  } else {
    ## Jarque Bera Test (univariate)
    jbu.resids <- apply(resids, 2, function(x) .jb.uni(x, obs = obs))
    for(i in 1 : K)
      jbu.resids[[i]][5] <- paste("Residual of", colnames(resids)[i], "equation")
    result <- list(resid = resid, jb.uni = jbu.resids, jb.mul = jbm.resids)
  }
  class(result) <- "varcheck"
  return(result)
}
normality <- function(x, multivariate.only = TRUE){
  .Deprecated("normality.test", package = "vars", msg = "Function 'normality' is deprecated; use 'normality.test' instead.\nSee help(\"vars-deprecated\") and help(\"normality-deprecated\") for more information.")
  normality.test(x = x, multivariate.only = multivariate.only)
}
