% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{dist_make}
\alias{dist_make}
\title{Make a distance matrix using a custom distance function}
\usage{
dist_make(x, distance_fcn, ...)
}
\arguments{
\item{x}{A matrix of observations, one per row}

\item{distance_fcn}{A function used to compute the distance between two
rows of the data matrix.  The two rows will be passed as the first and
second arguments to \code{distance_fcn}.}

\item{...}{Additional arguments passed to \code{distance_fcn}.}
}
\value{
A \code{dist} object containing the distances between rows of the
  data matrix.
}
\description{
Make a distance matrix using a custom distance function
}
\details{
We do not set the \code{call} or \code{method} attributes of the
  \code{dist} object.
}
\examples{
x <- matrix(sin(1:30), nrow=5)
rownames(x) <- LETTERS[1:5]
manhattan_distance <- function (v1, v2) sum(abs(v1 - v2))
dist_make(x, manhattan_distance)
}
