% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexahedron.R
\name{plotHexahedron}
\alias{plotHexahedron}
\title{Plot hexahedron}
\usage{
plotHexahedron(hexahedron, alpha = 1)
}
\arguments{
\item{hexahedron}{a hexahedron given by a 3 times 8 matrix; see 
\code{\link{makeHexahedron}}}

\item{alpha}{opacity, a number between 0 and 1}
}
\value{
No returned value, called for plotting.
}
\description{
Plot a hexahedron with \strong{rgl}.
}
\examples{
library(uniformly)
hexahedron <- makeHexahedron(
  p0 = c(0, 0, 0),
  p1 = c(2, 0, 0),
  p2 = c(2, 2, 0),
  p3 = c(0, 2, 0),
  p4 = c(0.5, 1.5, 2),
  p5 = c(0.5, 0.5, 2),
  p6 = c(1.5, 0.5, 2),
  p7 = c(1.5, 1.5, 2)
)
plotHexahedron(hexahedron)
}
