% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplex.R
\name{runif_unitSimplex}
\alias{runif_unitSimplex}
\alias{runif_on_unitSimplex}
\alias{runif_in_unitSimplex}
\title{Uniform sampling on/in a unit simplex}
\usage{
runif_on_unitSimplex(n, d)

runif_in_unitSimplex(n, d)
}
\arguments{
\item{n}{number of simulations}

\item{d}{dimension of the space}
}
\value{
The simulations in a \code{n} times \code{d} matrix.
}
\description{
Uniform sampling on or in a unit simplex (arbitrary dimension).
}
\examples{
\donttest{library(rgl)
sims <- runif_on_unitSimplex(300, d = 3)
points3d(sims)}
}
\seealso{
\code{\link{runif_in_tetrahedron}} for sampling in an arbitrary
  tetrahedron in dimension 3; \code{\link{runif_in_simplex}} for sampling
  in an arbitrary simplex.
}
