% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxDoC.R
\name{umxDiscTwin}
\alias{umxDiscTwin}
\title{Intra-pair association in MZ, DZ  twin models. (ALPHA quality!)}
\usage{
umxDiscTwin(
  x,
  y,
  data,
  mzZygs = c("MZFF", "MZMM"),
  dzZygs = c("DZFF", "DZMM", "DZOS"),
  FAMID = "FAMID",
  out = c("table", "plot", "model"),
  use = "complete.obs",
  sep = "_T"
)
}
\arguments{
\item{x}{Cause}

\item{y}{Effect}

\item{data}{dataframe containing MZ and DZ data}

\item{mzZygs}{MZ zygosities c("MZFF", "MZMM")}

\item{dzZygs}{DZ zygosities c("DZFF", "DZMM", "DZOS")}

\item{FAMID}{The column containing family IDs (default = "FAMID")}

\item{out}{Whether to return the table or the ggplot (if you want to decorate it)}

\item{use}{NA handling in corr.test (default= "complete.obs")}

\item{sep}{The separator in twin variable names, default = "_T", e.g. "dep_T1".}
}
\value{
\itemize{
\item table of results
}
}
\description{
Testing causal claims is often difficult due to an inability to experimentally randomize traits and situations.
A combination of control data and data from twins discordant for the putative causal trait can falsify causal hypotheses.

\code{umxDiscTwin} uses \code{\link[nlme:nlme]{nlme::nlme()}} to compute the beta for x in \code{y ~ x} in models either a) Only controlling non-independence,
and b) MZ and DZ subsample models in which the family level of the predictor y is also controlled.

If \code{x} is causal, then the effect size of x on y is expected to be equally large in all three samples.
If the population association reflects confounded genes or shared environments,
then the association in MZ twins will reduce to zero/non-significance.

\if{html}{\figure{discordantCausalPatterns.png}{options: width=50\% alt="Figure: Types of confounding"}}
\if{latex}{\figure{discordantCausalPatterns.pdf}{options: width=7cm}}

The function uses the \code{\link[nlme:lme]{nlme::lme()}} function to compute the effect of the presumed causal variable on the outcome,
controlling, for mid-family score and with random means model using familyID. e.g.:

\code{mzModel  = lme(fixed = y ~ x + FamMeanX, random = ~ 1+FamMeanX|FAMID, data = umx_scale(MZ), na.action = "na.omit")}

\strong{Example output from \code{umxDiscTwin}}

\if{html}{\figure{DiscTwinsExample.png}{options: width=50\% alt="Figure: Causation in Discordant twins"}}
\if{latex}{\figure{DiscTwinsExample.pdf}{options: width=7cm}}
}
\examples{
\dontrun{
data(twinData)
# add to test must set FAMID umxDiscTwin(x = "ht", y = "wt", data = twinData, sep="")
tmp = umxDiscTwin(x = "ht", y = "wt", data = twinData, sep="", FAMID = "fam")
print(tmp, digits = 3)
}
}
\references{
\itemize{
\item Begg, M. D., & Parides, M. K. (2003). Separation of individual-level and cluster-level covariate effects in regression analysis of correlated data. Stat Med, 22(16), 2591-2602. \doi{10.1002/sim.1524}
}
\itemize{
\item Bergen, S. E., Gardner, C. O., Aggen, S. H., & Kendler, K. S. (2008). Socioeconomic status and social support following illicit drug use: causal pathways or common liability? \emph{Twin Res Hum Genet}, \strong{11}, 266-274. \doi{10.1375/twin.11.3.266}
\item McGue, M., Osler, M., & Christensen, K. (2010). Causal Inference and Observational Research: The Utility of Twins. \emph{Perspectives on Psychological Science}, \strong{5}, 546-556. \doi{10.1177/1745691610383511}
}
}
\seealso{
\itemize{
\item \code{\link[=umxDoC]{umxDoC()}}, \code{\link[=umxDiffMZ]{umxDiffMZ()}}, \code{\link[=umxMR]{umxMR()}}
}

Other Twin Modeling Functions: 
\code{\link{power.ACE.test}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxACE}()},
\code{\link{umxCP}()},
\code{\link{umxDiffMZ}()},
\code{\link{umxDoCp}()},
\code{\link{umxDoC}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxGxE}()},
\code{\link{umxIP}()},
\code{\link{umxMRDoC}()},
\code{\link{umxReduceACE}()},
\code{\link{umxReduceGxE}()},
\code{\link{umxReduce}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umxSummarizeTwinData}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryACE}()},
\code{\link{umxSummaryDoC}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()},
\code{\link{umxTwinMaker}()},
\code{\link{umx}}
}
\concept{Twin Modeling Functions}
