% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utest3.R
\name{utest3}
\alias{utest3}
\title{U-test for three groups}
\usage{
utest3(group_id, md = NULL, data = NULL, alpha = 0.05, numB = 1000)
}
\arguments{
\item{group_id}{A vector of 1s, 2s and 3s indicating to which group the samples belong.
Must be in the same order as data or md.}

\item{md}{Matrix of distances between all data points.}

\item{data}{Data matrix. Each row represents an observation.}

\item{alpha}{Significance level}

\item{numB}{Number of resampling iterations.}
}
\value{
Returns a list with the following elements:\describe{
  \item{is.homo}{Logical of whether test indicates that data is homogeneous}
  \item{Pvalue}{Replication based p-value}
  \item{Bn}{Test Statistic}
  \item{sdBn}{Standard error for Bn statistic computed through resampling}

}
}
\description{
Test for the separation of three groups.
The null hypothesis states that the groups are homogeneous and the alternative
hypothesis states that at least one is separated from the others.
}
\details{
Either \code{data} or \code{md} should be provided.
If data are entered directly, Bn will be computed considering the squared Euclidean
 distance.

For more detail see
Bello, Debora Zava,  Marcio Valk and Gabriela Bettella Cybis.
 "Clustering inference in multiple groups." arXiv preprint arXiv:2106.09115 (2021).
}
\examples{

# Simulate a dataset with two separate groups,
# the first row has mean -4, the next 5 rows have mean 0 and the last 5 rows have mean 4.
data <- matrix(c(rnorm(15, -4),rnorm(75, 0), rnorm(75, 4)), nrow = 11, byrow=TRUE)
# U test for mixed up groups
utest3(group_id=c(1,2,3,1,2,3,1,2,3,1,2), data=data, numB=3000)
# U test for correct group definitions
utest3(group_id=c(1,2,2,2,2,2,3,3,3,3,3), data=data, numB=3000)


}
\seealso{
\code{\link{bn3}},\code{\link{utest}},\code{\link{is_homo3}}
}
