% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvCov.R
\name{tvCov}
\alias{tvCov}
\title{Time-varying Variance-Covariance Estimation}
\usage{
tvCov(
  x,
  z = NULL,
  ez = NULL,
  bw = NULL,
  cv.block = 0,
  est = c("lc", "ll"),
  tkernel = c("Triweight", "Epa", "Gaussian")
)
}
\arguments{
\item{x}{A matrix.}

\item{z}{A vector with the variable over which coefficients are smooth over.}

\item{ez}{(optional) A scalar or vector with the smoothing values. If 
values are not included then the vector \code{z} is used instead.}

\item{bw}{(Optional) A scalar.}

\item{cv.block}{A positive scalar with the size of the block in leave-one block-out cross-validation.
By default 'cv.block=0' meaning leave-one-out cross-validation.}

\item{est}{A character, either "lc" or "ll" for local constant or local linear.}

\item{tkernel}{A character, either "Triweight, "Epa" or "Gaussian" kernel functions.}
}
\value{
A matrix of dimension obs x neq x neq.
}
\description{
Estimation of a time-varying/funcional coefficients variance-covariance matrix using the local constant or the local linear kernel
smoothing methodologies.
}
\examples{
##Generate two independent (uncorrelated series)
y <- cbind(rnorm(100, sd = 4), rnorm(100, sd = 1))

##Estimation variance-variance matrix. If the bandwidth is unknown, it can
##calculated with function bwCov()
Sigma.hat <-  tvCov(y, bw = 1.4)

##The first time estimate
print(Sigma.hat[,,1])
##The mean over time of all estimates
print(apply(Sigma.hat, 1:2, mean))
##Generate two dependent variables
y <- MASS::mvrnorm(n = 100, mu = c(0,0), Sigma = cbind(c(1, -0.5), c(-0.5, 4)))

##Estimation variance-variance matrix
Sigma.hat <-  tvCov(y, bw = 3.2)
##The first time estimate
print(Sigma.hat[,,1])

}
\references{
Aslanidis, N. and Casas, I (2013) Nonparametric correlation models for portfolio
allocation. \emph{Journal of Banking and Finance}, 37, 2268-2283
}
\seealso{
\code{\link{bwCov}}
}
