% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LF_derived.R
\name{LF_derived}
\alias{LF_derived}
\title{Derived Likelihood Factor Estimated from Data + Other Likelihood values, using sl3.}
\format{
\code{\link{R6Class}} object.
}
\value{
\code{LF_base} object
}
\description{
Uses an \code{sl3} learner to estimate a likelihood factor from data.
Inherits from \code{\link{LF_base}}; see that page for documentation on likelihood factors in general.
}
\section{Constructor}{

\code{define_lf(LF_fit, name, learner, ..., type = "density")}

\describe{
\item{\code{name}}{character, the name of the factor. Should match a node name in the nodes specified by \code{\link{tmle3_Task}$npsem}
}
\item{\code{learner}}{An sl3 learner to be used to estimate the factor
}
\item{\code{...}}{Not currently used.
}
\item{\code{type}}{character, either "density", for conditional density or, "mean" for conditional mean
}
}
}

\section{Fields}{

\describe{
\item{\code{learner}}{The learner or learner fit object}
}
}

\seealso{
Other Likelihood objects: 
\code{\link{CF_Likelihood}},
\code{\link{LF_base}},
\code{\link{LF_emp}},
\code{\link{LF_fit}},
\code{\link{LF_known}},
\code{\link{LF_static}},
\code{\link{LF_targeted}},
\code{\link{Likelihood}},
\code{\link{Targeted_Likelihood}},
\code{\link{define_lf}()}
}
\concept{Likelihood objects}
\keyword{data}
