% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-tk_augment_holiday_signature.R
\name{tk_augment_holiday}
\alias{tk_augment_holiday}
\alias{tk_augment_holiday_signature}
\title{Add many holiday features to the data}
\usage{
tk_augment_holiday_signature(
  .data,
  .date_var = NULL,
  .holiday_pattern = ".",
  .locale_set = c("all", "none", "World", "US", "CA", "GB", "FR", "IT", "JP", "CH", "DE"),
  .exchange_set = c("all", "none", "NYSE", "LONDON", "NERC", "TSX", "ZURICH")
)
}
\arguments{
\item{.data}{A time-based tibble or time-series object.}

\item{.date_var}{A column containing either date or date-time values.
If \code{NULL}, the time-based column will interpret from the object (tibble).}

\item{.holiday_pattern}{A regular expression pattern to search the "Holiday Set".}

\item{.locale_set}{Return binary holidays based on locale.
One of: "all", "none", "World", "US", "CA", "GB", "FR", "IT", "JP", "CH", "DE".}

\item{.exchange_set}{Return binary holidays based on Stock Exchange Calendars.
One of: "all", "none", "NYSE", "LONDON", "NERC", "TSX", "ZURICH".}
}
\value{
Returns a \code{tibble} object describing the holiday timeseries.
}
\description{
Quickly add the "holiday signature" - sets of holiday features that correspond
to calendar dates. Works with \code{dplyr} groups too.
}
\details{
\code{tk_augment_holiday_signature} adds the holiday signature
features. See \code{\link[=tk_get_holiday_signature]{tk_get_holiday_signature()}} (powers the augment function)
for a full description and examples for how to use.

\strong{1. Individual Holidays}

These are \strong{single holiday features} that can be filtered using a pattern.
This helps in identifying which holidays are important to a machine learning model.
This can be useful for example in \strong{e-commerce initiatives}
(e.g. sales during Christmas and Thanskgiving).

\strong{2. Locale-Based Summary Sets}

Locale-based holdiay sets are useful for \strong{e-commerce initiatives}
(e.g. sales during Christmas and Thanskgiving). Filter on a locale to
identify all holidays in that locale.

\strong{3. Stock Exchange Calendar Summary Sets}

Exchange-based holdiay sets are useful for identifying \strong{non-working days.}
Filter on an index to identify all holidays that are commonly non-working.
}
\examples{
library(dplyr)
library(timetk)

dates_in_2017_tbl <- tibble(index = tk_make_timeseries("2017-01-01", "2017-12-31", by = "day"))

# Non-working days in US due to Holidays using NYSE stock exchange calendar
dates_in_2017_tbl \%>\%
    tk_augment_holiday_signature(
        index,
        .holiday_pattern = "^$",   # Returns nothing on purpose
        .locale_set      = "none",
        .exchange_set    = "NYSE")

# All holidays in US
dates_in_2017_tbl \%>\%
    tk_augment_holiday_signature(
        index,
        .holiday_pattern = "US_",
        .locale_set      = "US",
        .exchange_set    = "none")

# All holidays for World and Italy-specific Holidays
# - Note that Italy celebrates specific holidays in addition to many World Holidays
dates_in_2017_tbl \%>\%
    tk_augment_holiday_signature(
        index,
        .holiday_pattern = "(World)|(IT_)",
        .locale_set      = c("World", "IT"),
        .exchange_set    = "none")



}
\seealso{
Augment Operations:
\itemize{
\item \code{\link[=tk_augment_timeseries_signature]{tk_augment_timeseries_signature()}} - Group-wise augmentation of timestamp features
\item \code{\link[=tk_augment_holiday_signature]{tk_augment_holiday_signature()}} - Group-wise augmentation of holiday features
\item \code{\link[=tk_augment_slidify]{tk_augment_slidify()}} - Group-wise augmentation of rolling functions
\item \code{\link[=tk_augment_lags]{tk_augment_lags()}} - Group-wise augmentation of lagged data
\item \code{\link[=tk_augment_differences]{tk_augment_differences()}} - Group-wise augmentation of differenced data
\item \code{\link[=tk_augment_fourier]{tk_augment_fourier()}} - Group-wise augmentation of fourier series
}

Underlying Function:
\itemize{
\item \code{\link[=tk_get_holiday_signature]{tk_get_holiday_signature()}} - Underlying function that powers holiday feature generation
}
}
